<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html"/>
	<xsl:template match="Server">
		<html>
			<head>
				<title/>
				<link rel="stylesheet" type="text/css" href="/oma/docs/oma.css"/>
				<xsl:if test="@skin != ''">
					<link rel="stylesheet" type="text/css">
						<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if>scheme.css</xsl:attribute>
					</link>
					<xsl:if test="@language != ''">
						<link rel="stylesheet" type="text/css">
							<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if><xsl:value-of select="@language"/>/scheme.css</xsl:attribute>
						</link>
						<xsl:if test="@country != ''">
							<link rel="stylesheet" type="text/css">
								<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if><xsl:value-of select="@language"/>/<xsl:value-of select="@country"/>/scheme.css</xsl:attribute>
							</link>
						</xsl:if>
					</xsl:if>
				</xsl:if>
			</head>
			<body class="server-name">
				<table height="60" width="100%" cellpadding="0" cellspacing="0" border="0">
					<tr>
						<td height="6" colspan="3"/>
					</tr>
					<tr>
						<td width="23" height="54">
							<img>
								<xsl:attribute name="src">/oma/<xsl:if test="@skin != ''">skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if></xsl:if>images/srvltab.gif</xsl:attribute>
								<xsl:if test="string-length(@name)>10">
									<xsl:attribute name="alt"><xsl:value-of select="@name"/></xsl:attribute>
								</xsl:if>
							</img>
						</td>
						<td class="server-name-button" align="center" valign="middle">
							<a class="server-name" href="#" onclick="javascript:parent.ct.location.href='/servlet/ComponentTree?refresh=true'">
								<xsl:choose>
									<xsl:when test="string-length(@name)>10">
										<xsl:value-of select="substring(@name, 1, 10)"/>...</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="@name"/>
									</xsl:otherwise>
								</xsl:choose>
							</a>
						</td>
						<td width="23" height="54">
							<img>
								<xsl:attribute name="src">/oma/<xsl:if test="@skin != ''">skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if></xsl:if>images/srvrtab.gif	</xsl:attribute>
								<xsl:if test="string-length(@name)>10">
									<xsl:attribute name="alt"><xsl:value-of select="@name"/></xsl:attribute>
								</xsl:if>
							</img>
						</td>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
