<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:output method="html" />
	<xsl:template match="/OMA">
		<xsl:apply-templates select="Login"/>
	</xsl:template>
	<xsl:template match="Login">
		<html>
			<head>
				<title>Login</title>
				<link rel="stylesheet" href="/oma/docs/oma.css" type="text/css" />
				<xsl:if test="/OMA/@skin != ''">
					<link rel="stylesheet" type="text/css">
						<xsl:attribute name="href">/oma/skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if>scheme.css</xsl:attribute>
					</link>
					<xsl:if test="/OMA/@language != ''">
						<link rel="stylesheet" type="text/css">
							<xsl:attribute name="href">/oma/skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if><xsl:value-of select="/OMA/@language"/>/scheme.css</xsl:attribute>
						</link>
						<xsl:if test="/OMA/@country != ''">
							<link rel="stylesheet" type="text/css">
								<xsl:attribute name="href">/oma/skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if><xsl:value-of select="/OMA/@language"/>/<xsl:value-of select="/OMA/@country"/>/scheme.css</xsl:attribute>
							</link>
						</xsl:if>
					</xsl:if>
				</xsl:if>
			</head>
			<script language="javascript">
				var cancel = 'false';
				var ok = 'false';
				var username = 'false';
				var password = 'false';
				var ADarray = new Array();
				var browserValidateReturnValue=2;
                var haveDomain = 'false';

                <!-- if have any domains for list then set flag --> 
                <xsl:if test="DomainList">
                    <xsl:text>haveDomain='true';</xsl:text>
                </xsl:if>	         

                <xsl:for-each select="/OMA/InstalledProducts/Product">           
                <xsl:if test="ADSupport='true'">
                  <xsl:text>ADarray[</xsl:text>
				  <xsl:value-of select="position()-1"/>
				  <xsl:text>] = "</xsl:text>
			      <xsl:value-of select="ID"/> 
				  <xsl:text>"; </xsl:text>   
			    </xsl:if>	         
	  		    </xsl:for-each>
	  		    
                function isADEnabled(val) {
				   var i = 0;
				   while(ADarray[i] != null)
				    {
                       if(ADarray[i] == val)
                           return true;
						   
					   i++;	               
                    }
                 }        
                 
				function setLocalLogin() {
                  <xsl:if test="OSType='1'"> <!-- windows only -->
                    if(haveDomain == 'false')
                      {
                        <!-- if have no domains in list, then disable active directory checkbox --> 
                        <!-- ad disabled -->
                         document.login.locallogin.checked=false;
                         document.getElementById("locallogintext").style.visibility = "hidden";
                         return;
                      }

                    so = document.login.application.options;
                    <!-- do we have only one product -->
                    if(document.login.application.type == "hidden") {
                      if(isADEnabled(document.login.application.value)) {
                         // only one application installed
                         <!-- ad enabled -->
                         document.login.locallogin.checked=false;
                         document.getElementById("locallogintext").style.visibility = "visible";
                        }
                       else {
                         <!-- ad disabled -->
                         document.login.locallogin.checked=false;
                         document.getElementById("locallogintext").style.visibility = "hidden";
                         }
                     }
                     else 
                        {
                        <!-- do we have multiple products -->
                        if(isADEnabled(so[so.selectedIndex].value))
                          {
                           <!-- ad enabled -->
                          document.login.locallogin.checked=false;
                          document.getElementById("locallogintext").style.visibility="visible";
                          }
                        else {
                          <!-- ad disabled -->
                          if(document.getElementById) {
                            document.login.locallogin.checked=false;
                            document.getElementById("locallogintext").style.visibility = "hidden";
                          }
                       }
                     }
	                 </xsl:if>
                    }

          
				function setCancel(val){
					cancel = val;
				}
				function setOk(val){
					ok = val;
				}
				function setUsername(val){
					username = val;
				}
				function setPassword(val){
					password = val;
				}

				
				function init() {
				    setLocalLogin(); // set state of AD login checkbox
					document.getElementById("ok").noWrap = true;
					document.getElementById("cancel").noWrap = true;
					QueryString_Parse();
					if(QueryString("msgStatus") != "false" )
					{
						document.getElementById("msg").style.visibility = "hidden";
					}
					else{
						if (QueryString("denyLevel") == null) {							
							document.getElementById("msg").style.visibility = "visible";
						}
						else {
							if (QueryString("denyLevel") == "usr") {
								document.getElementById("msg").style.visibility = "visible";
								document.getElementById("msg").innerHTML = <xsl:value-of select="$strDenyLevelUser"/>;
							}
							else if (QueryString("denyLevel") == "pwrusr") {
								document.getElementById("msg").style.visibility = "visible";
								document.getElementById("msg").innerHTML = <xsl:value-of select="$strDenyLevelPwrUser"/>;
							}
							else {
								document.getElementById("msg").style.visibility = "visible";
							}
						}
					}
					<xsl:if test="/OMA/ProductNum > '1'">
						if ((QueryString("mode") != null)  &amp;&amp; (QueryString("mode") != "")){
							for(var i = 0 ; i &lt;  document.getElementById("application").options.length ; i++){
								if (QueryString("mode") == document.getElementById("application").options[i].value){
									document.getElementById("application").options[i].selected = true;
									break;
								}
							}
						}
						else{
							for(var i = 0 ; i &lt;  document.getElementById("application").options.length ; i++){
								if (document.getElementById("application").options[i].value == "omsa"){
									document.getElementById("application").options[i].selected = true;
									break;
								}
							}
						}
					</xsl:if>
					browserValidateReturnValue=browserValidate();
					if (browserValidateReturnValue==0)
						document.login.user.focus();
					else
					if(browserValidateReturnValue==1)
					{
						document.getElementById("msg").innerHTML = "<xsl:value-of select="$strBrowserVersionToo"/>";
						document.getElementById("msg").style.visibility = "visible";		
					}
					else
					if(browserValidateReturnValue==2)
					{
						document.getElementById("msg").innerHTML = "<xsl:value-of select="$strBrowserTypeUnsupported"/>";
						document.getElementById("msg").style.visibility = "visible";		
					}
				}
				
				
				//
				// QueryString
				//
				
				function QueryString(key)
				{
					var value = null;
					for (var i=0;i&lt;QueryString.keys.length;i++)
					{
						if (QueryString.keys[i]==key)
						{
							value = QueryString.values[i];
							break;
						}
					}
					return value;
				}
				
				function QueryString_Parse()
				{
					QueryString.keys = new Array();
					QueryString.values = new Array();
					var query = parent.location.search.substring(1);
					var pairs = query.split('&amp;');
					
					for (var i=0;i&lt;pairs.length;i++)
					{
						var pos = pairs[i].indexOf('=');
						if (pos &gt;= 0)
						{
							var argname = pairs[i].substring(0,pos);
							var value = pairs[i].substring(pos+1);
							QueryString.keys[QueryString.keys.length] = argname;
							QueryString.values[QueryString.values.length] = value;		
						}
					}
				
				}
							
				function frmSubmit () {	
					
					document.login.submit();
									
					QueryString_Parse();
					
					var msgstat = QueryString("msgStatus");
								
					document.getElementById("msg").style.visibility="visible";					
					document.getElementById("msg").innerHTML = <xsl:value-of select="$strLoading"/>;
					document.getElementById("msg").style.color="blue";
					document.getElementById("msg").style.fontsize="11pt";
					document.getElementById("msg").style.fontfamily="Arial";
				}
				
				function select () {
	
					if(navigator.appName == "Microsoft Internet Explorer") {
						if(event.keyCode == 13) {
							if(cancel == 'false')
							{
								if ((ok == 'true') || (username == 'true') || (password == 'true')) {
								}
								else {
									document.login.submit();
								}
							}
							else
							{
								frmCancel();
							}
						}
					}

				}
				function frmCancel() {
					document.login.user.value="";
					document.login.password.value="";
					document.login.user.focus();
				}
				
				function browserValidate()
				{
				
				//	<!-- Return Value =0 for Supported Browser ; Return Value =1 for Browser with low version ;Return Value =2 for UnSupported Browser -->
					var BrowserSupportStatusReturnValue=2;
					if((BrowserSupportStatusReturnValue=BrowserSupportStatusIE())!=2)								
					{
					return BrowserSupportStatusReturnValue;
					}
					if((BrowserSupportStatusReturnValue=BrowserSupportStatusFireFox())!=2)				
					{		
					return BrowserSupportStatusReturnValue;
					}
					return BrowserSupportStatusReturnValue;
				}
				
				function BrowserSupportStatusIE(){
					var version = 0;
					var returnvalue = 2;
					if (navigator.appName == "Microsoft Internet Explorer")
					{ 
						var temp=navigator.appVersion.split("MSIE");
						version=parseFloat(temp[1]);
						if(version &lt; 6)
						{
							returnvalue = 1;
						}
						if (version == 6)
						{
							if(navigator.userAgent.indexOf("Windows NT 5.0") != -1)
							{
								if(navigator.appMinorVersion.indexOf("SP1") != -1)
									returnvalue=0;
								else
									returnvalue=1;
							}
							else
							{
								if( (navigator.appMinorVersion.indexOf("SP2")!=-1) ||
								    (navigator.appMinorVersion.indexOf("SP1")!=-1))
									returnvalue=0;
								else
									returnvalue=1;
							}
						}
						if (version > 6)
						{
							returnvalue = 0;
						}
						
					}
					return returnvalue;
				}

				function BrowserSupportStatusFireFox(){
					var version = 0;
					var returnvalue = 2;
					if(navigator.userAgent.indexOf("Firefox/") != -1)
					{
						var temp=navigator.userAgent.split("Firefox/");
						version=parseFloat(temp[1]);
						if (version >= 1.5)
							returnvalue = 0;
						else
							returnvalue = 1;
					}
					return returnvalue;					
				}
			
</script>
			<body topmargin="0" leftmargin="0" onload="init()" onKeypress="javascript:select ();">
<table border="0" width="100%" height="90%">
<tr>
	<td height="10%"></td>
</tr>
<tr>
<td align="center" valign="top">

<table cellpadding="0" cellspacing="0" border="0">
  

   <tr>
	   <td colspan="2" rowspan="2" align="right" valign="top" style="height: 10px; width: 10px">			
		<img>
			<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/lta.gif</xsl:attribute>
		</img>
    	   </td>
    	   <td style="height: 1px; width: 350px; background-color: #CECFCE"><img alt="" src="" height="1" width="1" /></td>
         <td colspan="2" rowspan="2" align="right" valign="top" style="height: 10px; width: 10px">
		<img>
			<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/rta.gif</xsl:attribute>
		</img>
	   </td>
  </tr>

<tr>
	<td style="height: 9px; width: 350px" class="login-page-user-information"><img alt="" src="" height="1" width="1"/></td>
</tr>


  <tr>
    <td style="width: 1px; background-color: #CECFCE"><img alt="" src="" height="1" width="1"/></td>
    <td  style="width: 9px" class="login-page-user-information"><img alt="" src="" height="1" width="1"/></td>
    <td align="center" class="login-page-user-information" bordercolor="#999999" style="width: 350px" >

				<table cellpadding="0" cellspacing="0" border="0" height="35" width="100%">
					<tr>
						<td align="center" valign="middle" style="height: 232px">
							<FORM AUTOCOMPLETE="OFF" method="post" name="login" action="/servlet/LoginServlet?flag=true" target="_top">
								<table width="300" cellpadding="2" cellspacing="0">
                                                      <input type="hidden" name="manuallogin" value="true"/>
									<tr>
										<td class="data-area-title">
											<p>
												<br/><xsl:value-of select="$strLogIn"/></p>
										</td>
									</tr>
									<tr align="left">
										<td colspan="2">
											<span class="login-prompt-text">
												<xsl:value-of select="$strTypeInUsername"/>
											</span>
										</td>
									</tr>
									<tr>
										<td align="left" style="width: 72px">
											<span class="login-form-label"><xsl:value-of select="$strUsername"/></span>
											<div style="z-index: -1; position: absolute;"><input type="submit" size="20" maxlength="256" name="submit1"/></div>
										</td>
										<td style="width: 111px">
											<input class="login" onFocus="javascript:setUsername('true')" onblur="javascript:setUsername('false')"  type="text" size="20" maxlength="256" name="user"/>
										</td>
									</tr>
									<tr>
										<td align="left" style="width: 72px">
											<span class="login-form-label"><xsl:value-of select="$strPassword"/></span>
										</td>
										<td style="width: 111px">
											<input class="login" onFocus="javascript:setPassword('true')" onblur="javascript:setPassword('false')" type="password" size="20" maxlength="256" name="password"/>
										</td>
									</tr>
									<xsl:if test="OSType='1'">
										<xsl:apply-templates select="DomainList" />
									</xsl:if>
									<xsl:apply-templates select="/OMA/InstalledProducts"/>
									<xsl:if test="OSType='1'">
                                                          <tr>
   										   <td align="left"></td>
										   <td align="left" style="width: 160px" nowrap="nowrap">
	                                                            <div id="locallogintext" style="visibility:hidden" ><input type="checkbox" size="30" name="locallogin" />
                                                                     <xsl:value-of select="$strLocalLogin"/>
											</div>
	                                                         </td>
                                                           </tr>
									</xsl:if>
									<tr style="height: 30px">
										<td colspan="2">
											<img src="/oma/images/blank.gif" alt="blank" style="height: 30px"/>
										</td>
									</tr>
									<tr>
										<td colspan="2" align="center">
											<table border="0" cellpadding="0" cellspacing="0">
												<tr>
													<xsl:call-template name="button_details">
														<xsl:with-param name="href">#</xsl:with-param>
														<xsl:with-param name="onclick">javascript:frmSubmit()</xsl:with-param>
														<xsl:with-param name="id">ok</xsl:with-param>
														<xsl:with-param name="display"><xsl:value-of select="$strOK"/></xsl:with-param>
													</xsl:call-template>
													<xsl:call-template name="button_details">
														<xsl:with-param name="href">#</xsl:with-param>
														<xsl:with-param name="onclick">javascript:frmCancel()</xsl:with-param>
														<xsl:with-param name="id">cancel</xsl:with-param>
														<xsl:with-param name="display"><xsl:value-of select="$strCancel"/></xsl:with-param>
													</xsl:call-template>
												</tr>
											</table>
										</td>
									</tr>
								</table>
							</FORM>
						</td>
					</tr>
				</table>
  </td>

  <td style="width: 9px;" class="login-page-user-information"> <img alt="" src="" height="1" width="1"/> </td>
  <td style="width: 1px; background-color: #CECFCE"><img alt="" src="" height="1" width="1"/></td>

  </tr>

  <tr>

    <td colspan="2" rowspan="2" align="right" valign="top" style="height: 10px; width: 10px">			
			<img>
				<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/lba.gif</xsl:attribute>
			</img>
    </td>

    <td  style="height: 9px; width: 350px" class="login-page-user-information"><img alt="" src="" height="1" width="1"/>
    </td>

    <td colspan="2" rowspan="2" align="right" valign="top" style="height: 10px; width: 10px" >
			<img>
				<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/rba.gif</xsl:attribute>
			</img>
   </td>
  </tr>

  <tr>
	<td style="height: 1px; width: 350px; background-color: #CECFCE"><img alt="" src="" height="1" width="1"/></td>
  </tr>			


</table>
</td>
</tr>
<tr>
<td align="center" valign="top">
<div id="msg" style="visibility:hidden" class="data-area-error-message"><xsl:value-of select="$strLoginFailed"/></div>
</td>
</tr>

</table>



			</body>
		</html>
	</xsl:template>
	<xsl:template name="button_details">
		<xsl:param name="display" />
		<xsl:param name="href" />
		<xsl:param name="id" />
		<xsl:param name="onclick" />
		<td style="width: 14px; height: 25px">
			<img style="width: 14px; height: 25px">
				<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/llbutton.gif</xsl:attribute>
			</img>
		</td>
		<td class="data-area-button" align="center" valign="middle" style="width: 80px">
			<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
			<a>
				<xsl:attribute name="href"><xsl:value-of select="$href" /></xsl:attribute>

				<xsl:attribute name="onclick"><xsl:value-of select="$onclick" /></xsl:attribute>
				<xsl:attribute name="id"><xsl:value-of select="$display" /></xsl:attribute>
				<xsl:attribute name="name"><xsl:value-of select="$display" /></xsl:attribute>
				<xsl:if test="$id='cancel'">
					<xsl:attribute name="onFocus">javascript:setCancel('true');</xsl:attribute>
					<xsl:attribute name="onblur">javascript:setCancel('false');</xsl:attribute>
				</xsl:if>
				<xsl:if test="$id='ok'">
					<xsl:attribute name="onFocus">javascript:setOk('true');</xsl:attribute>
					<xsl:attribute name="onblur">javascript:setOk('false');</xsl:attribute>
				</xsl:if>

				
				<xsl:value-of select="$display" />
			</a>
		</td>
		<td style="width: 14px; height: 25px">
			<img style="width: 14px; height: 25px">
				<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/lrbutton.gif</xsl:attribute>
			</img>
		</td>
	</xsl:template>

	<xsl:template match="DomainList">
		<tr>
			<td align="left" style="width: 72px">
				<span class="login-form-label"><xsl:value-of select="$strDomain"/></span>
			</td>
			<td width="111">
				<select name="domain" size="0">
					<xsl:for-each select="DomainName">
						<xsl:variable name="var" select="."/>
						<option value="{$var}">
							<xsl:value-of select="."/>
						</option>
					</xsl:for-each>
				</select>
			</td>
		</tr>
	</xsl:template>
	
	<xsl:template match="/OMA/InstalledProducts">
		
		<xsl:if test="Product">
			<tr>
				<td align="left" style="width: 140px" nowrap="nowrap">
					<span class="login-form-label"><xsl:value-of select="$strApplication"/></span>
				</td>
				<xsl:choose>
					<xsl:when test="/OMA/ProductNum = '1'">
						<td nowrap="nowrap"><xsl:value-of select="Product/Name"/></td>
						<xsl:element name="input">
							<xsl:attribute name="type">hidden</xsl:attribute>
							<xsl:attribute name="name">application</xsl:attribute>
							<xsl:attribute name="id">application</xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="Product/ID"/></xsl:attribute>
						</xsl:element>
					</xsl:when>
					<xsl:otherwise>
						<td width="111">
							<select name="application" onchange="javascript:setLocalLogin()">
								<xsl:for-each select="Product">
                                          	   <xsl:variable name="var" select="ID"/>
									<option value="{$var}">
										<xsl:value-of select="Name"/>
									</option>
								</xsl:for-each>
							</select>
						</td>
					</xsl:otherwise>
				</xsl:choose>
			</tr>
		</xsl:if>
	</xsl:template>

</xsl:stylesheet>

