<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:template match="/OMA">
	<html>
	<head>
	<title><xsl:value-of select="$strAbout"/></title>
	<script LANGUAGE="javascript">
		function noResize()
		{
			parent.resizeTo(375, 300);
		}
		function doResize()
		{
			var width;
			if (window.innerWidth == null) {
				width = document.body.clientWidth;
			}
			else {
				width = window.innerWidth;
			}
			document.getElementById("line").width = width - 50;
		}
	</script>
	<link rel="stylesheet" type="text/css" href="/oma/docs/oma.css"></link>
	<xsl:if test="@skin != ''">
		<link rel="stylesheet" type="text/css">
			<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if>scheme.css</xsl:attribute>
		</link>
		<xsl:if test="@language != ''">
			<link rel="stylesheet" type="text/css">
				<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if><xsl:value-of select="@language"/>/scheme.css</xsl:attribute>
			</link>
			<xsl:if test="@country != ''">
				<link rel="stylesheet" type="text/css">
					<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if><xsl:value-of select="@language"/>/<xsl:value-of select="@country"/>/scheme.css</xsl:attribute>
				</link>
			</xsl:if>
		</xsl:if>
	</xsl:if>
	</head>
	<body marginheight="0" marginwidth="0" topmargin="0" leftmargin="0"  onResize="javascript:doResize();" onload="javascript:doResize();" >
	<form name="about" method="get">
		<div align="right">
		<table border="0" cellpadding="0" cellspacing="0">
			<tr>
				<td colspan="2">
					<img src="/oma/images/blank.gif" style="height: 15px" />
				</td>
			</tr>
			<tr>
				<td>
					<xsl:call-template name="button_details">
						<xsl:with-param name="href">javascript:parent.print ()</xsl:with-param>
						<xsl:with-param name="display"><xsl:value-of select="$strPrint"/></xsl:with-param>
					</xsl:call-template>
	      			</td>
				<td>
					<xsl:call-template name="button_details">
						<xsl:with-param name="href">/servlet/UDataArea?plugin=com.dell.oma.webplugins.DetailAboutWebPlugin</xsl:with-param>
						<xsl:with-param name="display"><xsl:value-of select="$strDetails"/></xsl:with-param>
					</xsl:call-template>
      				</td>
			</tr>
		</table>
		</div>
		<table border="0">
  			<tr>
	    			<td />
	    			<td nowrap="nowrap">
						<xsl:apply-templates/>
				</td>
				<td />
  	   		</tr>
		</table>
	</form>
	</body>
	</html>
	</xsl:template>

	<xsl:template match="About">
		<xsl:choose>
			<xsl:when test="ProductID = 'osia'">
				<xsl:choose>
					<xsl:when test="(../OEMTitleCompanyName)!=''">
						<xsl:value-of select="../OEMTitleCompanyName" />&#160;<xsl:value-of select="../OEMTitleCoreProductName" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="../OEMTitleCoreProductName" />
					</xsl:otherwise>
				</xsl:choose>
				<br/>
			</xsl:when>
			<xsl:when test="ProductID = 'pref'">
				<xsl:value-of select="ProductName"/>&#160;<xsl:value-of select="$strPreferences"/>
				<br/>
			</xsl:when>
			<xsl:when test="ProductName">
				<xsl:value-of select="ProductName"/>
				<br/>
			</xsl:when>
			<xsl:otherwise><xsl:value-of select="$strProductNameInformation"/><br></br></xsl:otherwise>
		</xsl:choose>
		<xsl:value-of select="$strVersion"/>
		<xsl:choose>
			<xsl:when test="ProductVersion"><xsl:value-of select="ProductVersion"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$strInformationNotAvailable"/></xsl:otherwise>
		</xsl:choose>
		<br />
		<xsl:if test="VendorName">
			<table>
				<tr>
					<td><xsl:value-of select="$strPoweredBy"/><xsl:value-of select="VendorName"></xsl:value-of><br/></td>
					<td><xsl:if test="VendorImage"><img><xsl:attribute name="src"><xsl:value-of select="VendorImage"/></xsl:attribute></img><br/></xsl:if></td>
				</tr>
			</table>
		</xsl:if>
		<xsl:call-template name="LegalCopyright">
			<xsl:with-param name="copyright"><xsl:value-of select="LegalCopyright"/></xsl:with-param>
		</xsl:call-template>
		<br /><br /><br /><br /><br /><br /><br />
		<xsl:value-of select="CompanyName"></xsl:value-of><br></br>
		<hr width="300" align="left" noshade="noshade" size="2" id="line"/>
	</xsl:template>

	<xsl:template name="LegalCopyright">
		<xsl:param name="copyright"/>
		<xsl:choose>
			<xsl:when test="substring-after($copyright , '1995-2008.') =' All rights reserved.'">
				<xsl:variable name="laststr"><xsl:value-of select="$strAllRightsReserved"/></xsl:variable>
				<xsl:value-of select="concat(substring-before($copyright , 'All') , $laststr)"/>
			</xsl:when>
			<xsl:otherwise><xsl:value-of select="$copyright"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="button_details">
		<xsl:param name="href"/>
		<xsl:param name="display"/>
		<xsl:param name="onclick"/>
		<xsl:param name="id"/>
		<td style="width: 14px; height: 25px">
			<img style="width: 14px; height: 25px">
				<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/lbutton.gif</xsl:attribute>
			</img>
		</td>
		<td class="data-area-button" align="center" valign="middle">
			<a>
				<xsl:attribute name="href"><xsl:value-of select="$href"/></xsl:attribute>
				<xsl:if test="$onclick != ''"><xsl:attribute name="onclick"><xsl:value-of select="$onclick"/></xsl:attribute></xsl:if>
				<xsl:if test="$id != ''"><xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute></xsl:if>
				<xsl:value-of select="$display"/>
			</a>
		</td>
		<td style="width: 14px; height: 25px">
			<img style="width: 14px; height: 25px">
				<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/rbutton.gif</xsl:attribute>
			</img>
		</td>
	</xsl:template>
	<xsl:template match="*"/>
</xsl:stylesheet>

