<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text" indent="no"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="/OMA">
		<xsl:apply-templates select="DataArea"/>
	</xsl:template>
	<xsl:template match="DataArea">
		<xsl:apply-templates />
	</xsl:template>
	<xsl:template match="PageTitle">
		<xsl:if test="@display">
			<xsl:value-of select="@display"/>
			<xsl:if test="@status!=''">
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>	
				<xsl:value-of select="$strHealth"/><xsl:call-template name="display-status">
				    	<xsl:with-param name="status"><xsl:value-of select="@status"/></xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:call-template name="NewLine"/>
		</xsl:if>
	</xsl:template>
	<xsl:template match="PromptText">
		<xsl:if test=". !=''">
			<xsl:choose>
				<xsl:when test="@ignoreoncli = 'true'"></xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="NewLine"/>
					<xsl:value-of select="."/>
					<xsl:call-template name="NewLine"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	<xsl:template match="SubHeader">
		<xsl:if test="@display">
			<xsl:call-template name="NewLine"/>
			<xsl:value-of select="@display"/>
			<xsl:call-template name="NewLine"/>
		</xsl:if>
	</xsl:template>
	<xsl:template match="ListData">
		<xsl:apply-templates select="SubHeader"/>
		<xsl:choose>
			<xsl:when test="@display">
				<xsl:call-template name="NewLine"/>
				<xsl:value-of select="@display"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="DataList">
					<xsl:with-param name="Data" select="Data"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="DataList">
					<xsl:with-param name="Data" select="Data"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="TableData">
		<xsl:choose>
			<xsl:when test="(count(SubHeader)) > 1">
				<xsl:for-each select="SubHeader">
					<xsl:call-template name="NewLine"/>
						<xsl:choose>
							<xsl:when test="@status">
								<xsl:value-of select="@display"/><xsl:text> : </xsl:text><xsl:call-template name="display-status">
								    	<xsl:with-param name="status"><xsl:value-of select="@status"/></xsl:with-param>
								</xsl:call-template>
							 </xsl:when>
							 <xsl:otherwise>
								<xsl:value-of select="@display"/>
							</xsl:otherwise>
				           </xsl:choose>
					<xsl:call-template name="NewLine"/>
				</xsl:for-each>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="SubHeader/@display">
						<xsl:call-template name="NewLine"/>
							<xsl:choose>
								<xsl:when test="SubHeader/@status">
									<xsl:value-of select="SubHeader/@display"/><xsl:text> : </xsl:text><xsl:call-template name="display-status">
									    	<xsl:with-param name="status"><xsl:value-of select="SubHeader/@status"/></xsl:with-param>
									</xsl:call-template>
								 </xsl:when>
								 <xsl:otherwise>
									<xsl:value-of select="SubHeader/@display"/>
								</xsl:otherwise>
					           </xsl:choose>
						<xsl:call-template name="NewLine"/>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="NewLine"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:call-template name="Header">
			<xsl:with-param name="Header" select="Header"/>
		</xsl:call-template>
		<xsl:call-template name="Row">
			<xsl:with-param name="Row" select="Row"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template match="ComboData">
		<xsl:if test="ListData/SubHeader/@display">
			<xsl:call-template name="NewLine"/>
			<xsl:value-of select="ListData/SubHeader/@display"/>
			<xsl:call-template name="NewLine"/>
		</xsl:if>
		<xsl:apply-templates select="ListData"/>
		<xsl:if test="TableData">
			<xsl:apply-templates select="TableData"/>
		</xsl:if>
	</xsl:template>
	<xsl:template match="SummaryData">
		<xsl:for-each select="Section">
			<xsl:if test="ListData">
				<!--xsl:call-template name="NewLine"/>
				<xsl:call-template name="spaces">
					<xsl:with-param name="length" select="string-length(@display)"/>
					<xsl:with-param name="character" select="'-'"/>
				</xsl:call-template>
				<xsl:call-template name="NewLine"/-->
				<xsl:value-of select="@display"/>
				<!--xsl:call-template name="NewLine"/>
				<xsl:call-template name="spaces">
					<xsl:with-param name="length" select="string-length(@display)"/>
					<xsl:with-param name="character" select="'-'"/>
				</xsl:call-template-->
				<xsl:apply-templates />
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="Section">
		<!--xsl:call-template name="NewLine"/>
		<xsl:call-template name="spaces">
			<xsl:with-param name="length" select="string-length(@display)"/>
			<xsl:with-param name="character" select="'-'"/>
		</xsl:call-template>
		<xsl:call-template name="NewLine"/-->
		<xsl:value-of select="@display"/>
		<!--xsl:call-template name="NewLine"/>
		<xsl:call-template name="spaces">
			<xsl:with-param name="length" select="string-length(@display)"/>
			<xsl:with-param name="character" select="'-'"/>
		</xsl:call-template-->
		<xsl:apply-templates />
	</xsl:template>
	<xsl:template name="Header">
		<xsl:param name="Header"/>
		<xsl:call-template name="HeaderData">
			<xsl:with-param name="Data" select="$Header/Data"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="Row">
		<xsl:param name="Row"/>
		<xsl:for-each select="$Row">
			<xsl:call-template name="RowData">
				<xsl:with-param name="Data" select="Data"/>
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="HeaderData">
		<xsl:param name="Data"/>
		<xsl:for-each select="$Data">
			<xsl:choose>
				<xsl:when test="@ignoreoncli='true'"></xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="@display"/>
					<xsl:choose>
						<xsl:when test="position()!=last()"><xsl:text>;</xsl:text></xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="NewLine"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>			
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="RowData">
		<xsl:param name="Data"/>
		<xsl:for-each select="$Data">
			<xsl:choose>
				<xsl:when test="@ignoreoncli='true'"></xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="@type">
							<xsl:if test="@type!='hidden'">
								<xsl:choose>
									<xsl:when test="@type='icon'">
										<xsl:value-of select="@alt"/>
									</xsl:when>
									<xsl:when test="@type='status'">
										<xsl:call-template name="display-status">
											<xsl:with-param name="status" select="@value" />
										</xsl:call-template>
									</xsl:when>
									<xsl:when test="@type='status-text'">
										<xsl:call-template name="display-status">
											<xsl:with-param name="status" select="@value" />
										</xsl:call-template>
									</xsl:when>
									<xsl:when test="@type='editbox'">
										<xsl:value-of select="@value"/>
									</xsl:when>
									<xsl:when test="@type='radio'">
										<xsl:call-template name="GetState">
											<xsl:with-param name="state"><xsl:value-of select="@state"/></xsl:with-param>
										</xsl:call-template>
									</xsl:when>
									<xsl:when test="@type='checkbox'">
										<xsl:call-template name="GetState">
											<xsl:with-param name="state"><xsl:value-of select="@state"/></xsl:with-param>
										</xsl:call-template>
									</xsl:when>
									<xsl:when test="@type='ipaddrbox'">
										<xsl:value-of select="@value1"/><xsl:text>.</xsl:text><xsl:value-of select="@value2"/><xsl:text>.</xsl:text><xsl:value-of select="@value3"/><xsl:text>.</xsl:text><xsl:value-of select="@value4"/>
									</xsl:when>
									<xsl:when test="@type='select'">
										<xsl:for-each select="Choice">
											<xsl:if test="@default = 'true'">
												<xsl:value-of select="@value"/>
											</xsl:if>
										</xsl:for-each>
									</xsl:when>
									<xsl:when test="@type='password'">
										<xsl:call-template name="PassWord">
											<xsl:with-param name="size"><xsl:value-of select="@size"/></xsl:with-param>
										</xsl:call-template>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="@value"/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:if>
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="ValueList/value">
									<xsl:for-each select="ValueList/value">
										<xsl:value-of select="."/>
										<xsl:if test="position()!=last()">
											<xsl:text>, </xsl:text>
										</xsl:if>
									</xsl:for-each>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="@value"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:choose>
						<xsl:when test="position()!=last()"><xsl:text>;</xsl:text></xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="NewLine"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="DataList">
		<xsl:param name="Data"/>
			<xsl:for-each select="$Data">
				<xsl:choose>
					<xsl:when test="@ignoreoncli='true'"></xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="@type">
								<xsl:if test="@type!='hidden'">
									<xsl:value-of select="@display"/>
									<xsl:text>;</xsl:text>
									<xsl:choose>
										<xsl:when test="@type">
											<xsl:choose>
												<xsl:when test="@type='icon'">
													<xsl:value-of select="@alt"/>
												</xsl:when>
												<xsl:when test="@type='status'">
													<xsl:call-template name="display-status">
														<xsl:with-param name="status" select="@value" />
													</xsl:call-template>
												</xsl:when>
												<xsl:when test="@type='status-text'">
													<xsl:call-template name="display-status">
														<xsl:with-param name="status" select="@value" />
													</xsl:call-template>
												</xsl:when>
												<xsl:when test="@type='editbox'">
													<xsl:value-of select="@value"/>
												</xsl:when>
												<xsl:when test="@type='radio'">
													<xsl:call-template name="GetState">
														<xsl:with-param name="state"><xsl:value-of select="@state"/></xsl:with-param>
													</xsl:call-template>
												</xsl:when>
												<xsl:when test="@type='checkbox'">
													<xsl:call-template name="GetState">
														<xsl:with-param name="state"><xsl:value-of select="@state"/></xsl:with-param>
													</xsl:call-template>
												</xsl:when>
												<xsl:when test="@type='ipaddrbox'">
													<xsl:value-of select="@value1"/><xsl:text>.</xsl:text><xsl:value-of select="@value2"/><xsl:text>.</xsl:text><xsl:value-of select="@value3"/><xsl:text>.</xsl:text><xsl:value-of select="@value4"/>
												</xsl:when>
												<xsl:when test="@type='select'">
													<xsl:for-each select="Choice">
														<xsl:if test="@default = 'true'">
															<xsl:value-of select="@value"/>
														</xsl:if>
													</xsl:for-each>
												</xsl:when>
												<xsl:when test="@type='password'">
													<xsl:call-template name="PassWord">
														<xsl:with-param name="size"><xsl:value-of select="@size"/></xsl:with-param>
													</xsl:call-template>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="@value"/>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="@value"/>
										</xsl:otherwise>
									</xsl:choose>
									<xsl:if test="position()!=last()">
										<xsl:call-template name="NewLine"/>
									</xsl:if>
								</xsl:if>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="@display"/>
								<xsl:text>;</xsl:text>
								<xsl:value-of select="@value"/>
								<xsl:if test="position()!=last()">
									<xsl:call-template name="NewLine"/>
								</xsl:if>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>					
				</xsl:choose>
			</xsl:for-each>
		<xsl:call-template name="NewLine"/>
	</xsl:template>
	<xsl:template name="NewLine">
		<xsl:text>
</xsl:text>
	</xsl:template>
	<xsl:template name="PassWord">
		<xsl:param name="size"/>
		<xsl:text>*</xsl:text>
		<xsl:if test="$size &gt; '0'">
			<xsl:call-template name="PassWord">
				<xsl:with-param name="size"><xsl:value-of select="($size) - 1"/></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<xsl:template name="GetState">
		<xsl:param name="state"/>
		<xsl:choose>
			<xsl:when test="$state=1">true</xsl:when>
			<xsl:when test="$state=3">true</xsl:when>
			<xsl:otherwise>false</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="spaces">
		<xsl:param name="length"/>
		<xsl:param name="character"/>
		<xsl:if test="$length!=0">
			<xsl:call-template name="spaces">
				<xsl:with-param name="length" select="($length)-1"/>
				<xsl:with-param name="character" select="$character"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:value-of select="$character"/>
	</xsl:template>

	<xsl:template name="display-status">
		<xsl:param name="status" />
		<xsl:choose>
			<xsl:when test="$status='0'"><xsl:value-of select="$strUnknown"/></xsl:when>
			<xsl:when test="$status='1'"><xsl:value-of select="$strUnknown1"/></xsl:when>
			<xsl:when test="$status='2'"><xsl:value-of select="$strOk"/></xsl:when>
			<xsl:when test="$status='3'"><xsl:value-of select="$strNonCritical"/></xsl:when>
			<xsl:when test="$status='4'"><xsl:value-of select="$strCritical"/></xsl:when>
			<xsl:when test="$status='5'"><xsl:value-of select="$strNonRecoverable"/></xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="*"/>
</xsl:stylesheet>
