<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="/OMA">
		<DataArea exportdata="false">
			<xsl:attribute name="submitdisplay"><xsl:value-of select="$strApplyChanges"/></xsl:attribute>
			<xsl:choose>
				<xsl:when test="OMAUserRights!='1'"><xsl:attribute name="validate">true</xsl:attribute></xsl:when>
				<xsl:otherwise></xsl:otherwise>
			</xsl:choose>
			<xsl:attribute name="submit">/servlet/SubmitFormServletUser?plugin=com.dell.oma.webplugins.SetUserPrefWebPlugin</xsl:attribute>
			<xsl:if test="OMAUserRights='1'">
				<xsl:attribute name="email">false</xsl:attribute>
			</xsl:if>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strUserPreferences"/></xsl:attribute>
			</PageTitle>
			<PromptText>
				<xsl:choose>
					<xsl:when test="(OMAUserRights='7') or (OMAUserRights='3')"><xsl:value-of select="$strSelectSkinScheme"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$strSelectSkinAnd"/></xsl:otherwise>
				</xsl:choose>
			</PromptText>
			<CustomButton>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.oma.webplugins.UsrprefWebPlugin&amp;help=Userpreferences</xsl:attribute>
				</Data>
			</CustomButton>					
			<ListData type="custom">
				<Data name="skin" editable="true" id="skin" type="select" align="left">
					<xsl:attribute name="display"><xsl:value-of select="$strSkin"/></xsl:attribute>
					<xsl:attribute name="event">onChange</xsl:attribute>
					<xsl:attribute name="handler">javascript:chgScheme()</xsl:attribute>
					<xsl:for-each select="SkinList/Skin">
						<xsl:sort select="." order="ascending"/>
						<Choice>
							<xsl:attribute name="returnvalue"><xsl:value-of select="@name"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="@display"/></xsl:attribute>
							<xsl:attribute name="default">
								<xsl:if test="@select='true'">true</xsl:if>
							</xsl:attribute>
						</Choice>
					</xsl:for-each>
				</Data>
				<xsl:for-each select="SkinList/Skin">
					<xsl:if test="@select='true'">
						<Data name="scheme" editable="true" id="scheme"  type="select" align="left">
							<xsl:attribute name="display"><xsl:value-of select="$strScheme"/></xsl:attribute>
							<xsl:for-each select="SchemeList/Scheme">
								<xsl:sort select="." order="ascending"/>
								<Choice>
									<xsl:attribute name="returnvalue"><xsl:value-of select="@name"/></xsl:attribute>
									<xsl:attribute name="value"><xsl:value-of select="@display"/></xsl:attribute>
									<xsl:attribute name="default">
										<xsl:if test="@select='true'">true</xsl:if>
									</xsl:attribute>
								</Choice>
							</xsl:for-each>
						</Data>
					</xsl:if>
				</xsl:for-each>
				<xsl:if test="(OMAUserRights='7') or (OMAUserRights='3')">
					<Data name="mailto" editable="true" type="editbox" align="left" size="30">
						<xsl:attribute name="display"><xsl:value-of select="$strMailTo"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="Emailto"/></xsl:attribute>
					</Data>
				</xsl:if>
			</ListData>
			<script language="javascript">
			
				function validate()
				{
				
					mailto = document.dataarea.mailto.value;
					
					if(isAlphaNumeric(mailto, "<xsl:value-of select="$strMailTo1"/>"))
					{	
						if(mailto != ""){
							if((mailto.indexOf('@')=="-1") || (mailto.indexOf('.')=="-1")){
								alert("<xsl:value-of select="$strEnterAProper"/>");
								document.dataarea.mailto.value = "";
								document.dataarea.mailto.focus();
							}
							else if ((mailto.indexOf(',') != "-1") || (mailto.indexOf(';') != "-1")) {
								alert("<xsl:value-of select="$strMailToDoes"/>");
								document.dataarea.mailto.value = "";
								document.dataarea.mailto.focus();
							}
							else {
								return true;
							}
						}
						else{
							return true;
						}
					}
					return false;
				}
			
				function isAlphaNumeric(text, varname)
				{
					var validValue = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_'*$,.!%():[]=/?+~@";
					var ok = "yes";
					var temp;
					
					//Eliminate the spaces at the end
					while(''+text.charAt(text.length-1)==' ')
					{
						text = text.substring(0,text.length-1);
					}
					
					for (var i=0; i&lt;text.length; i++)
					{
						temp = "" + text.substring(i, i+1);
						if (validValue.indexOf(temp) == "-1")
						{
							if(temp != " ")
							{
								ok = "no";
							}
						}
					}
					if (ok == "no")
					{
						alert(<xsl:value-of select="$strErrorInvalidValue"/>);
						return false;
					}
					// DFCT85635. MOH.  Remove check for maximum length of 63 chars.
					
					return true;
				}
			
				function chgScheme(){
					options = new Array();
					temp = new Array();
					var count = "<xsl:value-of select="SkinList/@count"/>";
					<xsl:for-each select="SkinList/Skin">
						option<xsl:value-of select="@index"/> = new Array();
						var val = "<xsl:value-of select="@name"/>";
						options = options.concat(val);
						<xsl:for-each select="SchemeList/Scheme">
							var valsch= "<xsl:value-of select="@name"/>";
							option<xsl:value-of select="@index"/> = option<xsl:value-of select="@index"/>.concat(valsch);
						</xsl:for-each>				
						temp = temp.concat([option<xsl:value-of select="@index"/>]);
					</xsl:for-each>
					
					for(var i = 0 ; i  &lt; options.length ; i++){	
						if (document.getElementById("dataarea").skin.value == options[i]){
							for(var k = 0 ; k &lt;  document.getElementById("scheme").options.length ; k++){
								document.getElementById("scheme").options[k].value = "";
								document.getElementById("scheme").options[k].text = "";
							}
							document.getElementById("scheme").options.length = temp[i].length;
							for(var j = 0 ; j  &lt; temp[i].length ; j++){
							//	var oOption = document.createElement("OPTION");
							//	oOption.text=temp[i][j];
							//	oOption.value=temp[i][j];
							//	document.getElementById("scheme").add(oOption);
								document.getElementById("scheme").options[j].value = temp[i][j];
								document.getElementById("scheme").options[j].text =temp[i][j];
							}
						}
					}
				}
			</script>
		</DataArea>
	</xsl:template>
	<xsl:template match="*"/>	
</xsl:stylesheet>
