<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="xml" />
<xsl:strip-space elements="*"/>
<xsl:template match="/OMA">
<DataArea>
  <script>
		function forceSubmit(actionStr, alertflag)
		{
			actionStr = top.gnv.appendVID(actionStr);
			if (alertflag)
			{
				var msg = "<xsl:value-of select="$strRedirectMsg"/>";
				if (confirm(msg))
				{
					document.getElementById("dataarea").action = actionStr;
					document.dataarea.submit();
				}
			}
			else
			{
				document.getElementById("dataarea").action = actionStr;
				document.dataarea.submit();
			}
		}
	  </script>

		<PageTitle>
			<xsl:attribute name="display"><xsl:value-of select="$strVersionReport"/></xsl:attribute>
		</PageTitle>
		<CustomButton>
			<Data name="Refresh"><xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
				<xsl:attribute name="href">#</xsl:attribute>
				<xsl:attribute name="onclick">javascript:location.reload ()</xsl:attribute>
			</Data>
		</CustomButton>
		<TableData columnspacing="true">
			<Header>
				<Data name="Name"><xsl:attribute name="value"><xsl:value-of select="$strName"/></xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="$strName1"/></xsl:attribute>
				</Data>
				<Data name="Version"><xsl:attribute name="value"><xsl:value-of select="$strVersion"/></xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="$strVersion1"/></xsl:attribute>
				</Data>
				<Data name="Update"><xsl:attribute name="value"><xsl:value-of select="$strServerAdministratorUpdateable"/></xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="$strServerAdministratorUpdateable1"/></xsl:attribute>
				</Data>
			</Header>
			<xsl:apply-templates  select="Update"/>
		</TableData>

          <!-- Show the SUU and DUP messages for Dell Systems on Windows and Linux -->
		<xsl:if test="OEM/OEMTitleCompanyName = 'Dell'">
			<xsl:choose>
			      <xsl:when test="OSType = '1' or OSType = '2'">
		                    <!-- Windows or Linux -->
						<xsl:element name="HTMLData">
					     	<font face="helvetica" size="2" weight="bold">
					 	<xsl:value-of select="$strSUULinkInfo1"/>
						<br> </br>
						<br> </br>
						<xsl:value-of select="$strSUULinkInfo2"/>
						<br> </br>
						</font>
					</xsl:element>
	       	      </xsl:when>
	             		<xsl:otherwise>
		                    <!-- Netware -->
		             </xsl:otherwise>
			</xsl:choose>
		</xsl:if>	
			
	</DataArea>
</xsl:template>

<xsl:template match="Update">
	<xsl:apply-templates  />
</xsl:template>

<xsl:template match="Application">
	<Row>
		<Data>
			<xsl:attribute name="name"><xsl:value-of select="@name" /></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="@display" /></xsl:attribute>
		</Data>
		<Data>
			<xsl:attribute name="name"><xsl:value-of select="@name" />_version</xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="@version" /></xsl:attribute>
		</Data>
		<Data editable="false">
			<xsl:attribute name="name"><xsl:value-of select="@name" />_update</xsl:attribute>
			<xsl:if test="@update_href != ''">
				<xsl:choose>
					<xsl:when test="@update_href ='1' ">
						<xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
					  		<xsl:when test="@redirectalert='1' ">
								<xsl:attribute name="value"><xsl:value-of select="$strPerformUpdate"/></xsl:attribute>
								<xsl:choose>
									<xsl:when test="contains(@update_href,'javascript')">
										<xsl:attribute name="href"><xsl:value-of select="@update_href"/></xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
										<xsl:attribute name="href">javascript:forceSubmit('<xsl:value-of select="@update_href"/>', true)</xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:attribute name="link">true</xsl:attribute>
	  				  		</xsl:when>
					  	<xsl:otherwise>
							<xsl:attribute name="value"><xsl:value-of select="$strPerformUpdate"/></xsl:attribute>
								<xsl:choose>
									<xsl:when test="contains(@update_href,'javascript')">
										<xsl:attribute name="href"><xsl:value-of select="@update_href"/></xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
										<xsl:attribute name="href">javascript:forceSubmit('<xsl:value-of select="@update_href"/>', false)</xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>

								<xsl:attribute name="link">true</xsl:attribute>
					  		</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="@update_href = ''">
				<xsl:attribute name="value"><xsl:value-of select="$strYes"/></xsl:attribute>
			</xsl:if>
		</Data>
	</Row>
	
</xsl:template>

</xsl:stylesheet>			
