<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:output method="xml" />
<xsl:strip-space elements="*"/>
 <xsl:variable name="IsTitleSystem">
   <xsl:choose>
       <xsl:when test="/OMA/Summary/Summary/Section/@display='System'">true</xsl:when>
        <xsl:when test="/OMA/Summary/Section/@display='System'">true</xsl:when>
	      <xsl:otherwise>false</xsl:otherwise>
	    </xsl:choose>
</xsl:variable>
<xsl:template match="/OMA">
	<DataArea>
		<PageTitle>
			<xsl:attribute name="display">
				<xsl:choose>
					<xsl:when test="count(//Section) = 1">
						<xsl:choose>
							<xsl:when test="//Section/@name = 'Software'"><xsl:value-of select="$strSoftwareSummary"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$strSystemSummary"/></xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$IsTitleSystem='true'">
							<xsl:value-of select="$strSystemSummary1"/>
							</xsl:when>
							<xsl:otherwise>
							<xsl:value-of select="$strBladeModuleSummary"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</PageTitle>
		<CustomButton>
			<!--<Data name="PrintAll" display="Print All" href="#" onclick="javascript:printAll ();" /> -->
			<Data name="Refresh"><xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
				<xsl:attribute name="href">#</xsl:attribute>
				<xsl:attribute name="onclick">javascript:location.reload ()</xsl:attribute>
			</Data>

		</CustomButton>
		<PromptText ignoreoncli="true"><xsl:value-of select="$strForFasterAccess"/></PromptText>
			<SummaryData>
				<xsl:apply-templates  select="Summary"/>
		</SummaryData>
	</DataArea>
</xsl:template>

<xsl:template match="Summary">
	<xsl:apply-templates  />
</xsl:template>

<xsl:template match="@*|node()">
  <xsl:copy>
    <xsl:apply-templates select="@*|node()"/>
  </xsl:copy>
</xsl:template>

<xsl:template match="SMStatus" />

</xsl:stylesheet>
