<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="/OMA">
		<DataArea exportdata="false">
			<xsl:attribute name="submitdisplay">
				<xsl:choose>
					<xsl:when test="Reminder/@mode='svr'"><xsl:value-of select="$strRebootSystem"/></xsl:when>
					<xsl:when test="Reminder/@mode='svc'"><xsl:value-of select="$strRestartWebserver"/></xsl:when>
				</xsl:choose>			
			</xsl:attribute>		
			<xsl:attribute name="submit">
				<xsl:choose>
					<xsl:when test="Reminder/@mode='svr'">/servlet/SubmitForm?plugin=com.dell.hip.webplugins.shtdwnWebPlugin&amp;os=8&amp;action1=1</xsl:when>
					<xsl:when test="Reminder/@mode='svc'">/servlet/SubmitForm?plugin=com.dell.oma.webplugins.RstServiceWebPlugin</xsl:when>
				</xsl:choose>			
			</xsl:attribute>
			<xsl:attribute name="email">false</xsl:attribute>
			<xsl:attribute name="printable">false</xsl:attribute>
			<xsl:if test="Reminder/@logoutBtn = 'true'">
				<CustomButton>
					<Data name="LogOut">
						<xsl:attribute name="display"><xsl:value-of select="$strLogOut"/></xsl:attribute>
						<xsl:attribute name="href"><xsl:choose><xsl:when test="Reminder/@mode='svr'">/servlet/LogoutServlet?page=Logout&amp;out=true&amp;rstmode=server&amp;CurrentProgram=<xsl:value-of select="Reminder/@currentprog"/></xsl:when><xsl:when test="Reminder/@mode='svc'">/servlet/LogoutServlet?page=Logout&amp;out=true&amp;rstmode=service&amp;CurrentProgram=<xsl:value-of select="Reminder/@currentprog"/></xsl:when></xsl:choose></xsl:attribute>
					</Data>
				</CustomButton>
			</xsl:if>
			<PageTitle>
			<xsl:attribute name="display"><xsl:value-of select="$strReminderForRestart"/></xsl:attribute>
			</PageTitle>
			<PromptText>
				<xsl:choose>
					<xsl:when test="Reminder/@mode='svr'"><xsl:value-of select="$strTheServerNeeds"/></xsl:when>
					<xsl:when test="Reminder/@mode='svc'"><xsl:value-of select="$strTheServicedaemonNeeds"/></xsl:when>
				</xsl:choose>
			</PromptText>
		</DataArea>
	</xsl:template>
	<xsl:template match="*"/>	
</xsl:stylesheet>
