<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:template match="/OMA">
		<html>
			<head>
				<title><xsl:value-of select="$strAbout"/></title>
				<link rel="stylesheet" type="text/css" href="/oma/docs/oma.css"/>
				<xsl:if test="@skin != ''">
					<link rel="stylesheet" type="text/css">
						<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if>scheme.css</xsl:attribute>
					</link>
					<xsl:if test="@language != ''">
						<link rel="stylesheet" type="text/css">
							<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if><xsl:value-of select="@language"/>/scheme.css</xsl:attribute>
						</link>
						<xsl:if test="@country != ''">
							<link rel="stylesheet" type="text/css">
								<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if><xsl:value-of select="@language"/>/<xsl:value-of select="@country"/>/scheme.css</xsl:attribute>
							</link>
						</xsl:if>
					</xsl:if>
				</xsl:if>
				<script language="javascript">
					function init()
					{
						var width;
						if (window.innerWidth == null) {
							width = document.body.clientWidth;
						}
						else {
							width = window.innerWidth;
						}
						var line = document.getElementsByTagName("hr");
						for(i=0; i &lt; line.length; i++)
						{
							line[i].width = width -50;
						}
					}
					function noResize()
					{
						parent.resizeTo(375, 300);
					}
				</script>
			</head>
			<body marginheight="0" marginwidth="0" topmargin="0" leftmargin="0" onResize="javascript:init();" onload="javascript:init();">
				<div align="right">
					<table border="0" cellpadding="0" cellspacing="0">
						<tr>
							<td colspan="1">
								<img src="/oma/images/blank.gif" style="height: 15px" />
							</td>
						</tr>
						<tr>
							<td>
								<xsl:call-template name="button_details">
									<xsl:with-param name="href">/servlet/UDataArea?plugin=com.dell.oma.webplugins.AboutWebPlugin</xsl:with-param>
									<xsl:with-param name="display"><xsl:value-of select="$strBack"/></xsl:with-param>
								</xsl:call-template>
							</td>
							<td>
								<xsl:call-template name="button_details">
									<xsl:with-param name="href">javascript:parent.print()</xsl:with-param>
									<xsl:with-param name="display"><xsl:value-of select="$strPrint"/></xsl:with-param>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</div>
				<table width="100%" border="0">
					<tr>
						<td/>
						<td nowrap="nowrap">
							<xsl:apply-templates select="About"/>
						</td>
						<td/>
					</tr>
				</table>
				<table border="0" width="100%">
					<tr>
						<td width="2"/>
						<td>
							<iframe height="200" width="100%" src="/oma/copyright.html" />
						</td>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
	<xsl:template match="About">
		<xsl:call-template name="LegalCopyright">
			<xsl:with-param name="copyright"><xsl:value-of select="About/LegalCopyright"/></xsl:with-param>
		</xsl:call-template>
		<br/>
		<xsl:value-of select="About/CompanyName"/>
		<br/>
		<br/>
		<br/>
		<hr width="325" align="left" noshade="noshade" size="2"></hr>
		<xsl:apply-templates select="About/Component"/>
		<br/>
	</xsl:template>
	<xsl:template match="About/Component">
		<xsl:choose>
			<xsl:when test="ID = 'osia' and Name">
				<!--IGNORE, AutDB provides only the version while name comes from OEM.ini-->
			</xsl:when>
			<xsl:when test="ID = 'OLD' or ID = 'old' or ID = 'odf' or ID = 'OLDCOMMON'">
				<!--IGNORE, OLD is removed from OMSA, so hide OLD components details.  -->
			</xsl:when>
			<xsl:when test="ID = 'osia'">
				<xsl:choose>
					<xsl:when test="(../OEMTitleCompanyName)!=''">
						<xsl:value-of select="../OEMTitleCompanyName" />&#160;<xsl:value-of select="../OEMTitleCoreProductName" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="../OEMTitleCoreProductName" />
					</xsl:otherwise>
				</xsl:choose>
				
				<br/>
				<xsl:if test="../OEMTitleVersion">
					<xsl:value-of select="$strVersion"/>
					<xsl:value-of select="../OEMTitleVersion"/>
					<br/>
				</xsl:if>
				<hr width="325" align="left" noshade="noshade" size="2"></hr>
			</xsl:when>
			<xsl:when test="Name">
				<xsl:value-of select="Name"/>
				<br/>
				<xsl:choose>
					<xsl:when test="Version">
						<xsl:value-of select="$strVersion1"/>
						<xsl:value-of select="Version"/>
							<!-- Add build number for oma framework -->
							<xsl:if test="ID = 'OMACORE' or ID = 'omacore' ">
								<xsl:variable name="buildNum"><xsl:value-of select="BuildNumber"/></xsl:variable>
								<xsl:if test="$buildNum != ''"> (<xsl:value-of select="$buildNum"/>)</xsl:if>
							</xsl:if>
						<br/>
					</xsl:when>
				</xsl:choose>
				<hr width="325" align="left" noshade="noshade" size="2"></hr>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="button_details">
		<xsl:param name="href"/>
		<xsl:param name="display"/>
		<xsl:param name="onclick"/>
		<xsl:param name="id"/>
		<td style="width: 14px; height: 25px">
			<img style="width: 14px; height: 25px">
				<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/lbutton.gif</xsl:attribute>
			</img>
		</td>
		<td class="data-area-button" align="center" valign="middle">
			<a>
				<xsl:attribute name="href"><xsl:value-of select="$href"/></xsl:attribute>
				<xsl:if test="$onclick != ''"><xsl:attribute name="onclick"><xsl:value-of select="$onclick"/></xsl:attribute></xsl:if>
				<xsl:if test="$id != ''"><xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute></xsl:if>
				<xsl:value-of select="$display"/>
			</a>
		</td>
		<td style="width: 14px; height: 25px">
			<img style="width: 14px; height: 25px">
				<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/rbutton.gif</xsl:attribute>
			</img>
		</td>
	</xsl:template>

	<xsl:template name="LegalCopyright">
		<xsl:param name="copyright"/>
		<xsl:choose>
			<xsl:when test="substring-after($copyright , '1995-2008.') =' All rights reserved.'">
				<xsl:variable name="laststr"><xsl:value-of select="$strAllRightsReserved"/></xsl:variable>
				<xsl:value-of select="concat(substring-before($copyright , 'All') , $laststr)"/>
			</xsl:when>
			<xsl:otherwise><xsl:value-of select="$copyright"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="*"/>
</xsl:stylesheet>
