<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!-- This XSL Stylesheet is used to handle Storage Services Message IDs -->
	<xsl:include href="../../sm/template/common/smmsgs.xsl"/>
	<xsl:include href="../../sm/template/en/common/smmsgs.xsl"/>
	<xsl:include href="commsg.xsl"/>
	<xsl:output method="text" indent="no"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="/OMA">
		<!-- CLISubCommand prints out the sub command along with the appropriate number of spaces -->
		<xsl:call-template name="CLISubCommand">
			<xsl:with-param name="command">
				<xsl:value-of select="CLISubCommand"/>
			</xsl:with-param>
		</xsl:call-template>
		<!-- CLIMsgID -->
		<xsl:choose>
			<!--First make sure syntax check was successful before displaying the status from DA-->
			<!--next check to see if CLIMsgID = 1011 and value for CustomStat is set to non-zero. This is a case where SMStatus is non-zero and "clpsup" updates CLIMsgId=1011 to reflect the non-zero SMStatus from DA-->
			<!-- Ideally if syntax check fails,command should not be sent to DA and should never have the CustomStat tag-->
			<xsl:when test="CLIMsgID='1000' and CustomStat">
				<xsl:call-template name="GetMessage">
					<xsl:with-param name="ErrorID">
						<xsl:value-of select="CustomStat"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="CLIMsgID='1011' and CustomStat">
				<xsl:call-template name="GetMessage">
					<xsl:with-param name="ErrorID">
						<xsl:value-of select="CustomStat"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="CLIMsgID">
					<xsl:with-param name="id">
						<xsl:value-of select="CLIMsgID"/>
					</xsl:with-param>
					<xsl:with-param name="shownvpairs">
						<xsl:value-of select="CLIShowNVPairs"/>
					</xsl:with-param>
					<xsl:with-param name="nametxt">
						<xsl:value-of select="CLIParseName"/>
					</xsl:with-param>
					<xsl:with-param name="paramtxt">
						<xsl:value-of select="CLIParamName"/>
					</xsl:with-param>
					<xsl:with-param name="parsetxt">
						<xsl:value-of select="CLIParseTxt"/>
					</xsl:with-param>
					<xsl:with-param name="parsetxt2">
						<xsl:value-of select="CLIParseTxt2"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="CLIMsgID">
		<xsl:param name="id"/>
		<xsl:param name="shownvpairs"/>
		<xsl:param name="nametxt"/>
		<xsl:param name="paramtxt"/>
		<xsl:param name="parsetxt"/>
		<xsl:param name="parsetxt2"/>
		<xsl:choose>
			<xsl:when test="$id='6000'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">storage</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Display storage component properties.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id='6001'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">storage</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Set storage component properties.<!--XLATESTOP-->
			</xsl:when>
			<!-- omreport storage controller usage -->
			<xsl:when test="$id = '6011'">
				<!--XLATESTART-->Display controller(s) properties.<!--XLATESTOP-->
				<xsl:if test="$shownvpairs = 'true'">
					<xsl:call-template name="NewLine"/>
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->Optional parameters are:<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>controller=id              </xsl:text>
					<!--XLATESTART-->Display the properties of the specified controller.<!--XLATESTOP-->
				</xsl:if>
			</xsl:when>
			<!-- omreport storage adisk usage -->
			<xsl:when test="$id = '6021'">
				<!--XLATESTART-->Display array disk(s) properties. DEPRECATED: please use pdisk<!--XLATESTOP-->
				<xsl:if test="$shownvpairs = 'true'">
					<xsl:call-template name="NewLine"/>
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->Required parameters are:<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>controller=id               </xsl:text>
					<!--XLATESTART-->All array disks are displayed<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->Optional parameters are:<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>vdisk=id                    </xsl:text>
					<!--XLATESTART-->All array disks that comprise the indicated<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->                            virtual disk<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>connector=id                  </xsl:text>
					<!--XLATESTART-->All array disks on the indicated connector<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>adisk=&lt;ADISKID&gt;               </xsl:text>
					<!--XLATESTART-->The indicated array disk<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
        				<xsl:text>    where ADISKID=&lt;connector:enclosureID:portID | connector:targetID&gt;</xsl:text>	
					<xsl:call-template name="NewLine"/>
				</xsl:if>
			</xsl:when>
			<!-- omreport storage pdisk usage -->
			<xsl:when test="$id = '6022'">
				<!--XLATESTART-->Display physical disk(s) properties.<!--XLATESTOP-->
				<xsl:if test="$shownvpairs = 'true'">
					<xsl:call-template name="NewLine"/>
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->Required parameters are:<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>controller=id               </xsl:text>
					<!--XLATESTART-->All physical disks are displayed<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->Optional parameters are:<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>vdisk=id                    </xsl:text>
					<!--XLATESTART-->All physical disks that comprise the indicated<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->                            virtual disk<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>connector=id                  </xsl:text>
					<!--XLATESTART-->All physical disks on the indicated connector<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>pdisk=&lt;PDISKID&gt;               </xsl:text>
					<!--XLATESTART-->The indicated physical disk<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
        				<xsl:text>    where PDISKID=&lt;connector:enclosureID:portID | connector:targetID&gt;</xsl:text>	
					<xsl:call-template name="NewLine"/>
				</xsl:if>
			</xsl:when>
			<!-- omreport storage vdisk usage -->
			<xsl:when test="$id = '6031'">
				<!--XLATESTART-->Display virtual disk(s) properties.<!--XLATESTOP-->
				<xsl:if test="$shownvpairs = 'true'">
					<xsl:call-template name="NewLine"/>
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->Optional parameters are:<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>controller=id             </xsl:text>
					<!--XLATESTART-->All virtual disks on the indicated controller<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>controller=id vdisk=id    </xsl:text>
					<!--XLATESTART-->The indicated virtual disk<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
				</xsl:if>
			</xsl:when>
			<!-- omreport storage connectors usage -->
			<xsl:when test="$id = '6042'">
				<!--XLATESTART-->Display connector properties.<!--XLATESTOP-->
				<xsl:if test="$shownvpairs = 'true'">
					<xsl:call-template name="NewLine"/>
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->Required parameters are:<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>controller=id          </xsl:text>
					<!--XLATESTART-->All connectors are displayed<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->Optional parameters are:<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>connector=id	       </xsl:text>
					<!--XLATESTART-->The indicated connector on the given controller<!--XLATESTOP-->
				</xsl:if>
			</xsl:when>
			<!-- omreport storage enclosure usage -->
			<xsl:when test="$id='6051'">
				<!--XLATESTART-->Display enclosure properties.<!--XLATESTOP-->
				<xsl:if test="$shownvpairs = 'true'">
					<xsl:call-template name="NewLine"/>
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->Optional parameters are:<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>controller=id			</xsl:text>
					<!--XLATESTART-->All enclosures connected to the controller.<!--XLATESTART-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>controller=id enclosure=&lt;ENCLOSUREID&gt;	</xsl:text>
					<!--XLATESTART-->Information about indicated enclosure<!--XLATESTART-->
					<xsl:call-template name="NewLine"/>
        				<xsl:text>    where ENCLOSUREID=&lt;connector | connector:enclosureID&gt;</xsl:text>	
					<xsl:call-template name="NewLine"/>
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->For a given enclosure, component info can be obtained by specifying the following parameters<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>info=temps			</xsl:text>
					<!--XLATESTART-->Information about all temperature probe.<!--XLATESTART-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>info=temps index=n		</xsl:text>
					<!--XLATESTART-->Information about a specific temperature probe.<!--XLATESTART-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>info=fans			</xsl:text>
					<!--XLATESTART-->Information about all fans.<!--XLATESTART-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>info=fans index=n		</xsl:text>
					<!--XLATESTART-->Information about a specific fan.<!--XLATESTART-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>info=pwrsupplies		</xsl:text>
					<!--XLATESTART-->Information about all power supplies.<!--XLATESTART-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>info=pwrsupplies index=n	</xsl:text>
					<!--XLATESTART-->Information about a specific power supply.<!--XLATESTART-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>info=emms			</xsl:text>
					<!--XLATESTART-->Information about all EMMs.<!--XLATESTART-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>info=emms index=n		</xsl:text>
					<!--XLATESTART-->Information about a specific EMM.<!--XLATESTART-->
				</xsl:if>
			</xsl:when>
			<!-- omreport storage battery usage -->
			<xsl:when test="$id = '6061'">
				<!--XLATESTART-->Display battery properties.<!--XLATESTOP-->
				<xsl:if test="$shownvpairs = 'true'">
					<xsl:call-template name="NewLine"/>
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->Optional parameters are:<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>controller=id               </xsl:text>
					<!--XLATESTART-->All batteries on the indicated controller<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>controller=id battery=id    </xsl:text>
					<!--XLATESTART-->The indicated battery<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
				</xsl:if>
			</xsl:when>
			<!-- omreport storage globalinfo usage -->
			<xsl:when test="$id = '6062'">
				<!--XLATESTART-->Display global storage properties.<!--XLATESTOP-->
			</xsl:when>
			<!-- HAVEN'T LOOKED AT THE BELOW CODE YET! -->
			<xsl:when test="$id = '6941'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">battery</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Supports battery configuration commands.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '6942'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">battery</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Supports battery configuration commands.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=recondition
    Required parameters are:
        controller=id 
        battery=id
reconditions given battery</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=startlearn
    Required parameters are:
        controller=id 
        battery=id 
starts a learn cycle on the given battery</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=delaylearn
    Required parameters are:
        controller=id 
        battery=id 
        days=d 
        hours=h
delays a learn cycle on the given battery for the specified amount of time</xsl:text>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '6951'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">enclosure</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Supports enclosure configuration commands.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id='6952'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">enclosure</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Supports enclosure configuration commands.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=enablealarm
    Required parameters are:
        controller=id 
        enclosure=&lt;ENCLOSUREID&gt;
    where ENCLOSUREID=&lt;connector | connector:enclosureID&gt; 
enables enclosure alarm</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=disablealarm
    Required parameters are:
        controller=id 
        enclosure=&lt;ENCLOSUREID&gt;
    where ENCLOSUREID=&lt;connector | connector:enclosureID&gt; 
disables enclosure alarm</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=setassettag
    Required parameters are:
        controller=id 
        enclosure=&lt;ENCLOSUREID&gt;
        assettag=&lt;string&gt;
    where ENCLOSUREID=&lt;connector | connector:enclosureID&gt; 
sets enclosure asset tag</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=setassetname
    Required parameters are:
        controller=id 
        enclosure=&lt;ENCLOSUREID&gt;
        assetname=&lt;string&gt;
    where ENCLOSUREID=&lt;connector | connector:enclosureID&gt; 
sets enclosure asset name</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=settempprobes
    Required parameters are:
        controller=id 
        enclosure=&lt;ENCLOSUREID&gt;
        index=id 
        minwarn=n 
        maxwarn=n 
    where ENCLOSUREID=&lt;connector | connector:enclosureID&gt; 
sets minimum warning and maximum warning threshold for temperature probes</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=resettempprobes
    Required parameters are:
        controller=id 
        enclosure=&lt;ENCLOSUREID&gt;
        index=id 
    where ENCLOSUREID=&lt;connector | connector:enclosureID&gt; 
sets to default minimum warning and maximum warning threshold for temperature probes</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=setalltempprobes
    Required parameters are:
        controller=id 
        enclosure=&lt;ENCLOSUREID&gt;
        minwarn=n 
        maxwarn=n 
    where ENCLOSUREID=&lt;connector | connector:enclosureID&gt; 
sets minimum warning and maximum warning threshold for all temperature probes</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=resetalltempprobes
    Required parameters are:
        controller=id 
        enclosure=&lt;ENCLOSUREID&gt;
    where ENCLOSUREID=&lt;connector | connector:enclosureID&gt; 
sets to default minimum warning and maximum warning threshold for all temperature probes</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=blink
    Required parameters are:
        controller=id 
        enclosure=&lt;ENCLOSUREID&gt;
    where ENCLOSUREID=&lt;connector | connector:enclosureID&gt; 
blinks the enclosure LEDs</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=unblink
    Required parameters are:
        controller=id 
        enclosure=&lt;ENCLOSUREID&gt;
    where ENCLOSUREID=&lt;connector | connector:enclosureID&gt; 
unblinks the enclosure LEDs</xsl:text>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<!-- omconfig storage connector-->
			<xsl:when test="$id = '6963'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">connector</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Supports connector configuration commands.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '6964'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">connector</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Supports connector configuration commands.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=rescan
    Required parameters are:
        controller=id 
        connector=id 
performs rescan on the given connector</xsl:text>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<!--omconfig storage -? -->
			<xsl:when test="$id='6971'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">controller</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Supports controller configuration commands.<!--XLATESTOP-->
			</xsl:when>
			<!--omconfig storage controller -? -->
			<xsl:when test="$id='6972'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">controller</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Supports controller configuration commands.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=rescan
    Required parameters are:
        controller=id
performs rescan on the given controller</xsl:text>
				<xsl:call-template name="NewLine"/>
        <xsl:text>
action=enablealarm
    Required parameters are:
        controller=id
enables alarm on the given controller</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=disablealarm
    Required parameters are:
        controller=id
disables alarm on the given controller</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=quietalarm
    Required parameters are:
        controller=id
quiets alarm on the given controller</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=testalarm	
    Required parameters are:
        controller=id
tests alarm by sounding the alarm for about 2 seconds</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=resetconfig
    Required parameters are:
        controller=id
    Optional parameters are:
	force=yes  
resets configuration on the given controller</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=createvdisk
    Required parameters are:
        controller=id
        raid=&lt;c | r0 | r1 | r1c | r5 | r10 | r50 | r6 | r60&gt; 
        size=[&lt;number&gt;&lt;b | m | g&gt; | &lt;max | min&gt;]
        pdisk=&lt;PDISKID,PDISKID,.....&gt;
    where PDISKID=&lt;connector:enclosureID:portID | connector:targetID&gt;	
    Optional parameters are:
        stripesize=&lt; 2kb | 4kb | 8kb | 16kb | 32kb | 64kb | 128kb | 256kb | 512kb | 1mb&gt;
        cachepolicy=&lt;d | c&gt;
        readpolicy=&lt;ra | nra | ara | rc | nrc&gt;
        writepolicy=&lt;wb | wt | wc | nwc |fwb&gt; 
        diskcachepolicy=&lt;disabled | enabled&gt;          
        name=&lt;string&gt;
        spanlength=&lt;n&gt;
lets user create a virtual disk on given controller</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=setrebuildrate
    Required parameters are:
        controller=id
        rate=&lt;0 to 100&gt; 
sets controller rebuild rate property</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=setchangecontrollerproperties
    Required parameters are controller id and one of the following optional parameters:
        controller=id
    Optional parameters are:
        bgirate=rate 
        reconstructrate=rate
        checkconsistencyrate=rate
        rebuildrate=rate
        clearredundantpath=clear
        abortcheckconsistencyonerror=enabled/disabled
        loadbalance=auto/disabled
        allowrevertiblehotspareandreplacemember=enabled/disabled
        autoreplacememberonpredictivefailure=enabled/disabled
        
        rate=&lt;0 to 100&gt; 
lets user set one or more of the above  properties</xsl:text>
        <xsl:call-template name="NewLine"/>
        <xsl:text>
action=discardpreservedcache
    Required parameters are:
        controller=id
        forcepreservedcachediscard=enabled/disabled
discards the controller preserved cache</xsl:text>
        <xsl:call-template name="NewLine"/>
        <xsl:text>
action=setbgirate
    Required parameters are:
        controller=id
        rate=&lt;0 to 100&gt; 
sets controller bgi rate property</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=setreconstructrate
    Required parameters are:
        controller=id
        rate=&lt;0 to 100&gt; 
sets controller reconstruct rate property</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=setcheckconsistencyrate
    Required parameters are:
        controller=id
        rate=&lt;0 to 100&gt; 
sets controller check consistency rate property</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=exportlog
    Required parameters are:
        controller=id
exports the controller log to windows folder on Windows and /var/log on Linux. Depending on the controller, the log file name will be either afa_&lt;mmdd&gt;.log or lsi_&lt;mmdd&gt;.log where &lt;mmdd&gt; is the month and date</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=importforeignconfig
    Required parameters are:
        controller=id
imports configuration from foreign disks</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=importrecoverforeignconfig
    Required parameters are:
        controller=id
imports or recovers foreign, degraded, or failed virtual disks residing on foreign physical disks</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>				
action=clearforeignconfig
    Required parameters are:
        controller=id
clears configuration on foreign disks</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=setpatrolreadmode
    Required parameters are:
        controller=id
        mode=manual|auto|disable
set patrol read mode to manual or auto or disabled</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=startpatrolread
    Required parameters are:
        controller=id 
start patrol read.  This action is possible only when patrol read  mode is manual</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=stoppatrolread
    Required parameters are:
        controller=id 
stop patrol read.  This action is possible only when patrol read mode is manual</xsl:text>
			</xsl:when>
			<xsl:when test="$id='6981'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">vdisk</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Supports virtual disk configuration commands.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id='6982'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">vdisk</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Supports virtual disk configuration commands.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=checkconsistency
    Required parameters are:
        controller=id 
        vdisk=id 
initiates check consistency operation on given virtual disk </xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=cancelcheckconsistency
    Required parameters are:
        controller=id 
        vdisk=id 
cancels check consistency operation on given virtual disk</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=pausecheckconsistency
    Required parameters are:
        controller=id 
        vdisk=id 
pauses check consistency operation on given virtual disk</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=resumecheckconsistency
    Required parameters are:
        controller=id 
        vdisk=id 
resumes check consistency operation on given virtual disk</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=blink
    Required parameters are:
        controller=id 
        vdisk=id 
blinks the given virtual Disk</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=unblink
    Required parameters are:
        controller=id 
        vdisk=id 
unblinks the given virtual Disk</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=initialize
    Required parameters are:
        controller=id 
        vdisk=id 
initializes the given virtual Disk</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=fastinit
    Required parameters are:
        controller=id 
        vdisk=id 
	Optional parameters are:
        force=yes
performs a fast initialization on the given virtual Disk</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=slowinit
    Required parameters are:
        controller=id 
        vdisk=id 
	Optional parameters are:
        force=yes
performs a slow initialization on the given virtual Disk</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=cancelinitialize
    Required parameters are:
        controller=id 
        vdisk=id 
cancels initialization on the given virtual Disk</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=cancelbginitialize
    Required parameters are:
        controller=id 
        vdisk=id 
cancels background initialization on the given virtual Disk</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=restoresegments
    Required parameters are:
        controller=id 
        vdisk=id 
recovers disk space occupied by a dead disk segment</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=splitmirror
    Required parameters are:
        controller=id 
        vdisk=id 
converts a mirror set into two concatenated or RAID 0 sets without erasing 
any redundant data</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=unmirror
    Required parameters are:
        controller=id 
        vdisk=id 
converts a mirror set into 1 concatenated set or RAID 0 set without erasing 
any redundent data and restores the other half of the mirror set to free space.</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=assigndedicatedhotspare
    Required parameters are:
        controller=id 
        vdisk=id 
        assign=&lt;yes | no&gt; 
        pdisk=&lt;PDISKID&gt;
    where PDISKID=&lt;connector:enclosureID:portID | connector:targetID&gt;	
assigns/unassigns a physical disk to the given virtual disk</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=deletevdisk
    Required parameters are:
        controller=id 
        vdisk=id 
    Optional parameters are:
        force=yes
deletes the given virtual disk</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=format
    Required parameters are:
        controller=id 
        vdisk=id 
formats the given virtual disk</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=reconfigure
    Required parameters are:
        controller=id 
        vdisk=id 
        raid=&lt;c | r0 | r1 | r1c | r5 | r6 | r10&gt; 
        size=&lt;size&gt; 
        pdisk=&lt;PDISKID,PDISKID,.....&gt;
    where PDISKID=&lt;connector:enclosureID:portID | connector:targetID&gt;	
changes RAID level of a virtual disk or expand the virtual disk by adding new physical disks.</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=changepolicy
    Required parameters are:
        controller=id 
        vdisk=id 
    Optional parameters are:
        readpolicy=&lt;ra | nra | ara | rc | nrc&gt;
        writepolicy=&lt;wb | wt | wc | nwc | fwb&gt;
        cachepolicy=&lt;d | c&gt;
	  diskcachepolicy=&lt;disabled | enabled&gt;
lets user modify read, write and/or cache policy of the given virtual disk</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=replacememberdisk
    Required parameters are:
        controller=id 
        vdisk=id
        source=&lt;PDISKID&gt;
        destination=&lt;PDISKID&gt;
    where PDISKID=&lt;connector:enclosureID:portID | connector:targetID&gt;	
replaces the member of given virtual disk with given destination disk</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=rename
    Required parameters are:
        controller=id 
        vdisk=id 
        name=&lt;string&gt;
renames the given virtual disk</xsl:text>
			</xsl:when>
			<!-- Adisk command should be deprecated -->
			<xsl:when test="$id = '6991'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">adisk</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Supports array disk configuration commands. DEPRECATED: please use pdisk<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '6992'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">adisk</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Supports array disk configuration commands. DEPRECATED: please use pdisk<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=blink
    Required parameters are:
        controller=id 
        adisk=&lt;ADISKID&gt;
    where ADISKID=&lt;connector:enclosureID:portID | connector:targetID&gt;	
blinks the given array disk</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=unblink
    Required parameters are:
        controller=id 
        adisk=&lt;ADISKID&gt;
    where ADISKID=&lt;connector:enclosureID:portID | connector:targetID&gt;	
unblinks the given array disk</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=remove
    Required parameters are:
        controller=id 
        adisk=&lt;ADISKID&gt;
    where ADISKID=&lt;connector:enclosureID:portID | connector:targetID&gt;	
prepares the array disk for removal</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=initialize
    Required parameters are:
        controller=id 
        adisk=&lt;ADISKID&gt;
    where ADISKID=&lt;connector:enclosureID:portID | connector:targetID&gt;	
initializes the given array disk</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=offline
    Required parameters are:
        controller=id 
        adisk=&lt;ADISKID&gt;
    where ADISKID=&lt;connector:enclosureID:portID | connector:targetID&gt;	
offlines the given array disk</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=online
    Required parameters are:
        controller=id 
        adisk=&lt;ADISKID&gt;
    where ADISKID=&lt;connector:enclosureID:portID | connector:targetID&gt;	
onlines the given array disk</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=assignglobalhotspare
    Required parameters are:
        controller=id 
        adisk=&lt;ADISKID&gt;
        assign=&lt;yes | no&gt;
    where ADISKID=&lt;connector:enclosureID:portID | connector:targetID&gt;	
assigns/unassigns the given array disk as global hot spare</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=rebuild
    Required parameters are:
        controller=id 
        adisk=&lt;ADISKID&gt;
    where ADISKID=&lt;connector:enclosureID:portID | connector:targetID&gt;	
rebuilds the given array disk</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=cancelrebuild
    Required parameters are:
        controller=id 
        adisk=&lt;ADISKID&gt;
    where ADISKID=&lt;connector:enclosureID:portID | connector:targetID&gt;	
cancels rebuild on the given array disk</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=cancelreplacemember
    Required parameters are:
        controller=id 
        adisk=&lt;ADISKID&gt;
    where ADISKID=&lt;connector:enclosureID:portID | connector:targetID&gt;	
cancels replace member operation on the given array disk</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=removedeadsegments
    Required parameters are:
        controller=id 
        adisk=&lt;ADISKID&gt;
    where ADISKID=&lt;connector:enclosureID:portID | connector:targetID&gt;	
removes the disk space occupied by a dead disk segment</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=clear
    Required parameters are:
        controller=id 
        adisk=&lt;ADISKID&gt;
    where ADISKID=&lt;connector:enclosureID:portID | connector:targetID&gt;	
clears the given array disk</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=cancelclear
    Required parameters are:
        controller=id 
        adisk=&lt;ADISKID&gt;
    where ADISKID=&lt;connector:enclosureID:portID | connector:targetID&gt;	
cancels clear operation on the given array disk

DEPRECATED: Please use pdisk instead of adisk</xsl:text>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<!-- pdisk commands -->
			<xsl:when test="$id = '6997'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">pdisk</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Supports physical disk configuration commands.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '6998'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">pdisk</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Supports physical disk configuration commands. <!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=blink
    Required parameters are:
        controller=id 
        pdisk=&lt;PDISKID&gt;
    where PDISKID=&lt;connector:enclosureID:portID | connector:targetID&gt;	
blinks the given physical disk</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=unblink
    Required parameters are:
        controller=id 
        pdisk=&lt;PDISKID&gt;
    where PDISKID=&lt;connector:enclosureID:portID | connector:targetID&gt;	
unblinks the given physical disk</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=remove
    Required parameters are:
        controller=id 
        pdisk=&lt;PDISKID&gt;
    where PDISKID=&lt;connector:enclosureID:portID | connector:targetID&gt;	
prepares the physical disk for removal</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=initialize
    Required parameters are:
        controller=id 
        pdisk=&lt;PDISKID&gt;
    where PDISKID=&lt;connector:enclosureID:portID | connector:targetID&gt;	
initializes the given physical disk</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=offline
    Required parameters are:
        controller=id 
        pdisk=&lt;PDISKID&gt;
    where PDISKID=&lt;connector:enclosureID:portID | connector:targetID&gt;	
offlines the given physical disk</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=online
    Required parameters are:
        controller=id 
        pdisk=&lt;PDISKID&gt;
    where PDISKID=&lt;connector:enclosureID:portID | connector:targetID&gt;	
onlines the given physical disk</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=assignglobalhotspare
    Required parameters are:
        controller=id 
        pdisk=&lt;PDISKID&gt;
        assign=&lt;yes | no&gt;
    where PDISKID=&lt;connector:enclosureID:portID | connector:targetID&gt;	
assigns/unassigns the given physical disk as global hot spare</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=rebuild
    Required parameters are:
        controller=id 
        pdisk=&lt;PDISKID&gt;
    where PDISKID=&lt;connector:enclosureID:portID | connector:targetID&gt;	
rebuilds the given physical disk</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=cancelrebuild
    Required parameters are:
        controller=id 
        pdisk=&lt;PDISKID&gt;
    where PDISKID=&lt;connector:enclosureID:portID | connector:targetID&gt;	
cancels rebuild on the given physical disk</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=cancelreplacemember
    Required parameters are:
        controller=id 
        pdisk=&lt;PDISKID&gt;
    where PDISKID=&lt;connector:enclosureID:portID | connector:targetID&gt;	
cancels replace member operation on the given physical disk</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=removedeadsegments
    Required parameters are:
        controller=id 
        pdisk=&lt;PDISKID&gt;
    where PDISKID=&lt;connector:enclosureID:portID | connector:targetID&gt;	
removes the disk space occupied by a dead disk segment</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=clear
    Required parameters are:
        controller=id 
        pdisk=&lt;PDISKID&gt;
    where PDISKID=&lt;connector:enclosureID:portID | connector:targetID&gt;	
clears the given physical disk</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=cancelclear
    Required parameters are:
        controller=id 
        pdisk=&lt;PDISKID&gt;
    where PDISKID=&lt;connector:enclosureID:portID | connector:targetID&gt;	
cancels clear operation on the given physical disk</xsl:text>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			
			<!-- global info help-->
			<xsl:when test="$id = '6994'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">globalinfo</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Supports global storage configuration commands.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '6995'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">globalinfo</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Supports global storage configuration commands. <!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=enablests
enables smart thermal shutdown </xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=disablests	
disables smart thermal shutdown </xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>
action=globalrescan
performs rescan on all controllers and connectors</xsl:text>
				<xsl:call-template name="NewLine"/>
			</xsl:when>

			<!--Storage services specific user error messages -->
			<xsl:when test="$id='1600'">
				<!--XLATETHIS-->Invalid controller value. Read, controller=<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:choose>
					<xsl:when test="$parsetxt2=''">No controllers found.</xsl:when>
					<xsl:otherwise><!--XLATETHIS-->Valid values for controller are: <xsl:value-of select="$parsetxt2"/><!--XLATETHIS--></xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$id='1601'">
				<!--XLATETHIS-->Invalid connector value. Read, connector=<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Valid values for connector are: <xsl:value-of select="$parsetxt2"/>
				<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1602'">
				<!--XLATETHIS-->Invalid physical disk value. Read, pdisk=<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Valid values for physical disk are: <xsl:value-of select="$parsetxt2"/>
				<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1603'">
				<!--XLATETHIS-->Invalid target value.<!--XLATETHIS-->
				<xsl:value-of select="$nametxt"/>, <xsl:value-of select="$paramtxt"/>, <xsl:value-of select="$parsetxt"/>, <xsl:value-of select="$parsetxt2"/>
			</xsl:when>
			<xsl:when test="$id='1604'">
				<!--XLATETHIS-->Invalid vdisk value. Read, vdisk=<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Valid values for vdisk are: <xsl:value-of select="$parsetxt2"/>
				<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1605'">
				<!--XLATETHIS-->Invalid enclosure value. Read, enclosure=<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Valid values for enclosure are: <xsl:value-of select="$parsetxt2"/>
				<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1606'">
				<!--XLATETHIS-->Invalid size value<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1607'">
				<!--XLATETHIS-->Invalid units for size value.<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Valid units are bytes, megabytes and gigabytes.<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->e.g 123456789b for bytes, 250m for megabytes or 33g for gigabytes.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1608'">
				<!--XLATETHIS-->No free space on given physical disk.<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id='1609'">
				<!--XLATETHIS-->Raid input value not supported on given controller. Read,raid=<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Supported values for raid are: <xsl:value-of select="$parsetxt2"/>
				<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1610'">
				<!--XLATETHIS-->Read policy input value not supported on given controller. Read,readpolicy=<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Supported values for readpolicy are: <xsl:value-of select="$parsetxt2"/>
				<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1611'">
				<!--XLATETHIS-->Write policy input value not supported on given controller. Read,writepolicy=<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Supported values for writepolicy are: <xsl:value-of select="$parsetxt2"/>
				<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1612'">
				<!--XLATETHIS-->Cache policy input value not supported on given controller. Read,cachepolicy=<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Supported values for cachepolicy are: <xsl:value-of select="$parsetxt2"/>
				<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1613'">
				<!--XLATETHIS-->Stripe size input value not supported on given controller. Read,stripesize=<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Supported values for stripesize are: <xsl:value-of select="$parsetxt2"/>
				<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1614'">
				<!--XLATETHIS-->Operation not supported. Read, action=<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>Refer to the documentation for more information.
			</xsl:when>
			<xsl:when test="$id='1615'">
				<!--XLATETHIS-->Operation disabled. Read, action=<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->
				<!--XLATETHIS-->.Refer to the documentation for more information.
			</xsl:when>
			<xsl:when test="$id='1616'">
				<!--XLATETHIS-->Input value for fan index not supported on given enclosure. Read,index=<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Supported values for fan index is: <xsl:value-of select="$parsetxt2"/>
				<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1617'">
				<!--XLATETHIS-->Input value for temps index not supported on given enclosure. Read,index=<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Supported values for temps index is: <xsl:value-of select="$parsetxt2"/>
				<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1618'">
				<!--XLATETHIS-->Input value for pwrsupplies index not supported on given enclosure. Read,index=<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Supported values for pwrsupplies index is: <xsl:value-of select="$parsetxt2"/>
				<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1619'">
				<!--XLATETHIS-->Input value for emms index not supported on given enclosure. Read,index=<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Supported values for emms index is: <xsl:value-of select="$parsetxt2"/>
				<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1620'">
				<!--XLATETHIS-->Invalid battery value. Read, battery=<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Valid values for battery are: <xsl:value-of select="$parsetxt2"/>
				<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1621'">
				<!--XLATETHIS-->Invalid virtual disk name. Read, name=<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Valid name characters are: <xsl:value-of select="$parsetxt2"/>
				<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1622'">
				<!--XLATETHIS-->Invalid vdisk value. Read, vdisk=<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->No virtual disks were found on controller <xsl:value-of select="$parsetxt2"/>
				<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1623'">
				<!--XLATETHIS-->The virtual disk cannot be created on the physical disks you selected. Possible reasons include: Insufficient disk space, available disks are not initialized, incorrect number of disks selected, unsupported mix of SAS and SATA type disks, controller restrictions or unsupported configuration.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1624'">
				<!--XLATETHIS-->Invalid min/max warn values. <xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Valid values for minwarn are: <xsl:value-of select="$parsetxt"/>
				<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Valid values for maxwarn are: <xsl:value-of select="$parsetxt2"/>
				<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1625'">
				<!--XLATETHIS-->Invalid enclosure asset tag. Read, assettag=<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Valid name characters are: <xsl:value-of select="$parsetxt2"/>
				<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1626'">
				<!--XLATETHIS-->Invalid enclosure asset name. Read, assetname=<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Valid name characters are: <xsl:value-of select="$parsetxt2"/>
				<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1627'">
				<!--XLATETHIS-->Invalid physical disk value. Read, pdisk=<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Hot spare is not allowed in physical disk list.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1628'">
				<!--XLATETHIS-->No batteries found<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1629'">
				<!--XLATETHIS-->Invalid physical disk value. Read, pdisk=<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->The physical disk cannot be assigned as dedicated hot spare to the virtual disk you selected. Possible reasons include: Invalid physical disk id, insufficient physical disk space, unsupported mix of SAS and SATA type physical disks.<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Valid values for physical disk are: <xsl:value-of select="$parsetxt2"/>
			</xsl:when>
			<xsl:when test="$id='1630'">
				<!--XLATETHIS-->Invalid virtual disk name. Read, name=<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Maximum virtual disk name length allowed is: <xsl:value-of select="$parsetxt2"/>
				<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1631'">
        <!--XLATETHIS-->SpanLength parameter is missing. Specify spanlength to create a Raid 50 virtual disk.<!--XLATETHIS-->
			</xsl:when>
                        <xsl:when test="$id='1632'">
				<!--XLATETHIS-->Invalid spanlength value. Read, spanlength=<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->The value of the span length should be an even number and should be less than or equal to half the number of disks available. Minimum span length for RAID 10 is 2.<!--XLATETHIS-->
			</xsl:when>			
			<xsl:when test="$id='1633'">
				<!--XLATETHIS-->Invalid parameter: spanlength<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Spanlength is required for a Raid 50 virtual disk.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1634'">
				<!--XLATETHIS-->No temperature probes were found on enclosure <xsl:value-of select="$parsetxt"/>.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1635'">
				<!--XLATETHIS-->Raid 1 virtual disk should use two physical disks.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1636'">
				<!--XLATETHIS-->Raid 5 virtual disk should use at least 3 physical disks.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1637'">
				<!--XLATETHIS-->Raid 10 or Raid1Concat virtual disk should use at least 4 physical disks and the number of physical disks should be even.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1638'">
				<!--XLATETHIS-->Raid 50 virtual disk should use at least 6 physical disks.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1639'">
				<!--XLATETHIS-->New and old names for the virtual disk are the same. Read, name=<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id='1640'">
				<!--XLATETHIS-->New and old asset tags are the same. Read, name=<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id='1641'">
				<!--XLATETHIS-->New and old asset names are the same. Read, name=<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id='1642'">
				<!--XLATETHIS-->The maximum number of virtual disks for this controller has been reached.<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Maximum number of virtual disks allowed: <xsl:value-of select="$parsetxt"/>.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1643'">
				<!--XLATETHIS-->Invalid command. Read, info=<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1644'">
				<!--XLATETHIS-->Invalid mindrives value. Read, mindrives=<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->
				<!--XLATETHIS-->mindrives should be less than or equal to the number of physical disks specified.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1645'">
				<!--XLATETHIS-->Invalid command. Read, mindrives=<!--XLATETHIS-->
                                
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->
				<!--XLATETHIS-->mindrives should be specified only in combination with physical disk values.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1646'">
				<!--XLATETHIS-->Invalid virtual disk size value. Valid virtual disk size range for the physical disks selected are:<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Minimum virtual disk size = <xsl:value-of select="$parsetxt"/>mb<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Maximum virtual disk size = <xsl:value-of select="$parsetxt2"/>mb<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1647'">
				<!--XLATETHIS-->The new values for minimum and maximum temperature thresholds are the same as the current values.<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Minimum Warning Threshold = <xsl:value-of select="$parsetxt"/>
				<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Maximum Warning Threshold = <xsl:value-of select="$parsetxt2"/>
				<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1648'">
				<!--XLATETHIS-->The new value for rebuild rate is the same as the current value.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1650'">
				<!--XLATETHIS-->Invalid service request command. Please contact your service representative for support.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1651'">
				<!--XLATETHIS-->Invalid parameter: spanlength<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Specify the span length only if you are creating a RAID 10 (optional parameter), RAID 50, or RAID 60 virtual disk.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1652'">
				<!--XLATETHIS-->User input and current read policies are the same. Read, readpolicy=<!--XLATETHIS--><xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id='1653'">
				<!--XLATETHIS-->User input and current write policies are the same. Read, writepolicy=<!--XLATETHIS--><xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id='1654'">
				<!--XLATETHIS-->User input and current cache policies are the same. Read, cachepolicy=<!--XLATETHIS--><xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<!--Error code 1655 is generated when malloc() fails or an expected required paarmeter is missing. Should never hit this case... -->
			<xsl:when test="$id='1655'">
				<!--XLATETHIS-->CLI sub-system critical error.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1656'">
				<!--XLATETHIS-->The new value for bgi rate is the same as the current value.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1657'">
				<!--XLATETHIS-->The new value for patrol read rate is the same as the current value.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1658'">
				<!--XLATETHIS-->The new value for reconstruct rate is the same as the current value.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1659'">
				<!--XLATETHIS-->The new value for check consistency rate is the same as the current value.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1660'">
				<!--XLATETHIS-->Invalid mode value. Read, mode=<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Valid values for mode are: <xsl:value-of select="$parsetxt2"/>
				<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1661'">
				<!--XLATETHIS-->Patrol Read Rate is not applicable or cannot be set for this controller.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1675'">
				<!--XLATETHIS-->Disk Cache Policy is same as the current disk cache policy.<!--XLATETHIS-->
			</xsl:when>

			<xsl:when test="$id='1677'">
				<!--XLATETHIS-->The new value for abortcheckconsistencyonerror is the same as the current value.<!--XLATETHIS-->
			</xsl:when>

			<xsl:when test="$id='1678'">
				<!--XLATETHIS-->The new value for allowrevertiblehotspareandreplacemember  is the same as the current value.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1679'">
				<!--XLATETHIS-->The new value for autoreplacememberonpredictivefailure is the same as the current value.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1680'">
				<!--XLATETHIS-->The new value for loadbalance is the same as the current value.<!--XLATETHIS-->
			</xsl:when>


			<xsl:when test="$id='1662'">
				<!--XLATETHIS-->Invalid delay learn amount: <xsl:value-of select="$parsetxt"/><!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Maximum allowed delay learn amount: <xsl:value-of select="$parsetxt2"/><!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1663'">
				<!--XLATETHIS-->Invalid asset tag: <xsl:value-of select="$parsetxt"/><!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Maximum allowed asset tag length: <xsl:value-of select="$parsetxt2"/><!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1664'">
				<!--XLATETHIS-->Invalid asset name: <xsl:value-of select="$parsetxt"/><!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Maximum allowed asset name length: <xsl:value-of select="$parsetxt2"/><!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1665'">
				<!--XLATETHIS-->Invalid size parameter: reconfiguration size can not be specified by the user on this controller.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1667'">
				<!--XLATETHIS-->Error! Required parameter missing: pdisk<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1668'">
				<!--XLATETHIS-->Error! Cannot use both pdisk and adisk parameters.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id='1670'">
				<!--XLATETHIS-->Invalid spanlength value. Read, spanlength=<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
		      <xsl:when test="$id='1671'">
			      <!--XLATETHIS-->SpanLength parameter is missing. Specify spanlength to create a Raid 60 virtual disk.<!--XLATETHIS-->
		      </xsl:when>
		      <xsl:when test="$id='1672'">
		            <!--XLATETHIS-->Raid 6 virtual disk should use at least 4 physical disks.<!--XLATETHIS-->
		      </xsl:when>
		      <xsl:when test="$id='1673'">
		            <!--XLATETHIS-->Raid 60 virtual disk should use at least 8 physical disks.<!--XLATETHIS-->
		      </xsl:when>
                      <xsl:when test="$id='1676'">
				<!--XLATETHIS-->Invalid source value. Read, source=<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Valid values for source physical disk are: <xsl:value-of select="$parsetxt2"/>
				<!--XLATETHIS-->
		      </xsl:when>
                      <xsl:when test="$id='1681'">
                        <!--XLATETHIS-->The new learn mode for battery is the same as the current value.<!--XLATETHIS-->
                      </xsl:when>
                  <xsl:when test="$id='1682'">
        	            <!--XLATETHIS-->Change Learn Mode is not applicable or cannot be set for this controller.<!--XLATETHIS-->
                  </xsl:when>
                <xsl:when test="$id='1684'">
                  <!--XLATETHIS-->Invalid virtual disk size value. Valid virtual disk size range for the physical disks selected are:<!--XLATETHIS-->
                  <xsl:call-template name="NewLine"/>
                  <!--XLATETHIS-->Virtual disk size = <xsl:value-of select="$parsetxt"/>mb<!--XLATETHIS-->
                </xsl:when>

                  <xsl:when test="$id='1685'">
                        <!--XLATETHIS-->Invalid spanlength value. Read, spanlength=<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
        	            <!--XLATETHIS-->Minimum spanlength value for RAID50 is: 3.<!--XLATETHIS-->
                  </xsl:when>
			<xsl:when test="$id='1686'">
                        <!--XLATETHIS-->Invalid spanlength value. Read, spanlength=<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
        	            <!--XLATETHIS-->Minimum spanlength value for RAID60 is: 4.<!--XLATETHIS-->
                  </xsl:when>
      <xsl:when test="$id='1687'">
        <!--XLATETHIS-->Please specify atleast one or more properties for the controller to be set.<!--XLATETHIS-->
      </xsl:when>
      <xsl:when test="$id='1688'">
        <!--XLATETHIS-->allowrevertiblehotspareandreplacemember cannot be disabled, unless autoreplacememberonpredictivefailure is disabled.<!--XLATETHIS-->
      </xsl:when>
      <xsl:when test="$id='1689'">
        <!--XLATETHIS-->Enable allowrevertiblehotspareandreplacemember before enabling autoreplacememberonpredictivefailure.<!--XLATETHIS-->
      </xsl:when>

      <xsl:when test="$id='1690'">
                        <!--XLATETHIS-->Invalid spanlength value. Read, spanlength=<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
        	            <!--XLATETHIS-->Only supported spanlength for RAID10 in this controller is: 2.<!--XLATETHIS-->
		  </xsl:when>
	          <xsl:when test="$id='1691'">
				<!--XLATETHIS-->Invalid destination value. Read, destination=<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Valid values for destination physical disk are: <xsl:value-of select="$parsetxt2"/>
				<!--XLATETHIS-->
		  </xsl:when>

      <xsl:when test="$id='1692'">
        <!--XLATETHIS-->Invalid value for the forcepreservedcachediscard.<!--XLATETHIS-->
      </xsl:when>

      <!--Srik: call OMSA's ComCLIMsgID in commsg.xsl -->
			<xsl:otherwise>
				<xsl:call-template name="ComCLIMsgID">
					<xsl:with-param name="id"><xsl:value-of select="CLIMsgID"/></xsl:with-param>
					<xsl:with-param name="shownvpairs"><xsl:value-of select="CLIShowNVPairs"/></xsl:with-param>
					<xsl:with-param name="nametxt"><xsl:value-of select="CLIParseName"/></xsl:with-param>
					<xsl:with-param name="paramtxt"><xsl:value-of select="CLIParamName"/></xsl:with-param>
					<xsl:with-param name="parsetxt"><xsl:value-of select="CLIParseTxt"/></xsl:with-param>
					<xsl:with-param name="parsetxt2"><xsl:value-of select="CLIParseTxt2"/></xsl:with-param>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:call-template name="NewLine"/>
	</xsl:template>
	<!--:Chethan Kumar 10/22/04 - Added the "ConfigSuccess" template to keep error messages consistent with DSA error messages -->
	<xsl:template name="ConfigSuccess">
		<xsl:param name="subCom"/>
		<xsl:param name="paramNam"/>
		<xsl:param name="parseTxt"/>
		<xsl:param name="parseTxt2"/>
		<xsl:choose>
			<xsl:when test="$subCom = 'alertaction'">
				<xsl:text>Alert action(s) configured successfully.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'alertlog'">
				<xsl:text>Alert log cleared successfully.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'assetinfo'">
				<xsl:text>Asset information set successfully.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'cmdlog'">
				<xsl:text>Command log cleared successfully.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'esmlog'">
				<xsl:text>Embedded System Management (ESM) log cleared successfully.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'recovery'">
				<xsl:text>System recovery actions configured successfully.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'shutdown'">
				<xsl:text>System shutdown in progress.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'thrmshutdown'">
				<xsl:text>Thermal shutdown severity level configured successfully.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'webserver'">
				<xsl:choose>
					<xsl:when test="$paramNam = 'start'">
						<xsl:text>Secure Port Server started successfully.</xsl:text>
					</xsl:when>
					<xsl:when test="$paramNam = 'stop'">
						<xsl:text>Secure Port Server stopped successfully.</xsl:text>
					</xsl:when>
					<xsl:when test="$paramNam = 'restart'">
						<xsl:text>Secure Port Server restarted successfully.</xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>Secure Port Server error.</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$subCom = 'snmp'">
				<xsl:choose>
					<xsl:when test="$paramNam = 'rootpw'">
						<xsl:text>SNMP root password set successfully.</xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>Preference set successfully.</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$subCom = 'useraccess'">
				<xsl:text>User access rights set successfully.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'cdvformat'">
				<xsl:text>CDV format delimiter set successfully.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'useraccess'">
				<xsl:text>User access rights set successfully.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'dirservice'">
				<xsl:text>Directory service configuration set successfully.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'events'">
				<xsl:choose>
					<xsl:when test="$parseTxt2='bytype'">
						<xsl:choose>
							<xsl:when test="$paramNam = 'all'">
								<xsl:text>Events configured successfully.</xsl:text>
							</xsl:when>
							<xsl:when test="$paramNam = 'powersupplies'">
								<xsl:text>Power supply events configured successfully.</xsl:text>
							</xsl:when>
							<xsl:when test="$paramNam = 'redundancy'">
								<xsl:text>Redundancy events configured successfully.</xsl:text>
							</xsl:when>
							<xsl:when test="$paramNam = 'temps'">
								<xsl:text>Temperature probe events configured successfully.</xsl:text>
							</xsl:when>
							<xsl:when test="$paramNam = 'fans'">
								<xsl:text>Fan probe events configured successfully.</xsl:text>
							</xsl:when>
							<xsl:when test="$paramNam = 'volts'">
								<xsl:text>Voltage probe events configured successfully.</xsl:text>
							</xsl:when>
							<xsl:when test="$paramNam = 'currents'">
								<xsl:text>Current probe events configured successfully.</xsl:text>
							</xsl:when>
							<xsl:when test="$paramNam = 'log'">
								<xsl:text>Log events configured successfully.</xsl:text>
							</xsl:when>
							<xsl:when test="$paramNam = 'fanenclosures'">
								<xsl:text>Fan enclosure events configured successfully.</xsl:text>
							</xsl:when>
							<xsl:when test="$paramNam = 'accords'">
								<xsl:text>AC Cord events configured successfully.</xsl:text>
							</xsl:when>
							<xsl:when test="$paramNam = 'memory'">
								<xsl:text>Memory events configured successfully.</xsl:text>
							</xsl:when>
							<xsl:when test="$paramNam = 'intrusion'">
								<xsl:text>Intrusion events configured successfully.</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>Event Configured successfully.</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:when test="$parseTxt2='byoid'">
						<xsl:choose>
							<xsl:when test="$paramNam = 'powersupplies'">
								<xsl:text>Single power supply event configured successfully.</xsl:text>
							</xsl:when>
							<xsl:when test="$paramNam = 'redundancy'">
								<xsl:text>Single redundancy event configured successfully.</xsl:text>
							</xsl:when>
							<xsl:when test="$paramNam = 'temps'">
								<xsl:text>Single temperature probe events configured successfully.</xsl:text>
							</xsl:when>
							<xsl:when test="$paramNam = 'fans'">
								<xsl:text>Single fan probe event configured successfully.</xsl:text>
							</xsl:when>
							<xsl:when test="$paramNam = 'volts'">
								<xsl:text>Single voltage probe event configured successfully.</xsl:text>
							</xsl:when>
							<xsl:when test="$paramNam = 'currents'">
								<xsl:text>Single current probe event configured successfully.</xsl:text>
							</xsl:when>
							<xsl:when test="$paramNam = 'log'">
								<xsl:text>Single log event configured successfully.</xsl:text>
							</xsl:when>
							<xsl:when test="$paramNam = 'fanenclosures'">
								<xsl:text>Single enclosure event configured successfully.</xsl:text>
							</xsl:when>
							<xsl:when test="$paramNam = 'accords'">
								<xsl:text>Single AC Cord event configured successfully.</xsl:text>
							</xsl:when>
							<xsl:when test="$paramNam = 'memory'">
								<xsl:text>Single memory event configured successfully.</xsl:text>
							</xsl:when>
							<xsl:when test="$paramNam = 'intrusion'">
								<xsl:text>Single intrusion event configured successfully.</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>Single event Configured successfully.</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<!--XLATESTART-->Event(s) configured successfully.<!--XLATESTOP-->
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$subCom = 'platformevents'">
				<xsl:text>Platform events configured successfully.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'pedestinations'">
				<xsl:text>Platform event destinations configured successfully.</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<!--XLATESTART-->Command successful.<!--XLATESTOP-->
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--:Chethan Kumar 10/22/04 - Added "CLIParamFormat" template to keep error messages consistent with DSA error messages -->
	<xsl:template name="CLIParamFormat">
		<xsl:param name="format"/>
		<xsl:choose>
			<xsl:when test="$format = '1'">
				<xsl:text>text</xsl:text>
			</xsl:when>
			<xsl:when test="$format = '2'">
				<xsl:text>text</xsl:text>
			</xsl:when>
			<xsl:when test="$format = '3'">
				<xsl:text>text (alphanumeric only)</xsl:text>
			</xsl:when>
			<xsl:when test="$format = '4'">
				<xsl:text>number</xsl:text>
			</xsl:when>
			<xsl:when test="$format = '5'">
				<xsl:text>&lt;true|false&gt;</xsl:text>
			</xsl:when>
			<xsl:when test="$format = '6'">
				<xsl:text>number</xsl:text>
			</xsl:when>
			<xsl:when test="$format = '7'">
				<xsl:text>number</xsl:text>
			</xsl:when>
			<xsl:when test="$format = '8'">
				<xsl:text>d.d</xsl:text>
			</xsl:when>
			<xsl:when test="$format = '9'">
				<xsl:text>number</xsl:text>
			</xsl:when>
			<xsl:when test="$format = '10'">
				<xsl:text>date</xsl:text>
			</xsl:when>
			<xsl:when test="$format = '19'">
				<xsl:text>percent (0-100)</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<!--XLATESTART-->value<!--XLATESTOP-->
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--:Chethan Kumar 10/22/04 - Added "CLIObjNotFound" template to keep error messages consistent with DSA error messages -->
	<xsl:template name="CLIObjNotFound">
		<xsl:param name="subCom"/>
		<xsl:param name="paramNam"/>
		<xsl:choose>
			<xsl:when test="$subCom = 'esmlog'">
				<xsl:text>Error! Embedded System Management(ESM) log not found..</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'postlog'">
				<xsl:text>Error! Power On Self Test (POST log not found..</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'alertlog'">
				<xsl:text>Error! Alert log not found.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'events'">
				<xsl:text>Error! Event type</xsl:text>
				<xsl:value-of select="$paramNam"/>
				<xsl:text> not found on this system.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'platformevents'">
				<xsl:text>Error! Platform events are not supported on this system.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'pedestinations'">
				<xsl:text>Error! Platform event destinations are not supported on this system.</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<!--XLATESTART-->Error! Hardware or feature not present.<!--XLATESTOP-->
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--:Chethan Kumar 10/22/04 - Added "CLICommandFailed" template to keep error messages consistent with DSA error messages -->
	<xsl:template name="CLICommandFailed">
		<xsl:param name="subCom"/>
		<xsl:param name="paramNam"/>
		<xsl:param name="parseTxt"/>
		<xsl:param name="parseTxt2"/>
		<xsl:param name="stat"/>
		<xsl:choose>
			<xsl:when test="$subCom = 'webserver'">
				<xsl:choose>
					<xsl:when test="$paramNam = 'start'">
						<xsl:choose>
							<xsl:when test="$stat = '258'">
								<xsl:text>Error! Secure Port Server is already started.</xsl:text>
							</xsl:when>
							<xsl:when test="$stat = '-9'">
								<xsl:text>Error! Web Server is not installed.</xsl:text>
							</xsl:when>
							<xsl:when test="$stat = '1'">
								<xsl:text>Error! Command not implemented on this operating system.</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>Error! Cannot start </xsl:text>
								<xsl:value-of select="$parseTxt"/>
								<xsl:text>  web server.</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:when test="$paramNam = 'stop'">
						<xsl:choose>
							<xsl:when test="$stat = '258'">
								<xsl:text>Error! Secure Port Server is already stopped.</xsl:text>
							</xsl:when>
							<xsl:when test="$stat = '-9'">
								<xsl:text>Error! Web Server is not installed.</xsl:text>
							</xsl:when>
							<xsl:when test="$stat = '1'">
								<xsl:text>Error! Command not implemented on this operating system.</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>Error! Cannot stop Secure Port Server.</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:when test="$paramNam = 'restart'">
						<xsl:choose>
							<xsl:when test="$stat = '258'">
								<xsl:text>Error! Secure Port Server is already stopped. </xsl:text>
								<xsl:call-template name="NewLine"/>
								<xsl:text>Please start the Secure Port Server first.</xsl:text>
							</xsl:when>
							<xsl:when test="$stat = '-9'">
								<xsl:text>Error! Web Server is not installed.</xsl:text>
							</xsl:when>
							<xsl:when test="$stat = '1'">
								<xsl:text>Error! Command not implemented on this operating system.</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>Error! Cannot stop Secure Port Server.</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>Error! Server Administrator unknown Secure Port Server error.</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$subCom = 'snmp'">
				<xsl:choose>
					<xsl:when test="$paramNam = 'rootpw'">
						<xsl:choose>
							<xsl:when test="$stat = '2'">
								<xsl:text>Error! SNMP old root password entered does not match current value.</xsl:text>
							</xsl:when>
							<xsl:when test="$stat = '1'">
								<xsl:text>Error! Command not implemented.</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>Error! Attempt to set SNMP root password failed.</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>Error! Attempt to set requested preference failed.</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$subCom = 'events'">
				<xsl:choose>
					<xsl:when test="$paramNam != 'all'">
						<xsl:choose>
							<xsl:when test="$stat = '2'">
								<xsl:choose>
									<xsl:when test="$parseTxt2 ='byoid'">
										<!--XLATESTART-->Error! Cannot enable single event at lower severity than current group setting.<!--XLATESTOP-->
									</xsl:when>
									<xsl:otherwise>
										<xsl:text>Error! Cannot enable more events for type=</xsl:text>
										<xsl:value-of select="$paramNam"/>
										<xsl:text> than current type=all setting.</xsl:text>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:when test="$stat = '1'">
								<xsl:text>Error! Events setting failed.</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>Error! Events setting failed.</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>Error! Attempt to set events for all types failed.</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$subCom = 'platformevents'">
				<xsl:text>Error! Platform events are not supported on this system.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'pedestinations'">
				<xsl:text>Error! Platform event destinations are not supported on this system.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'dirservice'">
				<xsl:text>Error! Command failed.</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<!--XLATESTART-->Error! Hardware subsystem reports command failed. <!--XLATESTOP-->
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
