<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:output method="text" />
	<xsl:strip-space elements="*" />
	<xsl:template match="ClipUsage">
		<xsl:value-of select="/ClipUsage"/>
		<xsl:text>
</xsl:text>
	</xsl:template>
	<xsl:template match="OMA">
		<xsl:call-template name="CLIMSG">
			<xsl:with-param name="id">
				<xsl:value-of select="CLIMsgID"/>
			</xsl:with-param>
			<xsl:with-param name="cliname">
				<xsl:value-of select="CLIName"/>
			</xsl:with-param>
			<xsl:with-param name="filename">
				<xsl:value-of select="FileName"/>
			</xsl:with-param>
			<xsl:with-param name="outputformat">
				<xsl:value-of select="OutputFormat"/>
			</xsl:with-param>
			<xsl:with-param name="invalidoption">
				<xsl:value-of select="InvalidOption"/>
			</xsl:with-param>
			<xsl:with-param name="invalidini">
				<xsl:value-of select="InvalidINI"/>
			</xsl:with-param>
			<xsl:with-param name="invalidprog">
				<xsl:value-of select="InvalidProg"/>
			</xsl:with-param>
			<xsl:with-param name="invalidcmd">
				<xsl:value-of select="InvalidCMD"/>
			</xsl:with-param>
			<xsl:with-param name="progname">
				<xsl:value-of select="ProgName"/>
			</xsl:with-param>
			<xsl:with-param name="status">
				<xsl:value-of select="Status"/>
			</xsl:with-param>
			<xsl:with-param name="parsetxt">
				<xsl:value-of select="CLIParseTxt"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="CLIMSG">
		<xsl:param name="id"/>
		<xsl:param name="cliname"/>
		<xsl:param name="filename"/>
		<xsl:param name="outputformat"/>
		<xsl:param name="invalidoption"/>
		<xsl:param name="invalidini"/>
		<xsl:param name="invalidprog"/>
		<xsl:param name="invalidcmd"/>
		<xsl:param name="progname"/>
		<xsl:param name="clipname"/>
		<xsl:param name="status"/>
		<xsl:choose>
			<xsl:when test="$id = '0'">
				<xsl:text>Message here</xsl:text>
			</xsl:when>
			<xsl:when test="$id = '1900'">system         <!--XLATESTART--> Configure system components<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1910'">chassis         <!--XLATESTART-->Configure chassis components<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '2001'">asset              <!--XLATESTART--> Set Asset parameters for this system<!--XLATETHIS-->
<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '2002'">
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->Valid parameters are one of: <!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>tag=&lt;string&gt;              <!--XLATETHIS-->Set asset tag value <!--XLATETHIS-->
                           <xsl:call-template name="NewLine"/>cost=&lt;number&gt;             <!--XLATETHIS-->Set purchase cost <!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>waybill=&lt;number&gt;          <!--XLATETHIS-->Set way bill number <!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>installdate=&lt;mmddyy&gt;      <!--XLATETHIS-->Set date of installation <!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>purchasedate=&lt;mmddyy&gt;     <!--XLATETHIS-->Set date of purchase <!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>ponum=&lt;number&gt;            <!--XLATETHIS-->Set purchase order number <!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>signauth=&lt;string&gt;         <!--XLATETHIS-->Set name of signing authority <!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>owner=&lt;string&gt;            <!--XLATETHIS-->Set system owner name <!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>systemlocation=&lt;string&gt;   <!--XLATETHIS-->Set system location <!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>primaryuser=&lt;string&gt;      <!--XLATETHIS-->Set primary user name <!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>primaryphone=&lt;string&gt;     <!--XLATETHIS-->Set primary user phone number <!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '2011'">esmlog              <!--XLATESTART-->ESM Log configuration commands<!--XLATESTOP-->
			<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '2012'">
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
                               <xsl:call-template name="NewLine"/>
    action=clear           <!--XLATESTART-->Clear the contents of the ESM log<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '2021'">alertlog            <!--XLATESTART-->Alert Log configuration commands<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '2022'">
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
                               <xsl:call-template name="NewLine"/>
    action=clear           <!--XLATESTART-->Clear the contents of the Alert log<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '2031'">cmdlog              <!--XLATESTART-->Command log configuration commands<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '2032'">
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
                               <xsl:call-template name="NewLine"/>
    action=clear           <!--XLATESTART-->Clear the contents of the Command log<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '2041'">lra                 <!--XLATESTART-->Set LRA (Local Response Action) parameters<!--XLATESTOP-->
			<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '2042'">
				<xsl:call-template name="NewLine"/>
				 <!--XLATESTART-->Valid parameters are one of: <!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>event=powersupply           <!--XLATESTART-->Set power supply failure actions<!--XLATESTOP-->
                           <xsl:call-template name="NewLine"/>event=tempnoncrit           <!--XLATESTART-->Set temperature non critical faluire actions <!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>event=tempcrit              <!--XLATESTART-->Set temperature critical failure actions<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>event=fannoncrit            <!--XLATESTART-->Set fan speed non critical failure actions<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>event=fancrit               <!--XLATESTART-->Set fan speed critical failure actions<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>event=voltnoncrit           <!--XLATESTART-->Set voltage non critical failure actions<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>event=voltcrit              <!--XLATESTART-->Set voltage critical failure actions<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>event=currentnoncrit        <!--XLATESTART-->Set current non critical failure actions<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>event=currentcrit           <!--XLATESTART-->Set current critical failure actions<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>event=intrusioncrit         <!--XLATESTART-->Set chassis intrusion actions<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>event=redundegrad           <!--XLATESTART-->Set redundancy degraded actions<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>event=redunlost             <!--XLATESTART-->Set redundancy lost actions<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>event=memeccnoncrit         <!--XLATESTART-->Set memory ECC non critical failure actions<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>event=memecccrit            <!--XLATESTART-->Set memory ECC critical failure actions<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>event=thermalshutdown       <!--XLATESTART-->Set thermal protection actions<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>				<!--XLATESTART-->For each event, either specify one or more actions or specify execappath: <!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>beep=&lt;true|false&gt;           <!--XLATESTART-->Enable / disable beep speaker<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>alert=&lt;true|false&gt;          <!--XLATESTART-->Enable / disable consol alert<!--XLATESTOP-->	     		             <xsl:call-template name="NewLine"/>broadcast=&lt;true|false&gt;      <!--XLATESTART-->Enable / disable broadcast message<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>clearall=&lt;true&gt;             <!--XLATESTART-->Clear all actions for this event<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>defaultall=&lt;true&gt;           <!--XLATESTART-->Set default actions for this event<!--XLATESTOP-->
		             <xsl:call-template name="NewLine"/>execappath=&lt;string&gt;         <!--XLATESTART-->Enable / disable broadcast message<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '2051'">recovery            <!--XLATESTART-->Set recovery parameters<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '2052'">
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
                               <xsl:call-template name="NewLine"/>action=reboot            <!--XLATESTART-->On recovery, reboot the server<!--XLATESTOP-->
                               <xsl:call-template name="NewLine"/>action=poweroff          <!--XLATESTART-->On recovery, poweroff the server<!--XLATESTOP-->
                               <xsl:call-template name="NewLine"/>action=powercycle        <!--XLATESTART-->On recovery, power cycle the server<!--XLATESTOP-->
                               <xsl:call-template name="NewLine"/>action=osshutdown        <!--XLATESTART-->On recovery, shutdown the OS first<!--XLATESTOP-->
                               <xsl:call-template name="NewLine"/>timer=&lt;number&gt;           <!--XLATESTART-->Set expiry time ( seconds )<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '2061'">shutdown            <!--XLATESTART-->Shutdown server<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '2062'">
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
                               <xsl:call-template name="NewLine"/>action=reboot            <!--XLATESTART-->Shutdown, reboot the server<!--XLATESTOP-->
                               <xsl:call-template name="NewLine"/>action=poweroff          <!--XLATESTART-->Shutdown, poweroff the server<!--XLATESTOP-->
                               <xsl:call-template name="NewLine"/>action=powercycle        <!--XLATESTART-->Shutdown and power cycle the server<!--XLATESTOP-->
                               <xsl:call-template name="NewLine"/>osfirst=&lt;true|false&gt;     <!--XLATESTART-->On shutdown, shutdown the OS first<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '3001'">
<!--XLATESTART-->current              Set current probe thresholds<!--XLATESTOP--><xsl:call-template name="NewLine"/>
			</xsl:when>			
			<xsl:when test="$id = '3002'">
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
                               <xsl:call-template name="NewLine"/>index=&lt;number&gt;              <!--XLATESTART-->Probe index ( must be specified )<!--XLATESTOP-->
                               <xsl:call-template name="NewLine"/>minwarnthresh=&lt;number&gt;    <!--XLATESTART-->Minimum warning threshold<!--XLATESTOP-->
                               <xsl:call-template name="NewLine"/>maxwarnthresh=&lt;number&gt;    <!--XLATESTART-->Maximum warning threshold<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '3011'">
<!--XLATESTART-->fan                  Set fan probe thresholds<!--XLATESTOP--><xsl:call-template name="NewLine"/>
			</xsl:when>			
			<xsl:when test="$id = '3012'">
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
                               <xsl:call-template name="NewLine"/>index=&lt;number&gt;              <!--XLATESTART-->Probe index ( must be specified )<!--XLATESTOP-->
                               <xsl:call-template name="NewLine"/>minwarnthresh=&lt;number&gt;    <!--XLATESTART-->Minimum warning threshold<!--XLATESTOP-->
                               <xsl:call-template name="NewLine"/>maxwarnthresh=&lt;number&gt;    <!--XLATESTART-->Maximum warning threshold<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '3021'">
<!--XLATESTART-->temperature          Set temperature probe thresholds<!--XLATESTOP--><xsl:call-template name="NewLine"/>
			</xsl:when>			
			<xsl:when test="$id = '3022'">
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
                               <xsl:call-template name="NewLine"/>index=&lt;number&gt;              <!--XLATESTART-->Probe index ( must be specified )<!--XLATESTOP-->
                               <xsl:call-template name="NewLine"/>minwarnthresh=&lt;number&gt;    <!--XLATESTART-->Minimum warning threshold<!--XLATESTOP-->
                               <xsl:call-template name="NewLine"/>maxwarnthresh=&lt;number&gt;    <!--XLATESTART-->Maximum warning threshold<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '3031'">
<!--XLATESTART-->voltage              Set voltage probe thresholds<!--XLATESTOP--><xsl:call-template name="NewLine"/>
			</xsl:when>	
			<xsl:when test="$id = '3032'">
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
                               <xsl:call-template name="NewLine"/>index=&lt;number&gt;              <!--XLATESTART-->Probe index ( must be specified )<!--XLATESTOP-->
                               <xsl:call-template name="NewLine"/>minwarnthresh=&lt;number&gt;    <!--XLATESTART-->Minimum warning threshold<!--XLATESTOP-->
                               <xsl:call-template name="NewLine"/>maxwarnthresh=&lt;number&gt;    <!--XLATESTART-->Maximum warning threshold<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '3041'">
<!--XLATESTART-->fancontrol           Set fan control to quiet or max cooling<!--XLATESTOP--><xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '3042'">
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
                               <xsl:call-template name="NewLine"/>speed=quiet       <!--XLATESTART-->Set fan speed to quiet mode<!--XLATESTOP-->
                               <xsl:call-template name="NewLine"/>speed=maxcool    <!--XLATESTART-->Set fan speed to max cooling mode<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			
			<xsl:when test="$id = '3051'">acswitch             <!--XLATESTART-->Set acswitch parameters<!--XLATESTOP--><xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '3052'">
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->valid parameters are:<!--XLATESTOP-->
                               <xsl:call-template name="NewLine"/>mode=sourcea       <!--XLATESTART--><!--XLATESTOP-->
                               <xsl:call-template name="NewLine"/>mode=sourceareturn<!--XLATESTART--><!--XLATESTOP-->
                               <xsl:call-template name="NewLine"/>mode=sourceb       <!--XLATESTART--><!--XLATESTOP-->
                               <xsl:call-template name="NewLine"/>mode=sourcebreturn       <!--XLATESTART--><!--XLATESTOP-->
                               <xsl:call-template name="NewLine"/>mode=sourceshare       <!--XLATESTART--><!--XLATESTOP-->
                               <xsl:call-template name="NewLine"/>redunexpected=&lt;true|false&gt;       <!--XLATESTART--><!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			
			<xsl:when test="$id = '3061'">biossetup            <!--XLATESTART-->Set bios setup values<!--XLATESTOP--><xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '3062'">
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
                               <xsl:call-template name="NewLine"/>setting=numlock  bootmode=&lt;on|off&gt;    <!--XLATESTART--><!--XLATESTOP-->
                              <xsl:call-template name="NewLine"/>setting=diskette  bootmode=&lt;disable|autoenable|nopxeenable&gt;    <!--XLATESTART--><!--XLATESTOP-->
                              <xsl:call-template name="NewLine"/>setting=usb  enable=&lt;true|false&gt;    <!--XLATESTART--><!--XLATESTOP-->
                              <xsl:call-template name="NewLine"/>setting=ide  enable=&lt;true|false&gt;    <!--XLATESTART--><!--XLATESTOP-->
                              <xsl:call-template name="NewLine"/>setting=scsi  enable=&lt;true|false&gt;    <!--XLATESTART--><!--XLATESTOP-->
                              <xsl:call-template name="NewLine"/>setting=bootsequence  device=&lt;diskettefirst|hdonly|devicelist|cdromfirst&gt;    <!--XLATESTART--><!--XLATESTOP-->
                              <xsl:call-template name="NewLine"/>setting=ppaddress  mapto=&lt;disable|lpt1|lpt2|lpt3&gt;    <!--XLATESTART--><!--XLATESTOP-->
                              <xsl:call-template name="NewLine"/>setting=ppmode  type=&lt;at|ps2|esp|epp&gt;    <!--XLATESTART--><!--XLATESTOP-->
                              <xsl:call-template name="NewLine"/>setting=serialport1  mapto=&lt;disable|autoenable|com1|com3&gt;    <!--XLATESTART--><!--XLATESTOP-->
                              <xsl:call-template name="NewLine"/>setting=serialport2  mapto=&lt;disable|autoenable|com2|com4&gt;    <!--XLATESTART--><!--XLATESTOP-->
                             <xsl:call-template name="NewLine"/>setting=speaker  volume=&lt;off|on|low|medium|high&gt;<!--XLATESTART--><!--XLATESTOP-->
                             <xsl:call-template name="NewLine"/>setting=wakeonlan  nic=&lt;dissable|expansion|onboard|addin&gt;<!--XLATESTART--><!--XLATESTOP-->

				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			

					
			<xsl:when test="$id = '3071'">faultled             <!--XLATESTART-->Set fault led values<!--XLATESTOP--><xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '3072'">
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->valid parameters are:<!--XLATESTOP-->
                               <xsl:call-template name="NewLine"/>options=...       <!--XLATESTART-->Various options<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			
			<xsl:when test="$id = '3081'">powerbutton          <!--XLATESTART-->Set powerbutton enable or disable<!--XLATESTOP--><xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '3082'">
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>enable=&lt;true|false&gt;          <!--XLATESTART-->Enable / disable powerbutton system off<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
						
			<xsl:when test="$id = '3091'">memory               <!--XLATESTART-->Clear memory error count<!--XLATESTOP--><xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '3092'">
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->valid parameters are:<!--XLATESTOP-->
                               <xsl:call-template name="NewLine"/>errorcount=clear        <!--XLATESTART-->Clear memory error count<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
					
						
<xsl:when test="$id = '4001'">
<!--XLATESTART-->modem                        Set RSC Modem Properties<!--XLATESTOP--><xsl:call-template name="NewLine"/>
			</xsl:when>			
			<xsl:when test="$id = '4002'">
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->For command omconfig modem valid parameters are:<!--XLATESTOP-->
                              <xsl:call-template name="NewLine"/>
<xsl:call-template name="NewLine"/>ModemBaudRate=&lt;number&gt;            <!--XLATESTART-->Sets the Baud Rate for the RSC modem<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>DialUpModemInitString=&lt;String&gt;    <!--XLATESTART-->Sets the Initialization String for RSC modem<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>DialUpDialType=&lt;0=Tone, 1=Pulse&gt;  <!--XLATESTART-->Sets the Dial Type for the RSC modem<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
<xsl:when test="$id = '4011'">
<!--XLATESTART-->dialinusers                  Set RSC Dial In User Properties<!--XLATESTOP--><xsl:call-template name="NewLine"/>
			</xsl:when>			
			<xsl:when test="$id = '4012'">
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->For command omconfig dialinusers valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
<xsl:call-template name="NewLine"/>DialInUserPppUserName=&lt;String&gt;     <!--XLATESTART-->Sets the Ppp User Name for RSC DialIn User<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>DialInUserPppPassword=&lt;String&gt;     <!--XLATESTART-->Sets the Ppp Password for RSC DialIn User<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>DialInUserCallbackNumber=&lt;String&gt;  <!--XLATESTART-->Sets the Callback Number for RSC DialIn User<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>DialInUserCallbackType=&lt;number&gt;    <!--XLATESTART-->0=none, 1=present, 3=usr-specified<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
<xsl:when test="$id = '4021'">
<!--XLATESTART-->dialoutusers                 Set RSC Dial Out User Properties<!--XLATESTOP--><xsl:call-template name="NewLine"/>
			</xsl:when>			
			<xsl:when test="$id = '4022'">
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->For command omconfig dialoutusers valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>	
<xsl:call-template name="NewLine"/>DemandDialIpAddr=&lt;String&gt;       <!--XLATESTART-->Sets the IP Address. Dot separated IP expected<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>DemandDialPppUserName=&lt;String&gt;  <!--XLATESTART-->Sets the Ppp UserName for the RSC Dial Out User<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>DemandDialPppPassword=&lt;String&gt;  <!--XLATESTART-->Sets the Ppp Password for the RSC Dial Out User<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>DemandDialPhoneNumber=&lt;String&gt;  <!--XLATESTART-->Sets the Phone Number for the RSC Dial Out User<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>DemandDialAuthType=&lt;number&gt;     <!--XLATESTART-->0=any, 1=encrypted, 2=mschap<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
<xsl:when test="$id = '4031'">
<!--XLATESTART-->network                      Set RSC Network Properties<!--XLATESTOP--><xsl:call-template name="NewLine"/>
			</xsl:when>			
			<xsl:when test="$id = '4032'">
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->For command omconfig network valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
<xsl:call-template name="NewLine"/>IPAddress=&lt;String&gt;                <!--XLATESTART-->Sets the IP Address for the RSC Network Card <!--XLATESTOP-->
<xsl:call-template name="NewLine"/>SubnetMask=&lt;String&gt;               <!--XLATESTART-->Sets SubnetMask. Dot separated IP expected<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>Gateway=&lt;String&gt;                  <!--XLATESTART-->Sets the Gateway. Dot separated IP expected<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>BaseIPAddr=&lt;String&gt;               <!--XLATESTART-->Sets the BaseIPAddress for the RSC Card<!--XLATESTOP-->
 <xsl:call-template name="NewLine"/>NICEnable=&lt;boolean&gt;               <!--XLATESTART-->Enables the NIC for the RSC Network Card<!--XLATESTOP-->
 <xsl:call-template name="NewLine"/>NICUseDHCP=&lt;boolean&gt;              <!--XLATESTART-->Enables DHCP for the RSC Network Card<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>SMTPAddr=&lt;String&gt;                 <!--XLATESTART-->Sets the SMTP Address for the RSC Card<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>DialUpDialInDHCPEnable=&lt;boolean&gt;  <!--XLATESTART-->Enables the DialIn DHCP<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>DialUpDialInAuthType=&lt;number&gt;     <!--XLATESTART-->0=any, 1=encrypted, 2=mschap<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>RHostSMTPEnable=&lt;boolean&gt;         <!--XLATESTART-->Enables SMTP for the RSC Network Card<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>DialInEnable=&lt;boolean&gt;            <!--XLATESTART-->Enables DialIn communications for the RSC Card<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '4041'">
<!--XLATESTART-->remote                       Set RSC Remote Features Properties<!--XLATESTOP--><xsl:call-template name="NewLine"/>
			</xsl:when>			
			<xsl:when test="$id = '4042'">
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->For command omconfig remote valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>	
 <xsl:call-template name="NewLine"/>RHostFloppyTFTPEnable=&lt;boolean&gt;   <!--XLATESTART-->Enables Remote Boot for remote features<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>RHostFloppyTFTPIPAddr=&lt;String&gt;    <!--XLATESTART-->Sets the Floppy TFTP Address<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>RHostFloppyTFTPPath=&lt;String&gt;      <!--XLATESTART-->Sets the Floppy TFTP Path for remote features<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>RHostFWUpdateTFTPEnable=&lt;boolean&gt; <!--XLATESTART-->Enables Remote Firmware Update<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>RHostFWUpdateTFTPIPAddr=&lt;String&gt;  <!--XLATESTART-->Sets the Firmware TFTP Address<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>RHostFWUpdateTFTPPath=&lt;String&gt;    <!--XLATESTART-->Sets the Firware TFTP  Path<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '4051'">
<!--XLATESTART-->snmptraps                    Set RSC SNMP Trap Properties<!--XLATESTOP--><xsl:call-template name="NewLine"/>
			</xsl:when>			
			<xsl:when test="$id = '4052'">
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->For command omconfig snmptraps valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>	
<xsl:call-template name="NewLine"/>TrapsEnable=&lt;boolean&gt;             <!--XLATESTART-->Enables SNMP Traps<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>TrapDestIPAddr=&lt;String&gt;           <!--XLATESTART-->Sets the IP Address for SNMP traps<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>SNMPCommunity=&lt;String&gt;            <!--XLATESTART-->Sets the Community for SNMP Traps  <!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '4061'">
<!--XLATESTART-->users                        Set RSC User Properties<!--XLATESTOP--><xsl:call-template name="NewLine"/>
			</xsl:when>			
			<xsl:when test="$id = '4062'">
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->For command omconfig users valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>	
<xsl:call-template name="NewLine"/>UserName=&lt;String&gt;                 <!--XLATESTART-->Sets the User Name for the RSC Card<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>UserPassword=&lt;String&gt;             <!--XLATESTART-->Sets the Password for the RSC Card<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>UserEnableNumericPaging=&lt;boolean&gt; <!--XLATESTART-->Enables Numeric Paging for the RSC Card<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>UserNumericPagerNumber=&lt;number&gt;   <!--XLATESTART-->Sets the Numeric Pager Number for RSC Card<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>UserNumericPagerMsg=&lt;string&gt;      <!--XLATESTART-->Sets the Numeric Pager Message for RSC Card<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>UserEnableEmailPaging=&lt;boolean&gt;   <!--XLATESTART-->Enables Email Paging for the RSC Card<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>UserEmailAddress=&lt;String&gt;         <!--XLATESTART-->Sets the Email address for the RSC Card<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>UserEnableAlphaPaging=&lt;boolean&gt;   <!--XLATESTART-->Enables Alpha Paging for the RSC Card<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>UserAlphaNumber=&lt;number&gt;          <!--XLATESTART-->Sets the Alpha Number for the RSC Card<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>UserAlphaProtocol=&lt;string&gt;        <!--XLATESTART-->Sets the Alpha Protocol for the RSC Card<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>UserAlphaBaudRate=&lt;number&gt;        <!--XLATESTART-->Sets the Baud Rate for the RSC Card<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>UserAlphaCustomMsg=&lt;string&gt;       <!--XLATESTART-->Sets the Alpha Custom Message for RSC Card<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>UserAlphaPagerPassword=&lt;string&gt;   <!--XLATESTART-->Sets the Alpha Pager Password for RSC Card<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '4071'">
<!--XLATESTART-->rsc             Set RSC User Properties<!--XLATESTOP--><xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '4081'">
<!--XLATESTART-->reset                        Set RSC Reset<!--XLATESTOP--><xsl:call-template name="NewLine"/>
			</xsl:when>	
			<xsl:when test="$id = '4082'">
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->For command omconfig reset valid parameters are:<!--XLATESTOP-->
                              <xsl:call-template name="NewLine"/>
			</xsl:when>	
		</xsl:choose>
	</xsl:template>
	<xsl:template name="ProgDesc">
		<xsl:param name="cliname"/>
		<xsl:choose>
			<xsl:when test="$cliname = 'omconfig'">
				<!--XLATETHIS-->System configuration utility<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$cliname = 'omdiag'">
				<!--XLATETHIS-->Diagnostics utility<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$cliname = 'omhelp'">
				<!--XLATETHIS-->Provides help information for executable commands<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$cliname = 'omreport'">
				<!--XLATETHIS-->Report generation utility<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:otherwise>
				<!--XLATETHIS-->Invalid Cliname<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="NewLine">
		<xsl:text>
</xsl:text>
	</xsl:template>
</xsl:stylesheet>
