<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template match="/OMA">
		<DataArea>
			<PageTitle display="Bundle Validation"/>
			<TableData>
				<Header>
					<Data value="Bundle Supported" display="Bundle Supported" name="BundleSupported"/>
					<Data value="System Supported" display="System Supported" name="SystemSupported"/>
					<Data value="OS Supported" display="OS Supported" name="OSSupported"/>
					<Data value="Bundle Complete" display="Bundle Complete" name="BundleComplete"/>
					<Data value="Status" display="Status" name="Status"/>
				</Header>
				<xsl:apply-templates  />
			</TableData>
		</DataArea>
	</xsl:template>
	<xsl:template match="BundleLog">
		<Row>
			<Data name="BundleSupported">
				<xsl:choose>
					<xsl:when test="Validation/@system-supported = 'true' and Validation/@os-supported and SMStatus/@result != '3075'">
						<xsl:attribute name="value">true</xsl:attribute>
						<xsl:attribute name="display">true</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="value">false</xsl:attribute>
						<xsl:attribute name="display">false</xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</Data>
			<xsl:choose>
				<xsl:when test="SMStatus/@result != '3081'">
					<Data name="SystemSupported">
						<xsl:attribute name="value"><xsl:value-of select="Validation/@system-supported" /></xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="Validation/@system-supported" /></xsl:attribute>
					</Data> 
					<Data name="OSSupported">
						<xsl:attribute name="value"><xsl:value-of select="Validation/@os-supported" /></xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="Validation/@os-supported" /></xsl:attribute>
					</Data> 
					<Data name="BundleComplete">
						<xsl:choose>
							<xsl:when test="SMStatus/@result = '3075'">
								<xsl:attribute name="value">false</xsl:attribute>
								<xsl:attribute name="display">false</xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="value">true</xsl:attribute>
								<xsl:attribute name="display">true</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</Data> 
				</xsl:when>
				<xsl:otherwise>
					<Data name="Status">
						<xsl:attribute name="value">Definition file not found.</xsl:attribute>
						<xsl:attribute name="display">Definition file not found.</xsl:attribute>
					</Data> 
				</xsl:otherwise>
			</xsl:choose>
		</Row>
	</xsl:template>
</xsl:stylesheet>
