<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:strip-space elements="*"/>
<xsl:output method="xml"/>
<xsl:template match="/OMA">
	<DataArea>
		<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strSlots"/></xsl:attribute>
		<xsl:attribute name="backpagetarget">/servlet/DataArea?plugin=com.dell.hip.webplugins.SlotsWebPlugin&amp;poid=2&amp;help=Slots</xsl:attribute>
		<PageTitle>
			<xsl:attribute name="display"><xsl:value-of select="$strSlotInformation"/><xsl:value-of select="Slot/ExtName" /></xsl:attribute>
		</PageTitle>
		<CustomButton>
			<Data name="Refresh"><xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
				<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.SlotWebPlugin&amp;oid=<xsl:value-of select="Slot/@oid"/></xsl:attribute>
			</Data>
		</CustomButton>
		<TableData>
			<xsl:choose>
				<xsl:when test="SMStatus[1] = '0' or SMStatus[2] = '0'">
					<Header>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strAttributes"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strAttributes1"/></xsl:attribute>
						</Data>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strValues"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strValues1"/></xsl:attribute>
						</Data>
					</Header>
					<xsl:apply-templates select="Slot"/>
					<xsl:apply-templates select="SlotDevice"/>
				</xsl:when>
				<xsl:otherwise>
					<Header>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strError"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strError1"/></xsl:attribute>
						</Data>
					</Header>
					<Row>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strSlotInformationNot"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strSlotInformationNot1"/></xsl:attribute>
						</Data>
					</Row>
				</xsl:otherwise>
			</xsl:choose>
		</TableData>
	</DataArea>
</xsl:template>

<xsl:template match="Slot">
	<Row>
		<Data name="ID"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strID"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strID1"/></xsl:attribute>
		</Data>
		<Data name="ID_value"  editable="false" type="ustring">
			<xsl:attribute name="value"><xsl:value-of select="SlotID"/></xsl:attribute>
		</Data>
	</Row>
	<Row>
		<Data name="Type"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strType"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strType1"/></xsl:attribute>
		</Data>
		<Data name="Type_value"  editable="false" type="ustring">
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="Type='1'"><xsl:value-of select="$strOther"/></xsl:when>
					<xsl:when test="Type='3'"><xsl:value-of select="$strISA"/></xsl:when>
					<xsl:when test="Type='4'"><xsl:value-of select="$strMCA"/></xsl:when>
					<xsl:when test="Type='5'"><xsl:value-of select="$strEISA"/></xsl:when>
					<xsl:when test="Type='6'"><xsl:value-of select="$strPCI"/></xsl:when>
					<xsl:when test="Type='7'"><xsl:value-of select="$strPCMCIA"/></xsl:when>
					<xsl:when test="Type='8'"><xsl:value-of select="$strVLVESA"/></xsl:when>
					<xsl:when test="Type='9'"><xsl:value-of select="$strProprietary"/></xsl:when>
					<xsl:when test="Type='10'"><xsl:value-of select="$strProcessorCard"/></xsl:when>
					<xsl:when test="Type='11'"><xsl:value-of select="$strProprietaryMemoryCard"/></xsl:when>
					<xsl:when test="Type='12'"><xsl:value-of select="$strIORiserCard"/></xsl:when>
					<xsl:when test="Type='13'"><xsl:value-of select="$strNuBus"/></xsl:when>
					<xsl:when test="Type='14'"><xsl:value-of select="$strPCI66Mhz"/></xsl:when>
					<xsl:when test="Type='15'"><xsl:value-of select="$strAGP"/></xsl:when>
					<xsl:when test="Type='16'"><xsl:value-of select="$strAGP2X"/></xsl:when>
					<xsl:when test="Type='17'"><xsl:value-of select="$strAGP4X"/></xsl:when>
					<xsl:when test="Type='18'"><xsl:value-of select="$strPCIX"/></xsl:when>
					<xsl:when test="Type='160'"><xsl:value-of select="$strPC98C20"/></xsl:when>
					<xsl:when test="Type='161'"><xsl:value-of select="$strPC98C24"/></xsl:when>
					<xsl:when test="Type='162'"><xsl:value-of select="$strPC98E"/></xsl:when>
					<xsl:when test="Type='163'"><xsl:value-of select="$strPC98LocalBus"/></xsl:when>
					<xsl:when test="Type='164'"><xsl:value-of select="$strPC98Card"/></xsl:when>
					<xsl:when test="Type='165'"><xsl:value-of select="$strPCIE"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$strNoValue"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</Data>
	</Row>
	<Row>
		<Data name="Length"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strSlotLength"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strSlotLength1"/></xsl:attribute>
		</Data>
		<Data name="Length_value"  editable="false" type="ustring">
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="Length='1'"><xsl:value-of select="$strOther1"/></xsl:when>
					<xsl:when test="Length='3'"><xsl:value-of select="$strShort"/></xsl:when>
					<xsl:when test="Length='4'"><xsl:value-of select="$strLong"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$strUnknown1"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</Data>
	</Row>
	<Row>
		<Data name="Speed"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strSpeed"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strSpeed1"/></xsl:attribute>
		</Data>
		<Data name="Speed_value"  editable="false" type="ustring">
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="HotPlugSystemSlot/SlotSpeed='0'"><xsl:value-of select="$strNotObtainedRefer"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="HotPlugSystemSlot/SlotSpeed"/><xsl:text> </xsl:text><xsl:value-of select="HotPlugSystemSlot/SlotSpeed/@unit"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</Data>
	</Row>
	<Row>
		<Data name="Category"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strCategory"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strCategory1"/></xsl:attribute>
		</Data>
		<Data name="Category_value"  editable="false" type="ustring">
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="Category='1'"><xsl:value-of select="$strOther2"/></xsl:when>
					<xsl:when test="Category='3'"><xsl:value-of select="$strBusConnector"/></xsl:when>
					<xsl:when test="Category='4'"><xsl:value-of select="$strPCMCIA1"/></xsl:when>
					<xsl:when test="Category='5'"><xsl:value-of select="$strMotherboard"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$strUnknown3"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</Data>
	</Row>
	<Row>
		<Data name="IsHotPlugCapable"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strHotPlugCapable"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strHotPlugCapable1"/></xsl:attribute>
		</Data>
		<Data name="IsHotPlugCapable_value"  editable="false" type="ustring">
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="HotPlugSystemSlot/IsHotPlugCapable='true'"><xsl:value-of select="$strYes"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$strNo"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</Data>
	</Row>
	<Row>
		<Data name="VoltSupply"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strVoltageSupply"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strVoltageSupply1"/></xsl:attribute>
		</Data>
		<Data name="VoltSupply_value"  editable="false" type="ustring">
			<xsl:attribute name="value">
				<xsl:if test="IsVolt33='true'"><xsl:value-of select="$str33Volts"/><xsl:if test="IsVolt5='true'">, </xsl:if></xsl:if>
				<xsl:if test="IsVolt5='true'"><xsl:value-of select="$str5Volts"/></xsl:if>
			</xsl:attribute>
		</Data>
	</Row>
	<Row>
		<Data name="IsShared"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strSharedSlot"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strSharedSlot1"/></xsl:attribute>
		</Data>
		<Data name="IsShared_value"  editable="false" type="ustring">
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="IsShared='true'"><xsl:value-of select="$strYes1"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$strNo1"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</Data>
	</Row>
	<Row>
		<Data name="IsCard16"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strPCCard16"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strPCCard161"/></xsl:attribute>
		</Data>
		<Data name="IsCard16_value"  editable="false" type="ustring">
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="IsCard16='true'"><xsl:value-of select="$strSupported"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$strNotSupported"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</Data>
	</Row>
	<Row>
		<Data name="IsCardBus"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strCardBus"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strCardBus1"/></xsl:attribute>
		</Data>
		<Data name="IsCardBus_value"  editable="false" type="ustring">
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="IsCardBus='true'"><xsl:value-of select="$strSupported1"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$strNotSupported1"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</Data>
	</Row>
	<Row>
		<Data name="IsZoomVideo"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strZoomVideo"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strZoomVideo1"/></xsl:attribute>
		</Data>
		<Data name="IsZoomVideo_value"  editable="false" type="ustring">
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="IsZoomVideo='true'"><xsl:value-of select="$strSupported2"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$strNotSupported2"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</Data>
	</Row>
	<Row>
		<Data name="IsModemRingResume"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strModemRingResume"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strModemRingResume1"/></xsl:attribute>
		</Data>
		<Data name="IsModemRingResume_value"  editable="false" type="ustring">
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="IsModemRingResume='true'"><xsl:value-of select="$strSupported3"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$strNotSupported3"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</Data>
	</Row>
	<Row>
		<Data name="IsPMECapable"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strPowerManagementEnable"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strPowerManagementEnable1"/></xsl:attribute>
		</Data>
		<Data name="IsPMECapable_value"  editable="false" type="ustring">
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="IsPMECapable='true'"><xsl:value-of select="$strSupported4"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$strNotSupported4"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</Data>
	</Row>
</xsl:template>

<xsl:template match="SlotDevice">
	<Row>
		<Data name="DeviceManufacturer"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strAdapterManufacturer"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strAdapterManufacturer1"/></xsl:attribute>
		</Data>
		<Data name="DeviceManufacturer_value"  editable="false" type="ustring">
			<xsl:attribute name="value"><xsl:value-of select="Manufacturer"/></xsl:attribute>
		</Data>
	</Row>
	<Row>
		<Data name="DeviceDesc"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strAdapterDescription"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strAdapterDescription1"/></xsl:attribute>
		</Data>
		<Data name="DeviceDesc_value"  editable="false" type="ustring">
			<xsl:attribute name="value"><xsl:value-of select="DeviceDesc"/></xsl:attribute>
		</Data>
	</Row>
	<Row>
		<Data name="DeviceDataBusWidth"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strAdapterDataBus"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strAdapterDataBus1"/></xsl:attribute>
		</Data>
		<Data name="DeviceDataBusWidth_value"  editable="false" type="ustring">
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="DataBusWidth = '0'"><xsl:value-of select="$strNotObtainedRefer"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="DataBusWidth"/> <xsl:value-of select="$strBits"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</Data>
	</Row>
	<Row>
		<Data name="DeviceSpeed"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strAdapterSpeed"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strAdapterSpeed1"/></xsl:attribute>
		</Data>
		<Data name="DeviceSpeed_value"  editable="false" type="ustring">
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="Speed='0'"><xsl:value-of select="$strNotObtainedRefer"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="Speed"/><xsl:text> </xsl:text><xsl:value-of select="Speed/@unit"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</Data>
	</Row>
</xsl:template>

<xsl:template match="*"/>

</xsl:stylesheet>
