<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:strip-space elements="*"/>
<xsl:output method="xml"/>
<xsl:template match="/OMA">
	<xsl:choose>
		<xsl:when test="SMStatus !='0'">
			<DataArea>
				<TableData>
					<Header>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strError"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strError1"/></xsl:attribute>
						</Data>
					</Header>
					<Row>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strPortInformationNot"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strPortInformationNot1"/></xsl:attribute>
						</Data>
					</Row>
				</TableData>
			</DataArea>
		</xsl:when>
		<xsl:otherwise>
			<DataArea>
				<PageTitle>
					<xsl:attribute name="display"><xsl:value-of select="$strPortsInformation"/></xsl:attribute>
				</PageTitle>
				<CustomButton>
					<Data name="Refresh"><xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
						<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.PortsWebPlugin&amp;poid=2</xsl:attribute>
					</Data>
				</CustomButton>
				<PromptText><xsl:value-of select="$str"/></PromptText>
				<xsl:apply-templates select="PortsList"/>
			</DataArea>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template match="PortsList">
	<TableData name="" columnspacing="true"><xsl:attribute name="display"><xsl:value-of select="$str1"/></xsl:attribute>
		<Header>
			<Data name="" editable="" type="">
				<xsl:attribute name="display"><xsl:value-of select="$strPortType"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strPortType1"/></xsl:attribute>
			</Data>
			<Data name="" editable="" type="">
				<xsl:attribute name="display"><xsl:value-of select="$strExternalName"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strExternalName1"/></xsl:attribute>
			</Data>
			<Data name="" editable="" type="">
				<xsl:attribute name="display"><xsl:value-of select="$strBaseIOAddr"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strBaseIOAddr1"/></xsl:attribute>
			</Data>
			<Data name="" editable="" type="">
				<xsl:attribute name="display"><xsl:value-of select="$strIRQLvl"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strIRQLvl1"/></xsl:attribute>
			</Data>
			<Data name="" editable="" type="">
				<xsl:attribute name="display"><xsl:value-of select="$strConnectorType"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strConnectorType1"/></xsl:attribute>
			</Data>
			<Data name="" editable="" type="">
				<xsl:attribute name="display"><xsl:value-of select="$strMaximumSpeed"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strMaximumSpeed1"/></xsl:attribute>
			</Data>
		</Header>
		<xsl:apply-templates select="Port"/>
	</TableData>
</xsl:template>	
	
<xsl:template match="Port">
	<Row>
		<Data name="PortType"  editable="false" type="ustring">
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="@objtype='192'"><xsl:value-of select="$strParallel"/></xsl:when>
					<xsl:when test="@objtype='193'"><xsl:value-of select="$strSerial"/></xsl:when>
					<xsl:when test="@objtype='194'"><xsl:value-of select="$strPointingDevice"/></xsl:when>
					<xsl:when test="@objtype='195'"><xsl:value-of select="$strKeyboard"/></xsl:when>
					<xsl:when test="@objtype='196'"><xsl:value-of select="$strProcessor"/></xsl:when>
					<xsl:when test="@objtype='197'"><xsl:value-of select="$strMemoryDevice"/></xsl:when>
					<xsl:when test="@objtype='198'"><xsl:value-of select="$strUSB"/></xsl:when>
					<xsl:when test="@objtype='199'"><xsl:value-of select="$strMonitor"/></xsl:when>
					<xsl:when test="@objtype='200'"><xsl:value-of select="$strSCSI"/></xsl:when>
				</xsl:choose>
			</xsl:attribute>
		</Data>
		<Data name=""  editable="false" type="ustring" align="left"><xsl:attribute name="display"><xsl:value-of select="$str2"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="ExtName" /></xsl:attribute>
		</Data>
		<Data name="BaseIOAddr"  editable="false" type="ustring">
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="BaseIOAddr = '0'"><xsl:value-of select="$strNoValue"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="BaseIOAddr"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</Data>
		<Data name="IrqLevel"  editable="false" type="ustring">
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="IrqLevel= '0'"><xsl:value-of select="$strNoValue"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="IrqLevel"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</Data>
		<xsl:choose>
			<!-- objtype 192 is for parallel port-->
			<xsl:when test="@objtype='192'">
				<Data name="ConnectorType"  editable="false" type="ustring">
					<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="ConnectorType='1'"><xsl:value-of select="$strOther"/></xsl:when>
							<xsl:when test="ConnectorType='3'"><xsl:value-of select="$strDB25Female"/></xsl:when>
							<xsl:when test="ConnectorType='4'"><xsl:value-of select="$strDB25Male"/></xsl:when>
							<xsl:when test="ConnectorType='5'"><xsl:value-of select="$strCentronics"/></xsl:when>
							<xsl:when test="ConnectorType='6'"><xsl:value-of select="$strMiniCentronics"/></xsl:when>
							<xsl:when test="ConnectorType='7'"><xsl:value-of select="$strProprietary"/></xsl:when>
							<xsl:when test="ConnectorType='160'"><xsl:value-of select="$strCentronics14"/></xsl:when>
							<xsl:when test="ConnectorType='161'"><xsl:value-of select="$strDB36Female"/></xsl:when>
							<xsl:when test="ConnectorType='162'"><xsl:value-of select="$strMiniCentronics20"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$strUnknown2"/></xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
				</Data>
				<Data name="MaxSpeed"  editable="false" type="ustring" />
			</xsl:when>
			<!-- objtype 193 is for serial port-->
			<xsl:when test="@objtype='193'">
				<Data name="ConnectorType"  editable="false" type="ustring">
					<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="ConnectorType='1'"><xsl:value-of select="$strOther1"/></xsl:when>
							<xsl:when test="ConnectorType='3'"><xsl:value-of select="$strDB9Male"/></xsl:when>
							<xsl:when test="ConnectorType='4'"><xsl:value-of select="$strDB9Female"/></xsl:when>
							<xsl:when test="ConnectorType='5'"><xsl:value-of select="$strDB25Male1"/></xsl:when>
							<xsl:when test="ConnectorType='6'"><xsl:value-of select="$strDB25Female1"/></xsl:when>
							<xsl:when test="ConnectorType='7'"><xsl:value-of select="$strRJ11"/></xsl:when>
							<xsl:when test="ConnectorType='8'"><xsl:value-of select="$strRJ45"/></xsl:when>
							<xsl:when test="ConnectorType='9'"><xsl:value-of select="$strProprietary1"/></xsl:when>
							<xsl:when test="ConnectorType='10'"><xsl:value-of select="$strCircularDIN8Male"/></xsl:when>
							<xsl:when test="ConnectorType='11'"><xsl:value-of select="$strCircularDIN8Female"/></xsl:when>
							<xsl:when test="ConnectorType='160'"><xsl:value-of select="$strMiniCentronicsType14"/></xsl:when>
							<xsl:when test="ConnectorType='161'"><xsl:value-of select="$strMiniCentronicsType26"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$strUnknown3"/></xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
				</Data>
				<Data name="MaxSpeed"  editable="false" type="ustring">
					<xsl:attribute name="value"><xsl:value-of select="MaxSpeed"/></xsl:attribute>
				</Data>
			</xsl:when>
			<xsl:otherwise>
				<Data name="SmbiosConnType"  editable="false" type="ustring">
					<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="SmbiosConnType='1'"><xsl:value-of select="$strNone"/></xsl:when>
							<xsl:when test="SmbiosConnType='1'"><xsl:value-of select="$strCentronics1"/></xsl:when>
							<xsl:when test="SmbiosConnType='2'"><xsl:value-of select="$strMiniCentronics1"/></xsl:when>
							<xsl:when test="SmbiosConnType='3'"><xsl:value-of select="$strProprietary2"/></xsl:when>
							<xsl:when test="SmbiosConnType='4'"><xsl:value-of select="$strDB25PinMale"/></xsl:when>
							<xsl:when test="SmbiosConnType='5'"><xsl:value-of select="$strDB25PinFemale"/></xsl:when>
							<xsl:when test="SmbiosConnType='6'"><xsl:value-of select="$strDB15PinMale"/></xsl:when>
							<xsl:when test="SmbiosConnType='7'"><xsl:value-of select="$strDB15PinFemale"/></xsl:when>
							<xsl:when test="SmbiosConnType='8'"><xsl:value-of select="$strDB9PinMale"/></xsl:when>
							<xsl:when test="SmbiosConnType='9'"><xsl:value-of select="$strDB9PinFemale"/></xsl:when>
							<xsl:when test="SmbiosConnType='10'"><xsl:value-of select="$strRJ111"/></xsl:when>
							<xsl:when test="SmbiosConnType='11'"><xsl:value-of select="$strRJ451"/></xsl:when>
							<xsl:when test="SmbiosConnType='12'"><xsl:value-of select="$str50PinMiniSCSI"/></xsl:when>
							<xsl:when test="SmbiosConnType='13'"><xsl:value-of select="$strMiniDIN"/></xsl:when>
							<xsl:when test="SmbiosConnType='14'"><xsl:value-of select="$strMicroDIN"/></xsl:when>
							<xsl:when test="SmbiosConnType='15'"><xsl:value-of select="$strPS2"/></xsl:when>
							<xsl:when test="SmbiosConnType='16'"><xsl:value-of select="$strInfrared"/></xsl:when>
							<xsl:when test="SmbiosConnType='17'"><xsl:value-of select="$strHPHIL"/></xsl:when>
							<xsl:when test="SmbiosConnType='18'"><xsl:value-of select="$strAccessBusUSB"/></xsl:when>
							<xsl:when test="SmbiosConnType='19'"><xsl:value-of select="$strSSASCSI"/></xsl:when>
							<xsl:when test="SmbiosConnType='20'"><xsl:value-of select="$strCircularDIN8Male1"/></xsl:when>
							<xsl:when test="SmbiosConnType='21'"><xsl:value-of select="$strCircularDIN8Female1"/></xsl:when>
							<xsl:when test="SmbiosConnType='22'"><xsl:value-of select="$strOnBoardIDE"/></xsl:when>
							<xsl:when test="SmbiosConnType='23'"><xsl:value-of select="$strOnBoardFloppy"/></xsl:when>
							<xsl:when test="SmbiosConnType='24'"><xsl:value-of select="$str9PinDual"/></xsl:when>
							<xsl:when test="SmbiosConnType='25'"><xsl:value-of select="$str25PinDual"/></xsl:when>
							<xsl:when test="SmbiosConnType='26'"><xsl:value-of select="$str50PinDual"/></xsl:when>
							<xsl:when test="SmbiosConnType='27'"><xsl:value-of select="$str68PinDual"/></xsl:when>
							<xsl:when test="SmbiosConnType='28'"><xsl:value-of select="$strOnBoardSound"/></xsl:when>
							<xsl:when test="SmbiosConnType='29'"><xsl:value-of select="$strMiniCentronicsType141"/></xsl:when>
							<xsl:when test="SmbiosConnType='30'"><xsl:value-of select="$strMiniCentronicsType261"/></xsl:when>
							<xsl:when test="SmbiosConnType='31'"><xsl:value-of select="$strMinijackHeadphones"/></xsl:when>
							<xsl:when test="SmbiosConnType='32'"><xsl:value-of select="$strBNC"/></xsl:when>
							<xsl:when test="SmbiosConnType='33'"><xsl:value-of select="$str1394"/></xsl:when>
							<xsl:when test="SmbiosConnType='160'"><xsl:value-of select="$strPC98"/></xsl:when>
							<xsl:when test="SmbiosConnType='161'"><xsl:value-of select="$strPC98Hireso"/></xsl:when>
							<xsl:when test="SmbiosConnType='162'"><xsl:value-of select="$strPCH98"/></xsl:when>
							<xsl:when test="SmbiosConnType='163'"><xsl:value-of select="$strPC98Note"/></xsl:when>
							<xsl:when test="SmbiosConnType='164'"><xsl:value-of select="$strPC98Full"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$strOther2"/></xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
				</Data>
				<Data name="MaxSpeed"  editable="false" type="ustring" />
			</xsl:otherwise>
		</xsl:choose>
	</Row>
</xsl:template>

<xsl:template match="*"/>

</xsl:stylesheet>
