<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:strip-space elements="*"/>
<xsl:output method="xml" indent="no"/>
<xsl:template match="/OMA">
<xsl:choose>
	<xsl:when test="SMStatus='0'"><xsl:call-template name="success"/></xsl:when>
	<xsl:otherwise><xsl:call-template name="failure"/></xsl:otherwise>
</xsl:choose>
</xsl:template>

<xsl:template name="failure">
	<DataArea exportdata="false">
		<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strBIOSSetup"/></xsl:attribute>
		<xsl:attribute name="backpagetarget">/servlet/DataArea?plugin=com.dell.hip.webplugins.biossetupWebPlugin&amp;help=BiosSetup</xsl:attribute>
		<PageTitle>
			<xsl:attribute name="display"><xsl:value-of select="$strBIOSSetup1"/></xsl:attribute>
		</PageTitle>
		<TableData>
			<Header>
				<Data name="">
					<xsl:attribute name="display"><xsl:value-of select="$strError"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strError1"/></xsl:attribute>
				</Data>
			</Header>
			<Row>
				<Data name="" ><xsl:attribute name="display"><xsl:value-of select="$str"/></xsl:attribute>
					<xsl:attribute name="value">
						<xsl:call-template name="smstatus">
							<xsl:with-param name="status"><xsl:value-of select="SMStatus"/></xsl:with-param>
						</xsl:call-template>
					</xsl:attribute>
				</Data>
			</Row>
		</TableData>
	</DataArea>
</xsl:template>

<xsl:template name="success">
<DataArea  onLoad="true" validate="true" exportdata="false">
<!-- Check to see if the Back button needs to be hidden -->
<xsl:choose>
   <xsl:when test="needBckButton='false'">
     <xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.hip.webplugins.setbiosobjWebPlugin&amp;button=false&amp;oid=<xsl:value-of select="BIOSSetup/@oid"/></xsl:attribute>
x   </xsl:when>
<xsl:otherwise>
   <xsl:attribute name="backpagedisplay"><xsl:value-of select="$strBIOSSetup2"/></xsl:attribute>
   <xsl:attribute name="backpagetarget">/servlet/DataArea?plugin=com.dell.hip.webplugins.biossetupWebPlugin&amp;help=BiosSetup</xsl:attribute>
   <xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.hip.webplugins.setbiosobjWebPlugin&amp;oid=<xsl:value-of select="BIOSSetup/@oid"/></xsl:attribute>
</xsl:otherwise>
</xsl:choose>


<!--
	<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strBIOSSetup2"/></xsl:attribute>
	<xsl:attribute name="backpagetarget">/servlet/DataArea?plugin=com.dell.hip.webplugins.biossetupWebPlugin&amp;help=BiosSetup</xsl:attribute>
	<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.hip.webplugins.setbiosobjWebPlugin&amp;oid=<xsl:value-of select="BIOSSetup/@oid"/></xsl:attribute>
-->
	<xsl:if test="ShutDownFlag='true'">
		<script language="javascript">
			function restart()
			{
				if (confirm("<xsl:value-of select="$strAreYouDone"/>")){
					document.getElementById("dataarea").action=top.gnv.appendVID('/servlet/SubmitForm?plugin=com.dell.hip.webplugins.shtdwnWebPlugin&amp;os=8&amp;action1=1');
					document.getElementById("dataarea").submit();
				}
				else{
					document.getElementById("dataarea").action=top.gnv.appendVID('/servlet/DataArea?plugin=com.dell.hip.webplugins.biosobjinfoWebPlugin&amp;oid=<xsl:value-of select="BIOSSetup/@oid"/>&amp;help=BiosSetup');
					document.getElementById("dataarea").submit();
				}
			}
		</script>
	</xsl:if>

	<script language="javascript">
		var actionSelected;
		var actionlen;
		function initializationRoutine(){
			var objname = '<xsl:value-of select="BIOSSetup/ObjName"/>';
			actionlen = document.getElementById("dataarea").actionsel.length;
			for (i = 0 ; i &lt; actionlen ; i++){
				if(document.getElementById("dataarea").actionsel[i].checked == true){
					actionSelected = objname + "." + document.getElementById("dataarea").actionsel[i].value;
				}
			}

			// get the setting of dual nics based on the current setting
			actionSelected = dualNicSetting();

			<xsl:if test="/OMA/BIOSSetup/@objtype='242'">
				<xsl:if test="/OMA/BIOSSetup/State = 1">disableChoices()</xsl:if>
			</xsl:if>
		}

		function validate(){
			var f_objname = '<xsl:value-of select="BIOSSetup/ObjName"/>';
			var f_actionSelected;
			var stateNic1;
			var stateNic2;

			<xsl:if test="/OMA/BIOSSetup/@objtype='265'">
				// get the setting of dual nics based on user selection
				document.getElementById("dataarea").actionsel[1].value = dualNicSetting();
			</xsl:if>

			for (i = 0 ; i &lt; actionlen ; i++){
				if(document.getElementById("dataarea").actionsel[i].checked == true){
					f_actionSelected = f_objname + "." + document.getElementById("dataarea").actionsel[i].value;
				}
			}
			<xsl:if test="BIOSSetup/IsSetImmediate='false'">
			    if (actionSelected != f_actionSelected) {
				    document.getElementById("reboot").value = "true";
			    }
		        </xsl:if>
            
			<xsl:if test="BIOSSetup/ObjName='OnBoard RAID'">
				if (confirm("<xsl:value-of select="$strChangingThisSetting"/>")){
					return true;
				}
				else
					return false;
			</xsl:if>

			return true;
		}

		function disableDualNic()
		{
			if(document.getElementById("dataarea").actionsel_NIC1_PXE != null) {
				document.getElementById("dataarea").actionsel_NIC1_PXE.disabled = true;
			}

			if(document.getElementById("dataarea").actionsel_NIC1_ISCSI != null) {
 				 document.getElementById("dataarea").actionsel_NIC1_ISCSI.disabled = true;
			}

			if(document.getElementById("dataarea").actionsel_NIC2_PXE != null) {
				document.getElementById("dataarea").actionsel_NIC2_PXE.disabled = true;
			}

			if(document.getElementById("dataarea").actionsel_NIC2_ISCSI != null) {
				document.getElementById("dataarea").actionsel_NIC2_ISCSI.disabled = true;
			}
		}

		function enableDualNic()
		{
      			if(document.getElementById("dataarea").actionsel_NIC1_PXE != null) {
				document.getElementById("dataarea").actionsel_NIC1_PXE.disabled = false;
			}

			if(document.getElementById("dataarea").actionsel_NIC1_ISCSI != null) {
				document.getElementById("dataarea").actionsel_NIC1_ISCSI.disabled = false;
			}

			if(document.getElementById("dataarea").actionsel_NIC2_PXE != null) {
				document.getElementById("dataarea").actionsel_NIC2_PXE.disabled = false;
			}

			if(document.getElementById("dataarea").actionsel_NIC2_ISCSI != null) {
				document.getElementById("dataarea").actionsel_NIC2_ISCSI.disabled = false;
			}
		}
		
		function dualNicSetting()
		{
			var currentState = 0;  // unknown

			<xsl:if test="/OMA/BIOSSetup/@objtype = '265' ">
				try {
					var PXE1= document.getElementById("dataarea").actionsel_NIC1_PXE;
					var ISCSI1= document.getElementById("dataarea").actionsel_NIC1_ISCSI;

					var PXE2= document.getElementById("dataarea").actionsel_NIC2_PXE;
					var ISCSI2= document.getElementById("dataarea").actionsel_NIC2_ISCSI;


					if  ( (PXE1 != null) &amp;&amp; (PXE1.checked == true) )  				    
					{
						if ( (PXE2 != null) &amp;&amp;(PXE2.checked == true))  //document.getElementById("dataarea").actionsel_NIC2_PXE.checked == true) 
						{
							currentState = 22;	// both are enabled with PXE


						}
						else if ( (ISCSI2 != null) &amp;&amp; (ISCSI2.checked == true)) //document.getElementById("dataarea").actionsel_NIC2_ISCSI.checked == true) 
						{
							currentState = 134;	// NIC 1 enabled with PXE, NIC 2 with iSCSI

						}
						else 
						{
							currentState = 38;	// NIC 1 enabled with PXE

						}
					}
					else if  ( (ISCSI1!=null) &amp;&amp; (ISCSI1.checked == true) )  				    
					{
						if ((ISCSI2 != null) &amp;&amp; (ISCSI2.checked ==true)) //document.getElementById("dataarea").actionsel_NIC2_ISCSI.checked == true) 
						{
							currentState = 194;	// both are enabled with ISCSI

						}
						else if ( (PXE2 != null) &amp;&amp; (PXE2.checked == true))  //document.getElementById("dataarea").actionsel_NIC2_PXE.checked == true) 
						{
							currentState = 82;	// NIC 1 enabled with iSCSI, NIC 2 enabled with PXE

						}
						else {
							currentState = 98;	// NIC 1 enabled with iSCSI


						}
					}
					else
					{
						if ( (PXE2 != null) &amp;&amp; (PXE2.checked == true))  //document.getElementById("dataarea").actionsel_NIC2_PXE.checked == true) 
						{
							currentState = 26;		// NIC 2 enabled with PXE

						}
						else if ((ISCSI2 != null) &amp;&amp; (ISCSI2.checked ==true))   //document.getElementById("dataarea").actionsel_NIC2_ISCSI.checked == true) 
						{
							currentState = 138;		// NIC 2 enabled with iSCSI

						}
						else {
							currentState = 42;		// enabled but no PXE/iSCSI on either NICs


						}
					}
				}
				catch(e) {}

			</xsl:if>

			return currentState;
		}

		function enableChoices()
		{
			var actionlen = document.getElementById("dataarea").actionsel.length;
			document.getElementById("dataarea").actionsel[actionlen-1].value = 3;

			if(document.getElementById("check1") != null)
			{
				document.getElementById("check1").disabled = false;
				if(document.getElementById("check1").checked == true)
					document.getElementById("dataarea").actionsel[actionlen-1].value = 2;
			}
			if(document.getElementById("check2") != null)
			{
				document.getElementById("check2").disabled = false;
				if(document.getElementById("check2").checked == true)
				document.getElementById("dataarea").actionsel[actionlen-1].value = 4;				
			}

			
		}
		
		function disableChoices()
		{
			if(document.getElementById("check1") != null){
				document.getElementById("check1").disabled = true;
			}
			if(document.getElementById("check2") != null) {		
				document.getElementById("check2").disabled = true;
			}
			
		}
		
		function alternateChoices(element)
		{
			var retval = 3;
			if( element.name == 'check1')
			{					
				if( element.checked == false)
					retval = 3;
				else {
				if(document.getElementById("check2") != null)				
					document.getElementById("check2").checked = false;
				retval=2;
				}				
			}

			if( element.name == 'check2')
			{
				if(element.checked == false)
					retval = 3;
				else{
					if(document.getElementById("check1") != null)				
						document.getElementById("check1").checked = false;
					retval=4;
				}			
			}

			var actionlen = document.getElementById("dataarea").actionsel.length;
			document.getElementById("dataarea").actionsel[actionlen-1].value = retval;

		}

		function DualNICAlternateChoice(element, nicNum)
		{
			var namePXE = "actionsel_NIC" + nicNum + "_PXE";
			var nameiSCSI = "actionsel_NIC" + nicNum + "_ISCSI";

			if( element.name == namePXE)
			{
				if(element.checked == true)
				{
					if(document.getElementById(nameiSCSI) != null)				
						document.getElementById(nameiSCSI).checked = false;
				}
			}
			if( element.name == nameiSCSI)
			{
				if(element.checked == true)
				{
					if(document.getElementById(namePXE) != null)
						document.getElementById(namePXE).checked = false;
				}
			}
		}

	</script>

	<PageTitle>
		<xsl:attribute name="display"><xsl:value-of select="BIOSSetup/ObjName"/></xsl:attribute>
	</PageTitle>
	<xsl:choose>
		<xsl:when test="/OMA/BIOSSetup/ObjName='OnBoard RAID'">
			<PromptText status="3"><xsl:value-of select="$strSelectOneOf"/></PromptText>
		</xsl:when>
		<xsl:when test="/OMA/BIOSSetup/ObjName='Boot Sequence'">
			<PromptText status="3"><xsl:value-of select="$strSelectOneOf2"/></PromptText>
		</xsl:when>
		<xsl:otherwise><PromptText><xsl:value-of select="$strSelectOneOf1"/></PromptText></xsl:otherwise>
	</xsl:choose>

	<CustomButton>
		<xsl:if test="ShutDownFlag='true'">
			<Data name="shtdwn">
				<xsl:attribute name="display"><xsl:value-of select="$strRebootSystem"/></xsl:attribute>
				<xsl:attribute name="href">javascript:restart()</xsl:attribute>
				<xsl:attribute name="formSubmit">true</xsl:attribute>
			</Data>
		</xsl:if>
	<Data name="Refresh">
			<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
			
<xsl:choose>
		  	 <xsl:when test="needBckButton='false'">
     			<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.biosobjinfoWebPlugin&amp;button=false&amp;oid=<xsl:value-of select="BIOSSetup/@oid"/>&amp;help=BiosSetup				</xsl:attribute>
   			</xsl:when>
<xsl:otherwise>

   			<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.biosobjinfoWebPlugin&amp;oid=<xsl:value-of select="BIOSSetup/@oid"/>&amp;help=BiosSetup</xsl:attribute>
</xsl:otherwise>
</xsl:choose>
		
	</Data>
	</CustomButton>

	<xsl:choose>
	   <xsl:when test="/OMA/BIOSSetup/@objtype!='265' and /OMA/BIOSSetup/@objtype!='242'">		
	      <TableData>
		<Header>
			<Data>
				<xsl:attribute name="display"> <xsl:value-of select="$strSetup"/><xsl:value-of select="BIOSSetup/ObjName"/></xsl:attribute>
				<xsl:attribute name="value"> <xsl:value-of select="$strSetup1"/><xsl:value-of select="BIOSSetup/ObjName"/></xsl:attribute>
			</Data>
		</Header>
		<xsl:for-each select="BIOSSetup/Capabilities/*">
			<xsl:if test=".='true'">
				<Row>
					<Data type="radio">
						<xsl:attribute name="name">actionsel</xsl:attribute>
						<xsl:attribute name="returnvalue">
							<xsl:call-template name="objstatus">
								<xsl:with-param name="type"><xsl:value-of select="/OMA/BIOSSetup/@objtype"/></xsl:with-param>
								<xsl:with-param name="name"><xsl:value-of select="name()"/></xsl:with-param>
								<xsl:with-param name="objname"><xsl:value-of select="/OMA/BIOSSetup/ObjName"/></xsl:with-param>
							</xsl:call-template>
						</xsl:attribute>
						<xsl:choose>
							<xsl:when test="/OMA/BIOSSetup/@objtype='240'">
								<xsl:choose>
									<xsl:when test="name()='Disable'">
										<xsl:attribute name="value"><xsl:value-of select="$strOff"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='Enable'">
										<xsl:attribute name="value"><xsl:value-of select="$strOn"/></xsl:attribute>
									</xsl:when>
								</xsl:choose>
							</xsl:when>
							<xsl:when test="/OMA/BIOSSetup/@objtype='241'">
								<xsl:choose>
									<xsl:when test="name()='Disable'">
										<xsl:attribute name="value"><xsl:value-of select="$strOff1"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='Auto'">
										<xsl:attribute name="value"><xsl:value-of select="$strAuto"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='Rdonly'">
										<xsl:attribute name="value"><xsl:value-of select="$strWriteProtect"/></xsl:attribute>
									</xsl:when>
								</xsl:choose>
							</xsl:when>
							<xsl:when test="/OMA/BIOSSetup/@objtype='243'">
								<xsl:choose>
									<xsl:when test="name()='Disable'">
										<xsl:attribute name="value"><xsl:value-of select="$strOff2"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='Enable'">
										<xsl:attribute name="value"><xsl:value-of select="$strOn1"/></xsl:attribute>
									</xsl:when>
								</xsl:choose>
							</xsl:when>
							<xsl:when test="/OMA/BIOSSetup/@objtype='244'">
								<xsl:choose>
									<xsl:when test="name()='Disable'">
										<xsl:attribute name="value"><xsl:value-of select="$strDisabled1"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='Enable'">
										<xsl:attribute name="value"><xsl:value-of select="$strEnabled1"/></xsl:attribute>
									</xsl:when>
								</xsl:choose>
							</xsl:when>
							<xsl:when test="/OMA/BIOSSetup/@objtype='245'">
								<xsl:choose>
									<xsl:when test="name()='Disable'">
										<xsl:attribute name="value"><xsl:value-of select="$strOff3"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='Auto'">
										<xsl:attribute name="value"><xsl:value-of select="$strAuto"/></xsl:attribute>
									</xsl:when>
								</xsl:choose>
							</xsl:when>
							<xsl:when test="/OMA/BIOSSetup/@objtype='246'">
								<xsl:choose>
									<xsl:when test="/OMA/BIOSSetup/ObjName='Secondary SCSI'">
										<xsl:choose>
											<xsl:when test="name()='Disable'">
												<xsl:attribute name="value"><xsl:value-of select="$strOff4"/></xsl:attribute>
											</xsl:when>
											<xsl:when test="name()='Enable'">
												<xsl:attribute name="value"><xsl:value-of select="$strOn3"/></xsl:attribute>
											</xsl:when>
										</xsl:choose>
									</xsl:when>
									<xsl:when test="/OMA/BIOSSetup/ObjName='Primary SCSI'">
										<xsl:choose>
											<xsl:when test="name()='Disable'">
												<xsl:attribute name="value"><xsl:value-of select="$strOff5"/></xsl:attribute>
											</xsl:when>
											<xsl:when test="name()='Enable'">
												<xsl:attribute name="value"><xsl:value-of select="$strOn4"/></xsl:attribute>
											</xsl:when>
										</xsl:choose>
									</xsl:when>
									<!-- [pp] 07/10/03 DFCT 86885 -->
									<xsl:when test="/OMA/BIOSSetup/ObjName='OnBoard RAID'">
										<xsl:choose>
											<xsl:when test="name()='Off'">
												<xsl:attribute name="value"><xsl:value-of select="$strOff5"/></xsl:attribute>
											</xsl:when>
											<xsl:otherwise>
												<xsl:attribute name="value"><xsl:value-of select="name()"/></xsl:attribute>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
								</xsl:choose>
							</xsl:when>
							<!-- pp 07/02/2003 DFCT71386: displaying the Boot sequence option in proper english format after checking the options sent by the DA  -->
							<xsl:when test="/OMA/BIOSSetup/@objtype='247'">
								<xsl:choose>
									<xsl:when test="name()='DisketteFirst'">
										<xsl:attribute name="value"><xsl:value-of select="$strDisketteFirst"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='HDOnly'">
										<xsl:attribute name="value"><xsl:value-of select="$strHDOnly"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='DeviceList'">
										<xsl:attribute name="value"><xsl:value-of select="$strDeviceList"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='CDRomFirst'">
										<xsl:attribute name="value"><xsl:value-of select="$strCDRomFirst"/></xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
											<xsl:attribute name="value"><xsl:value-of select="name()"/></xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:when test="/OMA/BIOSSetup/@objtype='249'">
								<xsl:choose>
									<xsl:when test="name()='Disable'">
										<xsl:attribute name="value"><xsl:value-of select="$strOff6"/></xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
										<xsl:attribute name="value"><xsl:value-of select="name()"/></xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>

							<xsl:when test="/OMA/BIOSSetup/@objtype='251'">
								<xsl:choose>
									<xsl:when test="name()='Disable'">
										<xsl:attribute name="value"><xsl:value-of select="$strOff"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='Serial'">
										<xsl:attribute name="value"><xsl:value-of select="$strBMCSrl"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='NIC'">
										<xsl:attribute name="value"><xsl:value-of select="$strBMCNic"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='RAC'">
											<xsl:attribute name="value"><xsl:value-of select="$strBMCRac"/>		</xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='COM1BMC'">
											<xsl:attribute name="value"><xsl:value-of select="$strCOM1BMC"/>		</xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
									    <xsl:attribute name="value"><xsl:value-of select="name()"/>	</xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>



							<xsl:when test="/OMA/BIOSSetup/@objtype='252'">
								<xsl:choose>
									<xsl:when test="name()='Disable'">
										<xsl:attribute name="value"><xsl:value-of select="$strOff9"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='Enable'">
										<xsl:attribute name="value"><xsl:value-of select="$strOn5"/></xsl:attribute>
									</xsl:when>
								</xsl:choose>
							</xsl:when>
							<!--Start Console Redirection -->
							<xsl:when test="/OMA/BIOSSetup/@objtype='267'">
								<xsl:choose>
									<xsl:when test="name()='CRoff'">
										<xsl:attribute name="value"><xsl:value-of select="$strOff9"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='CRcom1'">
										<xsl:attribute name="value"><xsl:value-of select="$strSerialPort1"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='CRcom2'">
										<xsl:attribute name="value"><xsl:value-of select="$strSerialPort2"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='CRnic'">
										<xsl:attribute name="value"><xsl:value-of select="$strBMCNic"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='CRmmb'">
										<xsl:attribute name="value"><xsl:value-of select="$strmmb"/></xsl:attribute>
									</xsl:when>
								</xsl:choose>
							</xsl:when>
							<!--End Console Redirection -->
							
							<!-- AC Power Recovery Mode  -->
							<xsl:when test="/OMA/BIOSSetup/@objtype='368'">
								<xsl:choose>
									<xsl:when test="name()='ACoff'">
										<xsl:attribute name="value"><xsl:value-of select="$strOff9"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='AClast'">
										<xsl:attribute name="value"><xsl:value-of select="$strAClast"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='ACon'">
										<xsl:attribute name="value"><xsl:value-of select="$strACon"/></xsl:attribute>
									</xsl:when>
								</xsl:choose>
							</xsl:when>

							<!-- Embedded SATA 2 Controller  -->
							<xsl:when test="/OMA/BIOSSetup/@objtype='369'">
								<xsl:choose>
									<xsl:when test="name()='SATAoff'">
										<xsl:attribute name="value"><xsl:value-of select="$strOff9"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='SATAcombined'">
										<xsl:attribute name="value"><xsl:value-of select="$strSATAcombined"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='SATAata'">
										<xsl:attribute name="value"><xsl:value-of select="$strSATAata"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='SATAqdma'">
										<xsl:attribute name="value"><xsl:value-of select="$strSATAqdma"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='SATAahci'">
										<xsl:attribute name="value"><xsl:value-of select="$strSATAahci"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='SATAraid'">
										<xsl:attribute name="value"><xsl:value-of select="$strSATAraid"/></xsl:attribute>
									</xsl:when>
								</xsl:choose>
							</xsl:when>

							<!-- Embedded SATA 2 Port  -->
							<xsl:when test="/OMA/BIOSSetup/@objtype='370'">
								<xsl:choose>
									<xsl:when test="name()='SATAPortOff'">
										<xsl:attribute name="value"><xsl:value-of select="$strOff9"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='SATAPortAuto'">
										<xsl:attribute name="value"><xsl:value-of select="$strAuto"/></xsl:attribute>
									</xsl:when>
								</xsl:choose>
							</xsl:when>
			
							<!-- IDE Primary Drive  -->
							<xsl:when test="/OMA/BIOSSetup/@objtype='371'">
								<xsl:choose>
									<xsl:when test="name()='IDEPriOff'">
										<xsl:attribute name="value"><xsl:value-of select="$strOff9"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='IDEPriAuto'">
										<xsl:attribute name="value"><xsl:value-of select="$strAuto"/></xsl:attribute>
									</xsl:when>
								</xsl:choose>
							</xsl:when>
							
							<!-- For DBS  -->
							<xsl:when test="/OMA/BIOSSetup/@objtype='372'">
								<xsl:choose>
									<xsl:when test="name()='DBSDisabled'">
										<xsl:attribute name="value"><xsl:value-of select="$strDisabled"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='DBSEnabled'">
										<xsl:attribute name="value"><xsl:value-of select="$strEnabled"/></xsl:attribute>
									</xsl:when>
								</xsl:choose>
							</xsl:when>


							<!-- For Console Redirection Failsafe BAUD Rate  -->
							<xsl:when test="/OMA/BIOSSetup/@objtype='271'">
								<xsl:choose>
									<xsl:when test="name()='FBR115200'">
										<xsl:attribute name="value"><xsl:value-of select="$strFBR115200"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='FBR57600'">
										<xsl:attribute name="value"><xsl:value-of select="$strFBR57600"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='FBR19200'">
										<xsl:attribute name="value"><xsl:value-of select="$strFBR19200"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='FBR9600'">
										<xsl:attribute name="value"><xsl:value-of select="$strFBR9600"/></xsl:attribute>
									</xsl:when>
								</xsl:choose>
							</xsl:when>
			
							<xsl:when test="/OMA/BIOSSetup/@objtype='260'">
								<xsl:choose>
									<xsl:when test="name()='Disable'">
										<xsl:attribute name="value"><xsl:value-of select="$strDisabled2"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='Enable'">
										<xsl:attribute name="value"><xsl:value-of select="$strEnabled2"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='EnableWithBIOS'">
										<xsl:attribute name="value"><xsl:value-of select="$strEnabledWithBIOS"/></xsl:attribute>
									</xsl:when>
								</xsl:choose>
							</xsl:when>
							<xsl:when test="/OMA/BIOSSetup/@objtype='262'">
								<xsl:choose>
									<xsl:when test="name()='Disable'">
										<xsl:attribute name="value"><xsl:value-of select="$strDisable"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='Enable'">
										<xsl:attribute name="value"><xsl:value-of select="$strEnable"/></xsl:attribute>
									</xsl:when>
								</xsl:choose>
							</xsl:when>
							<!-- PP [07/18/2003] - DFCT 86885 -->
							<xsl:when test="/OMA/BIOSSetup/@objtype='263'">
								<xsl:choose>
									<xsl:when test="name()='Off'">
										<xsl:attribute name="value"><xsl:value-of select="$strOff6"/></xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
										<xsl:attribute name="value"><xsl:value-of select="name()"/></xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:when test="/OMA/BIOSSetup/@objtype='374'">
								<xsl:choose>
									<xsl:when test="name()='Enable'">
										<xsl:attribute name="value"><xsl:value-of select="$strEnabled"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='Disable'">
										<xsl:attribute name="value"><xsl:value-of select="$strDisabled"/></xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
										<xsl:attribute name="value"><xsl:value-of select="name()"/></xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:when test="/OMA/BIOSSetup/@objtype='375'">
								<xsl:choose>
									<xsl:when test="name()='AllOn'">
										<xsl:attribute name="value"><xsl:value-of select="$strAllOn"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='BackOnly'">
										<xsl:attribute name="value"><xsl:value-of select="$strBackOn"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='AllOff'">
										<xsl:attribute name="value"><xsl:value-of select="$strAllOff"/></xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
										<xsl:attribute name="value"><xsl:value-of select="name()"/></xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:when test="/OMA/BIOSSetup/@objtype='378'">
								<xsl:choose>
									<xsl:when test="name()='OnWithoutCR'">
										<xsl:attribute name="value"><xsl:value-of select="$strOnWithoutCR"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='OnCRCom1'">
										<xsl:attribute name="value"><xsl:value-of select="$strOnWithCRCOM1"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='OnCRCom2'">
										<xsl:attribute name="value"><xsl:value-of select="$strOnWithCRCOM2"/></xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
										<xsl:attribute name="value"><xsl:value-of select="name()"/></xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:when test="/OMA/BIOSSetup/@objtype='379'">
								<xsl:choose>
									<xsl:when test="name()='RAC'">
										<xsl:attribute name="value"><xsl:value-of select="$strRemoteAccessDevice"/></xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
										<xsl:attribute name="value"><xsl:value-of select="name()"/></xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:when test="/OMA/BIOSSetup/@objtype='380'">
								<xsl:choose>
									<xsl:when test="name()='Enable'">
										<xsl:attribute name="value"><xsl:value-of select="$strEnabled"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='Disable'">
										<xsl:attribute name="value"><xsl:value-of select="$strDisabled"/></xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
										<xsl:attribute name="value"><xsl:value-of select="name()"/></xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:when test="/OMA/BIOSSetup/@objtype='381'">
								<xsl:choose>
									<xsl:when test="name()='Enable'">
										<xsl:attribute name="value"><xsl:value-of select="$strEnabled"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='Disable'">
										<xsl:attribute name="value"><xsl:value-of select="$strDisabled"/></xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
										<xsl:attribute name="value"><xsl:value-of select="name()"/></xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:when test="/OMA/BIOSSetup/@objtype='454'">
								<xsl:choose>
									<xsl:when test="name()='Enable'">
										<xsl:attribute name="value"><xsl:value-of select="$strEnabled"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='Disable'">
										<xsl:attribute name="value"><xsl:value-of select="$strDisabled"/></xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
										<xsl:attribute name="value"><xsl:value-of select="name()"/></xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:when test="/OMA/BIOSSetup/@objtype='455'">
								<xsl:choose>
									<xsl:when test="name()='Enable'">
										<xsl:attribute name="value"><xsl:value-of select="$strEnabled"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='Disable'">
										<xsl:attribute name="value"><xsl:value-of select="$strDisabled"/></xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
										<xsl:attribute name="value"><xsl:value-of select="name()"/></xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:when test="/OMA/BIOSSetup/@objtype='456'">
								<xsl:choose>
									<xsl:when test="name()='Enable'">
										<xsl:attribute name="value"><xsl:value-of select="$strEnabled"/></xsl:attribute>
									</xsl:when>
									<xsl:when test="name()='Disable'">
										<xsl:attribute name="value"><xsl:value-of select="$strDisabled"/></xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
										<xsl:attribute name="value"><xsl:value-of select="name()"/></xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="value"><xsl:value-of select="name()"/></xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:attribute name="state">
							<xsl:call-template name="objselect">
								<xsl:with-param name="state"><xsl:value-of select="/OMA/BIOSSetup/State"/></xsl:with-param>
								<xsl:with-param name="type"><xsl:value-of select="/OMA/BIOSSetup/@objtype"/></xsl:with-param>
								<xsl:with-param name="name"><xsl:value-of select="name()"/></xsl:with-param>
								<xsl:with-param name="objname"><xsl:value-of select="/OMA/BIOSSetup/ObjName"/></xsl:with-param>
							</xsl:call-template>
						</xsl:attribute>
					</Data>
				</Row>
			</xsl:if>
		</xsl:for-each>
	      </TableData>
	   </xsl:when>
	   <xsl:when test="/OMA/BIOSSetup/@objtype='242'">
	   <TableData>
	   	<Header>
	   		<Data width="20%">
	   			<xsl:attribute name="display"> <xsl:value-of select="$strSetup"/><xsl:value-of select="BIOSSetup/ObjName"/></xsl:attribute>
	   			<xsl:attribute name="value"> <xsl:value-of select="$strSetup1"/><xsl:value-of select="BIOSSetup/ObjName"/></xsl:attribute>
	   		</Data>
	   		<Data width="80%"></Data>
	   	</Header>
		<Row >
			<Data type="radio" Width="20%">
			<xsl:attribute name="name">actionsel</xsl:attribute>
			<xsl:attribute name="returnvalue">1</xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strDisabled"/></xsl:attribute>
			<xsl:attribute name="event">onClick</xsl:attribute>
			<xsl:attribute name="handler">javascript:disableChoices()</xsl:attribute>
			<xsl:attribute name="state">
				<xsl:if test="/OMA/BIOSSetup/State = 1">1</xsl:if>
			</xsl:attribute>
			</Data>
			<Data><xsl:attribute name="value">     </xsl:attribute></Data>
			
		</Row>
		<Row>
			<Data type="radio" align="left" Width="20%">
			<xsl:attribute name="name">actionsel</xsl:attribute>
			<xsl:attribute name="returnvalue"></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strEnabled"/></xsl:attribute>
			<xsl:attribute name="event">onClick</xsl:attribute>
			<xsl:attribute name="handler">javascript:enableChoices()</xsl:attribute>
			<xsl:attribute name="state">
				<xsl:if test="/OMA/BIOSSetup/State > 1">1</xsl:if>
			</xsl:attribute>
			</Data>

		</Row>
		<xsl:if test="/OMA/BIOSSetup/Capabilities/Enable = 'true'">
		<Row>
				<Data Width="20%">
				<xsl:attribute name="value">   </xsl:attribute>
				</Data>
				<Data type="checkbox" name="check1" align="left" Width="80%">
					<xsl:attribute name="returnvalue"></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strEnabledWithPXE"/></xsl:attribute>
					<xsl:attribute name="event">onClick</xsl:attribute>
					<xsl:attribute name="handler">javascript:alternateChoices(this)</xsl:attribute>
					<xsl:attribute name="state">
						<xsl:if test="/OMA/BIOSSetup/State = 2">1</xsl:if>
					</xsl:attribute>
				</Data>
		</Row>
		</xsl:if>
		<xsl:if test="/OMA/BIOSSetup/Capabilities/EnableWithISCSI = 'true'">
		<Row>
				<Data Width="20%">
				<xsl:attribute name="value">   </xsl:attribute>
				</Data>
				<Data type="checkbox" name="check2" Width="80%">
					<xsl:attribute name="returnvalue"></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strEnabledWithISCSI"/></xsl:attribute>
					<xsl:attribute name="event">onClick</xsl:attribute>
					<xsl:attribute name="handler">javascript:alternateChoices(this)</xsl:attribute>
					<xsl:attribute name="state">
						<xsl:if test="/OMA/BIOSSetup/State = 4">1</xsl:if>
					</xsl:attribute>
				</Data>

		</Row>
	   	</xsl:if>
	   </TableData>
	   </xsl:when>
	   <xsl:otherwise>	
	      <TableData ignoreJumpBar="true">
		<Header>
			<Data>
				<xsl:attribute name="display"> <xsl:value-of select="$strSetup"/><xsl:value-of select="BIOSSetup/ObjName"/></xsl:attribute>
				<xsl:attribute name="value"> <xsl:value-of select="$strSetup1"/><xsl:value-of select="BIOSSetup/ObjName"/></xsl:attribute>
			</Data>
		</Header>
		<xsl:if test="BIOSSetup/Capabilities/DualNicDisable='true'">
				<Row>
					<Data type="radio">
						<xsl:attribute name="name">actionsel</xsl:attribute>
						<xsl:attribute name="returnvalue">41</xsl:attribute>
						<xsl:attribute name="event">onClick</xsl:attribute>
						<xsl:attribute name="handler">javascript:disableDualNic()</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strOff"/></xsl:attribute>
						<xsl:attribute name="state"> 
							<xsl:if test="/OMA/BIOSSetup/State='41'">1</xsl:if>
						</xsl:attribute>
					</Data>
				</Row>
		</xsl:if>
		<xsl:if test="BIOSSetup/Capabilities/DualNicEnable='true'">
				<Row>
					<Data type="radio">
						<xsl:attribute name="name">actionsel</xsl:attribute>
						<xsl:attribute name="event">onClick</xsl:attribute>
						<xsl:attribute name="handler">javascript:enableDualNic()</xsl:attribute>						
						<xsl:attribute name="returnvalue">42</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strOn"/></xsl:attribute>
						<xsl:attribute name="state"> 
							<xsl:if test="/OMA/BIOSSetup/State!='41'">1</xsl:if>
						</xsl:attribute>
					</Data>
				</Row>
		</xsl:if>
	</TableData>
		<TableData ignoreJumpBar="true">
			<Header>
				<Data>
					<xsl:attribute name="display"> <xsl:value-of select="$strConfigDualNic1"/></xsl:attribute>
					<xsl:attribute name="value"> <xsl:value-of select="$strConfigDualNic1"/></xsl:attribute>
				</Data>
			</Header>
			<xsl:if test="BIOSSetup/Capabilities/PXEEnableOn1stNic='true'">
				<Row>
					<Data type="checkbox">

						<xsl:attribute name="name">actionsel_NIC1_PXE</xsl:attribute>
						<xsl:attribute name="returnvalue">38</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strConfigDualNicPXE"/></xsl:attribute>
						<xsl:attribute name="event">onClick</xsl:attribute>
						<xsl:attribute name="handler">javascript:DualNICAlternateChoice(this, 1)</xsl:attribute>
						<xsl:attribute name="state"> 
							<xsl:choose>
								<xsl:when test="/OMA/BIOSSetup/State='41'">2</xsl:when>
								<xsl:when test="/OMA/BIOSSetup/State='22'">1</xsl:when>
								<xsl:when test="/OMA/BIOSSetup/State='38'">1</xsl:when>
								<xsl:when test="/OMA/BIOSSetup/State='134'">1</xsl:when>
								<xsl:otherwise></xsl:otherwise>
							</xsl:choose>
						</xsl:attribute>
					</Data>
				</Row>
			</xsl:if>
			<xsl:if test="BIOSSetup/Capabilities/ISCSIEnableOn1stNic='true'">
				<Row>
					<Data type="checkbox">
						<xsl:attribute name="name">actionsel_NIC1_ISCSI</xsl:attribute>
						<xsl:attribute name="returnvalue">98</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strConfigDualNiciSCSI"/></xsl:attribute>
						<xsl:attribute name="event">onClick</xsl:attribute>
						<xsl:attribute name="handler">javascript:DualNICAlternateChoice(this, 1)</xsl:attribute>
						<xsl:attribute name="state"> 
							<xsl:choose>
								<xsl:when test="/OMA/BIOSSetup/State='41'">2</xsl:when>
								<xsl:when test="/OMA/BIOSSetup/State='82'">1</xsl:when>
								<xsl:when test="/OMA/BIOSSetup/State='98'">1</xsl:when>
								<xsl:when test="/OMA/BIOSSetup/State='194'">1</xsl:when>
								<xsl:otherwise></xsl:otherwise>
							</xsl:choose>
						</xsl:attribute>
					</Data>
				</Row>
			</xsl:if>
			</TableData>

		<TableData ignoreJumpBar="true">
			<Header>
				<Data>
					<xsl:attribute name="display"> <xsl:value-of select="$strConfigDualNic2"/></xsl:attribute>
					<xsl:attribute name="value"> <xsl:value-of select="$strConfigDualNic2"/></xsl:attribute>
				</Data>
			</Header>
			<xsl:if test="BIOSSetup/Capabilities/PXEEnableOn2ndNic='true'">
				<Row>
					<Data type="checkbox">
						<xsl:attribute name="name">actionsel_NIC2_PXE</xsl:attribute>
						<xsl:attribute name="returnvalue">26</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strConfigDualNicPXE"/></xsl:attribute>
						<xsl:attribute name="event">onClick</xsl:attribute>
						<xsl:attribute name="handler">javascript:DualNICAlternateChoice(this, 2)</xsl:attribute>
						<xsl:attribute name="state"> 
							<xsl:choose>
								<xsl:when test="/OMA/BIOSSetup/State='41'">2</xsl:when>
								<xsl:when test="/OMA/BIOSSetup/State='22'">1</xsl:when>
								<xsl:when test="/OMA/BIOSSetup/State='26'">1</xsl:when>
								<xsl:when test="/OMA/BIOSSetup/State='82'">1</xsl:when>
								<xsl:otherwise></xsl:otherwise>
							</xsl:choose>
						</xsl:attribute>
					</Data>
				</Row>
			</xsl:if>
			<xsl:if test="BIOSSetup/Capabilities/ISCSIEnableOn2ndNic='true'">
				<Row>
					<Data type="checkbox">
						<xsl:attribute name="name">actionsel_NIC2_ISCSI</xsl:attribute>
						<xsl:attribute name="returnvalue">138</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strConfigDualNiciSCSI"/></xsl:attribute>
						<xsl:attribute name="event">onClick</xsl:attribute>
						<xsl:attribute name="handler">javascript:DualNICAlternateChoice(this, 2)</xsl:attribute>
						<xsl:attribute name="state"> 
							<xsl:choose>
								<xsl:when test="/OMA/BIOSSetup/State='41'">2</xsl:when>
								<xsl:when test="/OMA/BIOSSetup/State='134'">1</xsl:when>
								<xsl:when test="/OMA/BIOSSetup/State='136'">1</xsl:when>
								<xsl:when test="/OMA/BIOSSetup/State='194'">1</xsl:when>
								<xsl:otherwise></xsl:otherwise>
							</xsl:choose>
						</xsl:attribute>
					</Data>
				</Row>
			</xsl:if>
		</TableData>
	   </xsl:otherwise>
	</xsl:choose>

	<ListData>
		<Data  display=" "  type="hidden" state="" align="left">
			<xsl:attribute name="name">reboot</xsl:attribute>
			<xsl:attribute name="returnvalue">false</xsl:attribute>
		</Data>
	</ListData>
</DataArea>
</xsl:template>

<xsl:template name="objselect">
	<xsl:param name="type"/>
	<xsl:param name="state"/>
	<xsl:param name="name"/>
	<xsl:param name="objname"/>
	<xsl:choose>
		<xsl:when test="$type='241'">
			<xsl:if test="$name='Disable'">
				<xsl:if test="$state='1'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='Auto'">
				<xsl:if test="$state='2'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='Rdonly'">
				<xsl:if test="$state='3'">1</xsl:if>
			</xsl:if>
		</xsl:when>

		<xsl:when test="$type='242'">
			<xsl:if test="$name='Disable'">
				<xsl:if test="$state='1'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='Enable'">
				<xsl:if test="$state='2'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='EnableNonePXE'">
				<xsl:if test="$state='3'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='EnableWithISCSI'">
				<xsl:if test="$state='4'">1</xsl:if>
			</xsl:if>
		</xsl:when>

		<xsl:when test="$type='245'">
			<xsl:if test="$name='Disable'">
				<xsl:if test="$state='1'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='Auto'">
				<xsl:if test="$state='2'">1</xsl:if>
			</xsl:if>
		</xsl:when>
		<!-- Start  For Console Redirection -->
		<xsl:when test="$type='267'">
			<xsl:if test="$name='CRoff'">
				<xsl:if test="$state='1'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='CRcom1'">
				<xsl:if test="$state='2'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='CRcom2'">
				<xsl:if test="$state='3'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='CRnic'">
				<xsl:if test="$state='4'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='CRmmb'">
				<xsl:if test="$state='5'">1</xsl:if>
			</xsl:if>
		</xsl:when>
		<!-- End  For Console Redirection -->
		
		<!-- Start  For AC Power Recovery Mode -->
		<xsl:when test="$type='368'">
			<xsl:if test="$name='ACoff'">
				<xsl:if test="$state='1'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='AClast'">
				<xsl:if test="$state='2'">1</xsl:if>
			</xsl:if>			
			<xsl:if test="$name='ACon'">
				<xsl:if test="$state='3'">1</xsl:if>
			</xsl:if>
		</xsl:when>
		<!-- End  For AC Power Recovery Mode -->

		<!-- Embedded SATA 2 Controller -->
		<xsl:when test="$type='369'">
			<xsl:if test="$name='SATAoff'">
				<xsl:if test="$state='1'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='SATAcombined'">
				<xsl:if test="$state='2'">1</xsl:if>
			</xsl:if>			
			<xsl:if test="$name='SATAata'">
				<xsl:if test="$state='3'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='SATAahci'">
				<xsl:if test="$state='4'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='SATAraid'">
				<xsl:if test="$state='5'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='SATAqdma'">
				<xsl:if test="$state='6'">1</xsl:if>
			</xsl:if>			
		</xsl:when>
		<!-- End  For Embedded SATA 2 Controller -->

		<!-- Embedded SATA 2 Port -->
		<xsl:when test="$type='370'">
			<xsl:if test="$name='SATAPortOff'">
				<xsl:if test="$state='1'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='SATAPortAuto'">
				<xsl:if test="$state='2'">1</xsl:if>
			</xsl:if>			
		</xsl:when>
		<!-- End  For Embedded SATA 2 Port -->

		<!-- IDE Primary Drive -->
		<xsl:when test="$type='371'">
			<xsl:if test="$name='IDEPriOff'">
				<xsl:if test="$state='1'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='IDEPriAuto'">
				<xsl:if test="$state='2'">1</xsl:if>
			</xsl:if>			
		</xsl:when>
		<!-- End  For IDE Primary Drive -->
		
		<!-- Start of DBS -->
		<xsl:when test="$type='372'">
			<xsl:if test="$name='DBSDisabled'">
				<xsl:if test="$state='1'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='DBSEnabled'">
				<xsl:if test="$state='2'">1</xsl:if>
			</xsl:if>			
		</xsl:when>
		<!-- End  of DBS -->

		<!-- Start  For Console Redirection BAUD Rate -->
		<xsl:when test="$type='271'">
			<xsl:if test="$name='FBR115200'">
				<xsl:if test="$state='1'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='FBR57600'">
				<xsl:if test="$state='2'">1</xsl:if>
			</xsl:if>			
			<xsl:if test="$name='FBR19200'">
				<xsl:if test="$state='3'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='FBR9600'">
				<xsl:if test="$state='4'">1</xsl:if>
			</xsl:if>
		</xsl:when>
		<!-- End  For Console Redirection BAUD Rate -->

		<xsl:when test="$type='246'">
			<xsl:if test="$objname='OnBoard RAID'">
				<xsl:if test="$name='RAID'">
					<xsl:if test="$state='0'">1</xsl:if>
				</xsl:if>
				<xsl:if test="$name='Off'">
					<xsl:if test="$state='1'">1</xsl:if>
				</xsl:if>
				<xsl:if test="$name='SCSI'">
					<xsl:if test="$state='2'">1</xsl:if>
				</xsl:if>
			</xsl:if>
			<xsl:if test="$objname='Primary SCSI'">
				<xsl:if test="$name='Disable'">
					<xsl:if test="$state='0'">1</xsl:if>
				</xsl:if>
				<xsl:if test="$name='Disable'">
					<xsl:if test="$state='1'">1</xsl:if>
				</xsl:if>
				<xsl:if test="$name='Enable'">
					<xsl:if test="$state='2'">1</xsl:if>
				</xsl:if>
			</xsl:if>
			<xsl:if test="$objname='Secondary SCSI'">
				<xsl:if test="$name='Disable'">
					<xsl:if test="$state='1'">1</xsl:if>
				</xsl:if>
				<xsl:if test="$name='Enable'">
					<xsl:if test="$state='2'">1</xsl:if>
				</xsl:if>
			</xsl:if>
		</xsl:when>
		<xsl:when test="$type='247'">
			<xsl:if test="$name='DisketteFirst'">
				<xsl:if test="$state='1'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='HDOnly'">
				<xsl:if test="$state='2'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='DeviceList'">
				<xsl:if test="$state='3'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='CDRomFirst'">
				<xsl:if test="$state='4'">1</xsl:if>
			</xsl:if>
		</xsl:when>

		<xsl:when test="$type='249'">
			<xsl:if test="$name='Disable'">
				<xsl:if test="$state='1'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='LPT1'">
				<xsl:if test="$state='2'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='LPT2'">
				<xsl:if test="$state='3'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='LPT3'">
				<xsl:if test="$state='4'">1</xsl:if>
			</xsl:if>
		</xsl:when>

		<xsl:when test="$type='250'">
			<xsl:if test="$name='AT'">
				<xsl:if test="$state='1'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='PS2'">
				<xsl:if test="$state='2'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='ECP'">
				<xsl:if test="$state='3'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='EPP'">
				<xsl:if test="$state='4'">1</xsl:if>
			</xsl:if>
		</xsl:when>

		<xsl:when test="$type='251'">
			<xsl:if test="$name='Disable'">
				<xsl:if test="$state='1'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='Auto'">
				<xsl:if test="$state='2'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='Com1'">
				<xsl:if test="$state='3'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='Com2'">
				<xsl:if test="$state='4'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='Com3'">
				<xsl:if test="$state='5'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='Com4'">
				<xsl:if test="$state='6'">1</xsl:if>
			</xsl:if>
				<xsl:if test="$name='Serial'">
				<xsl:if test="$state='7'">1</xsl:if>
			</xsl:if>
				<xsl:if test="$name='NIC'">
				<xsl:if test="$state='8'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='RAC'">
				<xsl:if test="$state='9'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='COM1BMC'">
				<xsl:if test="$state='10'">1</xsl:if>
			</xsl:if>
		</xsl:when>

		<xsl:when test="$type='252'">
			<xsl:if test="$name='Disable'">
				<xsl:if test="$state='1'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='Enable'">
				<xsl:if test="$state='2'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='Low'">
				<xsl:if test="$state='3'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='Medium'">
				<xsl:if test="$state='4'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='High'">
				<xsl:if test="$state='5'">1</xsl:if>
			</xsl:if>
		</xsl:when>

		<xsl:when test="$type='253'">
			<xsl:if test="$name='Disable'">
				<xsl:if test="$state='1'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='EnableAddInCard'">
				<xsl:if test="$state='2'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='EnableOnBoard'">
				<xsl:if test="$state='3'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='EnableAll'">
				<xsl:if test="$state='4'">1</xsl:if>
			</xsl:if>
		</xsl:when>

		<xsl:when test="$type='260'">
			<xsl:if test="$name='Disable'">
				<xsl:if test="$state='1'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='Enable'">
				<xsl:if test="$state='2'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='EnableWithBIOS'">
				<xsl:if test="$state='3'">1</xsl:if>
			</xsl:if>
		</xsl:when>
		
		<xsl:when test="$type='263'">
			<xsl:if test="$name='Off'">
				<xsl:if test="$state='1'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='SCSI'">
				<xsl:if test="$state='2'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='RAID'">
				<xsl:if test="$state='3'">1</xsl:if>			
			</xsl:if>
		</xsl:when>
		
		<xsl:when test="$type='264'">
			<xsl:if test="$name='SCSI'">
				<xsl:if test="$state='1'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='RAID'">
				<xsl:if test="$state='2'">1</xsl:if>
			</xsl:if>
		</xsl:when>
		
		<xsl:when test="$type='374'">
			<xsl:if test="$name='Enable'">
				<xsl:if test="$state='1'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='Disable'">
				<xsl:if test="$state='2'">1</xsl:if>
			</xsl:if>
		</xsl:when>
		<xsl:when test="$type='375'">
			<xsl:if test="$name='AllOff'">
				<xsl:if test="$state='1'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='BackOnly'">
				<xsl:if test="$state='2'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='AllOn'">
				<xsl:if test="$state='3'">1</xsl:if>
			</xsl:if>
		</xsl:when>
		<xsl:when test="$type='378'">
			<xsl:if test="$name='Off'">
				<xsl:if test="$state='1'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='OnWithoutCR'">
				<xsl:if test="$state='2'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='OnCRCom1'">
				<xsl:if test="$state='3'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='OnCRCom2'">
				<xsl:if test="$state='4'">1</xsl:if>
			</xsl:if>
		</xsl:when>
		<xsl:when test="$type='379'">
      <xsl:if test="$name='Com1'">
        <xsl:if test="$state='3'">1</xsl:if>
      </xsl:if>
      <xsl:if test="$name='Com2'">
        <xsl:if test="$state='4'">1</xsl:if>
      </xsl:if>
      <xsl:if test="$name='RAC'">
				<xsl:if test="$state='9'">1</xsl:if>
			</xsl:if>
		</xsl:when>
		<xsl:when test="$type='381'">
			<xsl:if test="$name='Disable'">
				<xsl:if test="$state='2'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='Enable'">
				<xsl:if test="$state='1'">1</xsl:if>
			</xsl:if>
		</xsl:when>
		<xsl:when test="$type='456'">
			<xsl:if test="$name='Disable'">
				<xsl:if test="$state='2'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='Enable'">
				<xsl:if test="$state='1'">1</xsl:if>
			</xsl:if>
		</xsl:when>
		<xsl:otherwise>
			<xsl:if test="$name='Disable'">
				<xsl:if test="$state='1'">1</xsl:if>
			</xsl:if>
			<xsl:if test="$name='Enable'">
				<xsl:if test="$state='2'">1</xsl:if>
			</xsl:if>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="DualNicStatus">
	<xsl:param name="Nic1Status"/>
	<xsl:param name="Nic2Status"/>
<!--
	<xsl:value-of select="sum($Nic1Status, $Nic2Status, 2)"/>
-->
</xsl:template>

<xsl:template name="objstatus">
	<xsl:param name="type"/>
	<xsl:param name="name"/>
	<xsl:param name="objname"/>
	<xsl:choose>
		<xsl:when test="$type='241'">
			<xsl:if test="$name='Disable'">1</xsl:if>
			<xsl:if test="$name='Auto'">2</xsl:if>
			<xsl:if test="$name='Rdonly'">3</xsl:if>
		</xsl:when>

		<xsl:when test="$type='242'">
			<xsl:if test="$name='Disable'">1</xsl:if>
			<xsl:if test="$name='Enable'">2</xsl:if>
			<xsl:if test="$name='EnableNonePXE'">3</xsl:if>
			<xsl:if test="$name='EnableWithISCSI'">4</xsl:if>
		</xsl:when>

		<xsl:when test="$type='245'">
			<xsl:if test="$name='Disable'">1</xsl:if>
			<xsl:if test="$name='Auto'">2</xsl:if>
		</xsl:when>

		<xsl:when test="$type='246'">
			<xsl:if test="$objname='OnBoard RAID'">
				<xsl:if test="$name='RAID'">0</xsl:if>
				<xsl:if test="$name='Off'">1</xsl:if>
				<xsl:if test="$name='SCSI'">2</xsl:if>
			</xsl:if>
			<xsl:if test="$objname='Primary SCSI'">
				<xsl:if test="$name='Disable'">1</xsl:if>
				<xsl:if test="$name='Enable'">2</xsl:if>
			</xsl:if>
			<xsl:if test="$objname='Secondary SCSI'">
				<xsl:if test="$name='Disable'">1</xsl:if>
				<xsl:if test="$name='Enable'">2</xsl:if>
			</xsl:if>
		</xsl:when>

		<xsl:when test="$type='247'">
			<xsl:if test="$name='DisketteFirst'">1</xsl:if>
			<xsl:if test="$name='HDOnly'">2</xsl:if>
			<xsl:if test="$name='DeviceList'">3</xsl:if>
			<xsl:if test="$name='CDRomFirst'">4</xsl:if>
		</xsl:when>

		<xsl:when test="$type='249'">
			<xsl:if test="$name='Disable'">1</xsl:if>
			<xsl:if test="$name='LPT1'">2</xsl:if>
			<xsl:if test="$name='LPT2'">3</xsl:if>
			<xsl:if test="$name='LPT3'">4</xsl:if>
		</xsl:when>

		<xsl:when test="$type='250'">
			<xsl:if test="$name='AT'">1</xsl:if>
			<xsl:if test="$name='PS2'">2</xsl:if>
			<xsl:if test="$name='ECP'">3</xsl:if>
			<xsl:if test="$name='EPP'">4</xsl:if>
		</xsl:when>

		<xsl:when test="$type='251'">
			<xsl:if test="$name='Disable'">1</xsl:if>
			<xsl:if test="$name='Auto'">2</xsl:if>
			<xsl:if test="$name='Com1'">3</xsl:if>
			<xsl:if test="$name='Com2'">4</xsl:if>
			<xsl:if test="$name='Com3'">5</xsl:if>
			<xsl:if test="$name='Com4'">6</xsl:if>
			<xsl:if test="$name='Serial'">7</xsl:if>
			<xsl:if test="$name='NIC'">8</xsl:if>
			<xsl:if test="$name='RAC'">9</xsl:if>
			<xsl:if test="$name='COM1BMC'">10</xsl:if>
		</xsl:when>

		<xsl:when test="$type='252'">
			<xsl:if test="$name='Disable'">1</xsl:if>
			<xsl:if test="$name='Enable'">2</xsl:if>
			<xsl:if test="$name='Low'">3</xsl:if>
			<xsl:if test="$name='Medium'">4</xsl:if>
			<xsl:if test="$name='High'">5</xsl:if>
		</xsl:when>

		<xsl:when test="$type='253'">
			<xsl:if test="$name='Disable'">1</xsl:if>
			<xsl:if test="$name='EnableAddInCard'">2</xsl:if>
			<xsl:if test="$name='EnableOnBoard'">3</xsl:if>
			<xsl:if test="$name='EnableAll'">4</xsl:if>
		</xsl:when>

		<xsl:when test="$type='260'">
			<xsl:if test="$name='Disable'">1</xsl:if>
			<xsl:if test="$name='Enable'">2</xsl:if>
			<xsl:if test="$name='EnableWithBIOS'">3</xsl:if>
		</xsl:when>
		
		<xsl:when test="$type='263' ">
			<xsl:if test="$name='Off'">1</xsl:if>
			<xsl:if test="$name='SCSI'">2</xsl:if>
			<xsl:if test="$name='RAID'">3</xsl:if>
		</xsl:when>
		
		<xsl:when test="$type='264'">
			<xsl:if test="$name='SCSI'">1</xsl:if>
			<xsl:if test="$name='RAID'">2</xsl:if>
		</xsl:when>
		
		<!-- Start  Console Redirection -->
		
		<xsl:when test="$type='267'">
			<xsl:if test="$name='CRoff'">1</xsl:if>
			<xsl:if test="$name='CRcom1'">2</xsl:if>
			<xsl:if test="$name='CRcom2'">3</xsl:if>
			<xsl:if test="$name='CRnic'">4</xsl:if>
			<xsl:if test="$name='CRmmb'">5</xsl:if>
		</xsl:when>
		<!-- End  Console Redirection -->

		<!-- Start AC Power Recovery Mode -->
		
		<xsl:when test="$type='368'">
			<xsl:if test="$name='ACoff'">1</xsl:if>
			<xsl:if test="$name='AClast'">2</xsl:if>
			<xsl:if test="$name='ACon'">3</xsl:if>
		</xsl:when>
		<!-- End  AC Power Recovery Mode -->

		<!-- Embedded SATA 2 Controller  -->
		
		<xsl:when test="$type='369'">
			<xsl:if test="$name='SATAoff'">1</xsl:if>
			<xsl:if test="$name='SATAcombined'">2</xsl:if>
			<xsl:if test="$name='SATAata'">3</xsl:if>
			<xsl:if test="$name='SATAahci'">4</xsl:if>
			<xsl:if test="$name='SATAraid'">5</xsl:if>
			<xsl:if test="$name='SATAqdma'">6</xsl:if>
		</xsl:when>
		<!-- End of Embedded SATA 2 Controller -->

		<!-- Embedded SATA 2 Port  -->
		
		<xsl:when test="$type='370'">
			<xsl:if test="$name='SATAPortOff'">1</xsl:if>
			<xsl:if test="$name='SATAPortAuto'">2</xsl:if>
		</xsl:when>
		<!-- End of Embedded SATA 2 Port -->

		<!-- IDE Primary Drive  -->
		
		<xsl:when test="$type='371'">
			<xsl:if test="$name='IDEPriOff'">1</xsl:if>
			<xsl:if test="$name='IDEPriAuto'">2</xsl:if>
		</xsl:when>
		<!-- End of IDE Primary Drive -->


		<!-- Start of DBS  -->
		<xsl:when test="$type='372'">
			<xsl:if test="$name='DBSDisabled'">1</xsl:if>
			<xsl:if test="$name='DBSEnabled'">2</xsl:if>
		</xsl:when>
		<!-- End of DBS -->

		<!-- Console Redirection FailSafe BAUD Rate -->
		
		<xsl:when test="$type='271'">
			<xsl:if test="$name='FBR115200'">1</xsl:if>
			<xsl:if test="$name='FBR57600'">2</xsl:if>
			<xsl:if test="$name='FBR19200'">3</xsl:if>
			<xsl:if test="$name='FBR9600'">4</xsl:if>
		</xsl:when>
		<!-- End  of Console Redirection FailSafe BAUD Rate -->
		
		<!-- Console Redirection After Boot(CRAB) -->
		<xsl:when test="$type='374'">
			<xsl:if test="$name='Enable'">1</xsl:if>
			<xsl:if test="$name='Disable'">2</xsl:if>
		</xsl:when>
		<!-- Console Redirection After Boot(CRAB) -->
		
		<!-- User Accessible USB Ports -->
		<xsl:when test="$type='375'">
			<xsl:if test="$name='AllOff'">1</xsl:if>
			<xsl:if test="$name='BackOnly'">2</xsl:if>
			<xsl:if test="$name='AllOn'">3</xsl:if>
		</xsl:when>
		<!-- User Accessible USB Ports -->
		
		<!-- Serial Communication -->
		<xsl:when test="$type='378'">
			<xsl:if test="$name='Off'">1</xsl:if>
			<xsl:if test="$name='OnWithoutCR'">2</xsl:if>
			<xsl:if test="$name='OnCRCom1'">3</xsl:if>
			<xsl:if test="$name='OnCRCom2'">4</xsl:if>
		</xsl:when>
		<!-- Serial Communication -->
		
		<!-- External Serial Connector -->
		<xsl:when test="$type='379'">
      <xsl:if test="$name='Com1'">3</xsl:if>
      <xsl:if test="$name='Com2'">4</xsl:if>
      <xsl:if test="$name='RAC'">9</xsl:if>
		</xsl:when>
		<!-- External Serial Connector -->

		<!-- CPU HyperThreading -->
		<xsl:when test="$type='381'">
			<xsl:if test="$name='Disable'">2</xsl:if>
			<xsl:if test="$name='Enable'">1</xsl:if>
		</xsl:when>
		<!-- CPU HyperThreading -->

		<xsl:when test="$type='456'">
			<xsl:if test="$name='Disable'">2</xsl:if>
			<xsl:if test="$name='Enable'">1</xsl:if>
		</xsl:when>
		
		<xsl:otherwise>
			<xsl:if test="$name='Disable'">1</xsl:if>
			<xsl:if test="$name='Enable'">2</xsl:if>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="smstatus">
		<xsl:param name="status"/>
		<xsl:param name="mssg"/>
		<xsl:choose>
			<xsl:when test="$status = '-1'"><xsl:value-of select="$strCommandUnsuccessful"/></xsl:when>
			<xsl:when test="$status = '1'"><xsl:value-of select="$strCommandNotImplemented"/></xsl:when>
			<xsl:when test="$status = '2'"><xsl:value-of select="$strBadCommand"/></xsl:when>
			<xsl:when test="$status = '3'"><xsl:value-of select="$strCommandTimeout"/></xsl:when>
			<xsl:when test="$status = '4'"><xsl:value-of select="$strCommandCancelled"/></xsl:when>
			<xsl:when test="$status = '5'"><xsl:value-of select="$strCommandAborted"/></xsl:when>
			<xsl:when test="$status = '6'"><xsl:value-of select="$strCommandPending"/></xsl:when>
			<xsl:when test="$status = '7'"><xsl:value-of select="$strNoSuchDevice"/></xsl:when>
			<xsl:when test="$status = '8'"><xsl:value-of select="$strDeviceBusy"/></xsl:when>
			<xsl:when test="$status = '9'"><xsl:value-of select="$strBadDevice"/></xsl:when>
			<xsl:when test="$status = '10'"><xsl:value-of select="$strSpuriousInterrupt"/></xsl:when>
			<xsl:when test="$status = '11'"><xsl:value-of select="$strResourceLocked"/></xsl:when>
			<xsl:when test="$status = '12'"><xsl:value-of select="$strInvalidIndex"/></xsl:when>
			<xsl:when test="$status = '13'"><xsl:value-of select="$strSMBError"/></xsl:when>
			<xsl:when test="$status = '14'"><xsl:value-of select="$strDataRequestedIs"/></xsl:when>
			<xsl:when test="$status = '15'"><xsl:value-of select="$strDataRequestedIs1"/></xsl:when>
			<xsl:when test="$status = '16'"><xsl:value-of select="$strDataRequestedIs2"/></xsl:when>
			<xsl:when test="$status = '17'"><xsl:value-of select="$strDeviceNotYet"/></xsl:when>
			<xsl:when test="$status = '18'"><xsl:value-of select="$strDeviceDoesNot"/></xsl:when>
			<xsl:when test="$status = '19'"><xsl:value-of select="$strDeviceOutOf"/></xsl:when>
			<xsl:when test="$status = '20'"><xsl:value-of select="$strDeviceAlreadyExists"/></xsl:when>
			<xsl:when test="$status = '256'"><xsl:value-of select="$strBIOSSetupObject"/></xsl:when>
			<xsl:when test="$status = '257'"><xsl:value-of select="$strBIOSSetupObject1"/></xsl:when>
			<xsl:when test="$status = '258'"><xsl:value-of select="$strBIOSSetupObject2"/></xsl:when>
			<xsl:when test="$status = '260'"><xsl:value-of select="$strINIFileNot"/></xsl:when>
			<xsl:when test="$status = '261'"><xsl:value-of select="$strINIMalformedCorrupt"/></xsl:when>
			<xsl:when test="$status = '262'"><xsl:value-of select="$strINISectionDoes"/></xsl:when>
			<xsl:when test="$status = '263'"><xsl:value-of select="$strINIKeyDoes"/></xsl:when>
			<xsl:when test="$status = '264'"><xsl:value-of select="$strINIValueMalformed"/></xsl:when>
			<xsl:when test="$status = '270'"><xsl:value-of select="$strInsufficientAccessRights"/></xsl:when>
			<xsl:when test="$status = '271'"><xsl:value-of select="$strInvalidParameterName"/><xsl:value-of select="$mssg"/></xsl:when>
			<xsl:when test="$status = '272'"><xsl:value-of select="$strOutOfMemory"/></xsl:when>
			<xsl:when test="$status = '280'"><xsl:value-of select="$strXMLFileNot"/></xsl:when>
			<xsl:when test="$status = '281'"><xsl:value-of select="$strXMLMalformedCorrupt"/></xsl:when>
			<xsl:when test="$status = '282'"><xsl:value-of select="$strXMLNodeDoes"/></xsl:when>
			<xsl:when test="$status = '283'"><xsl:value-of select="$strXMLValueMalformed"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$strSMStatus"/><xsl:value-of select="$status"/></xsl:otherwise>
		</xsl:choose>
</xsl:template>

<xsl:template match="*"/>

</xsl:stylesheet>
