<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:strip-space elements="*"/>
<xsl:template match="*"/>
<xsl:template match="/OMA">
	<xsl:choose>
		<xsl:when test="WatchDog/State='2' and SMStatus='0'"><xsl:call-template name="show_OS_WDT_message"/></xsl:when>
		<xsl:otherwise>
			<xsl:choose>
				<xsl:when test="SMStatus='0'"><xsl:call-template name="success"/></xsl:when>
				<xsl:otherwise><xsl:call-template name="failure"/></xsl:otherwise>
			</xsl:choose>			
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="failure">
	<DataArea exportdata="false">
		<PageTitle>
			<xsl:attribute name="display"><xsl:value-of select="$strAutoRecovery"/></xsl:attribute>
		</PageTitle>
		<TableData>
			<Header>
				<Data name="">
					<xsl:attribute name="display"><xsl:value-of select="$strError"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strError1"/></xsl:attribute>
				</Data>
			</Header>
			<Row>
				<Data name="" ><xsl:attribute name="display"><xsl:value-of select="$str"/></xsl:attribute>
					<xsl:attribute name="value">
						<xsl:call-template name="smstatus">
							<xsl:with-param name="status"><xsl:value-of select="SMStatus"/></xsl:with-param>
						</xsl:call-template>
					</xsl:attribute>
				</Data>
			</Row>
		</TableData>
	</DataArea>
</xsl:template>

<xsl:template name="show_OS_WDT_message">
	<DataArea>
		<CustomButton>
			<Data name="Refresh">
				<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
				<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.WatchdogWebPlugin&amp;help=AutoRecovery</xsl:attribute>
			</Data>
		</CustomButton>
		<PageTitle>
			<xsl:attribute name="display"><xsl:value-of select="$strAutoRecovery1"/></xsl:attribute>
		</PageTitle>
		<PromptText>
			<xsl:value-of select="$strBMCDisabled"/>
		</PromptText>

	</DataArea>
</xsl:template>


<xsl:template name="success">
	<xsl:choose>
		<xsl:when test="@cli='true'"><xsl:call-template name="cli"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="web"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="web">
	<xsl:choose>
		<xsl:when test="OMAUserRights='7'"><xsl:call-template name="edit"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="view"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="edit">
		<DataArea exportdata="false">
			<xsl:if test="/OMA/WatchDog/TimerCapabilities = '1' or /OMA/WatchDog/TimerCapabilities='2' or /OMA/WatchDog/TimerCapabilities='4'or /OMA/WatchDog/TimerCapabilities='8'">
				<xsl:attribute name="onLoad">true</xsl:attribute>
			</xsl:if>
			<xsl:if test="/OMA/WatchDog/TimerCapabilities = '1' or /OMA/WatchDog/TimerCapabilities='2' or /OMA/WatchDog/TimerCapabilities='4' or /OMA/WatchDog/TimerCapabilities='8'">
				<xsl:attribute name="validate">true</xsl:attribute>
			</xsl:if>
			<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.hip.webplugins.SetWatchdogWebPlugin&amp;oid=<xsl:value-of select="WatchDog/@oid"/></xsl:attribute>
			<CustomButton>
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.WatchdogWebPlugin&amp;help=AutoRecovery</xsl:attribute>
				</Data>
			</CustomButton>
		<PageTitle>
			<xsl:attribute name="display"><xsl:value-of select="$strAutoRecovery1"/></xsl:attribute>
		</PageTitle>
			<TableData name="HungServer">
				<xsl:attribute name="display"><xsl:value-of select="$strActionOnHung"/></xsl:attribute>
				<Header>
					<Data name="">
						<xsl:attribute name="display"><xsl:value-of select="$strActionOnHung1"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strActionOnHung2"/></xsl:attribute>
					</Data>
				</Header>
				<xsl:call-template name="edit1"/>
			</TableData>
			
			<xsl:if test="/OMA/WatchDog/TimerCapabilities = '1' or /OMA/WatchDog/TimerCapabilities='2' or /OMA/WatchDog/TimerCapabilities='4' or /OMA/WatchDog/TimerCapabilities='8'">
				<TableData name="SystemTimer">
					<xsl:attribute name="display"><xsl:value-of select="$strSystemResetTimer"/></xsl:attribute>
					<Header>
						<Data name="">
							<xsl:attribute name="display"><xsl:value-of select="$strSystemResetTimer1"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strSystemResetTimer2"/></xsl:attribute>
						</Data>
					</Header>
					<xsl:call-template name="edit2"/>
				</TableData>
			</xsl:if>
		</DataArea>
</xsl:template>
<xsl:template name="edit1">
	<Row>
		<Data name="action1" returnvalue="0" type="radio">
			<xsl:attribute name="value"><xsl:value-of select="$strNone"/></xsl:attribute>
			<xsl:attribute name="state"><xsl:call-template name="noneselect1"/></xsl:attribute>
		</Data>
	</Row>
	<xsl:if test="/OMA/WatchDog/Capabilities/Reboot='true'">
		<Row>	
			<Data type="radio">
				<xsl:attribute name="name">action1</xsl:attribute>
				<xsl:attribute name="returnvalue">1</xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strRebootSystem"/></xsl:attribute>
				<xsl:attribute name="state"><xsl:call-template name="rebootselect1"/></xsl:attribute>
			</Data>
		</Row>
	</xsl:if>	
	<xsl:if test="/OMA/WatchDog/Capabilities/PwrOff='true'">
		<Row>	
			<Data type="radio">
				<xsl:attribute name="name">action1</xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strPowerOffSystem"/></xsl:attribute>
				<xsl:attribute name="returnvalue">2</xsl:attribute>
				<xsl:attribute name="state"><xsl:call-template name="poweroffselect1"/></xsl:attribute>
			</Data>
		</Row>
	</xsl:if>	
	<xsl:if test="/OMA/WatchDog/Capabilities/PwrCycle='true'">
		<Row>	
			<Data type="radio">
				<xsl:attribute name="name">action1</xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strPowerCycleSystem"/></xsl:attribute>
				<xsl:attribute name="returnvalue">4</xsl:attribute>
				<xsl:attribute name="state"><xsl:call-template name="powercycleselect1"/></xsl:attribute>
			</Data>
		</Row>
	</xsl:if>
</xsl:template>


<xsl:template name="noneselect1">
<xsl:variable name="setting" select="/OMA/WatchDog/Settings/Reboot"/>
<xsl:variable name="setting1" select="/OMA/WatchDog/Settings/PwrOff"/>
<xsl:variable name="setting2" select="/OMA/WatchDog/Settings/PwrCycle"/>
	<xsl:choose>
		<xsl:when test="$setting='false'">
			<xsl:choose>
				<xsl:when test="$setting1='false'">
					<xsl:choose>
						<xsl:when test="$setting2='false'">1</xsl:when>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>
		</xsl:when>		
	</xsl:choose>
</xsl:template>


<xsl:template name="rebootselect1">
<xsl:variable name="setting" select="/OMA/WatchDog/Settings/Reboot"/>
	<xsl:if test="$setting='true'">1</xsl:if>
</xsl:template>

<xsl:template name="poweroffselect1">
<xsl:variable name="setting" select="/OMA/WatchDog/Settings/PwrOff"/>
	<xsl:if test="$setting='true'">1</xsl:if>
</xsl:template>

<xsl:template name="powercycleselect1">
<xsl:variable name="setting" select="/OMA/WatchDog/Settings/PwrCycle"/>
	<xsl:if test="$setting='true'">1</xsl:if>
</xsl:template>

<xsl:template name="edit2">
	
		<xsl:variable name="timer" select="/OMA/WatchDog/TimerCapabilities"/>
			<xsl:choose>
				<xsl:when test=" $timer='1' or $timer='8'  ">				
					<Row>
						<Data name="timer" type="editbox" align="left" size="10" maxlength="255"><xsl:attribute name="display"><xsl:value-of select="$str1"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="/OMA/WatchDog/ExpiryTime"/></xsl:attribute>
						</Data>
					</Row>
					
									
					<script language="javascript">
							var timerval ;
							var lastval;
							var maxval;
							var minval;
							var timernum;
							
							function initializationRoutine (){
								document.getElementById("timer").value = "";
								document.getElementById("timer").value = "<xsl:value-of select="/OMA/WatchDog/ExpiryTime"/>";
								document.getElementById("timer").disabled = false;
							}
							
							function tonum(obj){
     								 return parseInt(obj);
   						       }
   						       
                            function trimLeadingZero( str )
                            {
                                var numStr;
								
				                for ( var charId = 0; charId &lt; str.length; charId++ )
				                {
					                if ( str.charAt( charId ) != '0')
					                {
					                    break;
					                }
				                }
				                numStr = str.substring(charId); 
				                return numStr;
   						    }

							function isNotWholeNumber( str )
							{   
								var isNotWholeNum = false;
								var numStr =  str;
								var validValues="0123456789";

				                for ( var charId=0; charId &lt; numStr.length; charId++ )
				                {
					                if ( validValues.indexOf( numStr.charAt( charId ) ) &lt; 0 )
					                {
						                isNotWholeNum = true;
						                break;
					                }
				                }
								return isNotWholeNum;
							}

							function validate(){
							
								timerval0 = document.dataarea.timer.value;
								lastval = <xsl:value-of select="/OMA/WatchDog/ExpiryTime"/>;
								<xsl:choose>
									<xsl:when test="$timer='1'">				
										minval = 60;
									</xsl:when>
									<xsl:when test="$timer='8'">				
										minval = 60;
									</xsl:when>
								</xsl:choose>
								maxval = 480;
								timerval = trimLeadingZero( timerval0 );
								
								if (document.dataarea.timer.value== "" ){
									alert("<xsl:value-of select="$strPleaseSpecifySystem"/>");
									document.dataarea.timer.value = lastval;
									document.dataarea.timer.focus();
								}
								else
								{
									if(isNotWholeNumber(timerval) == true)
									{
										alert("<xsl:value-of select="$strSystemResetTimer3"/>");
										document.dataarea.timer.value = lastval;
										document.dataarea.timer.focus();
									}
									else
									{
									    if(!((tonum(timerval) &gt;= minval)&amp;&amp;(tonum(timerval) &lt;= maxval)))
                                        {
										      alert(<xsl:value-of select="$strSystemResetTimer4"/>);
										      document.dataarea.timer.value = lastval;
										      document.dataarea.timer.focus();
										}
									    else 
									    {
											 document.dataarea.timer.value = tonum(timerval);
										     return true;
									    }
									}
									return false;
								}
								return false;	
							}								
						</script>
				</xsl:when>
				
				<xsl:when test="$timer='2'">
					
					<Row>
						<Data type="spincontrol" state="2" size="10">
							<xsl:attribute name="name">timer2</xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="/OMA/WatchDog/ExpiryTime"/></xsl:attribute>
							<xsl:attribute name="uparrscript"><xsl:call-template name="script21"/></xsl:attribute>
							<xsl:attribute name="downarrscript"><xsl:call-template name="script22"/></xsl:attribute>
						</Data>
						<Data  display=" "  type="hidden" state="" align="left">
							<xsl:attribute name="name">timer</xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="/OMA/WatchDog/ExpiryTime"/></xsl:attribute>
						</Data>
					</Row>

					<script language="javascript">
								var lastobj;
								var curobj;
								var lastobj1;
								var curobj1;
								
								function initializationRoutine (){
									document.getElementById("timer2").disabled = false;
									document.getElementById("timer2").value = "";
									document.getElementById("timer2").focus();
									document.getElementById("timer2").value = "<xsl:value-of select="/OMA/WatchDog/ExpiryTime"/>";
									document.getElementById("timer2").disabled = true;
								}
					
								function validate()
								{
									return true;
								}
								function tonum(obj){
     									 return parseInt(obj);
   								 }
								function getvalue2(){
									lastobj = tonum(document.dataarea.timer2.value);
									return lastobj;
								}
								function getvalue21(){
									lastobj1 = tonum(document.dataarea.timer.value);
									return lastobj1;
								}

								function incr2(x , y , z){
									curobj=getvalue2();
									curobj1=getvalue21();

									if ( curobj == 0 ){
										curobj = curobj + x;
									}
									else if ( curobj &lt; 120 ){
										curobj = curobj*z;
									}
									else{
										curobj = curobj*2*z;
									}
		
									if ( y &gt;= curobj ){
										document.dataarea.timer2.value = curobj;
									}
									else{
									document.dataarea.timer2.value = y;
									}
									
									if ( curobj1 == 0 ){
										curobj1 = curobj1 + x;
									}
									else if ( curobj1 &lt; 120 ){
										curobj1= curobj1*z;
									}
									else{
										curobj1 = curobj1*2*z;
									}
		
									if ( y &gt;= curobj1 ){
										document.dataarea.timer.value = curobj1;
									}
									else{
									document.dataarea.timer.value = y;
									}
									return ;	
								}
								function decr2(y , z)	{
		
									curobj=getvalue2();
									curobj1=getvalue21();

									if ( curobj == 480 ){
										curobj = curobj/(2*z);
									}
									else if ( curobj &lt;=120 ){
										curobj = curobj/z;
									}
		
		
									if ( y &lt;= curobj ){
										document.dataarea.timer2.value = curobj;
									}
									else{
									document.dataarea.timer2.value = y;
									}
									
									if ( curobj1 == 480 ){
										curobj1 = curobj1/(2*z);
									}
									else if ( curobj1 &lt;=120 ){
										curobj1 = curobj1/z;
									}
		
		
									if ( y &lt;= curobj1 ){
										document.dataarea.timer.value = curobj1;
									}
									else{
									document.dataarea.timer.value = y;
									}
									return ;	
								}	
						</script>
				</xsl:when>
				
				<xsl:when test="$timer='4'">
					
					
					<Row>
						<Data type="spincontrol" state="2" size="10">
							<xsl:attribute name="name">timer3</xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="/OMA/WatchDog/ExpiryTime"/></xsl:attribute>
							<xsl:attribute name="uparrscript"><xsl:call-template name="script31"/></xsl:attribute>
							<xsl:attribute name="downarrscript"><xsl:call-template name="script32"/></xsl:attribute>
						</Data>
						<Data  display=" "  type="hidden" state="" align="left">
							<xsl:attribute name="name">timer</xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="/OMA/WatchDog/ExpiryTime"/></xsl:attribute>
						</Data>
					</Row>

					<script language="javascript">
								var lastobj;
								var curobj;
								var lastobj1;
								var curobj1;
								
								function initializationRoutine (){
									document.getElementById("timer3").disabled = false;
									document.getElementById("timer3").value = "";
									document.getElementById("timer3").focus();
									document.getElementById("timer3").value = "<xsl:value-of select="/OMA/WatchDog/ExpiryTime"/>";
									document.getElementById("timer3").disabled = true;
								}
								
								function validate()
								{
									return true;
								}
								function tonum(obj){
     									 return parseInt(obj);
   								 }
								function getvalue3(){
									lastobj = tonum(document.dataarea.timer3.value);
									return lastobj;
								}
								function getvalue31(){
									lastobj1 = tonum(document.dataarea.timer.value);
									return lastobj1;
								}

								function incr3(x , y){
		
									curobj=getvalue3();
									curobj1=getvalue31();

									curobj = curobj+x;
									if ( y &gt;= curobj ){
										document.dataarea.timer3.value = curobj;
									}
									else{
										document.dataarea.timer3.value = y;
									}
									
									curobj1 = curobj1+x;
									if ( y &gt;= curobj1 ){
										document.dataarea.timer.value = curobj1;
									}
									else{
										document.dataarea.timer.value = y;
									}
									return ;	
								}
								function decr3(x , y)	{
		
									curobj=getvalue3();
									curobj1=getvalue31();

									curobj = curobj-x;
									if ( y &lt;= curobj ){
										document.dataarea.timer3.value = curobj;
									}
									else{
										document.dataarea.timer3.value = y;
									}
									
									curobj1 = curobj1-x;
									if ( y &lt;= curobj1 ){
										document.dataarea.timer.value = curobj1;
									}
									else{
										document.dataarea.timer.value = y;
									}
									return ;	
								}	
						</script>
				</xsl:when>



			</xsl:choose>	
</xsl:template>

<xsl:template name="script11">javascript:incr1(1,480)</xsl:template>
<xsl:template name="script12">javascript:decr1(1,20)</xsl:template>

<xsl:template name="script21">javascript:incr2(60,480,2)</xsl:template>
<xsl:template name="script22">javascript:decr2(60,2)</xsl:template>

<xsl:template name="script31">javascript:incr3(60,480)</xsl:template>
<xsl:template name="script32">javascript:decr3(60,60)</xsl:template>

<xsl:template name="view">
	<DataArea exportdata="false">
		<PageTitle>
			<xsl:attribute name="display"><xsl:value-of select="$strAutoRecovery2"/></xsl:attribute>
		</PageTitle>
		<TableData name="HungServer">
			<xsl:attribute name="display"><xsl:value-of select="$strActionOnHung3"/></xsl:attribute>
			<Header>
				<Data name="">
					<xsl:attribute name="display"><xsl:value-of select="$strActionOnHung4"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strActionOnHung5"/></xsl:attribute>
				</Data>
			</Header>
			<xsl:call-template name="view1"/>
		</TableData>
		<TableData name="SystemTimer">
			<xsl:attribute name="display"><xsl:value-of select="$strSystemResetTimer5"/></xsl:attribute>
			<Header>
				<Data name="">
					<xsl:attribute name="display"><xsl:value-of select="$strSystemResetTimer6"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strSystemResetTimer7"/></xsl:attribute>
				</Data>
			</Header>
			<xsl:call-template name="view2"/>				
		</TableData>
	</DataArea>
</xsl:template>

<xsl:template name="view1">
	<Row>
		<Data name="None" returnvalue="0" type="radio">
			<xsl:attribute name="value"><xsl:value-of select="$strNone1"/></xsl:attribute>
			<xsl:attribute name="state"><xsl:call-template name="noneselect"/></xsl:attribute>
		</Data>
	</Row>	
	<xsl:if test="/OMA/WatchDog/Capabilities/Reboot='true'">
		<Row>	
			<Data type="radio">
				<xsl:attribute name="name">Reboot</xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strRebootSystem1"/></xsl:attribute>
				<xsl:attribute name="returnvalue">1</xsl:attribute>
				<xsl:attribute name="state"><xsl:call-template name="rebootselect"/></xsl:attribute>
			</Data>
		</Row>
	</xsl:if>
	<xsl:if test="/OMA/WatchDog/Capabilities/PwrOff='true'">
		<Row>	
			<Data type="radio">
				<xsl:attribute name="name">PowerOff</xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strPowerOffSystem1"/></xsl:attribute>
				<xsl:attribute name="returnvalue">2</xsl:attribute>
				<xsl:attribute name="state"><xsl:call-template name="poweroffselect"/></xsl:attribute>
			</Data>
		</Row>
	</xsl:if>		
	<xsl:if test="/OMA/WatchDog/Capabilities/PwrCycle='true'">
		<Row>	
			<Data type="radio">
				<xsl:attribute name="name">PowerCycle</xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strPowerCycleSystem1"/></xsl:attribute>
				<xsl:attribute name="returnvalue">4</xsl:attribute>
				<xsl:attribute name="state"><xsl:call-template name="powercycleselect"/></xsl:attribute>
			</Data>
		</Row>
	</xsl:if>
</xsl:template>

<xsl:template name="noneselect">
	<xsl:variable name="setting" select="/OMA/WatchDog/Settings/Reboot"/>
	<xsl:variable name="setting1" select="/OMA/WatchDog/Settings/PwrOff"/>
	<xsl:variable name="setting2" select="/OMA/WatchDog/Settings/PwrCycle"/>
	<xsl:choose>
		<xsl:when test="$setting='false'">
			<xsl:choose>
				<xsl:when test="$setting1='false'">
					<xsl:choose>
						<xsl:when test="$setting2='false'">3</xsl:when>
						<xsl:otherwise>2</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>2</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:otherwise>2</xsl:otherwise>		
	</xsl:choose>
</xsl:template>

<xsl:template name="rebootselect">
<xsl:variable name="setting" select="/OMA/WatchDog/Settings/Reboot"/>
	<xsl:choose>
		<xsl:when test="$setting='true'">3</xsl:when>
		<xsl:otherwise>2</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="poweroffselect">
<xsl:variable name="setting" select="/OMA/WatchDog/Settings/PwrOff"/>
	<xsl:choose>
		<xsl:when test="$setting='true'">3</xsl:when>
		<xsl:otherwise>2</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="powercycleselect">
<xsl:variable name="setting" select="/OMA/WatchDog/Settings/PwrCycle"/>
	<xsl:choose>
		<xsl:when test="$setting='true'">3</xsl:when>
		<xsl:otherwise>2</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="view2">
	<Row>
		<Data name="" ><xsl:attribute name="display"><xsl:value-of select="$str2"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="/OMA/WatchDog/ExpiryTime"/><xsl:value-of select="$strSeconds"/></xsl:attribute>
		</Data>
	</Row>		
</xsl:template>

<xsl:template name="cli">
	<DataArea>
		<PageTitle>
			<xsl:attribute name="display"><xsl:value-of select="$strAutoRecovery3"/></xsl:attribute>
		</PageTitle>
		<ListData>
			<xsl:choose>
				<xsl:when test="/OMA/WatchDog/Settings/Reboot='false'">
					<xsl:choose>
						<xsl:when test="/OMA/WatchDog/Settings/PwrOff='false'">
							<xsl:choose>
								<xsl:when test="/OMA/WatchDog/Settings/PwrCycle='false'">
									<Data value="None">
										<xsl:attribute name="display"><xsl:value-of select="$strActionOnHung6"/></xsl:attribute>
									</Data>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="cliotherwise"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="cliotherwise"/>
						</xsl:otherwise>
					</xsl:choose>			
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="cliotherwise"/>				
				</xsl:otherwise>
			</xsl:choose>
			<xsl:call-template name="clitimer"/>
		</ListData>
	</DataArea>
</xsl:template>


<xsl:template name="cliotherwise">
		<xsl:for-each select="/OMA/WatchDog/Capabilities/*">
			<xsl:if test=".='true'">
				<xsl:call-template name="cliotherwise1">
					<xsl:with-param name="name1"><xsl:value-of select="name()"/></xsl:with-param>
				</xsl:call-template>
			</xsl:if>	
		</xsl:for-each>
</xsl:template>

<xsl:template name="cliotherwise1">
	<xsl:param name="name1"/>
	<xsl:for-each select="/OMA/WatchDog/Settings/*">
		<xsl:if test="$name1=name()">
			<xsl:if test=".='true'">
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strActionOnHung7"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$name1"/></xsl:attribute>
				</Data>
			</xsl:if>
		</xsl:if>
	</xsl:for-each>
</xsl:template>

<xsl:template name="clitimer">
	<Data>
		<xsl:attribute name="display"><xsl:value-of select="$strSystemResetTimer8"/></xsl:attribute>
		<xsl:attribute name="value"><xsl:value-of select="/OMA/WatchDog/ExpiryTime"/><xsl:text disable-output-escaping="yes">  </xsl:text><xsl:value-of select="/OMA/WatchDog/ExpiryTime/@unit"/></xsl:attribute>
	</Data>
</xsl:template>	

<xsl:template name="smstatus">
		<xsl:param name="status"/>
		<xsl:param name="mssg"/>
		<xsl:choose>
			<xsl:when test="$status = '-1'"><xsl:value-of select="$strCommandUnsuccessful"/></xsl:when>
			<xsl:when test="$status = '1'"><xsl:value-of select="$strCommandNotImplemented"/></xsl:when>
			<xsl:when test="$status = '2'"><xsl:value-of select="$strBadCommand"/></xsl:when>
			<xsl:when test="$status = '3'"><xsl:value-of select="$strCommandTimeout"/></xsl:when>
			<xsl:when test="$status = '4'"><xsl:value-of select="$strCommandCancelled"/></xsl:when>
			<xsl:when test="$status = '5'"><xsl:value-of select="$strCommandAborted"/></xsl:when>
			<xsl:when test="$status = '6'"><xsl:value-of select="$strCommandPending"/></xsl:when>
			<xsl:when test="$status = '7'"><xsl:value-of select="$strNoSuchDevice"/></xsl:when>
			<xsl:when test="$status = '8'"><xsl:value-of select="$strDeviceBusy"/></xsl:when>
			<xsl:when test="$status = '9'"><xsl:value-of select="$strBadDevice"/></xsl:when>
			<xsl:when test="$status = '10'"><xsl:value-of select="$strSpuriousInterrupt"/></xsl:when>
			<xsl:when test="$status = '11'"><xsl:value-of select="$strResourceLocked"/></xsl:when>
			<xsl:when test="$status = '12'"><xsl:value-of select="$strInvalidIndex"/></xsl:when>
			<xsl:when test="$status = '13'"><xsl:value-of select="$strSMBError"/></xsl:when>
			<xsl:when test="$status = '14'"><xsl:value-of select="$strDataRequestedIs"/></xsl:when>
			<xsl:when test="$status = '15'"><xsl:value-of select="$strDataRequestedIs1"/></xsl:when>
			<xsl:when test="$status = '16'"><xsl:value-of select="$strDataRequestedIs2"/></xsl:when>
			<xsl:when test="$status = '17'"><xsl:value-of select="$strDeviceNotYet"/></xsl:when>
			<xsl:when test="$status = '18'"><xsl:value-of select="$strDeviceDoesNot"/></xsl:when>
			<xsl:when test="$status = '19'"><xsl:value-of select="$strDeviceOutOf"/></xsl:when>
			<xsl:when test="$status = '20'"><xsl:value-of select="$strDeviceAlreadyExists"/></xsl:when>
			<xsl:when test="$status = '256'"><xsl:value-of select="$strRecoveryObjectNot"/></xsl:when>
			<xsl:when test="$status = '257'"><xsl:value-of select="$strRecoveryObjectMalformed"/></xsl:when>
			<xsl:when test="$status = '258'"><xsl:value-of select="$strRecoveryObjectAlready"/></xsl:when>
			<xsl:when test="$status = '260'"><xsl:value-of select="$strINIFileNot"/></xsl:when>
			<xsl:when test="$status = '261'"><xsl:value-of select="$strINIMalformedCorrupt"/></xsl:when>
			<xsl:when test="$status = '262'"><xsl:value-of select="$strINISectionDoes"/></xsl:when>
			<xsl:when test="$status = '263'"><xsl:value-of select="$strINIKeyDoes"/></xsl:when>
			<xsl:when test="$status = '264'"><xsl:value-of select="$strINIValueMalformed"/></xsl:when>
			<xsl:when test="$status = '270'"><xsl:value-of select="$strInsufficientAccessRights"/></xsl:when>
			<xsl:when test="$status = '271'"><xsl:value-of select="$strInvalidParameterName"/><xsl:value-of select="$mssg"/></xsl:when>
			<xsl:when test="$status = '272'"><xsl:value-of select="$strOutOfMemory"/></xsl:when>
			<xsl:when test="$status = '280'"><xsl:value-of select="$strXMLFileNot"/></xsl:when>
			<xsl:when test="$status = '281'"><xsl:value-of select="$strXMLMalformedCorrupt"/></xsl:when>
			<xsl:when test="$status = '282'"><xsl:value-of select="$strXMLNodeDoes"/></xsl:when>
			<xsl:when test="$status = '283'"><xsl:value-of select="$strXMLValueMalformed"/></xsl:when>
			<xsl:otherwise>SMStatus: <xsl:value-of select="$status"/></xsl:otherwise>
		</xsl:choose>
</xsl:template>
	
</xsl:stylesheet>
