<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:output method="xml" omit-xml-declaration="yes"/>
	<xsl:strip-space elements="*"/>
    <xsl:variable name="IsCLICmdNew">
      <xsl:choose>
        <xsl:when test="/OMA/OMACMDNEW='0'">false</xsl:when>
        <xsl:otherwise>true</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="IsBlade">
	    <xsl:choose>
	      <xsl:when test="/OMA/ChassisSummary/ChassisList/Chassis/ChassisInfo/ChassisProps1/ChassType='25'">true</xsl:when>
	      <xsl:otherwise>false</xsl:otherwise>
	    </xsl:choose>
	  </xsl:variable>
  <xsl:template match="/OMA">
		<Summary>
			<xsl:apply-templates/>
		</Summary>
	</xsl:template>

  <xsl:template match="ChassisSummary">
    <xsl:apply-templates/>
  </xsl:template>
  
	<xsl:template match="System">
   	 <xsl:if test="$IsCLICmdNew='false' or ($IsCLICmdNew='true' and $IsBlade='false')">
		<Section name="System">
			<xsl:attribute name="display"><xsl:value-of select="$strSystem"/></xsl:attribute>
			<ListData name="system">
				<xsl:attribute name="display"><xsl:value-of select="$strSystem1"/></xsl:attribute>
				<Data name="HostName">
					<xsl:attribute name="display"><xsl:value-of select="$strHostName"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="HostName"/></xsl:attribute>
				</Data>
				<Data name="SystemLocation">
					<xsl:attribute name="display"><xsl:value-of select="$strSystemLocation"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="SystemInfo/SystemLocation"/></xsl:attribute>
				</Data>
			</ListData>
		</Section>
		</xsl:if>
  </xsl:template>
	<xsl:template match="ChassisList">
			<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="Chassis">
		<Section>
			<xsl:attribute name="name">chassis_<xsl:value-of select="@index" /></xsl:attribute>
			<xsl:attribute name="display">
          	<xsl:choose>
              <xsl:when test="@display = 'Main System Chassis'">
							<xsl:choose>
                <xsl:when test="$IsCLICmdNew='false' or ($IsCLICmdNew='true' and $IsBlade='false')">
                  <xsl:value-of select="$strMainSystemChassis"/>
                </xsl:when>
								<xsl:otherwise><xsl:value-of select="$strBladeModule" /></xsl:otherwise>
							</xsl:choose>
              </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="@display"/>
                </xsl:otherwise>
              </xsl:choose>
            
			</xsl:attribute>

			<xsl:apply-templates select="ChassisInfo" />
			<xsl:apply-templates select="Hardware" />
		</Section>
		<xsl:apply-templates select="Network" />
		<xsl:apply-templates select="Software" />
	</xsl:template>
	<xsl:template match="ChassisInfo">
   
				<ListData name="ChassisInformation">
					<xsl:choose>
						<xsl:when test="$IsCLICmdNew='true' and $IsBlade='true'">
							<xsl:attribute name="display"><xsl:value-of select="$strInformation"/>
							</xsl:attribute></xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="display"><xsl:value-of select="$strChassisInformation"/>
							</xsl:attribute>
						</xsl:otherwise>
				</xsl:choose>
				<xsl:if test="$IsBlade ='true' and $IsCLICmdNew='true'">
				<Data name="HostName">
					<xsl:attribute name="display"><xsl:value-of select="$strHostName"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="/OMA/ChassisSummary/System/HostName"/></xsl:attribute>
				</Data>
				<Data name="SystemLocation">
					<xsl:attribute name="display"><xsl:value-of select="$strSystemLocation"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="/OMA/ChassisSummary/System/SystemInfo/SystemLocation"/></xsl:attribute>
				</Data>
				<Data name="Model">
					<xsl:attribute name="display"><xsl:value-of select="$strModel"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="/OMA/ChassisSummary/ChassisList/Chassis/ChassisInfo/ChassisProps1/ChassModel"/></xsl:attribute>
				</Data>
				<xsl:if test="ChassisProps1/SystemRevision!='0' and ChassisProps1/SystemRevision!='255'">
				<Data name="SystemRevision">
					<xsl:attribute name="display"><xsl:value-of select="$strSystemRevisionName"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="/OMA/ChassisSummary/ChassisList/Chassis/ChassisInfo/ChassisProps1/SystemRevisionName"/></xsl:attribute>
				</Data>
				</xsl:if>
				</xsl:if>

				<xsl:if test="$IsCLICmdNew='false' or ($IsCLICmdNew='true' and $IsBlade='false')">
				<Data name="ChassModel">
					<xsl:attribute name="display"><xsl:value-of select="$strChassisModel"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="ChassisProps1/ChassModel"/></xsl:attribute>
				</Data>
				
				<xsl:if test="ChassisProps1/SystemRevision!='0' and ChassisProps1/SystemRevision!='255'">
				<Data name="SystemRevision">
					<xsl:attribute name="display"><xsl:value-of select="$strSystemRevisionName"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="ChassisProps1/SystemRevisionName"/></xsl:attribute>
				</Data>
				</xsl:if>

				<Data name="ServiceTag">
					<xsl:attribute name="display"><xsl:value-of select="$strChassisServiceTag"/></xsl:attribute>
					<xsl:call-template name="DispChasSrvcTag"/>
				</Data>
				<Data name="ChassLock">
					<xsl:attribute name="display"><xsl:value-of select="$strChassisLock"/></xsl:attribute>
					<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="ChassisProps1/ChassLockPresent = 'true'"><xsl:value-of select="$strPresent"/></xsl:when>
							<xsl:when test="ChassisProps1/ChassLockPresent='false'"><xsl:value-of select="$strAbsent"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$strNoValue"/></xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
				</Data>
				</xsl:if>

				<Data name="AssetTag">
					<xsl:attribute name="display">
					<xsl:choose>
						<xsl:when test="$IsBlade='true' and $IsCLICmdNew='true'"><xsl:value-of select="$strAssetTag"/></xsl:when>
            			<xsl:when test="$IsBlade='true' and $IsCLICmdNew='false'"><xsl:value-of select="$strServerModuleAsset"/></xsl:when>
            			<xsl:otherwise><xsl:value-of select="$strChassisAssetTag"/></xsl:otherwise>
					</xsl:choose>
					</xsl:attribute>
						<xsl:call-template name="DispChasAssetTag"/>
				</Data>
				<xsl:choose>
					<xsl:when test="ChassisProps1/ChassType = '25' ">
						<xsl:call-template name="YellowStone"/>
					</xsl:when>

				</xsl:choose>

				<xsl:if test="ChassisProps1/ChassType = '25' ">
					<xsl:apply-templates select="/OMA/ChassisSummary/BaseBoardList"/>
				</xsl:if>
				</ListData>
	</xsl:template>

	<xsl:template name="YellowStone">
		<xsl:for-each select="/OMA/ChasssisSummary/BaseBoardList/BaseBoard">
			<xsl:choose>
			  <xsl:when test="BaseBoardType = '11'">
				<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strPMMAssetTag"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="AssetTag"/></xsl:attribute>
				</Data>

				<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strPMMserviceTag"/></xsl:attribute>
  			        <xsl:attribute name="value"><xsl:value-of select="ServiceTag"/></xsl:attribute>
				</Data>

				<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strPMMLocation"/></xsl:attribute>
   			        <xsl:attribute name="value"><xsl:value-of select="BoardLocation"/></xsl:attribute>
				</Data>
			 </xsl:when>

			<xsl:when test="BaseBoardType = '12'">
				<Data>
				   <xsl:attribute name="display"><xsl:value-of select="$strIOMAssetTag"/></xsl:attribute>
				   <xsl:attribute name="value"><xsl:value-of select="AssetTag"/></xsl:attribute>
				</Data>

				<Data>
				  <xsl:attribute name="display"><xsl:value-of select="$strIOMserviceTag"/></xsl:attribute>
				  <xsl:attribute name="value"><xsl:value-of select="ServiceTag"/></xsl:attribute>
				 </Data>
				<Data>
				 <xsl:attribute name="display"><xsl:value-of select="$strIOMLocation"/></xsl:attribute>
				 <xsl:attribute name="value"><xsl:value-of select="BoardLocation"/></xsl:attribute>
				</Data>
			</xsl:when>
               	</xsl:choose>
	</xsl:for-each>

	<xsl:for-each select="/OMA/ChasssisSummary/BaseBoardList/BaseBoard[BaseBoardType='2']">
    	   <xsl:choose>
	     <xsl:when test="position() = 1">

		<Data>
			<xsl:attribute name="name">dsmassetag</xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="$strDSM0AssetTag"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="AssetTag"/></xsl:attribute>

		</Data>

		<Data>
			<xsl:attribute name="display"><xsl:value-of select="$strDSM0serviceTag"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="ServiceTag"/></xsl:attribute>
		</Data>

		<Data>
			<xsl:attribute name="display"><xsl:value-of select="$strDSM0Location"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="BoardLocation"/></xsl:attribute>
		</Data>
	    </xsl:when>

	<xsl:when test="position() = 2">

		<Data>
			<xsl:attribute name="name">dsmassetag</xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="$strDSM1AssetTag"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="AssetTag"/></xsl:attribute>

		</Data>

		<Data>
			<xsl:attribute name="display"><xsl:value-of select="$strDSM1serviceTag"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="ServiceTag"/></xsl:attribute>
		</Data>

		<Data>
			<xsl:attribute name="display"><xsl:value-of select="$strDSM1Location"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="BoardLocation"/></xsl:attribute>
		</Data>
	    </xsl:when>

	<xsl:when test="position() = 3">

		<Data>
			<xsl:attribute name="name">dsmassetag</xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="$strDSM2AssetTag"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="AssetTag"/></xsl:attribute>

		</Data>

		<Data>
			<xsl:attribute name="display"><xsl:value-of select="$strDSM2serviceTag"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="ServiceTag"/></xsl:attribute>
		</Data>

		<Data>
			<xsl:attribute name="display"><xsl:value-of select="$strDSM2Location"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="BoardLocation"/></xsl:attribute>
		</Data>
	    </xsl:when>
	</xsl:choose>

	</xsl:for-each>


	</xsl:template>

	<xsl:template name="DispChasSrvcTag">
		<xsl:attribute name="value">
		<!--check for shredder-->
		<xsl:choose>
			<!--Shredder-->
			<xsl:when test="ChassisProps1/ChassType = '25' ">
				<xsl:if test="/OMA/ChassisSummary/BaseBoardList/@count > 0">
					<xsl:for-each select="/OMA/ChassisSummary/BaseBoardList/BaseBoard">
						<xsl:if test="BaseBoardType = '13'">
							<xsl:value-of select="ServiceTag"/>
						</xsl:if>
					</xsl:for-each>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<!--not shredder -->
				<xsl:value-of select="ChassisProps2/ServiceTag"/>
			</xsl:otherwise>
		</xsl:choose>
		</xsl:attribute>
	</xsl:template>

	<xsl:template name="DispChasAssetTag">
		<xsl:attribute name="value"><xsl:value-of select="ChassisProps2/AssetTag"/></xsl:attribute>
	</xsl:template>

	<xsl:template match="BaseBoardList">
		<xsl:for-each select="BaseBoard">
			<xsl:if test="(BaseBoardType!='11') and (BaseBoardType!='2') and (BaseBoardType!='12')and (BaseBoardType!='13')">
        <Data name="BladeServiceTag">
          <xsl:attribute name="display">
            <xsl:choose>
              <xsl:when test="$IsCLICmdNew='true' and $IsBlade='true'"> 
			             <xsl:value-of select="$strServiceTag"/>        
            </xsl:when>
            <xsl:when test="$IsCLICmdNew='false' and $IsBlade='true'">
              <xsl:value-of select="$strServerModuleService"/>
            </xsl:when>
          </xsl:choose>
          </xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="ServiceTag"/></xsl:attribute>
				</Data>

			</xsl:if>
			<xsl:if test="(BaseBoardType!='3') and (BaseBoardType!='11') and (BaseBoardType!='2') and (BaseBoardType!='12')">
				<Data name="BladeLocation" type="ustring">
          <xsl:choose>
            <xsl:when test="$IsCLICmdNew='true' and $IsBlade='true'">
              <xsl:attribute name="display"><xsl:value-of select="$strSlotNumber"/></xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="display"><xsl:value-of select="$strServerModuleLocation"/></xsl:attribute>
            </xsl:otherwise>
          </xsl:choose>
            <xsl:attribute name="value"><xsl:value-of select="BoardLocation"/></xsl:attribute>
				</Data>
        <xsl:if test="$IsCLICmdNew='true' and $IsBlade='true'">
          <Data name="BladeName" type="ustring">
            <xsl:attribute name="display"><xsl:value-of select="$strSlotName"/></xsl:attribute>
            <xsl:attribute name="value">
              <xsl:value-of select="/OMA/EMPObjSummary/EMPObj/BladeLocation"/> </xsl:attribute>
          </Data>
        </xsl:if>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

	<xsl:template match="Hardware">
		<xsl:apply-templates/>
		<xsl:apply-templates select="parent::node()/FirmwareList" />
	</xsl:template>
	<xsl:template match="ProcessorList">
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="DevProcessor">
		<ListData name="processor">
			<xsl:attribute name="display"><xsl:value-of select="ExtName"/></xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="$strProcessor"/> <xsl:value-of select="@index + 1"/></xsl:attribute>
      <xsl:choose>
        <xsl:when test="Brand=''">
          <Data name="ProcessorManufacturer">
				    <xsl:attribute name="display"><xsl:value-of select="$strProcessorManufacturer"/></xsl:attribute>
				    <xsl:attribute name="value"><xsl:value-of select="Manufacturer"/></xsl:attribute>
			    </Data>
			    <Data name="ProcessorFamily">
				    <xsl:attribute name="display"><xsl:value-of select="$strProcessorFamily"/></xsl:attribute>
				    <xsl:attribute name="value">
					    <xsl:choose>
                            <xsl:when test="Family='1'"><xsl:value-of select="$strOther"/></xsl:when>
                            <xsl:when test="Family='2'"><xsl:value-of select="$strUnknown"/></xsl:when>
                            <xsl:when test="Family='3'"><xsl:value-of select="$str8086"/></xsl:when>
                            <xsl:when test="Family='4'"><xsl:value-of select="$str80286"/></xsl:when>
                            <xsl:when test="Family='5'"><xsl:value-of select="$str80386"/></xsl:when>
                            <xsl:when test="Family='6'"><xsl:value-of select="$str80486"/></xsl:when>
                            <xsl:when test="Family='7'"><xsl:value-of select="$str8087"/></xsl:when>
                            <xsl:when test="Family='8'"><xsl:value-of select="$str80287"/></xsl:when>
                            <xsl:when test="Family='9'"><xsl:value-of select="$str80387"/></xsl:when>
                            <xsl:when test="Family='10'"><xsl:value-of select="$str80487"/></xsl:when>
                            <xsl:when test="Family='11'"><xsl:value-of select="$strPentiumFamily"/></xsl:when>
                            <xsl:when test="Family='12'"><xsl:value-of select="$strPentiumPro"/></xsl:when>
                            <xsl:when test="Family='13'"><xsl:value-of select="$strPentiumII"/></xsl:when>
                            <xsl:when test="Family='14'"><xsl:value-of select="$strPentiumMMX"/></xsl:when>
                            <xsl:when test="Family='15'"><xsl:value-of select="$strCeleron"/></xsl:when>
                            <xsl:when test="Family='16'"><xsl:value-of select="$strXeon"/></xsl:when>
                            <xsl:when test="Family='17'"><xsl:value-of select="$strPentiumIII"/></xsl:when>
                            <xsl:when test="Family='18'"><xsl:value-of select="$strM1Family"/></xsl:when>
                            <xsl:when test="Family='19'"><xsl:value-of select="$strM2Family"/></xsl:when>
                            <xsl:when test="Family='24'"><xsl:value-of select="$strAMDDuron"/></xsl:when>
                            <xsl:when test="Family='25'"><xsl:value-of select="$strK5Family"/></xsl:when>
                            <xsl:when test="Family='26'"><xsl:value-of select="$strK6Family"/></xsl:when>
                            <xsl:when test="Family='27'"><xsl:value-of select="$strK6-2"/></xsl:when>
                            <xsl:when test="Family='28'"><xsl:value-of select="$strK6-3"/></xsl:when>
                            <xsl:when test="Family='29'"><xsl:value-of select="$strAMDAthlon"/></xsl:when>
                            <xsl:when test="Family='30'"><xsl:value-of select="$strAMD2900"/></xsl:when>
                            <xsl:when test="Family='31'"><xsl:value-of select="$strK6-2Plus"/></xsl:when>
                            <xsl:when test="Family='32'"><xsl:value-of select="$strPowerPCFamily"/></xsl:when>
                            <xsl:when test="Family='33'"><xsl:value-of select="$strPowerPC601"/></xsl:when>
                            <xsl:when test="Family='34'"><xsl:value-of select="$strPowerPC603"/></xsl:when>
                            <xsl:when test="Family='35'"><xsl:value-of select="$strPowerPC6031"/></xsl:when>
                            <xsl:when test="Family='36'"><xsl:value-of select="$strPowerPC604"/></xsl:when>
                            <xsl:when test="Family='37'"><xsl:value-of select="$strPowerPC620"/></xsl:when>
                            <xsl:when test="Family='38'"><xsl:value-of select="$strPowerPCx704"/></xsl:when>
                            <xsl:when test="Family='39'"><xsl:value-of select="$strPowerPC750"/></xsl:when>
                            <xsl:when test="Family='48'"><xsl:value-of select="$strAlphaFamily"/></xsl:when>
                            <xsl:when test="Family='49'"><xsl:value-of select="$strAlpha21064"/></xsl:when>
                            <xsl:when test="Family='50'"><xsl:value-of select="$strAlpha21066"/></xsl:when>
                            <xsl:when test="Family='51'"><xsl:value-of select="$strAlpha21164"/></xsl:when>
                            <xsl:when test="Family='52'"><xsl:value-of select="$strAlpha21164PC"/></xsl:when>
                            <xsl:when test="Family='53'"><xsl:value-of select="$strAlpha21164a"/></xsl:when>
                            <xsl:when test="Family='54'"><xsl:value-of select="$strAlpha21264"/></xsl:when>
                            <xsl:when test="Family='55'"><xsl:value-of select="$strAlpha21364"/></xsl:when>
                            <xsl:when test="Family='64'"><xsl:value-of select="$strMIPSFamily"/></xsl:when>
                            <xsl:when test="Family='65'"><xsl:value-of select="$strMIPSR4000"/></xsl:when>
                            <xsl:when test="Family='66'"><xsl:value-of select="$strMIPSR4200"/></xsl:when>
                            <xsl:when test="Family='67'"><xsl:value-of select="$strMIPSR4400"/></xsl:when>
                            <xsl:when test="Family='68'"><xsl:value-of select="$strMIPSR4600"/></xsl:when>
                            <xsl:when test="Family='69'"><xsl:value-of select="$strMIPSR10000"/></xsl:when>
                            <xsl:when test="Family='80'"><xsl:value-of select="$strSPARCFamily"/></xsl:when>
                            <xsl:when test="Family='81'"><xsl:value-of select="$strSuperSPARC"/></xsl:when>
                            <xsl:when test="Family='82'"><xsl:value-of select="$strmicroSPARCII"/></xsl:when>
                            <xsl:when test="Family='83'"><xsl:value-of select="$strmicroSPARCIIep"/></xsl:when>
                            <xsl:when test="Family='84'"><xsl:value-of select="$strUltraSPARC"/></xsl:when>
                            <xsl:when test="Family='85'"><xsl:value-of select="$strUltraSPARCII"/></xsl:when>
                            <xsl:when test="Family='86'"><xsl:value-of select="$strUltraSPARCIIi"/></xsl:when>
                            <xsl:when test="Family='87'"><xsl:value-of select="$strUltraSPARCIII"/></xsl:when>
                            <xsl:when test="Family='88'"><xsl:value-of select="$strUltraSPARCIIIi"/></xsl:when>
                            <xsl:when test="Family='96'"><xsl:value-of select="$str68040"/></xsl:when>
                            <xsl:when test="Family='97'"><xsl:value-of select="$str68xxxFamily"/></xsl:when>
                            <xsl:when test="Family='98'"><xsl:value-of select="$str68000"/></xsl:when>
                            <xsl:when test="Family='99'"><xsl:value-of select="$str68010"/></xsl:when>
                            <xsl:when test="Family='100'"><xsl:value-of select="$str68020"/></xsl:when>
                            <xsl:when test="Family='101'"><xsl:value-of select="$str68030"/></xsl:when>
                            <xsl:when test="Family='112'"><xsl:value-of select="$strHobbitFamily"/></xsl:when>
                            <xsl:when test="Family='120'"><xsl:value-of select="$strCrusoeTM5000"/></xsl:when>
                            <xsl:when test="Family='121'"><xsl:value-of select="$strCrusoeTM3000"/></xsl:when>
                            <xsl:when test="Family='122'"><xsl:value-of select="$strEfficeonTM8000"/></xsl:when>
                            <xsl:when test="Family='128'"><xsl:value-of select="$strWeitek"/></xsl:when>
                            <xsl:when test="Family='130'"><xsl:value-of select="$strItanium"/></xsl:when>
                            <xsl:when test="Family='131'"><xsl:value-of select="$strAMDAthlon64"/></xsl:when>
                            <xsl:when test="Family='132'"><xsl:value-of select="$strAMDOpteron"/></xsl:when>
                            <xsl:when test="Family='144'"><xsl:value-of select="$strPARISCFamily"/></xsl:when>
                            <xsl:when test="Family='145'"><xsl:value-of select="$strPA-RISC8500"/></xsl:when>
                            <xsl:when test="Family='146'"><xsl:value-of select="$strPA-RISC8000"/></xsl:when>
                            <xsl:when test="Family='147'"><xsl:value-of select="$strPA-RISC7300LC"/></xsl:when>
                            <xsl:when test="Family='148'"><xsl:value-of select="$strPA-RISC7200"/></xsl:when>
                            <xsl:when test="Family='149'"><xsl:value-of select="$strPA-RISC7100LC"/></xsl:when>
                            <xsl:when test="Family='150'"><xsl:value-of select="$strPA-RISC7100"/></xsl:when>
                            <xsl:when test="Family='160'"><xsl:value-of select="$strV30Family"/></xsl:when>
                            <xsl:when test="Family='176'"><xsl:value-of select="$strPentiumIIIXeon"/></xsl:when>
                            <xsl:when test="Family='177'"><xsl:value-of select="$strPentiumIIIStep"/></xsl:when>
                            <xsl:when test="Family='178'"><xsl:value-of select="$strPentiumIV"/></xsl:when>
                            <xsl:when test="Family='179'"><xsl:value-of select="$strXeon1"/></xsl:when>
                            <xsl:when test="Family='180'"><xsl:value-of select="$strAS400"/></xsl:when>
                            <xsl:when test="Family='181'"><xsl:value-of select="$strXeonMP"/></xsl:when>
                            <xsl:when test="Family='182'"><xsl:value-of select="$strAMDAthlonXP"/></xsl:when>
                            <xsl:when test="Family='183'"><xsl:value-of select="$strAMDAthlonMP"/></xsl:when>
                            <xsl:when test="Family='184'"><xsl:value-of select="$strItanium2"/></xsl:when>
                            <xsl:when test="Family='185'"><xsl:value-of select="$strPentiumM"/></xsl:when>
                            <xsl:when test="Family='186'"><xsl:value-of select="$strCeleronD"/></xsl:when>
                            <xsl:when test="Family='187'"><xsl:value-of select="$strPentiumD"/></xsl:when>
                            <xsl:when test="Family='188'"><xsl:value-of select="$strPentiumExtreme"/></xsl:when>
                            <xsl:when test="Family='200'"><xsl:value-of select="$strIBM390"/></xsl:when>
                            <xsl:when test="Family='201'"><xsl:value-of select="$strG4"/></xsl:when>
                            <xsl:when test="Family='202'"><xsl:value-of select="$strG5"/></xsl:when>
                            <xsl:when test="Family='250'"><xsl:value-of select="$stri860"/></xsl:when>
                            <xsl:when test="Family='251'"><xsl:value-of select="$stri960"/></xsl:when>
						    <xsl:otherwise><xsl:value-of select="$strNoValue1"/></xsl:otherwise>
					    </xsl:choose>
				    </xsl:attribute>
			    </Data>
        </xsl:when>
        <xsl:otherwise>
          <Data name="ProcessorBrand">
				    <xsl:attribute name="display"><xsl:value-of select="$strProcessorBrand"/></xsl:attribute>
				    <xsl:attribute name="value"><xsl:value-of select="Brand"/></xsl:attribute>
			    </Data>
        </xsl:otherwise>
      </xsl:choose>
			<Data name="ProcessorVersion">
				<xsl:attribute name="display"><xsl:value-of select="$strProcessorVersion"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="Model"/><xsl:text> </xsl:text><xsl:value-of select="Stepping"/></xsl:attribute>
			</Data>
      <xsl:if test="Brand=''">
			  <Data name="CurrentSpeed">
				  <xsl:attribute name="display"><xsl:value-of select="$strCurrentSpeed"/></xsl:attribute>
				  <xsl:attribute name="value"><xsl:value-of select="CurSpeed"/><xsl:text> </xsl:text>
					  <xsl:call-template name="displayunits"><xsl:with-param name="unit"><xsl:value-of select="CurSpeed/@unit"/></xsl:with-param></xsl:call-template>
				  </xsl:attribute>
			  </Data>
			  <Data name="MaximumSpeed">
				  <xsl:attribute name="display"><xsl:value-of select="$strMaximumSpeed"/></xsl:attribute>
				  <xsl:attribute name="value"><xsl:value-of select="MaxSpeed"/><xsl:text> </xsl:text>
					  <xsl:call-template name="displayunits"><xsl:with-param name="unit"><xsl:value-of select="MaxSpeed/@unit"/></xsl:with-param></xsl:call-template>
				  </xsl:attribute>
			  </Data>
			  <Data name="ExtClockSpeed">
				  <xsl:attribute name="display"><xsl:value-of select="$strExternalClockSpeed"/></xsl:attribute>
				  <xsl:attribute name="value"><xsl:value-of select="ExtClockSpeed"/><xsl:text> </xsl:text>
					  <xsl:call-template name="displayunits"><xsl:with-param name="unit"><xsl:value-of select="ExtClockSpeed/@unit"/></xsl:with-param></xsl:call-template>
				  </xsl:attribute>
			  </Data>
      </xsl:if>
			<Data name="Voltage">
				<xsl:attribute name="display"><xsl:value-of select="$strVoltage"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="Voltage"/><xsl:text> </xsl:text>
					<xsl:call-template name="displayunits"><xsl:with-param name="unit"><xsl:value-of select="Voltage/@unit"/></xsl:with-param></xsl:call-template>
				</xsl:attribute>
			</Data>
		</ListData>
	</xsl:template>
	<xsl:template match="MemoryArrayList">
		<ListData name="Memory">
			<xsl:attribute name="display"><xsl:value-of select="$strMemory"/></xsl:attribute>
			<Data name="InstalledSize">
				<xsl:attribute name="display"><xsl:value-of select="$strTotalInstalledCapacity"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="../MaxInstalledSizeMBCumulative"/><xsl:text> </xsl:text>
					<xsl:call-template name="displayunits"><xsl:with-param name="unit"><xsl:value-of select="../MaxInstalledSizeMBCumulative/@unit"/></xsl:with-param></xsl:call-template>
				</xsl:attribute>
			</Data>
			<Data name="OSInstalledSize">
				<xsl:attribute name="display"><xsl:value-of select="$strMemoryAvailableTo"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="../MemoryInfo/TotalPhysMemorySizeMB"/><xsl:text> </xsl:text>
					<xsl:call-template name="displayunits"><xsl:with-param name="unit"><xsl:value-of select="../MemoryInfo/TotalPhysMemorySizeMB/@unit"/></xsl:with-param></xsl:call-template>
				</xsl:attribute>
			</Data>
			<Data name="TotalSize">
				<xsl:attribute name="display"><xsl:value-of select="$strTotalMaximumCapacity"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="../MaxSizeMBCumulative"/><xsl:text> </xsl:text>
					<xsl:call-template name="displayunits"><xsl:with-param name="unit"><xsl:value-of select="../MaxSizeMBCumulative/@unit"/></xsl:with-param></xsl:call-template>
				</xsl:attribute>
			</Data>
			<Data name="MemoryArrays">
				<xsl:attribute name="display"><xsl:value-of select="$strMemoryArrayCount"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="@count"/></xsl:attribute>
			</Data>
		</ListData>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="MemoryArray">
		<ListData name="MemoryArray">
			<xsl:attribute name="display"><xsl:value-of select="$strMemoryArray"/> <xsl:value-of select="@index + 1"/></xsl:attribute>
			<Data name="Location">
				<xsl:attribute name="display"><xsl:value-of select="$strLocation"/></xsl:attribute>
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="Location='1'"><xsl:value-of select="$strOther1"/></xsl:when>
						<xsl:when test="Location='3'"><xsl:value-of select="$strSystemBoardOr"/></xsl:when>
						<xsl:when test="Location='4'"><xsl:value-of select="$strISAAddonCard"/></xsl:when>
						<xsl:when test="Location='5'"><xsl:value-of select="$strEISAAddonCard"/></xsl:when>
						<xsl:when test="Location='6'"><xsl:value-of select="$strPCIAddonCard"/></xsl:when>
						<xsl:when test="Location='7'"><xsl:value-of select="$strMCAAddonCard"/></xsl:when>
						<xsl:when test="Location='8'"><xsl:value-of select="$strPCMCIAAddonCard"/></xsl:when>
						<xsl:when test="Location='9'"><xsl:value-of select="$strProprietaryAddonCard"/></xsl:when>
						<xsl:when test="Location='16'"><xsl:value-of select="$strNuBus"/></xsl:when>
						<xsl:when test="Location='160'"><xsl:value-of select="$strPC98C20AddonCard"/></xsl:when>
						<xsl:when test="Location='161'"><xsl:value-of select="$strPC98C24AddonCard"/></xsl:when>
						<xsl:when test="Location='162'"><xsl:value-of select="$strPC98EAddonCard"/></xsl:when>
						<xsl:when test="Location='163'"><xsl:value-of select="$strPC98LocalBusAddon"/></xsl:when>
						<xsl:when test="Location='164'"><xsl:value-of select="$strPC98CardSlotAddon"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="$strNoValue2"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
			<Data name="Use">
				<xsl:attribute name="display"><xsl:value-of select="$strUse"/></xsl:attribute>
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="Use='1'"><xsl:value-of select="$strOther2"/></xsl:when>
						<xsl:when test="Use='3'"><xsl:value-of select="$strSystemMemory"/></xsl:when>
						<xsl:when test="Use='4'"><xsl:value-of select="$strVideoMemory"/></xsl:when>
						<xsl:when test="Use='5'"><xsl:value-of select="$strFlashMemory"/></xsl:when>
						<xsl:when test="Use='6'"><xsl:value-of select="$strNonVolatileRAM"/></xsl:when>
						<xsl:when test="Use='7'"><xsl:value-of select="$strCacheMemory"/></xsl:when>
					</xsl:choose>
				</xsl:attribute>
			</Data>
			<Data name="InstalledSize">
				<xsl:attribute name="display"><xsl:value-of select="$strInstalledCapacity"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="InstalledSizeMBCumulative"/><xsl:text> </xsl:text>
					<xsl:call-template name="displayunits"><xsl:with-param name="unit"><xsl:value-of select="InstalledSizeMBCumulative/@unit"/></xsl:with-param></xsl:call-template>
				</xsl:attribute>
			</Data>
			<Data name="MaximumCapacity">
				<xsl:attribute name="display"><xsl:value-of select="$strMaximumCapacity"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="MaxSizeMB"/><xsl:text> </xsl:text>
					<xsl:call-template name="displayunits"><xsl:with-param name="unit"><xsl:value-of select="MaxSizeMB/@unit"/></xsl:with-param></xsl:call-template>
				</xsl:attribute>
			</Data>
			<Data name="NumSocketsTotal">
				<xsl:attribute name="display"><xsl:value-of select="$strSlotsAvailable"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="NumSocketsTotal"/></xsl:attribute>
			</Data>
			<Data name="NumSocketsInUse">
				<xsl:attribute name="display"><xsl:value-of select="$strSlotsUsed"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="NumSocketsInUse"/></xsl:attribute>
			</Data>
			<Data name="ErrCorrType">
				<xsl:attribute name="display"><xsl:value-of select="$strECCType"/></xsl:attribute>
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="ErrCorrType='1'"><xsl:value-of select="$strOther3"/></xsl:when>
						<xsl:when test="ErrCorrType='3'"><xsl:value-of select="$strNone"/></xsl:when>
						<xsl:when test="ErrCorrType='4'"><xsl:value-of select="$strParity"/></xsl:when>
						<xsl:when test="ErrCorrType='5'"><xsl:value-of select="$strSingleBitECC"/></xsl:when>
						<xsl:when test="ErrCorrType='6'"><xsl:value-of select="$strMultibitECC"/></xsl:when>
						<xsl:when test="ErrCorrType='7'"><xsl:value-of select="$strCRC"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="$strNoValue4"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
		</ListData>
	</xsl:template>
	<xsl:template match="SlotsList">
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="Slot">
		<xsl:if test="ExtName != 'Embedded'">
			<ListData>
				<xsl:attribute name="name">slot<xsl:value-of select="@index"/></xsl:attribute>
				<xsl:attribute name="display"><xsl:value-of select="$strSlot"/> <xsl:value-of select="ExtName"/></xsl:attribute>
				<Data name="adapter">
					<xsl:attribute name="display"><xsl:value-of select="$strAdapter"/></xsl:attribute>
					<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="SlotDevice"><xsl:value-of select="SlotDevice/DeviceDesc" /></xsl:when>
							<xsl:otherwise><xsl:value-of select="$strNotOccupied"/></xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
				</Data>
				<Data name="Type"  editable="false" type="ustring">
					<xsl:attribute name="display"><xsl:value-of select="$strType"/></xsl:attribute>
					<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="Type='1'"><xsl:value-of select="$strOther4"/></xsl:when>
							<xsl:when test="Type='3'"><xsl:value-of select="$strISA"/></xsl:when>
							<xsl:when test="Type='4'"><xsl:value-of select="$strMCA"/></xsl:when>
							<xsl:when test="Type='5'"><xsl:value-of select="$strEISA"/></xsl:when>
							<xsl:when test="Type='6'"><xsl:value-of select="$strPCI"/></xsl:when>
							<xsl:when test="Type='7'"><xsl:value-of select="$strPCMCIA"/></xsl:when>
							<xsl:when test="Type='8'"><xsl:value-of select="$strVLVESA"/></xsl:when>
							<xsl:when test="Type='9'"><xsl:value-of select="$strProprietary"/></xsl:when>
							<xsl:when test="Type='10'"><xsl:value-of select="$strProcessorCard"/></xsl:when>
							<xsl:when test="Type='11'"><xsl:value-of select="$strProprietaryMemoryCard"/></xsl:when>
							<xsl:when test="Type='12'"><xsl:value-of select="$strIORiserCard"/></xsl:when>
							<xsl:when test="Type='13'"><xsl:value-of select="$strNuBus1"/></xsl:when>
							<xsl:when test="Type='14'"><xsl:value-of select="$strPCI66MHz"/></xsl:when>
							<xsl:when test="Type='15'"><xsl:value-of select="$strAGP"/></xsl:when>
							<xsl:when test="Type='16'"><xsl:value-of select="$strAGP2X"/></xsl:when>
							<xsl:when test="Type='17'"><xsl:value-of select="$strAGP4X"/></xsl:when>
							<xsl:when test="Type='18'"><xsl:value-of select="$strPCIX"/></xsl:when>
							<xsl:when test="Type='160'"><xsl:value-of select="$strPC98C20"/></xsl:when>
							<xsl:when test="Type='161'"><xsl:value-of select="$strPC98C24"/></xsl:when>
							<xsl:when test="Type='162'"><xsl:value-of select="$strPC98E"/></xsl:when>
							<xsl:when test="Type='163'"><xsl:value-of select="$strPC98LocalBus"/></xsl:when>
							<xsl:when test="Type='164'"><xsl:value-of select="$strPC98Card"/></xsl:when>
							<xsl:when test="Type='165'"><xsl:value-of select="$strPCIE"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$strNoValue5"/></xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
				</Data>
				<Data name="DataBusWidth">
					<xsl:attribute name="display"><xsl:value-of select="$strDataBusWidth"/></xsl:attribute>
					<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="HotPlugSystemSlot/DataBusWidth='1'"><xsl:value-of select="$strOther5"/></xsl:when>
							<xsl:when test="HotPlugSystemSlot/DataBusWidth='3'"><xsl:value-of select="$str8Bits"/></xsl:when>
							<xsl:when test="HotPlugSystemSlot/DataBusWidth='4'"><xsl:value-of select="$str16Bits"/></xsl:when>
							<xsl:when test="HotPlugSystemSlot/DataBusWidth='5'"><xsl:value-of select="$str32Bits"/></xsl:when>
							<xsl:when test="HotPlugSystemSlot/DataBusWidth='6'"><xsl:value-of select="$str64Bits"/></xsl:when>
							<xsl:when test="HotPlugSystemSlot/DataBusWidth='7'"><xsl:value-of select="$str128Bits"/></xsl:when>
							<xsl:when test="HotPlugSystemSlot/DataBusWidth='8'"><xsl:value-of select="$str1xOr1x"/></xsl:when>
							<xsl:when test="HotPlugSystemSlot/DataBusWidth='9'"><xsl:value-of select="$str2xOr2x"/></xsl:when>
							<xsl:when test="HotPlugSystemSlot/DataBusWidth='10'"><xsl:value-of select="$str4xOr4x"/></xsl:when>
							<xsl:when test="HotPlugSystemSlot/DataBusWidth='11'"><xsl:value-of select="$str8xOr8x"/></xsl:when>
							<xsl:when test="HotPlugSystemSlot/DataBusWidth='12'"><xsl:value-of select="$str12xOr12x"/></xsl:when>
							<xsl:when test="HotPlugSystemSlot/DataBusWidth='13'"><xsl:value-of select="$str16xOr16x"/></xsl:when>
							<xsl:when test="HotPlugSystemSlot/DataBusWidth='14'"><xsl:value-of select="$str32xOr32x"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$strNotObtainedRefer"/></xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
				</Data>
				<Data name="Speed"  editable="false" type="ustring">
					<xsl:attribute name="display"><xsl:value-of select="$strSpeed"/></xsl:attribute>
					<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="HotPlugSystemSlot/SlotSpeed='0'"><xsl:value-of select="$strNotObtainedRefer"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="HotPlugSystemSlot/SlotSpeed"/><xsl:text> </xsl:text>
								<xsl:call-template name="displayunits"><xsl:with-param name="unit"><xsl:value-of select="HotPlugSystemSlot/SlotSpeed/@unit"/></xsl:with-param></xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
				</Data>
				<Data name="SlotLength">
					<xsl:attribute name="display"><xsl:value-of select="$strSlotLength"/></xsl:attribute>
					<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="Length='1'"><xsl:value-of select="$strOther6"/></xsl:when>
							<xsl:when test="Length='3'"><xsl:value-of select="$strShort"/></xsl:when>
							<xsl:when test="Length='4'"><xsl:value-of select="$strLong"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$strNoValue8"/></xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
				</Data>
				<Data name="VoltSupply"  editable="false" type="ustring">
					<xsl:attribute name="display"><xsl:value-of select="$strVoltageSupply"/></xsl:attribute>
					<xsl:attribute name="value">
						<xsl:if test="IsVolt33='true'"><xsl:value-of select="$str33Volts"/><xsl:if test="IsVolt5='true'">, </xsl:if></xsl:if>
						<xsl:if test="IsVolt5='true'"><xsl:value-of select="$str5Volts"/></xsl:if>
					</xsl:attribute>
				</Data>
			</ListData>
		</xsl:if>
	</xsl:template>
	<xsl:template match="SystemBIOS">
		<ListData name="SystemBIOS">
			<xsl:attribute name="display"><xsl:value-of select="$strBIOSInformation"/></xsl:attribute>
			<Data name="Manufacturer">
				<xsl:attribute name="display"><xsl:value-of select="$strManufacturer"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="Manufacturer"/></xsl:attribute>
			</Data>
			<Data name="Version">
				<xsl:attribute name="display"><xsl:value-of select="$strVersion"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="Version"/></xsl:attribute>
			</Data>
			<Data name="ReleaseDate">
				<xsl:attribute name="display"><xsl:value-of select="$strReleaseDate"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="ReleaseDate"/></xsl:attribute>
			</Data>
		</ListData>
	</xsl:template>
	<xsl:template match="Network">
		<Section name="Network">
			<xsl:attribute name="display"><xsl:value-of select="$strNetworkData"/></xsl:attribute>
			<xsl:choose>
				<xsl:when test="NICList">
					<xsl:apply-templates select="NICList" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates/>
				</xsl:otherwise>
			</xsl:choose>
		</Section>
	</xsl:template>
	<xsl:template match="NICList">
			<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="NICCard">
		<ListData>
			<xsl:attribute name="name">NICList<xsl:value-of select="@index"/></xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="$strNetworkInterfaceCard"/><xsl:value-of select="@index"/></xsl:attribute>
			<Data>
				<xsl:attribute name="name">IPAddr<xsl:value-of select="@index"/></xsl:attribute>
				<xsl:attribute name="display"><xsl:value-of select="$strIPAddress"/></xsl:attribute>
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="IPAddress = ''"><xsl:value-of select="$strNoValue9"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="IPAddress"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
			<xsl:if test="SubnetMask != ''">
			<Data>
				<xsl:attribute name="name">SubnetMask<xsl:value-of select="@index"/></xsl:attribute>
				<xsl:attribute name="display"><xsl:value-of select="$strSubnetMask"/></xsl:attribute>
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="SubnetMask = ''"><xsl:value-of select="$strNoValue10"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="SubnetMask"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
			</xsl:if>
			<xsl:if test="DefaultGateway != ''">
			<Data>
				<xsl:attribute name="name">DefaultGateway<xsl:value-of select="@index"/></xsl:attribute>
				<xsl:attribute name="display"><xsl:value-of select="$strDefaultGateway"/></xsl:attribute>
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="DefaultGateway = ''"><xsl:value-of select="$strNoValue11"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="DefaultGateway"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
			</xsl:if>
			<xsl:if test="CurrentMACAddr!= ''">
			<Data>
				<xsl:attribute name="name">MacAddr<xsl:value-of select="@index"/></xsl:attribute>
				<xsl:attribute name="display"><xsl:value-of select="$strMACAddress"/></xsl:attribute>
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="CurrentMACAddr = ''"><xsl:value-of select="$strNoValue12"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="CurrentMACAddr"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
			</xsl:if>
		</ListData>
	</xsl:template>
	<xsl:template match="IPAddrList">
		<ListData name="IPAddrList">
			<xsl:attribute name="display"><xsl:value-of select="$strIPAddressData"/></xsl:attribute>
			<xsl:apply-templates/>
		</ListData>
	</xsl:template>
	<xsl:template match="IPAddr">
		<Data name="IPAddr">
			<xsl:attribute name="name">IPAddr<xsl:value-of select="@index"/></xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="$strIPAddress1"/><xsl:value-of select="@index"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
		</Data>
	</xsl:template>
	<xsl:template match="Software">
		<Section name="Software">
			<xsl:attribute name="display"><xsl:value-of select="$strSoftwareProfile"/></xsl:attribute>
			<xsl:apply-templates/>
		</Section>
	</xsl:template>
	<xsl:template match="OSInfo">
		<ListData name="OSInfo">
			<xsl:attribute name="display"><xsl:value-of select="$strOperatingSystem"/></xsl:attribute>
			<Data name="OSName">
				<xsl:attribute name="display"><xsl:value-of select="$strName"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="OSName"/></xsl:attribute>
			</Data>
			<Data name="OSVersion">
				<xsl:attribute name="display"><xsl:value-of select="$strVersion1"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="OSVersion"/></xsl:attribute>
			</Data>
			<Data name="SystemTime">
				<xsl:attribute name="display"><xsl:value-of select="$strSystemTime"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="//System/SystemInfo/SystemTime"/></xsl:attribute>
			</Data>
			<Data name="SystemBootupTime">
				<xsl:attribute name="display"><xsl:value-of select="$strSystemBootupTime"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="//System/SystemInfo/SystemBootupTime"/></xsl:attribute>
			</Data>
		</ListData>
	</xsl:template>
	<xsl:template match="FirmwareList">
		<xsl:apply-templates />
	</xsl:template>
	<xsl:template match="Firmware">
		<ListData>
			<xsl:attribute name="name">Firmware_<xsl:value-of select="@index"/></xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="$strFirmwareInformation"/></xsl:attribute>
			<Data name="Name">
				<xsl:attribute name="display"><xsl:value-of select="$strName1"/></xsl:attribute>
				<xsl:attribute name="value">
					<xsl:call-template name="getFWType">
							<xsl:with-param name="type">
								<xsl:value-of select="FWType"/>
							</xsl:with-param>
					</xsl:call-template>
				</xsl:attribute>
			</Data>
			<Data name="Version">
				<xsl:attribute name="display"><xsl:value-of select="$strVersion2"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="FWVersion"/></xsl:attribute>
			</Data>
		</ListData>
	</xsl:template>

	<xsl:template match="ClusterInfo">
		<Section name="ClusterInfo">
			<xsl:attribute name="display"><xsl:value-of select="$strClusterInformation"/></xsl:attribute>
			<ListData name="Information">
				<xsl:attribute name="display"><xsl:value-of select="$strClusterInformation1"/></xsl:attribute>
				<Data name="ClusterName">
					<xsl:attribute name="display"><xsl:value-of select="$strClusterName"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="ClusterName"/></xsl:attribute>
				</Data>
				<Data name="TypeDescription">
					<xsl:attribute name="display"><xsl:value-of select="$strClusterDescription"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="TypeDescription"/></xsl:attribute>
				</Data>
				<Data name="ClusterType">
					<xsl:attribute name="display"><xsl:value-of select="$strClusterType"/></xsl:attribute>
					<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="ClusterType='2'"><xsl:value-of select="$strMicrosoftClusterServer"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$strNoValue13"/></xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
				</Data>
			</ListData>
		</Section>
	</xsl:template>

	<xsl:template name="displayunits">
	<xsl:param name="unit"/>
	<xsl:choose>
		<xsl:when test="$unit='MB'"><xsl:value-of select="$strMB"/></xsl:when>
		<xsl:when test="$unit='KB'"><xsl:value-of select="$strKB"/></xsl:when>
		<xsl:otherwise><xsl:value-of select="$unit"/></xsl:otherwise>
	</xsl:choose>
	</xsl:template>

	<xsl:template name="getFWType">
		<xsl:param name="type"/>
		<xsl:choose>
			<xsl:when test="$type='2'"><xsl:value-of select="FWText"/></xsl:when>
			<xsl:when test="$type='3'"><xsl:value-of select="$strBIOSVersion"/></xsl:when>
			<xsl:when test="$type='4'"><xsl:value-of select="$strESMFirmwareVersion"/></xsl:when>
			<xsl:when test="$type='5'"><xsl:value-of select="$strPowerSupplyParalleling"/></xsl:when>
			<xsl:when test="$type='6'"><xsl:value-of select="$strBackplaneFirmwareVersion"/></xsl:when>
			<xsl:when test="$type='7'"><xsl:value-of select="$strKernelVersion"/></xsl:when>
			<xsl:when test="$type='8'"><xsl:value-of select="$strApplicationVersion"/></xsl:when>
			<xsl:when test="$type='9'"><xsl:value-of select="$strFrontPanelController"/></xsl:when>
			<xsl:when test="$type='10'"><xsl:value-of select="$strBaseboardManagementController"/></xsl:when>
			<xsl:when test="$type='11'"><xsl:value-of select="$strHotPlugPCI"/></xsl:when>
			<xsl:when test="$type='12'"><xsl:value-of select="$strSensorDataRecords"/></xsl:when>
			<xsl:when test="$type='13'"><xsl:value-of select="$strPeripheralBayBackplane"/></xsl:when>
			<xsl:when test="$type='14'"><xsl:value-of select="$strPowerEdge2450Secondary"/></xsl:when>
			<xsl:when test="$type='15'"><xsl:value-of select="$strSecondaryBackPlane"/></xsl:when>
			<xsl:when test="$type='16'"><xsl:value-of select="$strRemoteAccessController"/></xsl:when>
	        	<xsl:when test="$type='17'"><xsl:value-of select="$striDRAC"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$strUnknownFirmwareVersion"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="*"/>

</xsl:stylesheet>
