<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
  
  <xsl:variable name="currentObjs"><xsl:value-of select="/OMA/CurrentProbeList/CurrentProbe"/></xsl:variable>
  <xsl:variable name="currentpoid"><xsl:value-of select="/OMA/CurrentProbeList/@poid"/></xsl:variable>
    
  <xsl:template match="OMA">
    <DataArea>
    <xsl:choose>
      <!-- Power Monitoring not available -->
      <xsl:when test="count(/OMA/PowerConsumptionDataObj) &lt; 1">
          <CustomButton>
            <Data>
              <xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
              <xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.ListPowerMonitoringWebPlugin&amp;poid=<xsl:value-of select="$currentpoid"/>&amp;help=PowerMonitoring</xsl:attribute>
            </Data>
          </CustomButton>
          <PromptText><xsl:value-of select="$strPowerMonitoringNAMessage"/></PromptText>
      </xsl:when>
      <xsl:otherwise>
        <PageTitle>
          <xsl:attribute name="display"><xsl:value-of select="$strPowerConsumptionInfo"/></xsl:attribute>
          <xsl:choose>
            <xsl:when test="/OMA/@cli = 'true'">	</xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="status"><xsl:value-of select="/OMA/ObjStatus"/></xsl:attribute>
            </xsl:otherwise>
          </xsl:choose>
        </PageTitle>
        <xsl:choose>
          <!-- Power Monitoring available, but error condition -->
          <xsl:when test="SMStatus != '0'">
              <TableData>
                <Header>
                  <Data>
                    <xsl:attribute name="display"><xsl:value-of select="$strError"/></xsl:attribute>
                    <xsl:attribute name="value"><xsl:value-of select="$strError"/></xsl:attribute>
                  </Data>
                </Header>
                <Row>
                  <Data>
                    <xsl:attribute name="display"><xsl:value-of select="$str"/></xsl:attribute>
                    <xsl:attribute name="value">
                      <xsl:call-template name="smstatus">
                        <xsl:with-param name="status"><xsl:value-of select="SMStatus"/></xsl:with-param>
                      </xsl:call-template>
                    </xsl:attribute>
                  </Data>
                </Row>
              </TableData>
          </xsl:when>
          <!-- Power Monitoring available and success condition -->
          <xsl:otherwise>
              <script language="javascript">

                function resetreadings(countertype)
                {
                if (confirm("<xsl:value-of select="$strResetWarnMsg"/>"))
                {
                document.getElementById("dataarea").action=top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.hip.webplugins.ListPowerMonitoringWebPlugin&amp;resetreading=true&amp;countertypevalue=" + countertype + "&amp;poid=" + <xsl:value-of select="$currentpoid"/>);
                document.getElementById("dataarea").submit();
                }
                }

              </script>
              <CustomButton>
                <Data>
                  <xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
                  <xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.ListPowerMonitoringWebPlugin&amp;poid=<xsl:value-of select="$currentpoid"/>&amp;help=PowerMonitoring</xsl:attribute>
                </Data>
              </CustomButton>
              <xsl:call-template name="CurrentSensorsData"/>
              <xsl:apply-templates select="PowerConsumptionDataObj"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </DataArea>
  </xsl:template>

  <xsl:template name="CurrentSensorsData">
    <xsl:if test="count(/OMA/CurrentProbeList/CurrentProbe[SubType = '26']) &gt; 0">
      <xsl:call-template name="PowerConsumptionTable"/>
    </xsl:if>
    <xsl:if test="count(/OMA/CurrentProbeList/CurrentProbe[SubType = '23']) &gt; 0">
      <xsl:call-template name="AmperageInformationTable"/>
    </xsl:if>
  </xsl:template>

  <xsl:template name="AmperageInformationTable">
    <TableData name="ampinfo" columnspacing="false">
      <xsl:attribute name="display"><xsl:value-of select="$strAmperage"/></xsl:attribute>
      <SubHeader>
        <xsl:attribute name="display"><xsl:value-of select="$strAmperage"/></xsl:attribute>
      </SubHeader>
      <Header>
        <Data>
          <xsl:attribute name="display"><xsl:value-of select="$strLocation"/></xsl:attribute>
          <xsl:attribute name="value"><xsl:value-of select="$strLocation"/></xsl:attribute>
        </Data>
        <Data>
          <xsl:attribute name="display"><xsl:value-of select="$strReading"/></xsl:attribute>
          <xsl:attribute name="value"><xsl:value-of select="$strReading"/></xsl:attribute>
        </Data>
      </Header>
      <xsl:for-each select="/OMA/CurrentProbeList/CurrentProbe[SubType = '23']">
        <Row>
          <Data>
            <xsl:attribute name="value"><xsl:value-of select="ProbeLocation"/></xsl:attribute>
          </Data>
          <Data>
            <xsl:attribute name="value">
            <xsl:call-template name="formatDeciAmpsValue">
              <xsl:with-param name="value"><xsl:value-of select="ProbeReading"/></xsl:with-param>
            </xsl:call-template>
            </xsl:attribute>
          </Data>
        </Row>
      </xsl:for-each>
    </TableData>
  </xsl:template>

  <xsl:template name="PowerConsumptionTable">
    <TableData columnspacing="true" name="powerconinfo">
      <xsl:attribute name="display"><xsl:value-of select="$strPowerConsumption"/></xsl:attribute>
      <xsl:attribute name="status"><xsl:value-of select="ObjStatus"/></xsl:attribute>
      <SubHeader>
        <xsl:attribute name="display"><xsl:value-of select="$strPowerConsumption"/></xsl:attribute>
      </SubHeader>
      <xsl:if test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
        <PromptText><xsl:value-of select="$strClickTheProbe"/></PromptText>
      </xsl:if>
      <Header>
        <Data ignoreonweb="true">
          <xsl:attribute name="display"><xsl:value-of select="$strIndex"/></xsl:attribute>
          <xsl:attribute name="value"><xsl:value-of select="$strIndex"/></xsl:attribute>
        </Data>
        <Data align="center">
          <xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
          <xsl:attribute name="value"><xsl:value-of select="$strStatus"/></xsl:attribute>
        </Data>
        <Data>
          <xsl:attribute name="display"><xsl:value-of select="$strProbeName"/></xsl:attribute>
          <xsl:attribute name="value"><xsl:value-of select="$strProbeName"/></xsl:attribute>
        </Data>
        <Data align="center">
          <xsl:attribute name="display"><xsl:value-of select="$strReading"/></xsl:attribute>
          <xsl:attribute name="value"><xsl:value-of select="$strReading"/></xsl:attribute>
        </Data>
        <Data align="center">
          <xsl:attribute name="display"><xsl:value-of select="$strWarningThreshold"/></xsl:attribute>
          <xsl:attribute name="value"><xsl:value-of select="$strWarningThreshold"/></xsl:attribute>
        </Data>
        <Data align="center">
          <xsl:attribute name="display"><xsl:value-of select="$strFailureThreshold"/></xsl:attribute>
          <xsl:attribute name="value"><xsl:value-of select="$strFailureThreshold"/></xsl:attribute>
        </Data>
      </Header>
      <xsl:for-each select="/OMA/CurrentProbeList/CurrentProbe[SubType = '26']">
        <Row>
          <Data ignoreonweb="true">
            <xsl:attribute name="value"><xsl:value-of select="@index"/></xsl:attribute>
          </Data>
          <Data type="status">
            <xsl:attribute name="value"><xsl:value-of select="@status"/></xsl:attribute>
            <xsl:attribute name="align">center</xsl:attribute>
          </Data>
          <Data>
            <xsl:attribute name="value" ><xsl:value-of select="ProbeLocation"/></xsl:attribute>
            <xsl:if test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
              <xsl:if test="(ProbeThresholds/UCThreshold != '-2147483648') and (ProbeThresholds/UNCThreshold != '-2147483648') and (ProbeReading != '-2147483648')">
                <xsl:choose>
                  <xsl:when test="(Capabilities/ProbeUNCDefSetEnabled = 'false') and (Capabilities/ProbeUNCSetEnabled = 'false')">
                    <!-- need not provide a link to the editable page -->
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:attribute name="link">true</xsl:attribute>
                    <xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.PowerMonitoringProbeWebPlugin&amp;oid=<xsl:value-of select="@oid"/>&amp;help=EditPowerMonProbes</xsl:attribute>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:if>
            </xsl:if>
          </Data>
          <Data>
            <xsl:attribute name="value">
              <xsl:call-template name="formatWattValue">
                <xsl:with-param name="value"><xsl:value-of select="ProbeReading"/></xsl:with-param>
              </xsl:call-template>
            </xsl:attribute>
            <xsl:attribute name="align">center</xsl:attribute>
          </Data>
          <Data>
            <xsl:attribute name="value">
              <xsl:call-template name="formatWattValue">
                <xsl:with-param name="value"><xsl:value-of select="ProbeThresholds/UNCThreshold"/></xsl:with-param>
              </xsl:call-template>
            </xsl:attribute>
            <xsl:attribute name="align">center</xsl:attribute>
          </Data>
          <Data>
            <xsl:attribute name="value">
              <xsl:call-template name="formatWattValue">
                <xsl:with-param name="value"><xsl:value-of select="ProbeThresholds/UCThreshold"/></xsl:with-param>
              </xsl:call-template>
            </xsl:attribute>
            <xsl:attribute name="align">center</xsl:attribute>
          </Data>
        </Row>
      </xsl:for-each>
    </TableData>
  </xsl:template>

  <xsl:template match="PowerConsumptionDataObj">
    <xsl:call-template name="CumulativePower"/>
    <xsl:call-template name="PeakPower"/>
  </xsl:template>

  <xsl:template name="CumulativePower">
    <TableData columnspacing="true" name="cumlpower" >
      <xsl:attribute name="display"><xsl:value-of select="$strPowerTrackStats"/></xsl:attribute>
      <SubHeader>
        <xsl:attribute name="display"><xsl:value-of select="$strPowerTrackStats"/></xsl:attribute>
      </SubHeader>
      <Header>
        <Data>
          <xsl:attribute name="display"><xsl:value-of select="$strStatistic"/></xsl:attribute>
          <xsl:attribute name="value"><xsl:value-of select="$strStatistic"/></xsl:attribute>
        </Data>
        <Data>
          <xsl:attribute name="display"><xsl:value-of select="$strMeasureStartTime"/></xsl:attribute>
          <xsl:attribute name="value"><xsl:value-of select="$strMeasureStartTime"/></xsl:attribute>
        </Data>
        <Data>
          <xsl:attribute name="display"><xsl:value-of select="$strMeasureFinishTime"/></xsl:attribute>
          <xsl:attribute name="value"><xsl:value-of select="$strMeasureFinishTime"/></xsl:attribute>
        </Data>
        <Data align="center">
          <xsl:attribute name="display"><xsl:value-of select="$strReading"/></xsl:attribute>
          <xsl:attribute name="value"><xsl:value-of select="$strReading"/></xsl:attribute>
        </Data>
        <xsl:if test="(/OMA/OMAUserRights = '7')">
          <Data align="center">
            <xsl:attribute name="display"><xsl:value-of select="$strResetReading"/></xsl:attribute>
            <xsl:attribute name="value"><xsl:value-of select="$strResetReading"/></xsl:attribute>
          </Data>
        </xsl:if>
      </Header>
      <Row>
        <Data>
          <xsl:attribute name="value"><xsl:value-of select="$strEnergyConsumption"/></xsl:attribute>
        </Data>
        <Data>
          <xsl:attribute name="value"><xsl:value-of select="/OMA/cwStartTimeDisplay"/></xsl:attribute>
          <xsl:attribute name="align">left</xsl:attribute>
        </Data>
        <Data>
          <xsl:attribute name="value"><xsl:value-of select="/OMA/cwFinishTimeDisplay"/></xsl:attribute>
          <xsl:attribute name="align">left</xsl:attribute>
        </Data>
        <Data>
          <xsl:attribute name="value">
            <xsl:call-template name="formatKiloWattValue">
              <xsl:with-param name="value"><xsl:value-of select="cumulativeWatts"/></xsl:with-param>
            </xsl:call-template>
          </xsl:attribute>
          <xsl:attribute name="align">center</xsl:attribute>
        </Data>
        <xsl:if test="(/OMA/OMAUserRights = '7')">
          <Data id="resetreadid" type="button">
            <xsl:attribute name="value"><xsl:value-of select="$strReset"/></xsl:attribute>
            <xsl:attribute name="tablebutton">true</xsl:attribute>
            <xsl:attribute name="href">javascript:resetreadings(1)</xsl:attribute>
            <xsl:attribute name="formSubmit">true</xsl:attribute>
            <xsl:attribute name="align">center</xsl:attribute>
          </Data>
        </xsl:if>
      </Row>
    </TableData>
  </xsl:template>
  
  <xsl:template name="PeakPower">
    <TableData columnspacing="true" name="peakpower">
      <Header>
        <Data>
          <xsl:attribute name="display"><xsl:value-of select="$strStatistic"/></xsl:attribute>
          <xsl:attribute name="value"><xsl:value-of select="$strStatistic"/></xsl:attribute>
        </Data>
        <Data>
          <xsl:attribute name="display"><xsl:value-of select="$strMeasureStartTime"/></xsl:attribute>
          <xsl:attribute name="value"><xsl:value-of select="$strMeasureStartTime"/></xsl:attribute>
        </Data>
        <Data>
          <xsl:attribute name="display"><xsl:value-of select="$strPeakTime"/></xsl:attribute>
          <xsl:attribute name="value"><xsl:value-of select="$strPeakTime"/></xsl:attribute>
        </Data>
        <Data align="center">
          <xsl:attribute name="display"><xsl:value-of select="$strPeakReading"/></xsl:attribute>
          <xsl:attribute name="value"><xsl:value-of select="$strPeakReading"/></xsl:attribute>
        </Data>
        <xsl:if test="(/OMA/OMAUserRights = '7')">
          <Data align="center">
            <xsl:attribute name="display"><xsl:value-of select="$strResetReading"/></xsl:attribute>
            <xsl:attribute name="value"><xsl:value-of select="$strResetReading"/></xsl:attribute>
          </Data>
        </xsl:if>
      </Header>
      <Row>
        <Data>
          <xsl:attribute name="value"><xsl:value-of select="$strSystemPeakPower"/></xsl:attribute>
        </Data>
        <Data>
          <xsl:attribute name="value"><xsl:value-of select="/OMA/pwStartTimeDisplay"/></xsl:attribute>
          <xsl:attribute name="align">left</xsl:attribute>
        </Data>
        <Data>
          <xsl:attribute name="value"><xsl:value-of select="/OMA/pwReadingTimeDisplay"/></xsl:attribute>
          <xsl:attribute name="align">left</xsl:attribute>
        </Data>
        <Data>
          <xsl:attribute name="value">
            <xsl:call-template name="formatWattValue">
                <xsl:with-param name="value"><xsl:value-of select="peakWatts"/></xsl:with-param>
            </xsl:call-template>
          </xsl:attribute>
          <xsl:attribute name="align">center</xsl:attribute>
        </Data>
        <xsl:if test="(/OMA/OMAUserRights = '7')">
          <Data id="resetreadid" rowspan="2" type="button">
            <xsl:attribute name="value"><xsl:value-of select="$strReset"/></xsl:attribute>
            <xsl:attribute name="tablebutton">true</xsl:attribute>
            <xsl:attribute name="href">javascript:resetreadings(2)</xsl:attribute>
            <xsl:attribute name="formSubmit">true</xsl:attribute>
            <xsl:attribute name="align">center</xsl:attribute>
          </Data>
        </xsl:if>
      </Row>
      <xsl:variable name="peakamp"><xsl:value-of select="peakAmps"/></xsl:variable>
      <xsl:if test="$peakamp != ''">
      <Row>
        <Data>
          <xsl:attribute name="value" ><xsl:value-of select="$strSystemPeakAmperage"/></xsl:attribute>
        </Data>
        <Data> 
          <xsl:attribute name="value"><xsl:value-of select="/OMA/paStartTimeDisplay"/></xsl:attribute>
          <xsl:attribute name="align">left</xsl:attribute>
        </Data>
        <Data>
          <xsl:attribute name="value"><xsl:value-of select="/OMA/paReadingTimeDisplay"/></xsl:attribute>
          <xsl:attribute name="align">left</xsl:attribute>
        </Data>
        <Data>
          <xsl:attribute name="value">
            <xsl:call-template name="formatDeciAmpsValue">
              <xsl:with-param name="value"><xsl:value-of select="peakAmps"/></xsl:with-param>
            </xsl:call-template>
          </xsl:attribute>
          <xsl:attribute name="align">center</xsl:attribute>
        </Data>
      </Row>
      </xsl:if>
    </TableData>
  </xsl:template>

  <xsl:template name="formatWattValue">
    <xsl:param name="value"/>
    <xsl:choose>
      <xsl:when test="$value = '-2147483648'"><xsl:value-of select="$strNA"/></xsl:when>
      <xsl:when test="$value = ''"><xsl:value-of select="$strNA"/></xsl:when>
      <xsl:otherwise><xsl:value-of select="$value"/><xsl:value-of select="$strWattUnit"/></xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="formatKiloWattValue">
    <xsl:param name="value"/>
    <xsl:choose>
      <xsl:when test="$value = '-2147483648'"><xsl:value-of select="$strNA"/></xsl:when>
      <xsl:when test="$value = ''"><xsl:value-of select="$strNA"/></xsl:when>
      <xsl:otherwise>
        <xsl:variable name="formatval"><xsl:value-of select="format-number($value div 1000,'##0.0')"/></xsl:variable>
					<xsl:variable name="univdecsep">
						<xsl:choose>
							<xsl:when test="substring(format-number(1.1,'##0.0'), 2, 1) = '.'">.</xsl:when>
							<xsl:when test="substring(format-number(1.1,'##0.0'), 2, 1) = ','">,</xsl:when>
						</xsl:choose>
					</xsl:variable>
					<xsl:variable name="localdecsep"><xsl:value-of select="$strDecimalFractionSeperator"/></xsl:variable>
					<xsl:value-of select="translate($formatval, $univdecsep,$localdecsep)"/><xsl:value-of select="$strKiloWattHrUnit"/>        
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="formatDeciAmpsValue">
    <xsl:param name="value"/>
    <xsl:choose>
      <xsl:when test="$value = '-2147483648'"><xsl:value-of select="$strNA"/></xsl:when>
      <xsl:when test="$value = ''"><xsl:value-of select="$strNA"/></xsl:when>
      <xsl:otherwise>
        <xsl:variable name="formatval"><xsl:value-of select="format-number($value div 10,'##0.0')"/></xsl:variable>
					<xsl:variable name="univdecsep">
						<xsl:choose>
							<xsl:when test="substring(format-number(1.1,'##0.0'), 2, 1) = '.'">.</xsl:when>
							<xsl:when test="substring(format-number(1.1,'##0.0'), 2, 1) = ','">,</xsl:when>
						</xsl:choose>
					</xsl:variable>
					<xsl:variable name="localdecsep"><xsl:value-of select="$strDecimalFractionSeperator"/></xsl:variable>
					<xsl:value-of select="translate($formatval, $univdecsep,$localdecsep)"/><xsl:value-of select="$strAmperageUnit"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
    
  <xsl:template name="smstatus">
    <xsl:param name="status"/>
    <xsl:param name="mssg"/>
    <xsl:choose>
      <xsl:when test="$status = '-1'"><xsl:value-of select="$strCommandUnsuccessful"/></xsl:when>
      <xsl:when test="$status = '0'"><xsl:value-of select="$strCommandSuccessful"/></xsl:when>
      <xsl:when test="$status = '256'"><xsl:value-of select="$strCurrentProbesNotFound"/></xsl:when>
      <xsl:otherwise>SMStatus: <xsl:value-of select="$status"/></xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>

