<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:variable name="allowEdits">
		<xsl:choose>
			<xsl:when test="/OMA/OMAUserRights &lt; '7' or /OMA/@cli = 'true'">false</xsl:when>
			<xsl:otherwise>true</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="controlsNotAvailable">
		<xsl:choose>
			<xsl:when test="(
								not(/OMA/ChassisProps/ChassisInfo/ChassisProps2) or
								(/OMA/ChassisProps/ChassisInfo/ChassisProps2/PowerButtonControl = '0' and
									/OMA/ChassisProps/ChassisInfo/ChassisProps2/NMIButtonControl = '0')
							) and not(/OMA/LCDProps/LCDObj)">true</xsl:when>
			<xsl:otherwise>false</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:template match="/OMA">
		<DataArea exportdata="false" validate="true">
			<xsl:choose>
				<xsl:when test="/OMA/@cli = 'true' and $controlsNotAvailable = 'true'">
					<PageTitle display="{$strErrorNoFront}"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="(/OMA/OMAUserRights = '7')">
						<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.hip.webplugins.SetPwrButtonWebPlugin</xsl:attribute>
					</xsl:if>
					<PageTitle display="{$strFrontPanelInfo}"/>
					<CustomButton>
						<Data display="{$strRefresh}">
							<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.PwrButtonWebPlugin&amp;poid=<xsl:value-of select="/OMA/ChassisProps/Chassis/@oid"/>&amp;help=pwrbutton&amp;app=hip&amp;ct=MainChassis&amp;snb=Properties&amp;lsnb=PowerButton</xsl:attribute>
						</Data>
					</CustomButton>
		
					<script language="javascript">
						function validate() {
							var returnVal = true;
							if (typeof(ValidateLcdLines) == "function") {
								returnVal = ValidateLcdLines();
							}
							return returnVal;
						}
					</script>
		
					<xsl:choose>
						<xsl:when test="$controlsNotAvailable = 'true'">
							<!-- no information available: -->
							<PromptText><xsl:value-of select="$strNoInfoAvailable"/></PromptText>
						</xsl:when>
						<xsl:otherwise>
							<!-- draw Buttons table -->
							<xsl:apply-templates select="ChassisProps/ChassisInfo/ChassisProps2"/>
							<!-- draw LCD info -->
							<xsl:apply-templates select="LCDProps"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</DataArea>
	</xsl:template>

	<xsl:template match="ChassisProps2">
		<xsl:choose>
			<xsl:when test="PowerButtonControl = '0' and NMIButtonControl = '0'"/>
			<xsl:when test="$allowEdits = 'true'">
				<TableData name="buttonsTbl" display="{$strFrontPanelButtons}">
					<SubHeader display="{$strFrontPanelButtons}"/>
					<!-- draw row for power button -->
					<xsl:if test="PowerButtonControl != '0'">
						<Row>
							<Data name="oid" type="hidden" returnvalue="{@oid}"/>
							<Data name="pwrbtnctrl" display="{$strPowerButton}" value="{$strPowerButton}"/>
							<Data name="PowerButtonControl" returnvalue="1" type="radio" value="{$strEnabled}">
								<xsl:if test="PowerButtonControl = '1'">
									<xsl:attribute name="state">1</xsl:attribute>
								</xsl:if>
							</Data>
							<Data name="PowerButtonControl" returnvalue="2" type="radio" value="{$strDisabled}">
								<xsl:if test="PowerButtonControl = '2'">
									<xsl:attribute name="state">1</xsl:attribute>
								</xsl:if>
							</Data>
						</Row>
					</xsl:if>
					<!-- draw row for NMI button -->
					<xsl:if test="NMIButtonControl != '0'">
						<Row>
							<Data name="oid" type="hidden" returnvalue="{@oid}"/>
							<Data type="ustring" name="nmibtnctrl" display="{$strNMIButton}" value="{$strNMIButton}"/>
							<Data name="NMIButtonControl" returnvalue="1" type="radio" value="{$strEnabled}">
								<xsl:if test="NMIButtonControl = '1'">
									<xsl:attribute name="state">1</xsl:attribute>
								</xsl:if>
							</Data>
							<Data name="NMIButtonControl" returnvalue="2" type="radio" value="{$strDisabled}">
								<xsl:if test="NMIButtonControl = '2'">
									<xsl:attribute name="state">1</xsl:attribute>
								</xsl:if>
							</Data>
						</Row>
					</xsl:if>
				</TableData>
			</xsl:when>
			<xsl:otherwise>
				<ListData type='custom'>
					<SubHeader display="{$strFrontPanelButtons}"/>
					<!-- draw row for power button -->
					<xsl:if test="PowerButtonControl != '0'">
						<Data display="{$strPowerButton}">
							<xsl:if test="PowerButtonControl = 1"><xsl:attribute name="value"><xsl:value-of select="$strEnabled"/></xsl:attribute></xsl:if>
							<xsl:if test="PowerButtonControl = 2"><xsl:attribute name="value"><xsl:value-of select="$strDisabled"/></xsl:attribute></xsl:if>
						</Data>
					</xsl:if>
					<!-- draw row for NMI button -->
					<xsl:if test="NMIButtonControl != '0'">
						<Data display="{$strNMIButton}">
							<xsl:if test="NMIButtonControl = 1"><xsl:attribute name="value"><xsl:value-of select="$strEnabled"/></xsl:attribute></xsl:if>
							<xsl:if test="NMIButtonControl = 2"><xsl:attribute name="value"><xsl:value-of select="$strDisabled"/></xsl:attribute></xsl:if>
						</Data>
					</xsl:if>
				</ListData>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="LCDProps">
		<xsl:variable name="lcdConfigCustomVal" select="'0'"/>
		<xsl:variable name="lcdConfigDefaultVal" select="'1'"/>
		<xsl:variable name="lcdConfigNoneVal" select="'2'"/>
		<xsl:choose>
			<xsl:when test="not(LCDObj) or LCDObj/maxLines &lt; 1"/>
			<xsl:when test="$allowEdits = 'true'">
				<xsl:variable name="lcdCharsetAscii" select="'0'"/>
				<xsl:variable name="lcdRadioBtnName" select="'LcdLineRadio_'"/>
				<xsl:variable name="lcdEditBoxName" select="'LcdLineEdit_'"/>
				<xsl:variable name="lcdMaxlinesHdnName" select="'LcdMaxLines'"/>
				<xsl:variable name="lcdCharsetHdnName" select="'LcdOldCharSet'"/>
				<script language="javascript">
					function LcdLineRadioClicked(radioBtn) {
						var lastUnderscore = radioBtn.id.lastIndexOf("_");
						var lineNum = radioBtn.id.substring(lastUnderscore + 1, radioBtn.id.length);
						var type = radioBtn.id.substring(radioBtn.id.lastIndexOf("_", lastUnderscore - 1) + 1, lastUnderscore);
						var editbox = document.getElementById("<xsl:value-of select="$lcdEditBoxName"/>" + lineNum);
						if (editbox != null) {
							switch(type) {
								case "None":
								case "Default":
									// set edit box to readonly:
									editbox.disabled = true;
									break;
								case "Custom":
									// set edit box to writable:
									editbox.disabled = false;
									// move focus to editbox
									editbox.focus();
									editbox.select();
									break;
							}
						}
					}
					
					function ValidateLcdLines() {
						var returnVal = true, maxLines = 0, charSet = 0, tempObj,
							customRadio, editbox, editboxText, char1, errorsText = "", badEditbox = null;

						tempObj = document.getElementById("<xsl:value-of select="$lcdMaxlinesHdnName"/>");
						if (tempObj != null) {
							maxLines = tempObj.value;
						}

						tempObj = document.getElementById("<xsl:value-of select="$lcdCharsetHdnName"/>");
						if (tempObj != null) {
							charSet = tempObj.value;
						}

						for (var ii = 0; ii &lt; maxLines; ++ii) {
							customRadio = document.getElementById("<xsl:value-of select="$lcdRadioBtnName"/>Custom_" + ii);
							editbox = document.getElementById("<xsl:value-of select="$lcdEditBoxName"/>" + ii);
							if (customRadio != null &amp;&amp; editbox != null) {
								if (customRadio.checked == true) {
									editboxText = editbox.value;
									switch (charSet) {
										case "<xsl:value-of select="$lcdCharsetAscii"/>":
											// make sure text in editbox is ASCII:
											for (var jj = 0; jj &lt; editboxText.length; ++jj) {
												char1 = editboxText.charCodeAt(jj);
												if (char1 &lt; 0x20 /* space */ || char1 &gt; 0x7e) {
													if (errorsText.length &gt; 0) {
														errorsText += "\n";
													}
													errorsText += "<xsl:value-of select="$strJScriptErr1Part1"/> " + (ii + 1) + " <xsl:value-of select="$strJScriptErr1Part2"/>";
													returnVal = false;
													if (badEditbox == null) {
														badEditbox = editbox;
													}
													break;
												}
											}
											break;
										default:
											returnVal = false;
									}
								}
							}
						}

						if (returnVal == false &amp;&amp; errorsText.length &gt; 0) {
							errorsText += "\n\n<xsl:value-of select="$strJScriptErr1Part3"/>";
							alert(errorsText);
							if (badEditbox != null) {
								badEditbox.focus();
								badEditbox.select();
							}
						}

						return returnVal;
					}
				</script>

				<TableData name="lcdTbl" display="{$strFrontPanelLCD}">
					<SubHeader display="{$strFrontPanelLCD}"/>
					<xsl:for-each select="LCDLineObj">
						<xsl:sort select="index" data-type="number"/>
						<xsl:variable name="lcdid">
							<xsl:choose>
								<xsl:when test="index"><xsl:value-of select="index"/></xsl:when>
								<xsl:otherwise><xsl:value-of select="position() - 1"/></xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<Row>
							<Data display="{$strLcdLine} {position()}" value="{$strLcdLine} {position()}"/>
							<Data name="{$lcdRadioBtnName}{$lcdid}" id="{$lcdRadioBtnName}None_{$lcdid}" returnvalue="{$lcdConfigNoneVal}" type="radio" value="{$strLcdConfigNone}" event="onClick" handler="javascript:LcdLineRadioClicked(this);">
								<xsl:if test="state = $lcdConfigNoneVal">
									<xsl:attribute name="state">1</xsl:attribute>
								</xsl:if>
							</Data>
							<Data name="{$lcdRadioBtnName}{$lcdid}" id="{$lcdRadioBtnName}Default_{$lcdid}" returnvalue="{$lcdConfigDefaultVal}" type="radio" value="{$strLcdConfigDefault}" event="onClick" handler="javascript:LcdLineRadioClicked(this);">
								<xsl:if test="state = $lcdConfigDefaultVal">
									<xsl:attribute name="state">1</xsl:attribute>
								</xsl:if>
							</Data>
							<Data name="{$lcdRadioBtnName}{$lcdid}" id="{$lcdRadioBtnName}Custom_{$lcdid}" returnvalue="{$lcdConfigCustomVal}" type="radio" value="{$strLcdConfigCustom}:" event="onClick" handler="javascript:LcdLineRadioClicked(this);">
								<xsl:if test="state = $lcdConfigCustomVal">
									<xsl:attribute name="state">1</xsl:attribute>
								</xsl:if>
							</Data>
							<Data name="{$lcdEditBoxName}{$lcdid}" type="editbox">
								<xsl:attribute name="size"><xsl:value-of select="maxLineSize"/></xsl:attribute>
								<xsl:attribute name="maxlength"><xsl:value-of select="maxLineSize"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="LCDstring"/></xsl:attribute>
								<xsl:attribute name="state">
									<xsl:choose>
										<xsl:when test="state != $lcdConfigCustomVal">2</xsl:when>
										<xsl:otherwise>1</xsl:otherwise>
									</xsl:choose>
								</xsl:attribute>
							</Data>
						</Row>
					</xsl:for-each>
				</TableData>
				<HiddenTable>
					<Data id="{$lcdMaxlinesHdnName}" name="{$lcdMaxlinesHdnName}" returnvalue="{LCDObj/maxLines}"/>
					<Data id="{$lcdCharsetHdnName}" name="{$lcdCharsetHdnName}" returnvalue="{LCDObj/charSet}"/>
					<xsl:for-each select="LCDLineObj">
						<xsl:sort select="index" data-type="number"/>
						<xsl:variable name="lcdid">
							<xsl:choose>
								<xsl:when test="index"><xsl:value-of select="index"/></xsl:when>
								<xsl:otherwise><xsl:value-of select="position() - 1"/></xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<Data id="LcdLineOldState_{$lcdid}" name="LcdLineOldState_{$lcdid}" returnvalue="{state}"/>
						<Data id="LcdLineOldString_{$lcdid}" name="LcdLineOldString_{$lcdid}" returnvalue="{LCDstring}"/>
					</xsl:for-each>
				</HiddenTable>
			</xsl:when>
			<xsl:otherwise>	<!-- list info only -->
				<ListData type='custom'>
					<SubHeader display="{$strFrontPanelLCD}"/>
					<xsl:for-each select="LCDLineObj">
						<xsl:sort select="index" data-type="number"/>
						<Data display="{$strLcdLine} {position()}">
							<xsl:attribute name="value">
								<xsl:choose>
									<xsl:when test="state = $lcdConfigCustomVal">
										<xsl:value-of select="LCDstring"/>
									</xsl:when>
									<xsl:when test="state = $lcdConfigDefaultVal">
										<xsl:value-of select="$strLcdConfigDefaultSettings"/>
									</xsl:when>
									<xsl:when test="state = $lcdConfigNoneVal">
										<xsl:value-of select="$strLcdConfigNone"/>
									</xsl:when>
								</xsl:choose>
							</xsl:attribute>
						</Data>
					</xsl:for-each>
				</ListData>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
