<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:strip-space elements="*"/>
<xsl:output method="xml" indent="no"/>
<xsl:template match="/OMA">
	<xsl:choose>
		<xsl:when test="SMStatus != '0'">
			<DataArea printable="false">
				<TableData>
					<Header>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strError"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strError1"/></xsl:attribute>
						</Data>
					</Header>
					<Row>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strNICObjectNot"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strNICObjectNot1"/></xsl:attribute>
						</Data>
					</Row>
				</TableData>
			</DataArea>
		</xsl:when>
		<xsl:otherwise>
			<DataArea>
				<PageTitle>
					<xsl:attribute name="display"><xsl:value-of select="$strNetworkCardsInformation"/></xsl:attribute>
				</PageTitle>
				<CustomButton>
					<Data name="Refresh"><xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
						<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.NICListWebPlugin&amp;help=NIC&amp;poid=2</xsl:attribute>
					</Data>
				</CustomButton>
				<xsl:call-template name="MainHeading"/>
				<xsl:apply-templates select="NICList "/>
			</DataArea>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="MainHeading">
	<ListData type="custom">
		<Data width="300">
			<xsl:attribute name="display"><xsl:value-of select="$strTotalNumberOf"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="/OMA/NICList/@count"/></xsl:attribute>
		</Data>
	</ListData>
</xsl:template>
<xsl:template match="NICList ">
	<TableData columnspacing="true">
		<PromptText><xsl:value-of select="$strClickTheIP"/></PromptText>
		<Header>
			<Data ignoreonweb="true">
				<xsl:attribute name="display"><xsl:value-of select="$strIndex"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strIndex1"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strIPAddress"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strIPAddress1"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strVendor"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strVendor1"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strDescription"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strDescription1"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strConnectionStatus"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strConnectionStatus1"/></xsl:attribute>
			</Data>
		</Header>
		<xsl:apply-templates select="NICCard"/>		
	</TableData>
</xsl:template>
<xsl:template match="NICCard">
	<Row>
		<Data ignoreonweb="true">
			<xsl:attribute name="display"><xsl:value-of select="@index"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="@index"/></xsl:attribute>
		</Data>
		<Data>
			<xsl:choose>
				<xsl:when test="IPAddress = ''">
					<xsl:attribute name="display"><xsl:value-of select="$strNotObtained"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strNotObtained1"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="display"><xsl:value-of select="IPAddress"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="IPAddress"/></xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:attribute name="link">true</xsl:attribute>
			<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.NICCardWebPlugin&amp;help=NICInfo&amp;oid=<xsl:value-of select="@oid"/></xsl:attribute>
		</Data>
		<Data name="Vendor" type="ustring"><xsl:attribute name="display"><xsl:value-of select="$strVendor2"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="Vendor"/></xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="Vendor"/></xsl:attribute>
		</Data>
		<Data name="Description" type="ustring"><xsl:attribute name="display"><xsl:value-of select="$strDescription2"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="Description"/></xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="Description"/></xsl:attribute>
		</Data>
		<Data name="Connection Status" type="ustring"><xsl:attribute name="display"><xsl:value-of select="$strConnectionStatus2"/></xsl:attribute>
			<xsl:choose>
				<xsl:when test="NICStatus='0'">
					<xsl:attribute name="display"><xsl:value-of select="$strNotObtained"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strNotObtained"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="NICStatus='1'">
					<xsl:attribute name="display"><xsl:value-of select="$strConnected"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strConnected1"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="NICStatus='2'">
					<xsl:attribute name="display"><xsl:value-of select="$strDisconnected"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strDisconnected1"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="NICStatus='3'">
					<xsl:attribute name="display"><xsl:value-of select="$strDriverNotInstalled"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strDriverNotInstalled1"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="NICStatus='4'">
					<xsl:attribute name="display"><xsl:value-of select="$strDisabled"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strDisabled1"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="NICStatus='10'">
					<xsl:attribute name="display"><xsl:value-of select="$strInitializing"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strInitializing1"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="NICStatus='11'">
					<xsl:attribute name="display"><xsl:value-of select="$strResetting"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strResetting1"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="NICStatus='12'">
					<xsl:attribute name="display"><xsl:value-of select="$strClosing"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strClosing1"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="NICStatus='13'">
					<xsl:attribute name="display"><xsl:value-of select="$strAdapterNotReady"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strAdapterNotReady1"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="display"><xsl:value-of select="$strNoValue2"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strNoValue3"/></xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
		</Data>
	</Row>
</xsl:template>
<xsl:template match="*"/>
</xsl:stylesheet>
