<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:strip-space elements="*"/>
<xsl:output method="xml" indent="no"/>
<xsl:template match="/OMA">
<xsl:choose>
	<xsl:when test="SMStatus != '0'">
		<DataArea printable="false">
			<TableData>
				<Header>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strError"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strError1"/></xsl:attribute>
					</Data>
				</Header>
				<Row>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strNICObjectNot"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strNICObjectNot1"/></xsl:attribute>
					</Data>
				</Row>
			</TableData>
		</DataArea>
	</xsl:when>
	<xsl:otherwise>
		<DataArea backpagetarget="/servlet/DataArea?plugin=com.dell.hip.webplugins.NICListWebPlugin&amp;help=NIC&amp;poid=2">
			<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strNetworkCards"/></xsl:attribute>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strNetworkCardInformation"/></xsl:attribute>
			</PageTitle>
			<SubHeader>
			 	<xsl:attribute name="display"><xsl:value-of select="$strCard"/><xsl:value-of select="NICCard/Description"/></xsl:attribute>		
			</SubHeader>			
			<CustomButton>
				<Data name="Refresh"><xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.NICCardWebPlugin&amp;help=NICInfo&amp;oid=<xsl:value-of select="NICCard/@oid"/></xsl:attribute>
				</Data>
			</CustomButton>
			<xsl:apply-templates select="NICCard"/>
		</DataArea>
	</xsl:otherwise>
</xsl:choose>
</xsl:template>
<xsl:template match="NICCard">
	<ListData type="custom">
		<xsl:if test="Description!=''">
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strDescription"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="Description"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="Vendor!=''">
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strVendor"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="Vendor"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="CurrentMACAddr!=''">
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strCurrentMACAddress"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="CurrentMACAddr"/></xsl:attribute>
			</Data>
		</xsl:if>		
		<Data>
			<xsl:attribute name="display"><xsl:value-of select="$strIPAddress"/></xsl:attribute>
			<xsl:choose>
				<xsl:when test="IPAddress=''">
					<xsl:attribute name="value"><xsl:value-of select="$strNoValue2"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="value"><xsl:value-of select="IPAddress"/></xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
		</Data>
		<xsl:if test="SubnetMask!=''">
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strSubnetMask"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="SubnetMask"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="DHCPServer!=''">
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strDHCPServer"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="DHCPServer"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="DefaultGateway!=''">
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strDefaultGateway"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="DefaultGateway"/></xsl:attribute>
			</Data>
		</xsl:if>
		<Data>
			<xsl:attribute name="display"><xsl:value-of select="$strConnectionStatus"/></xsl:attribute>
			<xsl:choose>
				<xsl:when test="NICStatus='1'">
					<xsl:attribute name="value"><xsl:value-of select="$strConnected"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="NICStatus='2'">
					<xsl:attribute name="value"><xsl:value-of select="$strDisconnected"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="NICStatus='3'">
					<xsl:attribute name="value"><xsl:value-of select="$strDriverNotInstalled"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="NICStatus='4'">
					<xsl:attribute name="value"><xsl:value-of select="$strDisabled"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="NICStatus='10'">
					<xsl:attribute name="value"><xsl:value-of select="$strInitializing"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="NICStatus='11'">
					<xsl:attribute name="value"><xsl:value-of select="$strResetting"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="NICStatus='12'">
					<xsl:attribute name="value"><xsl:value-of select="$strClosing"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="NICStatus='13'">
					<xsl:attribute name="value"><xsl:value-of select="$strAdapterNotReady"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="value"><xsl:value-of select="$strNoValue6"/></xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
		</Data>
		<xsl:if test="NICTOECapability!='0'">
		    <Data>
			    <xsl:attribute name="display"><xsl:value-of select="$strTOECapable"/></xsl:attribute>
			    <xsl:choose>
				    <xsl:when test="NICTOECapability='1'">
					    <xsl:attribute name="value"><xsl:value-of select="$strTOECapability0"/></xsl:attribute>
				    </xsl:when>
				    <xsl:when test="NICTOECapability='2'">
					    <xsl:attribute name="value"><xsl:value-of select="$strTOECapability1"/></xsl:attribute>
				    </xsl:when>
				    <xsl:when test="NICTOECapability='4'">
					    <xsl:attribute name="value"><xsl:value-of select="$strTOECapability2"/></xsl:attribute>
				    </xsl:when>
				    <xsl:when test="NICTOECapability='8'">
					    <xsl:attribute name="value"><xsl:value-of select="$strTOECapability3"/></xsl:attribute>
				    </xsl:when>
				    <xsl:when test="NICTOECapability='16'">
					    <xsl:attribute name="value"><xsl:value-of select="$strTOECapability4"/></xsl:attribute>
				    </xsl:when>
				    <xsl:otherwise>
					    <xsl:attribute name="value"><xsl:value-of select="$strNoValue"/></xsl:attribute>
				    </xsl:otherwise>
			    </xsl:choose>
		    </Data>
		    <Data>
			    <xsl:attribute name="display"><xsl:value-of select="$strTOEEnabled"/></xsl:attribute>
			    <xsl:choose>
				    <xsl:when test="NICTOEEnabled='true'">
					    <xsl:attribute name="value"><xsl:value-of select="$strTOEEnabled0"/></xsl:attribute>
				    </xsl:when>
				    <xsl:otherwise>
					    <xsl:attribute name="value"><xsl:value-of select="$strTOEEnabled1"/></xsl:attribute>
				    </xsl:otherwise>
			    </xsl:choose>
		    </Data>
		</xsl:if>
		<xsl:if test="DriverImagePath!=''">
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strDriverImagePath"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="DriverImagePath"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="DriverVersion!=''">
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strDriverVersion"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="DriverVersion"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:choose>
			<xsl:when test="/OMA/OSType='2'">
				<xsl:call-template name="SYSTEM_LINUX"/>
			</xsl:when>
			<xsl:when test="/OMA/OSType='3'">
				<xsl:call-template name="SYSTEM_NETWARE"/>
			</xsl:when>
		</xsl:choose>	
	 	</ListData>
</xsl:template>
<xsl:template name="SYSTEM_NETWARE">
		<Data>
			<xsl:attribute name="display"><xsl:value-of select="$strLogicalNameOf"/></xsl:attribute>
			<xsl:choose>
				<xsl:when test="ServiceName=''">
					<xsl:attribute name="value"><xsl:value-of select="$strNoValue13"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="value"><xsl:value-of select="ServiceName"/></xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>			
		</Data>
</xsl:template>
<xsl:template name="SYSTEM_LINUX">
	<Data>
		<xsl:attribute name="display"><xsl:value-of select="$strIRQUsedBy"/></xsl:attribute>
		<xsl:choose>	
			<xsl:when test="IRQ=''">
				<xsl:attribute name="value"><xsl:value-of select="$strNoValue20"/></xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="value"><xsl:value-of select="IRQ"/></xsl:attribute>
			</xsl:otherwise>
		</xsl:choose>
	</Data>		
</xsl:template>
<xsl:template match="*"/>
</xsl:stylesheet>
