<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:strip-space elements="*"/>

<xsl:template match="/OMA">
	<xsl:choose>
		<xsl:when test="SMStatus='0'"><xsl:call-template name="success"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="failure"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="failure">
	<DataArea>
		<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strMemory"/></xsl:attribute>	
		<xsl:attribute name="backpagetarget">/servlet/DataArea?plugin=com.dell.hip.webplugins.MemoryArrayWebPlugin&amp;poid=2&amp;help=Memory</xsl:attribute>
		<PageTitle>
			<xsl:attribute name="display"><xsl:value-of select="$strMemoryDevice"/></xsl:attribute>
		</PageTitle>
		<TableData>
			<Header>
				<Data name="">
					<xsl:attribute name="display"><xsl:value-of select="$strError"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strError1"/></xsl:attribute>
				</Data>
			</Header>
			<Row>
				<Data name="" ><xsl:attribute name="display"><xsl:value-of select="$str"/></xsl:attribute>
					<xsl:attribute name="value">
						<xsl:call-template name="smstatus">
							<xsl:with-param name="status"><xsl:value-of select="SMStatus"/></xsl:with-param>
						</xsl:call-template>
					</xsl:attribute>
				</Data>
			</Row>
		</TableData>
	</DataArea>
</xsl:template>

<xsl:template name="success">
	<DataArea>			
		<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strMemory1"/></xsl:attribute>	
		<xsl:attribute name="backpagetarget">/servlet/DataArea?plugin=com.dell.hip.webplugins.MemoryArrayWebPlugin&amp;poid=2&amp;help=Memory</xsl:attribute>
		
		<xsl:if test="(OMAUserRights='7') or (OMAUserRights='3')">
			<script language="javascript">
				function clearErr()
				{
					var oid 	= <xsl:value-of select="ServletArguments/@oid"/>;
					var check 	= <xsl:value-of select="MemDevList/MemoryDevice/@oid"/>;
					document.getElementById("dataarea").action=top.gnv.appendVID('/servlet/SubmitForm?plugin=com.dell.hip.webplugins.ClrMemErrCountWebPlugin&amp;oid=' + oid + '&amp;check=' + check);
					document.getElementById("dataarea").submit();
				}
			</script>
		</xsl:if>
		
		<PageTitle>
			<xsl:attribute name="display"><xsl:value-of select="$strMemoryDevice1"/></xsl:attribute>
			<xsl:attribute name="status"><xsl:value-of select="ObjStatus"/></xsl:attribute>
		</PageTitle>
		<CustomButton>
			<xsl:call-template name="submit"/>
			<Data name="Refresh">
				<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
				<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.MemoryDeviceListWebPlugin&amp;oid=<xsl:value-of select="ServletArguments/@oid"/>&amp;help=MemoryDevice</xsl:attribute>
			</Data>
		</CustomButton>
		
		<TableData>
			<SubHeader>
				<xsl:attribute name="display">
					<xsl:call-template name="devlocator">
						<xsl:with-param name="count"><xsl:value-of select="MemDevList/@count"/></xsl:with-param>
						<xsl:with-param name="locator"><xsl:value-of select="ExtName"/></xsl:with-param>
					</xsl:call-template>
				</xsl:attribute>	
			</SubHeader>
			
			<Header>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strAttributes"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strAttributes1"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strValues"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strValues1"/></xsl:attribute>
				</Data>
			</Header>
			
			<Row>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strStatus1"/></xsl:attribute>
				</Data>
				<xsl:for-each select="MemDevList/MemoryDevice">
					<Data type="status-text">
						<xsl:attribute name="value"><xsl:value-of select="@status" /></xsl:attribute>
					</Data>			
				</xsl:for-each>		
			</Row>		
			<Row>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strDeviceName"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strDeviceName1"/></xsl:attribute>
				</Data>
				<xsl:for-each select="MemDevList/MemoryDevice">
					<Data>
						<xsl:attribute name="display"><xsl:call-template name="devname"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:call-template name="devname"/></xsl:attribute>
					</Data>			
				</xsl:for-each>
			</Row>
			<Row>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strSize"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strSize1"/></xsl:attribute>
				</Data>
				<xsl:for-each select="MemDevList/MemoryDevice">
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="SizeMB"/><xsl:text disable-output-escaping="yes"> </xsl:text>
							<xsl:call-template name="displayunits"><xsl:with-param name="unit"><xsl:value-of select="SizeMB/@unit"/></xsl:with-param></xsl:call-template>
						</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="SizeMB"/><xsl:text disable-output-escaping="yes"> </xsl:text>
							<xsl:call-template name="displayunits"><xsl:with-param name="unit"><xsl:value-of select="SizeMB/@unit"/></xsl:with-param></xsl:call-template>											</xsl:attribute>
					</Data>			
				</xsl:for-each>		
			</Row>		
			<Row>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strType"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strType1"/></xsl:attribute>
				</Data>
				<xsl:for-each select="MemDevList/MemoryDevice">
					<Data>
						<xsl:attribute name="display"><xsl:call-template name="Type"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:call-template name="Type"/></xsl:attribute>
					</Data>			
				</xsl:for-each>
			</Row>	
			<Row>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strSpeed"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strSpeed1"/></xsl:attribute>
				</Data>
				<xsl:for-each select="MemDevList/MemoryDevice">
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="SpeedInString"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="SpeedInString"/></xsl:attribute>
					</Data>			
				</xsl:for-each>		
			</Row>		
						
			<Row>
				<Data valign="top">
					<xsl:attribute name="display"><xsl:value-of select="$strFailures"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strFailures1"/></xsl:attribute>
				</Data>
				
				<xsl:for-each select="MemDevList/MemoryDevice">
					<xsl:apply-templates select="FailureModes" />
				</xsl:for-each>
			</Row>
						
	
		</TableData>
	</DataArea>
</xsl:template>

<xsl:template name="displayunits">
	<xsl:param name="unit"/>
	<xsl:choose>
		<xsl:when test="$unit='MB'"><xsl:value-of select="$strMB"/></xsl:when>
		<xsl:when test="$unit='KB'"><xsl:value-of select="$strKB"/></xsl:when>
		<xsl:otherwise><xsl:value-of select="$unit"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="devname">
	<xsl:choose>
		<xsl:when test="BankLocator!=''">
			<xsl:value-of select="BankLocator"/>/<xsl:value-of select="DeviceLocator"/>
		</xsl:when>
		<xsl:otherwise><xsl:value-of select="DeviceLocator"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="Type">
	<xsl:choose>
		<xsl:when test="MemDevType= '1'"><xsl:value-of select="$strOTHER"/></xsl:when>
		<xsl:when test="MemDevType= '2'"><xsl:value-of select="$strUNKNOWN"/></xsl:when>
		<xsl:when test="MemDevType= '3'"><xsl:value-of select="$strDRAM"/><xsl:call-template name="TypeDetail"/></xsl:when>
		<xsl:when test="MemDevType= '4'"><xsl:value-of select="$strEDRAM"/><xsl:call-template name="TypeDetail"/></xsl:when>
		<xsl:when test="MemDevType= '5'"><xsl:value-of select="$strVRAM"/><xsl:call-template name="TypeDetail"/></xsl:when>
		<xsl:when test="MemDevType= '6'"><xsl:value-of select="$strSRAM"/><xsl:call-template name="TypeDetail"/></xsl:when>
		<xsl:when test="MemDevType= '7'"><xsl:value-of select="$strRAM"/><xsl:call-template name="TypeDetail"/></xsl:when>
		<xsl:when test="MemDevType= '8'"><xsl:value-of select="$strROM"/><xsl:call-template name="TypeDetail"/></xsl:when>
		<xsl:when test="MemDevType= '9'"><xsl:value-of select="$strFLASH"/><xsl:call-template name="TypeDetail"/></xsl:when>
		<xsl:when test="MemDevType= '10'"><xsl:value-of select="$strEEPROM"/><xsl:call-template name="TypeDetail"/></xsl:when>
		<xsl:when test="MemDevType= '11'"><xsl:value-of select="$strFEPROM"/><xsl:call-template name="TypeDetail"/></xsl:when>
		<xsl:when test="MemDevType= '12'"><xsl:value-of select="$strEPROM"/><xsl:call-template name="TypeDetail"/></xsl:when>
		<xsl:when test="MemDevType= '13'"><xsl:value-of select="$strCDRAM"/><xsl:call-template name="TypeDetail"/></xsl:when>
		<xsl:when test="MemDevType= '14'"><xsl:value-of select="$str3DRAM"/><xsl:call-template name="TypeDetail"/></xsl:when>
		<xsl:when test="MemDevType= '15'"><xsl:value-of select="$strSDRAM"/><xsl:call-template name="TypeDetail"/></xsl:when>
		<xsl:when test="MemDevType= '16'"><xsl:value-of select="$strSGRAM"/><xsl:call-template name="TypeDetail"/></xsl:when>
		<xsl:when test="MemDevType= '17'"><xsl:value-of select="$strRDRAM"/><xsl:call-template name="TypeDetail"/></xsl:when>
		<xsl:when test="MemDevType= '18'"><xsl:value-of select="$strDDR"/><xsl:call-template name="TypeDetail"/></xsl:when>
		<xsl:when test="MemDevType= '19'"><xsl:value-of select="$strDDR2"/><xsl:call-template name="TypeDetail"/></xsl:when>
		<xsl:when test="MemDevType= '20'"><xsl:value-of select="$strDDR2FBDIMM"/><xsl:call-template name="TypeDetail"/></xsl:when>
	</xsl:choose>
</xsl:template>
<xsl:template name="TypeDetail">
	<xsl:choose>
		<xsl:when test="TypeDetail= '1'">-<xsl:value-of select="$strOTHER1"/></xsl:when>
		<xsl:when test="TypeDetail= '2'">-<xsl:value-of select="$strUNKNOWN1"/></xsl:when>
		<xsl:when test="TypeDetail= '3'">-<xsl:value-of select="$strFASTPAGED"/></xsl:when>
		<xsl:when test="TypeDetail= '4'">-<xsl:value-of select="$strSTATICCOL"/></xsl:when>
		<xsl:when test="TypeDetail= '5'">-<xsl:value-of select="$strPSEUDOSTATIC"/></xsl:when>
		<xsl:when test="TypeDetail= '6'">-<xsl:value-of select="$strRAMBUS"/></xsl:when>
		<xsl:when test="TypeDetail= '7'">-<xsl:value-of select="$strSYNCHRONOUS"/></xsl:when>
		<xsl:when test="TypeDetail= '8'">-<xsl:value-of select="$strCMOS"/></xsl:when>
		<xsl:when test="TypeDetail= '9'">-<xsl:value-of select="$strEDO"/></xsl:when>
		<xsl:when test="TypeDetail= '10'">-<xsl:value-of select="$strWINDRAM"/></xsl:when>
		<xsl:when test="TypeDetail= '11'">-<xsl:value-of select="$strCACHEDRAM"/></xsl:when>
		<xsl:when test="TypeDetail= '12'">-<xsl:value-of select="$strNONVOLATILE"/></xsl:when>
	</xsl:choose>
</xsl:template>

<xsl:template match="FailureModes">
	<Data>
		<xsl:choose>
			<xsl:when test="/OMA/@cli = 'true'">
				<xsl:attribute name="value">
					<xsl:choose>
					    <xsl:when test="Value='0'"><xsl:value-of select="$strNone"/></xsl:when>
					    <xsl:otherwise>
								<xsl:if test="SB_WRATE='true'"><xsl:value-of select="$strSingleBitWarning"/></xsl:if>
								<xsl:if test="SB_FRATE='true'"><xsl:value-of select="$strSingleBitFailure"/></xsl:if>
								<xsl:if test="MB_ERR='true'"><xsl:value-of select="$strMultiBitError"/></xsl:if>
								<xsl:if test="SB_LOG_DISABLE='true'"><xsl:value-of select="$strSingleBitError"/></xsl:if>
								<xsl:if test="SB_SPARE_BANK='true'"><xsl:value-of select="$strDIMMDisabledVia"/></xsl:if>
					    </xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
			    <ValueList>
					<xsl:choose>
					    <xsl:when test="Value='0'">
						<value><xsl:value-of select="$strNone1"/></value>
					    </xsl:when>
					    <xsl:otherwise>
						<xsl:if test="SB_WRATE='true'">
						    <value><xsl:value-of select="$strSingleBitWarning1"/></value>
						</xsl:if>
						<xsl:if test="SB_FRATE='true'">
						    <value><xsl:value-of select="$strSingleBitFailure1"/></value>
						</xsl:if>
						<xsl:if test="MB_ERR='true'">
						    <value><xsl:value-of select="$strMultiBitError1"/></value>
						</xsl:if>
						<xsl:if test="SB_LOG_DISABLE='true'">
						    <value><xsl:value-of select="$strSingleBitError1"/></value>
						</xsl:if>
						<xsl:if test="SB_SPARE_BANK='true'">
						    <value><xsl:value-of select="$strDIMMDisabledVia1"/></value>
						</xsl:if>
					    </xsl:otherwise>
					</xsl:choose>
			    </ValueList>
			</xsl:otherwise>
		</xsl:choose>
	</Data>
</xsl:template>

<xsl:template name="submit">
	<xsl:choose>
		<xsl:when test="(OMAUserRights='7') or (OMAUserRights='3')">
			<xsl:choose>
			<xsl:when test="(MemDevList/@count='1') and (MemDevList/MemoryDevice/ErrCount='0')"></xsl:when>
			</xsl:choose>		
		</xsl:when>
		<xsl:otherwise></xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!--xsl:template name="speed">
	<xsl:choose>
		<xsl:when test="Speed='0'"><xsl:value-of select="$strUnknown"/></xsl:when>
		<xsl:otherwise><xsl:value-of select="Speed"/><xsl:text disable-output-escaping="yes"> </xsl:text><xsl:value-of select="Speed/@unit"/></xsl:otherwise>
	</xsl:choose>
</xsl:template-->

<xsl:template name="devlocator">
	<xsl:param name="count"/>
	<xsl:param name="locator"/>
	<xsl:choose>
		<xsl:when test="$count='0'"><xsl:value-of select="$strMemoryDeviceOn"/><xsl:text disable-output-escaping="yes"> </xsl:text><xsl:value-of select="$locator"/><xsl:text disable-output-escaping="yes"> </xsl:text><xsl:value-of select="$strIsNotOccupied"/></xsl:when>
		<xsl:otherwise><xsl:value-of select="$strMemoryDeviceOn1"/><xsl:text disable-output-escaping="yes"> </xsl:text><xsl:value-of select="$locator"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="smstatus">
		<xsl:param name="status"/>
		<xsl:param name="mssg"/>
		<xsl:choose>
			<xsl:when test="$status = '-1'"><xsl:value-of select="$strCommandUnsuccessful"/></xsl:when>
			<xsl:when test="$status = '1'"><xsl:value-of select="$strCommandNotImplemented"/></xsl:when>
			<xsl:when test="$status = '2'"><xsl:value-of select="$strBadCommand"/></xsl:when>
			<xsl:when test="$status = '3'"><xsl:value-of select="$strCommandTimeout"/></xsl:when>
			<xsl:when test="$status = '4'"><xsl:value-of select="$strCommandCancelled"/></xsl:when>
			<xsl:when test="$status = '5'"><xsl:value-of select="$strCommandAborted"/></xsl:when>
			<xsl:when test="$status = '6'"><xsl:value-of select="$strCommandPending"/></xsl:when>
			<xsl:when test="$status = '7'"><xsl:value-of select="$strNoSuchDevice"/></xsl:when>
			<xsl:when test="$status = '8'"><xsl:value-of select="$strDeviceBusy"/></xsl:when>
			<xsl:when test="$status = '9'"><xsl:value-of select="$strBadDevice"/></xsl:when>
			<xsl:when test="$status = '10'"><xsl:value-of select="$strSpuriousInterrupt"/></xsl:when>
			<xsl:when test="$status = '11'"><xsl:value-of select="$strResourceLocked"/></xsl:when>
			<xsl:when test="$status = '12'"><xsl:value-of select="$strInvalidIndex"/></xsl:when>
			<xsl:when test="$status = '13'"><xsl:value-of select="$strSMBError"/></xsl:when>
			<xsl:when test="$status = '14'"><xsl:value-of select="$strDataRequestedIs"/></xsl:when>
			<xsl:when test="$status = '15'"><xsl:value-of select="$strDataRequestedIs1"/></xsl:when>
			<xsl:when test="$status = '16'"><xsl:value-of select="$strDataRequestedIs2"/></xsl:when>
			<xsl:when test="$status = '17'"><xsl:value-of select="$strDeviceNotYet"/></xsl:when>
			<xsl:when test="$status = '18'"><xsl:value-of select="$strDeviceDoesNot"/></xsl:when>
			<xsl:when test="$status = '19'"><xsl:value-of select="$strDeviceOutOf"/></xsl:when>
			<xsl:when test="$status = '20'"><xsl:value-of select="$strDeviceAlreadyExists"/></xsl:when>
			<xsl:when test="$status = '256'"><xsl:value-of select="$strMemoryDeviceNot"/></xsl:when>
			<xsl:when test="$status = '257'"><xsl:value-of select="$strMemoryDeviceMalformed"/></xsl:when>
			<xsl:when test="$status = '258'"><xsl:value-of select="$strMemoryDeviceAlready"/></xsl:when>
			<xsl:when test="$status = '260'"><xsl:value-of select="$strINIFileNot"/></xsl:when>
			<xsl:when test="$status = '261'"><xsl:value-of select="$strINIMalformedCorrupt"/></xsl:when>
			<xsl:when test="$status = '262'"><xsl:value-of select="$strINISectionDoes"/></xsl:when>
			<xsl:when test="$status = '263'"><xsl:value-of select="$strINIKeyDoes"/></xsl:when>
			<xsl:when test="$status = '264'"><xsl:value-of select="$strINIValueMalformed"/></xsl:when>
			<xsl:when test="$status = '270'"><xsl:value-of select="$strInsufficientAccessRights"/></xsl:when>
			<xsl:when test="$status = '271'"><xsl:value-of select="$strInvalidParameterName"/><xsl:value-of select="$mssg"/></xsl:when>
			<xsl:when test="$status = '272'"><xsl:value-of select="$strOutOfMemory"/></xsl:when>
			<xsl:when test="$status = '280'"><xsl:value-of select="$strXMLFileNot"/></xsl:when>
			<xsl:when test="$status = '281'"><xsl:value-of select="$strXMLMalformedCorrupt"/></xsl:when>
			<xsl:when test="$status = '282'"><xsl:value-of select="$strXMLNodeDoes"/></xsl:when>
			<xsl:when test="$status = '283'"><xsl:value-of select="$strXMLValueMalformed"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$strSMStatus"/><xsl:value-of select="$status"/></xsl:otherwise>
		</xsl:choose>
</xsl:template>

<xsl:template match="*"/>
</xsl:stylesheet>
