<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:strip-space elements="*"/>
<xsl:template match="/OMA">
	<xsl:choose>
		<xsl:when test="SMStatus='0'"><xsl:call-template name="success"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="failure"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="failure">
	<DataArea>
		<PageTitle>
			<xsl:attribute name="display"><xsl:value-of select="$strMemory"/></xsl:attribute>
		</PageTitle>
		<TableData>
			<Header>
				<Data name="">
					<xsl:attribute name="display"><xsl:value-of select="$strError"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strError1"/></xsl:attribute>
				</Data>
			</Header>
			<Row>
				<Data name="" ><xsl:attribute name="display"><xsl:value-of select="$str"/></xsl:attribute>
					<xsl:attribute name="value">
						<xsl:call-template name="smstatus">
							<xsl:with-param name="status"><xsl:value-of select="SMStatus"/></xsl:with-param>
						</xsl:call-template>
					</xsl:attribute>
				</Data>
			</Row>
		</TableData>
	</DataArea>
</xsl:template>

<xsl:template name="success">
	<DataArea>
		<xsl:if test="OMAUserRights='7'">
			<xsl:if test="MemoryConfig and ((MemoryConfig/Capabilities/SpareBank!='false') or (MemoryConfig/Capabilities/Mirroring!='false') or (MemoryConfig/Capabilities/Raid5!='false'))">
				<xsl:attribute name="validate">true</xsl:attribute>
				<xsl:attribute name="onLoad">true</xsl:attribute>
				<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.hip.webplugins.SetMemConfigWebPlugin&amp;oid=<xsl:value-of select="MemoryConfig/@oid"/>&amp;poid=2</xsl:attribute>
				<script language="javascript">

					var memconfig;
					function validate()
					{
						var memconfig1;
						var j = document.getElementById("dataarea").redconfg.length;
						for (i = 0; i &lt; j; i++)
						{
							if(document.getElementById("dataarea").redconfg[i].checked == true)
							{
								memconfig1 = document.getElementById("dataarea").redconfg[i].value;
							}
						}
						if (memconfig1 == memconfig) 
						{
							var confgval;
							switch ( memconfig1 )
							{
							    case "2": confgval = "<xsl:value-of select="$strDisabled"/>";
									    break;
							    case "1": confgval = "<xsl:value-of select="$strSpareBank"/>";
									    break;
								  case "3": confgval = "<xsl:value-of select="$strMirroring"/>";
									    break;
								  case "4": confgval = "<xsl:value-of select="$strRaid5"/>";
									    break;
							}
							alert(<xsl:value-of select="$strConfgvalIsAlready"/>);
							return false;
						}
						else 
						{
							alert("<xsl:value-of select="$strYouNeedTo"/>");
							return true;
						}
					}

					function initializationRoutine()
					{
						var j = document.getElementById("dataarea").redconfg.length;
						for (i = 0; i &lt; j; i++){
							if(document.getElementById("dataarea").redconfg[i].checked == true)
							{
								memconfig = document.getElementById("dataarea").redconfg[i].value;
							}
						}
					}

				</script>
			</xsl:if>
		</xsl:if>

		<xsl:if test="OMAUserRights='7'">
			<xsl:if test="MemoryConfig and (ShutDownFlag='true')">
				<script language="javascript">
					function restart()
					{
						if (confirm("<xsl:value-of select="$strAreYouDone"/>")){
							document.getElementById("dataarea").action=top.gnv.appendVID('/servlet/SubmitForm?plugin=com.dell.hip.webplugins.shtdwnWebPlugin&amp;os=8&amp;action1=1');
							document.getElementById("dataarea").submit();
						}
						else{
							document.getElementById("dataarea").action=top.gnv.appendVID('/servlet/DataArea?plugin=com.dell.hip.webplugins.MemoryArrayWebPlugin&amp;poid=2&amp;help=Memory');
							document.getElementById("dataarea").submit();
						}
					}
				</script>
			</xsl:if>
		</xsl:if>
		<PageTitle>
			<xsl:attribute name="display"><xsl:value-of select="$strMemory1"/></xsl:attribute>
			<xsl:attribute name="status"><xsl:value-of select="ObjStatus"/></xsl:attribute>
		</PageTitle>

		<CustomButton>
			<xsl:if test="OMAUserRights='7'">
				<xsl:if test="MemoryConfig and (ShutDownFlag='true')">
					<Data name="shtdwn">
						<xsl:attribute name="display"><xsl:value-of select="$strRebootSystem"/></xsl:attribute>
						<xsl:attribute name="href">javascript:restart()</xsl:attribute>
						<xsl:attribute name="formSubmit">true</xsl:attribute>
					</Data>
				</xsl:if>
			</xsl:if>
			<Data name="Refresh">
				<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
				<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.MemoryArrayWebPlugin&amp;poid=2&amp;help=Memory</xsl:attribute>
			</Data>
		</CustomButton>
		<xsl:if test="MemoryConfig">
			<SubHeader>
				<xsl:attribute name="display"><xsl:value-of select="$strMemoryRedundancy"/></xsl:attribute>
				<xsl:attribute name="status"><xsl:value-of select="Redundancy/@status"/></xsl:attribute>
			</SubHeader>
			<ListData>
				<xsl:apply-templates select="Redundancy"/>
				<xsl:apply-templates select="MemoryConfig"/>
			</ListData>
		</xsl:if>
		<xsl:call-template name="MemoryArray"/>
	</DataArea>
</xsl:template>

<xsl:template match="Redundancy">
	<Data>
		<xsl:attribute name="display"><xsl:value-of select="$strRedundancyStatus"/></xsl:attribute>
		<xsl:call-template name="RedStat">
			<xsl:with-param name="status"><xsl:value-of select="RedunStatus"/></xsl:with-param>
		</xsl:call-template>
	</Data>
</xsl:template>

<xsl:template name="RedStat">
	<xsl:param name="status"/>
	<xsl:choose>
		<xsl:when test="$status = 1">
			<xsl:attribute name="value"><xsl:value-of select="$strUnknown"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="$status = 2">
			<xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="$status = 3">
			<xsl:attribute name="value"><xsl:value-of select="$strOffline"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="$status = 4">
			<xsl:attribute name="value"><xsl:value-of select="$strFull"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="$status = 5">
			<xsl:attribute name="value"><xsl:value-of select="$strDegraded"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="$status = 6">
			<xsl:attribute name="value"><xsl:value-of select="$strLost"/></xsl:attribute>
		</xsl:when>
		<xsl:otherwise>
			<xsl:attribute name="value"><xsl:value-of select="$strOther"/></xsl:attribute>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="MemoryConfig">
	<Data>
		<xsl:attribute name="display"><xsl:value-of select="$strFailOverState"/></xsl:attribute>
		<xsl:call-template name="FOS">
			<xsl:with-param name="state"><xsl:value-of select="FailOverState"/></xsl:with-param>
		</xsl:call-template>
	</Data>
	<xsl:choose>
		<xsl:when test="/OMA/@cli='true'">
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strRedundancyConfiguration"/></xsl:attribute>
				<xsl:attribute name="value">
					<xsl:if test="State='0'"><xsl:value-of select="$strDisabled1"/></xsl:if>
					<xsl:if test="State='1'"><xsl:value-of select="$strSpareBank1"/></xsl:if>
					<xsl:if test="State='2'"><xsl:value-of select="$strMirroring1"/></xsl:if>
					<xsl:if test="State='3'"><xsl:value-of select="$strRaid5"/></xsl:if>
				</xsl:attribute>
			</Data>
		</xsl:when>
		<xsl:otherwise>
			<xsl:choose>
				<xsl:when test="/OMA/OMAUserRights='7'">
					<xsl:choose>
						<xsl:when test="(Capabilities/SpareBank != 'false') or (Capabilities/Mirroring != 'false')or (Capabilities/Raid5 != 'false')">
							<Data>
								<xsl:attribute name="name">redconfg</xsl:attribute>
								<xsl:attribute name="display"><xsl:value-of select="$strRedundancyConfiguration1"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strDisabled2"/></xsl:attribute>
								<xsl:attribute name="type">radio</xsl:attribute>
								<xsl:attribute name="returnvalue">2</xsl:attribute>
								<xsl:attribute name="state"><xsl:if test="State='0'">1</xsl:if></xsl:attribute>
							</Data>
							<xsl:for-each select="Capabilities/*">
							<xsl:if test=".='true'">
								<Data type="radio">
									<xsl:attribute name="name">redconfg</xsl:attribute>
									<xsl:attribute name="value">
										<xsl:choose>
											<xsl:when test="name()='SpareBank'"><xsl:value-of select="$strSpareBank2"/></xsl:when>
											<xsl:when test="name()='Mirroring'"><xsl:value-of select="$strMirroring1"/></xsl:when>
											<xsl:when test="name()='Raid5'"><xsl:value-of select="$strRaid5"/></xsl:when>
											<xsl:otherwise><xsl:value-of select="name()"/></xsl:otherwise>
										</xsl:choose>
									</xsl:attribute>
									<xsl:attribute name="returnvalue">
										<xsl:if test="name()='SpareBank'">1</xsl:if>
										<xsl:if test="name()='Mirroring'">3</xsl:if>
										<xsl:if test="name()='Raid5'">4</xsl:if>
									</xsl:attribute>
									<xsl:attribute name="state">
										<xsl:if test="name()='SpareBank'"><xsl:if test="/OMA/MemoryConfig/State='1'">1</xsl:if></xsl:if>
										<xsl:if test="name()='Mirroring'"><xsl:if test="/OMA/MemoryConfig/State='2'">1</xsl:if></xsl:if>
										<xsl:if test="name()='Raid5'"><xsl:if test="/OMA/MemoryConfig/State='3'">1</xsl:if></xsl:if>
									</xsl:attribute>
								</Data>
							</xsl:if>
						</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strRedundancyConfiguration2"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strDisabled3"/></xsl:attribute>
							</Data>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strRedundancyConfiguration3"/></xsl:attribute>
						<xsl:attribute name="value">
							<xsl:if test="State='0'"><xsl:value-of select="$strDisabled4"/></xsl:if>
							<xsl:if test="State='1'"><xsl:value-of select="$strSpareBank2"/></xsl:if>
							<xsl:if test="State='2'"><xsl:value-of select="$strMirroring2"/></xsl:if>
							<xsl:if test="State='3'"><xsl:value-of select="$strRaid5"/></xsl:if>
						</xsl:attribute>
					</Data>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="FOS">
	<xsl:param name="state"/>
	<xsl:choose>
		<xsl:when test="$state = 0">
			<xsl:attribute name="value"><xsl:value-of select="$strInactive"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="$state = 1">
			<xsl:attribute name="value"><xsl:value-of select="$strActive"/></xsl:attribute>
		</xsl:when>
		<xsl:otherwise>
			<xsl:attribute name="value"><xsl:value-of select="$strNA1"/></xsl:attribute>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name="MemoryArray">
	<TableData name="genprop">
		<xsl:attribute name="display"><xsl:value-of select="$strAttributesOfMemory"/></xsl:attribute>
		<SubHeader>
			<xsl:attribute name="display"><xsl:value-of select="$strAttributesOfMemory1"/></xsl:attribute>
		</SubHeader>
		<Header>
			<xsl:choose>
				<xsl:when test="MemoryArrayList/@count='1'">
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strAttributes"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strAttributes1"/></xsl:attribute>
					</Data>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strMemoryArray"/><xsl:call-template name="count"><xsl:with-param name="index"><xsl:value-of select="MemoryArrayList/MemoryArray/@index"/></xsl:with-param></xsl:call-template></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strMemoryArray1"/><xsl:call-template name="count"><xsl:with-param name="index"><xsl:value-of select="MemoryArrayList/MemoryArray/@index"/></xsl:with-param></xsl:call-template></xsl:attribute>
					</Data>
				</xsl:when>
				<xsl:otherwise>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strAttributes2"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strAttributes3"/></xsl:attribute>
					</Data>
					<xsl:for-each select="MemoryArrayList/MemoryArray">
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strMemoryArray2"/><xsl:call-template name="count">
								<xsl:with-param name="index"><xsl:value-of select="@index"/></xsl:with-param>
							</xsl:call-template></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strMemoryArray3"/><xsl:call-template name="count">
								<xsl:with-param name="index"><xsl:value-of select="@index"/></xsl:with-param>
							</xsl:call-template></xsl:attribute>
						</Data>
					</xsl:for-each>
				</xsl:otherwise>
			</xsl:choose>
		</Header>
			<Row>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strLocation"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strLocation1"/></xsl:attribute>
				</Data>
				<xsl:for-each select="MemoryArrayList/MemoryArray">
					<Data>
						<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="Location='1'"><xsl:value-of select="$strOther1"/></xsl:when>
							<xsl:when test="Location='3'"><xsl:value-of select="$strSystemBoardOr"/></xsl:when>
							<xsl:when test="Location='4'"><xsl:value-of select="$strISAAddonCard"/></xsl:when>
							<xsl:when test="Location='5'"><xsl:value-of select="$strEISAAddonCard"/></xsl:when>
							<xsl:when test="Location='6'"><xsl:value-of select="$strPCIAddonCard"/></xsl:when>
							<xsl:when test="Location='7'"><xsl:value-of select="$strMCAAddonCard"/></xsl:when>
							<xsl:when test="Location='8'"><xsl:value-of select="$strPCMCIAAddonCard"/></xsl:when>
							<xsl:when test="Location='9'"><xsl:value-of select="$strProprietaryAddonCard"/></xsl:when>
							<xsl:when test="Location='16'"><xsl:value-of select="$strNuBus"/></xsl:when>
							<xsl:when test="Location='160'"><xsl:value-of select="$strPC98C20AddonCard"/></xsl:when>
							<xsl:when test="Location='161'"><xsl:value-of select="$strPC98C24AddonCard"/></xsl:when>
							<xsl:when test="Location='162'"><xsl:value-of select="$strPC98EAddonCard"/></xsl:when>
							<xsl:when test="Location='163'"><xsl:value-of select="$strPC98LocalBusAddon"/></xsl:when>
							<xsl:when test="Location='164'"><xsl:value-of select="$strPC98CardSlotAddon"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$strNoValue"/></xsl:otherwise>
						</xsl:choose>
						</xsl:attribute>
					</Data>
				</xsl:for-each>
			</Row>
			<Row>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strUse"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strUse1"/></xsl:attribute>
				</Data>
				<xsl:for-each select="MemoryArrayList/MemoryArray">
					<Data>
						<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="Use='1'"><xsl:value-of select="$strOther2"/></xsl:when>
							<xsl:when test="Use='3'"><xsl:value-of select="$strSystemMemory"/></xsl:when>
							<xsl:when test="Use='4'"><xsl:value-of select="$strVideoMemory"/></xsl:when>
							<xsl:when test="Use='5'"><xsl:value-of select="$strFlashMemory"/></xsl:when>
							<xsl:when test="Use='6'"><xsl:value-of select="$strNonVolatileRAM"/></xsl:when>
							<xsl:when test="Use='7'"><xsl:value-of select="$strCacheMemory"/></xsl:when>						
							</xsl:choose>
						</xsl:attribute>
					</Data>
				</xsl:for-each>
			</Row>
			<Row>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strInstalledCapacity"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strInstalledCapacity1"/></xsl:attribute>
				</Data>
				<xsl:for-each select="MemoryArrayList/MemoryArray">
					<Data>
						<xsl:attribute name="display">
							<xsl:value-of select="InstalledSizeMBCumulative"/><xsl:text disable-output-escaping="yes">  </xsl:text>
							<xsl:choose>
								<xsl:when test="InstalledSizeMBCumulative/@unit='MB'"><xsl:value-of select="$strMB"/></xsl:when>
								<xsl:otherwise><xsl:value-of select="InstalledSizeMBCumulative/@unit"/></xsl:otherwise>
							</xsl:choose>
						</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="InstalledSizeMBCumulative"/><xsl:text disable-output-escaping="yes">  </xsl:text>
							<xsl:choose>
								<xsl:when test="InstalledSizeMBCumulative/@unit='MB'"><xsl:value-of select="$strMB1"/></xsl:when>
								<xsl:otherwise><xsl:value-of select="InstalledSizeMBCumulative/@unit"/></xsl:otherwise>
							</xsl:choose>
						</xsl:attribute>
					</Data>
				</xsl:for-each>
			</Row>
			<Row>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strMaximumCapacity"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strMaximumCapacity1"/></xsl:attribute>
				</Data>
				<xsl:for-each select="MemoryArrayList/MemoryArray">
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="MaxSizeMB"/><xsl:text disable-output-escaping="yes">  </xsl:text>
							<xsl:choose>
								<xsl:when test="MaxSizeMB/@unit='MB'"><xsl:value-of select="$strMB2"/></xsl:when>
								<xsl:otherwise><xsl:value-of select="MaxSizeMB/@unit"/></xsl:otherwise>
							</xsl:choose>
						</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="MaxSizeMB"/><xsl:text disable-output-escaping="yes">  </xsl:text>
							<xsl:choose>
								<xsl:when test="MaxSizeMB/@unit='MB'"><xsl:value-of select="$strMB3"/></xsl:when>
								<xsl:otherwise><xsl:value-of select="MaxSizeMB/@unit"/></xsl:otherwise>
							</xsl:choose>
						</xsl:attribute>
					</Data>
				</xsl:for-each>
			</Row>
		<Row>
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strSlotsAvailable"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strSlotsAvailable1"/></xsl:attribute>
			</Data>
			<xsl:for-each select="MemoryArrayList/MemoryArray">
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="NumSocketsTotal"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="NumSocketsTotal"/></xsl:attribute>
				</Data>
			</xsl:for-each>
			</Row>
			<Row>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strSlotsUsed"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strSlotsUsed1"/></xsl:attribute>
				</Data>
				<xsl:for-each select="MemoryArrayList/MemoryArray">
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="NumSocketsInUse"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="NumSocketsInUse"/></xsl:attribute>
					</Data>
				</xsl:for-each>
			</Row>
			<Row>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strErrorCorrection"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strECCType"/></xsl:attribute>
				</Data>
				<xsl:for-each select="MemoryArrayList/MemoryArray">
					<Data>
						<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="ErrCorrType='1'"><xsl:value-of select="$strOther3"/></xsl:when>
							<xsl:when test="ErrCorrType='3'"><xsl:value-of select="$strNone"/></xsl:when>
							<xsl:when test="ErrCorrType='4'"><xsl:value-of select="$strParity"/></xsl:when>
							<xsl:when test="ErrCorrType='5'"><xsl:value-of select="$strSingleBitECC"/></xsl:when>
							<xsl:when test="ErrCorrType='6'"><xsl:value-of select="$strMultibitECC"/></xsl:when>
							<xsl:when test="ErrCorrType='7'"><xsl:value-of select="$strCRC"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$strNoValue2"/></xsl:otherwise>
						</xsl:choose>
						</xsl:attribute>
					</Data>
				</xsl:for-each>
			</Row>
		</TableData>
		<TableData name="totprop" >
			<xsl:attribute name="display"><xsl:value-of select="$strTotalOfMemory"/></xsl:attribute>
			<SubHeader>
				<xsl:attribute name="display"><xsl:value-of select="$strTotalOfMemory1"/></xsl:attribute>
			</SubHeader>
			<Header>
				<Data align="left">
					<xsl:attribute name="display"><xsl:value-of select="$strAttributes4"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strAttributes5"/></xsl:attribute>
				</Data>
				<Data align="left">
					<xsl:attribute name="display"><xsl:value-of select="$strValue"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strValue1"/></xsl:attribute>
				</Data>
			</Header>
			<Row>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strTotalInstalledCapacity"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strTotalInstalledCapacity1"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="/OMA/MaxInstalledSizeMBCumulative"/><xsl:text disable-output-escaping="yes">  </xsl:text>
						<xsl:choose>
							<xsl:when test="/OMA/MaxInstalledSizeMBCumulative/@unit='MB'"><xsl:value-of select="$strMB4"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="/OMA/MaxInstalledSizeMBCumulative/@unit"/></xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="/OMA/MaxInstalledSizeMBCumulative"/><xsl:text disable-output-escaping="yes">  </xsl:text>
						<xsl:choose>
							<xsl:when test="/OMA/MaxInstalledSizeMBCumulative/@unit='MB'"><xsl:value-of select="$strMB5"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="/OMA/MaxInstalledSizeMBCumulative/@unit"/></xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
				</Data>
			</Row>
			<Row>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strTotalInstalledCapacity2"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strTotalInstalledCapacity3"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="/OMA/MemoryInfo/TotalPhysMemorySizeMB"/><xsl:text disable-output-escaping="yes">  </xsl:text>
						<xsl:choose>
							<xsl:when test="/OMA/MemoryInfo/TotalPhysMemorySizeMB/@unit='MB'"><xsl:value-of select="$strMB6"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="/OMA/MemoryInfo/TotalPhysMemorySizeMB/@unit"/></xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="/OMA/MemoryInfo/TotalPhysMemorySizeMB"/><xsl:text disable-output-escaping="yes">  </xsl:text>
						<xsl:choose>
							<xsl:when test="/OMA/MemoryInfo/TotalPhysMemorySizeMB/@unit='MB'"><xsl:value-of select="$strMB7"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="/OMA/MemoryInfo/TotalPhysMemorySizeMB/@unit"/></xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
				</Data>
			</Row>
			<Row>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strTotalMaximumCapacity"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strTotalMaximumCapacity1"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="/OMA/MaxSizeMBCumulative"/><xsl:text disable-output-escaping="yes">  </xsl:text>
						<xsl:choose>
							<xsl:when test="/OMA/MaxSizeMBCumulative/@unit='MB'"><xsl:value-of select="$strMB8"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="/OMA/MaxSizeMBCumulative/@unit"/></xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="/OMA/MaxSizeMBCumulative"/><xsl:text disable-output-escaping="yes">  </xsl:text>
						<xsl:choose>
							<xsl:when test="/OMA/MaxSizeMBCumulative/@unit='MB'"><xsl:value-of select="$strMB9"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="/OMA/MaxSizeMBCumulative/@unit"/></xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
				</Data>
			</Row>
	</TableData>

	<xsl:for-each select="MemoryArrayList/MemoryArray">
		<xsl:apply-templates select="MemPortConnList">
			<xsl:with-param name="memindex"><xsl:value-of select="@index"/></xsl:with-param>
		</xsl:apply-templates>
	</xsl:for-each>
</xsl:template>

<xsl:template match="MemPortConnList">
	<xsl:param name="memindex"/>
	<TableData>
		<xsl:attribute name="name">memarr<xsl:call-template name="count"><xsl:with-param name="index"><xsl:value-of select="$memindex"/></xsl:with-param></xsl:call-template></xsl:attribute>
		<xsl:attribute name="display"><xsl:value-of select="$strConnectorDetailsOfPart1"/><xsl:text disable-output-escaping="yes"> </xsl:text>
			<xsl:call-template name="count"><xsl:with-param name="index"><xsl:value-of select="$memindex"/></xsl:with-param></xsl:call-template>
			<xsl:value-of select="$strConnectorDetailsOfPart3"/>
		</xsl:attribute>
		<PromptText><xsl:value-of select="$strClickTheConnectorPart1"/><xsl:text disable-output-escaping="yes"> </xsl:text>
			<xsl:call-template name="count"><xsl:with-param name="index"><xsl:value-of select="$memindex"/></xsl:with-param></xsl:call-template>
			<xsl:value-of select="$strClickTheConnectorPart3"/>
			<xsl:value-of select="$strToViewIts"/>
		</PromptText>
		<SubHeader>
			<xsl:attribute name="display"><xsl:value-of select="$strDetailsOfPart1"/>
				<xsl:call-template name="count"><xsl:with-param name="index"><xsl:value-of select="$memindex"/></xsl:with-param></xsl:call-template>
				<xsl:value-of select="$strDetailsOfPart3"/>
			</xsl:attribute>
		</SubHeader>
		<Header>
			<Data ignoreonweb="true">
				<xsl:attribute name="display"><xsl:value-of select="$strIndex"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strIndex1"/></xsl:attribute>
			</Data>
			<Data align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strStatus1"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strConnectorName"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strConnectorName1"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strType"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strType1"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strSize"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strSize1"/></xsl:attribute>
			</Data>
		</Header>

		<xsl:for-each select="PortGeneric">
			<xsl:call-template name="portgeneric">
				<xsl:with-param name="index"><xsl:value-of select="@index"/></xsl:with-param>
			</xsl:call-template>
		</xsl:for-each>

	</TableData>
</xsl:template>

<xsl:template name="portgeneric">
<xsl:param name="index"/>
<Row>
	<Data ignoreonweb="true">
		<xsl:attribute name="display"><xsl:value-of select="$index"/></xsl:attribute>
		<xsl:attribute name="value"><xsl:value-of select="$index"/></xsl:attribute>
	</Data>
	<Data name=""  type="status" align="center"><xsl:attribute name="display"><xsl:value-of select="$str1"/></xsl:attribute>
		<xsl:attribute name="value"><xsl:call-template name="showstatus"><xsl:with-param name="status1"><xsl:value-of select="@status"/></xsl:with-param></xsl:call-template></xsl:attribute>
	</Data>
	<Data name=""  type=""><xsl:attribute name="display"><xsl:value-of select="$str2"/></xsl:attribute>
		<xsl:attribute name="value"><xsl:value-of select="ExtName"/></xsl:attribute>
		<xsl:call-template name="link"/>
	</Data>
	<Data name=""  type=""><xsl:attribute name="display"><xsl:value-of select="$str3"/></xsl:attribute>
		<xsl:attribute name="value"><xsl:call-template name="occupied"/></xsl:attribute>
	</Data>
	<Data name=""  type=""><xsl:attribute name="display"><xsl:value-of select="$str4"/></xsl:attribute>
		<xsl:attribute name="value"><xsl:call-template name="size"><xsl:with-param name="unit"><xsl:value-of select="MemoryDevice/SizeMB/@unit"/></xsl:with-param></xsl:call-template></xsl:attribute>
	</Data>
</Row>
</xsl:template>

<xsl:template name="link">
	<xsl:choose>
		<xsl:when test="IsOccupied='true'">
			<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.MemoryDeviceListWebPlugin&amp;oid=<xsl:value-of select="@oid"/>&amp;help=MemoryDevice</xsl:attribute>
			<xsl:attribute name="link">true</xsl:attribute>
		</xsl:when>
		<xsl:otherwise></xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="showstatus">
	<xsl:param name="status1"/>
	<xsl:choose>
		<xsl:when test="IsOccupied='true'"><xsl:value-of select="$status1"/></xsl:when>
		<xsl:otherwise>0</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="occupied">
	<xsl:choose>
		<xsl:when test="IsOccupied='true'">
			<xsl:call-template name="Type"/>
		</xsl:when>
		<xsl:otherwise><xsl:value-of select="$strNotOccupied"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="size">
	<xsl:param name="unit"/>
	<xsl:choose>
		<xsl:when test="IsOccupied='true'"><xsl:value-of select="MemoryDevice/SizeMB"/><xsl:text disable-output-escaping="yes">  </xsl:text>
			<xsl:choose>
				<xsl:when test="$unit='MB'"><xsl:value-of select="$strMB10"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="$unit"/></xsl:otherwise>
			</xsl:choose>
		</xsl:when>
	</xsl:choose>
</xsl:template>

<xsl:template name="count">
	<xsl:param name="index"/>
	<xsl:choose>
		<xsl:when test="/OMA/MemoryArrayList/@count='1'">1</xsl:when>
		<xsl:otherwise>
			<xsl:variable name="index1" select="$index"/>
			<xsl:value-of select="number($index1)+1"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="Type">
	<xsl:choose>
		<xsl:when test="MemoryDevice/MemDevType= '1'"><xsl:value-of select="$strOTHER"/></xsl:when>
		<xsl:when test="MemoryDevice/MemDevType= '2'"><xsl:value-of select="$strUNKNOWN"/></xsl:when>
		<xsl:when test="MemoryDevice/MemDevType= '3'"><xsl:value-of select="$strDRAM"/><xsl:call-template name="TypeDetail"/></xsl:when>
		<xsl:when test="MemoryDevice/MemDevType= '4'"><xsl:value-of select="$strEDRAM"/><xsl:call-template name="TypeDetail"/></xsl:when>
		<xsl:when test="MemoryDevice/MemDevType= '5'"><xsl:value-of select="$strVRAM"/><xsl:call-template name="TypeDetail"/></xsl:when>
		<xsl:when test="MemoryDevice/MemDevType= '6'"><xsl:value-of select="$strSRAM"/><xsl:call-template name="TypeDetail"/></xsl:when>
		<xsl:when test="MemoryDevice/MemDevType= '7'"><xsl:value-of select="$strRAM"/><xsl:call-template name="TypeDetail"/></xsl:when>
		<xsl:when test="MemoryDevice/MemDevType= '8'"><xsl:value-of select="$strROM"/><xsl:call-template name="TypeDetail"/></xsl:when>
		<xsl:when test="MemoryDevice/MemDevType= '9'"><xsl:value-of select="$strFLASH"/><xsl:call-template name="TypeDetail"/></xsl:when>
		<xsl:when test="MemoryDevice/MemDevType= '10'"><xsl:value-of select="$strEEPROM"/><xsl:call-template name="TypeDetail"/></xsl:when>
		<xsl:when test="MemoryDevice/MemDevType= '11'"><xsl:value-of select="$strFEPROM"/><xsl:call-template name="TypeDetail"/></xsl:when>
		<xsl:when test="MemoryDevice/MemDevType= '12'"><xsl:value-of select="$strEPROM"/><xsl:call-template name="TypeDetail"/></xsl:when>
		<xsl:when test="MemoryDevice/MemDevType= '13'"><xsl:value-of select="$strCDRAM"/><xsl:call-template name="TypeDetail"/></xsl:when>
		<xsl:when test="MemoryDevice/MemDevType= '14'"><xsl:value-of select="$str3DRAM"/><xsl:call-template name="TypeDetail"/></xsl:when>
		<xsl:when test="MemoryDevice/MemDevType= '15'"><xsl:value-of select="$strSDRAM"/><xsl:call-template name="TypeDetail"/></xsl:when>
		<xsl:when test="MemoryDevice/MemDevType= '16'"><xsl:value-of select="$strSGRAM"/><xsl:call-template name="TypeDetail"/></xsl:when>
		<xsl:when test="MemoryDevice/MemDevType= '17'"><xsl:value-of select="$strRDRAM"/><xsl:call-template name="TypeDetail"/></xsl:when>
		<xsl:when test="MemoryDevice/MemDevType= '18'"><xsl:value-of select="$strDDR"/><xsl:call-template name="TypeDetail"/></xsl:when>
		<xsl:when test="MemoryDevice/MemDevType= '19'"><xsl:value-of select="$strDDR2"/><xsl:call-template name="TypeDetail"/></xsl:when>
		<xsl:when test="MemoryDevice/MemDevType= '20'"><xsl:value-of select="$strDDR2FBDIMM"/><xsl:call-template name="TypeDetail"/></xsl:when>
	</xsl:choose>
</xsl:template>

<xsl:template name="TypeDetail">
	<xsl:choose>
		<xsl:when test="MemoryDevice/TypeDetail= '1'">-<xsl:value-of select="$strOTHER1"/></xsl:when>
		<xsl:when test="MemoryDevice/TypeDetail= '2'">-<xsl:value-of select="$strUNKNOWN1"/></xsl:when>
		<xsl:when test="MemoryDevice/TypeDetail= '3'">-<xsl:value-of select="$strFASTPAGED"/></xsl:when>
		<xsl:when test="MemoryDevice/TypeDetail= '4'">-<xsl:value-of select="$strSTATICCOL"/></xsl:when>
		<xsl:when test="MemoryDevice/TypeDetail= '5'">-<xsl:value-of select="$strPSEUDOSTATIC"/></xsl:when>
		<xsl:when test="MemoryDevice/TypeDetail= '6'">-<xsl:value-of select="$strRAMBUS"/></xsl:when>
		<xsl:when test="MemoryDevice/TypeDetail= '7'">-<xsl:value-of select="$strSYNCHRONOUS"/></xsl:when>
		<xsl:when test="MemoryDevice/TypeDetail= '8'">-<xsl:value-of select="$strCMOS"/></xsl:when>
		<xsl:when test="MemoryDevice/TypeDetail= '9'">-<xsl:value-of select="$strEDO"/></xsl:when>
		<xsl:when test="MemoryDevice/TypeDetail= '10'">-<xsl:value-of select="$strWINDRAM"/></xsl:when>
		<xsl:when test="MemoryDevice/TypeDetail= '11'">-<xsl:value-of select="$strCACHEDRAM"/></xsl:when>
		<xsl:when test="MemoryDevice/TypeDetail= '12'">-<xsl:value-of select="$strNONVOLATILE"/></xsl:when>
	</xsl:choose>
</xsl:template>

<xsl:template name="smstatus">
		<xsl:param name="status"/>
		<xsl:choose>
			<xsl:when test="$status = '-1'"><xsl:value-of select="$strCommandUnsuccessful"/></xsl:when>
			<xsl:when test="$status = '1'"><xsl:value-of select="$strCommandNotImplemented"/></xsl:when>
			<xsl:when test="$status = '2'"><xsl:value-of select="$strBadCommand"/></xsl:when>
			<xsl:when test="$status = '3'"><xsl:value-of select="$strCommandTimeout"/></xsl:when>
			<xsl:when test="$status = '4'"><xsl:value-of select="$strCommandCancelled"/></xsl:when>
			<xsl:when test="$status = '5'"><xsl:value-of select="$strCommandAborted"/></xsl:when>
			<xsl:when test="$status = '6'"><xsl:value-of select="$strCommandPending"/></xsl:when>
			<xsl:when test="$status = '7'"><xsl:value-of select="$strNoSuchDevice"/></xsl:when>
			<xsl:when test="$status = '8'"><xsl:value-of select="$strDeviceBusy"/></xsl:when>
			<xsl:when test="$status = '9'"><xsl:value-of select="$strBadDevice"/></xsl:when>
			<xsl:when test="$status = '10'"><xsl:value-of select="$strSpuriousInterrupt"/></xsl:when>
			<xsl:when test="$status = '11'"><xsl:value-of select="$strResourceLocked"/></xsl:when>
			<xsl:when test="$status = '12'"><xsl:value-of select="$strInvalidIndex"/></xsl:when>
			<xsl:when test="$status = '13'"><xsl:value-of select="$strSMBError"/></xsl:when>
			<xsl:when test="$status = '14'"><xsl:value-of select="$strDataRequestedIs"/></xsl:when>
			<xsl:when test="$status = '15'"><xsl:value-of select="$strDataRequestedIs1"/></xsl:when>
			<xsl:when test="$status = '16'"><xsl:value-of select="$strDataRequestedIs2"/></xsl:when>
			<xsl:when test="$status = '17'"><xsl:value-of select="$strDeviceNotYet"/></xsl:when>
			<xsl:when test="$status = '18'"><xsl:value-of select="$strDeviceDoesNot"/></xsl:when>
			<xsl:when test="$status = '19'"><xsl:value-of select="$strDeviceOutOf"/></xsl:when>
			<xsl:when test="$status = '20'"><xsl:value-of select="$strDeviceAlreadyExists"/></xsl:when>
			<xsl:when test="$status = '256'"><xsl:value-of select="$strMemoryObjectNot"/></xsl:when>
			<xsl:when test="$status = '257'"><xsl:value-of select="$strMemoryObjectMalformed"/></xsl:when>
			<xsl:when test="$status = '258'"><xsl:value-of select="$strMemoryObjectAlready"/></xsl:when>
			<xsl:when test="$status = '260'"><xsl:value-of select="$strINIFileNot"/></xsl:when>
			<xsl:when test="$status = '261'"><xsl:value-of select="$strINIMalformedCorrupt"/></xsl:when>
			<xsl:when test="$status = '262'"><xsl:value-of select="$strINISectionDoes"/></xsl:when>
			<xsl:when test="$status = '263'"><xsl:value-of select="$strINIKeyDoes"/></xsl:when>
			<xsl:when test="$status = '264'"><xsl:value-of select="$strINIValueMalformed"/></xsl:when>
			<xsl:when test="$status = '270'"><xsl:value-of select="$strInsufficientAccessRights"/></xsl:when>
			<xsl:when test="$status = '271'"><xsl:value-of select="$strInvalidParameterName"/></xsl:when>
			<xsl:when test="$status = '272'"><xsl:value-of select="$strOutOfMemory"/></xsl:when>
			<xsl:when test="$status = '280'"><xsl:value-of select="$strXMLFileNot"/></xsl:when>
			<xsl:when test="$status = '281'"><xsl:value-of select="$strXMLMalformedCorrupt"/></xsl:when>
			<xsl:when test="$status = '282'"><xsl:value-of select="$strXMLNodeDoes"/></xsl:when>
			<xsl:when test="$status = '283'"><xsl:value-of select="$strXMLValueMalformed"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$strSMStatus"/><xsl:value-of select="$status"/></xsl:otherwise>
		</xsl:choose>
</xsl:template>

<xsl:template match="*"/>
</xsl:stylesheet>
