<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="OMA">
		<xsl:choose>
			<xsl:when test="SMStatus != '0'" >
				<xsl:call-template name="failure"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="ListPerformance"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="failure">
		<DataArea>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strHWPerformance"/></xsl:attribute>
			</PageTitle>
			<TableData>
				<Header>
					<Data>
						<xsl:attribute name="value"><xsl:value-of select="$strError"/></xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="$strError"/></xsl:attribute>
					</Data>
				</Header>
				<Row>
					<Data>
						<xsl:attribute name="value"><xsl:value-of select="$strNoPerformanceSensor"/></xsl:attribute>
					</Data>
				</Row>
			</TableData>
		</DataArea>
	</xsl:template>
	<xsl:template name="ListPerformance">
		<DataArea>
			<PageTitle>
        <xsl:attribute name="display"><xsl:value-of select="$strHWPerformance"/></xsl:attribute>
			</PageTitle>
			<CustomButton>
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.ListPerformanceWebPlugin&amp;help=HardwarePerformance</xsl:attribute>
				</Data>
			</CustomButton>
			<TableData columnspacing="true">
					<Header>
							<Data name="index">
								<xsl:attribute name="ignoreonweb">true</xsl:attribute>
								<xsl:attribute name="display"><xsl:value-of select="$strIndex"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strIndex"/></xsl:attribute>
							</Data>
							<Data name="ProbeName">
								<xsl:attribute name="display"><xsl:value-of select="$strProbeName"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strProbeName"/></xsl:attribute>
							</Data>
              						<Data name="Status" align="center">
              						  <xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
              						  <xsl:attribute name="value"><xsl:value-of select="$strStatus"/></xsl:attribute>
              						</Data>
							<Data name="Cause" align="center">
								<xsl:attribute name="display"><xsl:value-of select="$strCause"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strCause"/></xsl:attribute>
							</Data>
						</Header>
				<xsl:apply-templates select="/OMA/PerformanceSensorObj"/>
			</TableData>
		</DataArea>
	</xsl:template>
	
	<xsl:template match="PerformanceSensorObj">
		<Row>
			<Data ignoreonweb="true">
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="@instance"><xsl:value-of select="@instance"/></xsl:when>
						<xsl:otherwise>0</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
			<Data value="{ProbeLocation}" display="{ProbeLocation}" type="ustring" editable="false"/>
			<Data align="center">
      			  <xsl:attribute name="value">
      			  <xsl:choose>
                  
                  <xsl:when test="probeReading='0'">
                    <xsl:value-of select="$strUnknown"/>
                  </xsl:when>
      			      <xsl:when test="probeReading='1'"><xsl:value-of select="$strNormal"/></xsl:when>
      			      <xsl:otherwise><xsl:value-of select="$strDegraded"/></xsl:otherwise>
        		    </xsl:choose>
      			  </xsl:attribute>
                       </Data>
                      <Data align="center">
				<xsl:attribute name="value">
					<xsl:choose>
            <xsl:when test="probeReading='0' or probeReading='1'">
              <xsl:value-of select="$strNA"/>
            </xsl:when>
	  		  			<xsl:when test="probeReading='2'"><xsl:value-of select="$strOther"/></xsl:when>
		    				<xsl:when test="probeReading='4'"><xsl:value-of select="$strThermalLimits"/></xsl:when>
      					<xsl:when test="probeReading='8'"><xsl:value-of select="$strInsuffCoolingCapacity"/></xsl:when>
      					<xsl:when test="probeReading='16'"><xsl:value-of select="$strInsuffPowerCapacity"/></xsl:when>
      					<xsl:when test="probeReading='32'"><xsl:value-of select="$strUserConfig"/></xsl:when>
      					<xsl:otherwise><xsl:value-of select="$strUnknownStatus"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
		</Row>
	</xsl:template>
</xsl:stylesheet>
