<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:variable name="lraObjs" select="/OMA/LRAResponse/lroConfigSDOArrayarray/lroConfigSDOArray"/>
<xsl:variable name="UsrRights" select="/OMA/OMACLIUserRights"/>
<xsl:variable name="UsrElevate" select="/OMA/Elevate"/>
  <xsl:variable name="lraName">
    <xsl:choose>
      <xsl:when test="/OMA/Type !=''"><xsl:value-of select="/OMA/Type"/></xsl:when>
      <xsl:otherwise>empty</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  
  <xsl:template match="OMA">
    <DataArea exportdata="false">
      <PageTitle>
        <xsl:attribute name="display"><xsl:value-of select="$strAlertActions"/></xsl:attribute>
      </PageTitle>
      <Header>Header</Header>
      <CustomButton>
        <Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.ListLRAWebPlugin&amp;type=<xsl:value-of select="/OMA/Type"/>&amp;help=ListLRA</xsl:attribute>
				</Data>
			</CustomButton>

    <xsl:choose>
      <xsl:when test="$lraName ='empty'">
        <xsl:call-template name="SystemEvents"/>
        <xsl:call-template name="StorageEvents"/>
      </xsl:when>
      <xsl:when test="$lraName='storage'">
        <xsl:call-template name="StorageEvents"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="SystemEvents"/>
      </xsl:otherwise>
    </xsl:choose>

  </DataArea>
</xsl:template>

<xsl:template name="SystemEvents">
			<xsl:choose>
				<xsl:when test="$lraName = 'empty' or
						($lraName = 'powersupply' and count($lraObjs[lrcLraType = '177' or lrcLraType = '308'][lraApplicableToSystem = 'true']) &gt; 0) or
						($lraName = 'fan' and count($lraObjs[lrcLraType = '180' or lrcLraType = '181'][lraApplicableToSystem = 'true']) &gt; 0) or
						($lraName = 'temperature' and count($lraObjs[lrcLraType = '178' or lrcLraType = '179'][lraApplicableToSystem = 'true']) &gt; 0) or
						($lraName = 'voltage' and count($lraObjs[lrcLraType = '182' or lrcLraType = '183'][lraApplicableToSystem = 'true']) &gt; 0) or
						($lraName = 'powermonitoring' and count($lraObjs[lrcLraType = '184' or lrcLraType = '185'][lraApplicableToSystem = 'true']) &gt; 0) or
						($lraName = 'intrusion' and count($lraObjs[lrcLraType = '186'][lraApplicableToSystem = 'true']) &gt; 0) or
						($lraName = 'memory' and count($lraObjs[lrcLraType = '189' or lrcLraType = '190'][lraApplicableToSystem = 'true']) &gt; 0) or
						($lraName = 'processor' and count($lraObjs[lrcLraType = '306' or lrcLraType = '307'][lraApplicableToSystem = 'true']) &gt; 0) or
						($lraName = 'battery' and count($lraObjs[lrcLraType = '309' or lrcLraType = '310'][lraApplicableToSystem = 'true']) &gt; 0)">
					<xsl:if test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
						<PromptText><xsl:value-of select="$strClickTheEvent"/></PromptText>
					</xsl:if>
      <TableData columnspacing="true" name="sysevents">
        <xsl:attribute name="display"><xsl:value-of select="$strSystemEvent"/></xsl:attribute>
							<xsl:choose>
							<xsl:when test="/OMA/@cli = 'true'">
								<Header>
									<Data>
										<xsl:attribute name="display"><xsl:value-of select="$strEvent"/></xsl:attribute>
										<xsl:attribute name="value"><xsl:value-of select="$strEvent1"/></xsl:attribute>
									</Data>					
									<Data>
										<xsl:attribute name="display"><xsl:value-of select="$strConsoleAlert"/></xsl:attribute>
										<xsl:attribute name="value"><xsl:value-of select="$strConsoleAlert1"/></xsl:attribute>
									</Data>
									<Data>
										<xsl:attribute name="display"><xsl:value-of select="$strBroadcastMessage"/></xsl:attribute>
										<xsl:attribute name="value"><xsl:value-of select="$strBroadcastMessage1"/></xsl:attribute>
									</Data>
									<Data>
										<xsl:attribute name="display"><xsl:value-of select="$strExecuteApplication"/></xsl:attribute>
										<xsl:attribute name="value"><xsl:value-of select="$strExecuteApplication1"/></xsl:attribute>
									</Data>
                  <xsl:if test="$UsrRights=7 and $UsrElevate!=1">
									<Data>
										<xsl:attribute name="display"><xsl:value-of select="$strAbsolutePathTo"/></xsl:attribute>
										<xsl:attribute name="value"><xsl:value-of select="$strAbsolutePathTo1"/></xsl:attribute>
									</Data>
                  </xsl:if>
								</Header>
							</xsl:when>
							<xsl:otherwise>
								<Header>
              <Data name="SystemEvent">
										<xsl:attribute name="display"></xsl:attribute>
									</Data>
									<Data name="Action" colspan="7" underlined="true" align="center">
										<xsl:attribute name="display"><xsl:value-of select="$strCurrentlyActiveActions"/></xsl:attribute>
										<xsl:attribute name="value"><xsl:value-of select="$strCurrentlyActiveActions1"/></xsl:attribute>
									</Data>
								</Header>
								<Header>
              <Data name=" " width="300">
                <xsl:attribute name="display"><xsl:value-of select="$strSystemEvent"/></xsl:attribute>
                <xsl:attribute name="value"><xsl:value-of select="$strSystemEvent"/></xsl:attribute>
									</Data>					
									<Data name="" append="Action" align="center" width="100">
										<xsl:attribute name="display"><xsl:value-of select="$strAlertOnConsole"/></xsl:attribute>
										<xsl:attribute name="value"><xsl:value-of select="$strAlertOnConsole1"/></xsl:attribute>
									</Data>
									<Data name="" append="Action" align="center" width="100">
										<xsl:attribute name="display"><xsl:value-of select="$strBroadcastMessage2"/></xsl:attribute>
										<xsl:attribute name="value"><xsl:value-of select="$strBroadcastMessage3"/></xsl:attribute>
									</Data>
									<Data name="" append="Action" align="center" width="100">
										<xsl:attribute name="display"><xsl:value-of select="$strExecuteApplication2"/></xsl:attribute>
										<xsl:attribute name="value"><xsl:value-of select="$strExecuteApplication3"/></xsl:attribute>
									</Data>
									<Data name="" ignoreonweb="true">
										<xsl:attribute name="display"><xsl:value-of select="$strAbsolutePathTo2"/></xsl:attribute>
										<xsl:attribute name="value"><xsl:value-of select="$strAbsolutePathTo3"/></xsl:attribute>
									</Data>
								</Header>
							</xsl:otherwise>
						</xsl:choose>
        <xsl:call-template name="SystemLRAResponse"/>
					</TableData>
				</xsl:when>
				<xsl:otherwise>
					<PromptText><xsl:value-of select="$strNoActionsAvailable"/></PromptText>
				</xsl:otherwise>
			</xsl:choose>
</xsl:template>

<xsl:template name="SystemLRAResponse">
  <xsl:for-each select="LRAResponse/lroConfigSDOArrayarray/lroConfigSDOArray">
    <xsl:call-template name="SystemlroConfigSDOArray"/>
  </xsl:for-each>
</xsl:template>
  
<xsl:template name="SystemlroConfigSDOArray">  
	<!--Display only LRA ralated to that page -->
    <xsl:if test="lraApplicableToSystem = 'true' and
					  ( ($lraName = 'empty' and not(lrcLraType &gt; '2047' and lrcLraType &lt; '3072')) or
						($lraName = 'powersupply' and (lrcLraType = '177' or lrcLraType = '308')) or
						($lraName = 'fan' and (lrcLraType = '180' or lrcLraType = '181')) or
						($lraName = 'temperature' and (lrcLraType = '178' or lrcLraType = '179')) or
						($lraName = 'voltage' and (lrcLraType = '182' or lrcLraType = '183')) or
						($lraName = 'powermonitoring' and (lrcLraType = '184' or lrcLraType = '185')) or
						($lraName = 'intrusion' and lrcLraType = '186') or
						($lraName = 'memory' and (lrcLraType = '189' or lrcLraType = '190')) or
						($lraName = 'processor' and (lrcLraType = '306' or lrcLraType = '307')) or
						($lraName = 'battery' and (lrcLraType = '309' or lrcLraType = '310')))">
		<Row>
			<xsl:element name="Data">
				<xsl:attribute name="display"><xsl:value-of select="lrcLraType"/></xsl:attribute>
				<xsl:attribute name="value">
					<xsl:call-template name="Getname">
						<xsl:with-param name="type"><xsl:value-of select="lrcLraType"/></xsl:with-param>
					</xsl:call-template>
				</xsl:attribute>
				<xsl:attribute name="type">ustring</xsl:attribute>
					<xsl:if test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
					<xsl:attribute name="link">true</xsl:attribute>
				</xsl:if>
				<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.LRAWebPlugin&amp;oid=<xsl:value-of select="@oid"/>&amp;type=<xsl:value-of select="/OMA/Type"/>&amp;lratype=<xsl:value-of select="lrcLraType"/>&amp;help=ListLRA</xsl:attribute>
				<xsl:attribute name="editable">false</xsl:attribute>
				<xsl:attribute name="align">left</xsl:attribute>
			</xsl:element>
			<Data type="icon" align="center">
				<xsl:attribute name="value">
					<xsl:call-template name="getaction">
						<xsl:with-param name="status"><xsl:value-of select="lrcBitmapSettings/ConsAlert"/></xsl:with-param>
					</xsl:call-template>
				</xsl:attribute>
				<xsl:attribute name="alt">
					<xsl:call-template name="getactiontxt">
						<xsl:with-param name="status"><xsl:value-of select="lrcBitmapSettings/ConsAlert"/></xsl:with-param>
					</xsl:call-template>
				</xsl:attribute>
			</Data>
			<Data type="icon" align="center">
				<xsl:attribute name="value">
					<xsl:call-template name="getaction">
						<xsl:with-param name="status"><xsl:value-of select="lrcBitmapSettings/BcastMssg"/></xsl:with-param>
					</xsl:call-template>
				</xsl:attribute>
				<xsl:attribute name="alt">
					<xsl:call-template name="getactiontxt">
						<xsl:with-param name="status"><xsl:value-of select="lrcBitmapSettings/BcastMssg"/></xsl:with-param>
					</xsl:call-template>
				</xsl:attribute>
			</Data>
			<Data type="icon" align="center">
				<xsl:attribute name="value">
					<xsl:call-template name="getaction">
						<xsl:with-param name="status"><xsl:value-of select="lrcBitmapSettings/ExecApp"/></xsl:with-param>
					</xsl:call-template>
				</xsl:attribute>
				<xsl:attribute name="alt">
					<xsl:call-template name="getactiontxt">
						<xsl:with-param name="status"><xsl:value-of select="lrcBitmapSettings/ExecApp"/></xsl:with-param>
					</xsl:call-template>
				</xsl:attribute>
			</Data>
      <xsl:choose>
      <xsl:when test="/OMA/@cli = 'true'">
        <xsl:if test="$UsrRights=7 and $UsrElevate!=1">
          <Data ignoreonweb="true">
            <xsl:choose>
              <xsl:when test="lrcBitmapSettings/ExecApp = 'true'">
                <xsl:attribute name="value"><xsl:value-of select="lrcEpfName"/></xsl:attribute>
                <xsl:attribute name="display"><xsl:value-of select="lrcEpfName"/></xsl:attribute>
              </xsl:when>
              <xsl:otherwise>
                <xsl:attribute name="value"><xsl:value-of select="$strNotSelected"/></xsl:attribute>
                <xsl:attribute name="display"><xsl:value-of select="$strNotSelected1"/></xsl:attribute>
              </xsl:otherwise>
            </xsl:choose>
          </Data>
        </xsl:if>
      </xsl:when>
      <xsl:otherwise>
        <Data ignoreonweb="true">
          <xsl:choose>
            <xsl:when test="lrcBitmapSettings/ExecApp = 'true'">
              <xsl:attribute name="value"><xsl:value-of select="lrcEpfName"/></xsl:attribute>
              <xsl:attribute name="display"><xsl:value-of select="lrcEpfName"/></xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="value"><xsl:value-of select="$strNotSelected"/></xsl:attribute>
              <xsl:attribute name="display"><xsl:value-of select="$strNotSelected1"/></xsl:attribute>
            </xsl:otherwise>
          </xsl:choose>
          </Data>
      </xsl:otherwise>
      </xsl:choose>
		</Row>
	</xsl:if>
	</xsl:template>
  
	<xsl:template name="Getname">
		<xsl:param name="type"/>
		<xsl:choose>
			<xsl:when test="$type='177'"><xsl:value-of select="$strPowerSupplyCritical"/></xsl:when>
			<xsl:when test="$type='178'"><xsl:value-of select="$strTemperatureProbeWarning"/></xsl:when>
			<xsl:when test="$type='179'"><xsl:value-of select="$strTemperatureProbeDetects"/></xsl:when>
			<xsl:when test="$type='180'"><xsl:value-of select="$strFanProbeWarning"/></xsl:when>
			<xsl:when test="$type='181'"><xsl:value-of select="$strFanProbeDetects"/></xsl:when>
			<xsl:when test="$type='182'"><xsl:value-of select="$strVoltageProbeWarning"/></xsl:when>
			<xsl:when test="$type='183'"><xsl:value-of select="$strVoltageProbeDetects"/></xsl:when>
			<xsl:when test="$type='184'"><xsl:value-of select="$strSystemPowerProbeWarning"/></xsl:when>
			<xsl:when test="$type='185'"><xsl:value-of select="$strSystemPowerProbeFailure"/></xsl:when>
			<xsl:when test="$type='186'"><xsl:value-of select="$strChassisIntrusionDetected"/></xsl:when>
			<xsl:when test="$type='187'"><xsl:value-of select="$strRedundancyDegraded"/></xsl:when>
			<xsl:when test="$type='188'"><xsl:value-of select="$strRedundancyLost"/></xsl:when>
			<xsl:when test="$type='189'"><xsl:value-of select="$strMemoryPrefailure"/></xsl:when>
			<xsl:when test="$type='190'"><xsl:value-of select="$strMemoryFailure"/></xsl:when>
			<xsl:when test="$type='304'"><xsl:value-of select="$strHardwareLogWarning"/></xsl:when>
			<xsl:when test="$type='305'"><xsl:value-of select="$strHardwareLogFailure"/></xsl:when>
			<xsl:when test="$type='308'"><xsl:value-of select="$strPowerSupplyWarning"/></xsl:when>
			<xsl:when test="$type='306'"><xsl:value-of select="$strProcessorWarning"/></xsl:when>
			<xsl:when test="$type='307'"><xsl:value-of select="$strProcessorFailure"/></xsl:when>
			<xsl:when test="$type='175'"><xsl:value-of select="$strWatchdogASR"/></xsl:when>
			<xsl:when test="$type='309'"><xsl:value-of select="$strBatteryProbeWarning"/></xsl:when>
			<xsl:when test="$type='310'"><xsl:value-of select="$strBatteryProbeDetects"/></xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="getaction">
		<xsl:param name="status"/>
		<xsl:if test="$status='true'"><!--/oma/images/bullet.gif-->/oma/images/check.gif</xsl:if>
		<xsl:if test="$status='false'">/oma/images/blank.gif</xsl:if>
	</xsl:template>
	<xsl:template name="getactiontxt">
		<xsl:param name="status"/>
		<xsl:if test="$status='true'"><!--/oma/images/bullet.gif--><xsl:value-of select="$strSelected"/></xsl:if>
		<xsl:if test="$status='false'"><xsl:value-of select="$strNotSelected2"/></xsl:if>
	</xsl:template>

  <xsl:template name="StorageEvents">
    <xsl:choose>
      <xsl:when test="count($lraObjs[lrcLraType &gt; '2047' and lrcLraType &lt; '3072'][lraApplicableToSystem = 'true']) &gt; 0">
        <xsl:if test="$lraName='storage'">
	        <xsl:if test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
	         <PromptText><xsl:value-of select="$strClickTheEvent"/></PromptText>
          </xsl:if>
        </xsl:if>
        <TableData columnspacing="true" name="ssevents" >
          <xsl:attribute name="display"><xsl:value-of select="$strStorageEvent"/></xsl:attribute>
          <xsl:choose>
            <xsl:when test="/OMA/@cli = 'true'">
              <Header>
                <Data>
                  <xsl:attribute name="display"><xsl:value-of select="$strEvent"/></xsl:attribute>
                  <xsl:attribute name="value"><xsl:value-of select="$strEvent1"/></xsl:attribute>
                </Data>
                <Data>
                  <xsl:attribute name="display"><xsl:value-of select="$strConsoleAlert"/></xsl:attribute>
                  <xsl:attribute name="value"><xsl:value-of select="$strConsoleAlert1"/></xsl:attribute>
                </Data>
                <Data>
                  <xsl:attribute name="display"><xsl:value-of select="$strBroadcastMessage"/></xsl:attribute>
                  <xsl:attribute name="value"><xsl:value-of select="$strBroadcastMessage1"/></xsl:attribute>
                </Data>
                <Data>
                  <xsl:attribute name="display"><xsl:value-of select="$strExecuteApplication"/></xsl:attribute>
                  <xsl:attribute name="value"><xsl:value-of select="$strExecuteApplication1"/></xsl:attribute>
                </Data>
                <xsl:if test="$UsrRights=7 and $UsrElevate!=1">
                <Data>
                  <xsl:attribute name="display"><xsl:value-of select="$strAbsolutePathTo"/></xsl:attribute>
                  <xsl:attribute name="value"><xsl:value-of select="$strAbsolutePathTo1"/></xsl:attribute>
                </Data>
                </xsl:if>
              </Header>
            </xsl:when>
            <xsl:otherwise>
              <Header>
                <Data name="StorageEvent">
			<xsl:attribute name="display"></xsl:attribute>
                </Data>
                <Data name="Action" colspan="7" underlined="true" align="center">
                  <xsl:attribute name="display"><xsl:value-of select="$strCurrentlyActiveActions"/></xsl:attribute>
                  <xsl:attribute name="value"><xsl:value-of select="$strCurrentlyActiveActions1"/></xsl:attribute>
                </Data>
              </Header>
              <Header>
                <Data name=" " width="300">
                  <xsl:attribute name="display"><xsl:value-of select="$strStorageEvent"/></xsl:attribute>
                  <xsl:attribute name="value"><xsl:value-of select="$strStorageEvent"/></xsl:attribute>
                </Data>
                <Data name="" append="Action" align="center" width="100">
                  <xsl:attribute name="display"><xsl:value-of select="$strAlertOnConsole"/></xsl:attribute>
                  <xsl:attribute name="value"><xsl:value-of select="$strAlertOnConsole1"/></xsl:attribute>
                </Data>
                <Data name="" append="Action" align="center" width="100">
                  <xsl:attribute name="display"><xsl:value-of select="$strBroadcastMessage2"/></xsl:attribute>
                  <xsl:attribute name="value"><xsl:value-of select="$strBroadcastMessage3"/></xsl:attribute>
                </Data>
                <Data name="" append="Action" align="center" width="100">
                  <xsl:attribute name="display"><xsl:value-of select="$strExecuteApplication2"/></xsl:attribute>
                  <xsl:attribute name="value"><xsl:value-of select="$strExecuteApplication3"/></xsl:attribute>
                </Data>
                <Data name="" ignoreonweb="true">
                  <xsl:attribute name="display"><xsl:value-of select="$strAbsolutePathTo2"/></xsl:attribute>
                  <xsl:attribute name="value"><xsl:value-of select="$strAbsolutePathTo3"/></xsl:attribute>
                </Data>
              </Header>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:call-template name="StorageLRAResponse"/>
        </TableData>
      </xsl:when>
      <xsl:otherwise>
        <xsl:if test="$lraName='storage'">
          <PromptText><xsl:value-of select="$strNoActionsAvailable"/></PromptText>
        </xsl:if>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="StorageLRAResponse">
    <xsl:for-each select="/OMA/LRAResponse/lroConfigSDOArrayarray/lroConfigSDOArray">
      <xsl:call-template name="StoragelroConfigSDOArray"/>
    </xsl:for-each>
  </xsl:template>

  <xsl:template name="StoragelroConfigSDOArray">
    <!--Display only LRA ralated to that page -->
    <xsl:if test="lraApplicableToSystem = 'true' and
		 ( lrcLraType = '2050' or lrcLraType = '2051' or lrcLraType = '2060' or lrcLraType = '2061' or
	     lrcLraType = '2070' or lrcLraType = '2071' or lrcLraType = '2080' or lrcLraType = '2081' or
       lrcLraType = '2090' or lrcLraType = '2091' or lrcLraType = '2100' or lrcLraType = '2101')">
      <Row>
        <xsl:element name="Data">
          <xsl:attribute name="display"><xsl:value-of select="lrcLraType"/></xsl:attribute>
          <xsl:attribute name="value">
            <xsl:call-template name="StorageGetName">
              <xsl:with-param name="type"><xsl:value-of select="lrcLraType"/></xsl:with-param>
            </xsl:call-template>
          </xsl:attribute>
          <xsl:attribute name="type">ustring</xsl:attribute>
          <xsl:if test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
            <xsl:attribute name="link">true</xsl:attribute>
          </xsl:if>
          <xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.LRAWebPlugin&amp;oid=<xsl:value-of select="@oid"/>&amp;type=<xsl:value-of select="/OMA/Type"/>&amp;lratype=<xsl:value-of select="lrcLraType"/>&amp;help=ListLRA</xsl:attribute>
          <xsl:attribute name="editable">false</xsl:attribute>
          <xsl:attribute name="align">left</xsl:attribute>
        </xsl:element>
        <Data type="icon" align="center">
          <xsl:attribute name="value">
            <xsl:call-template name="getaction">
              <xsl:with-param name="status"><xsl:value-of select="lrcBitmapSettings/ConsAlert"/></xsl:with-param>
            </xsl:call-template>
          </xsl:attribute>
          <xsl:attribute name="alt">
            <xsl:call-template name="getactiontxt">
              <xsl:with-param name="status"><xsl:value-of select="lrcBitmapSettings/ConsAlert"/></xsl:with-param>
            </xsl:call-template>
          </xsl:attribute>
        </Data>
        <Data type="icon" align="center">
          <xsl:attribute name="value">
            <xsl:call-template name="getaction">
              <xsl:with-param name="status"><xsl:value-of select="lrcBitmapSettings/BcastMssg"/></xsl:with-param>
            </xsl:call-template>
          </xsl:attribute>
          <xsl:attribute name="alt">
            <xsl:call-template name="getactiontxt">
              <xsl:with-param name="status"><xsl:value-of select="lrcBitmapSettings/BcastMssg"/></xsl:with-param>
            </xsl:call-template>
          </xsl:attribute>
        </Data>
        <Data type="icon" align="center">
          <xsl:attribute name="value">
            <xsl:call-template name="getaction">
              <xsl:with-param name="status"><xsl:value-of select="lrcBitmapSettings/ExecApp"/></xsl:with-param>
            </xsl:call-template>
          </xsl:attribute>
          <xsl:attribute name="alt">
            <xsl:call-template name="getactiontxt">
              <xsl:with-param name="status"><xsl:value-of select="lrcBitmapSettings/ExecApp"/></xsl:with-param>
            </xsl:call-template>
          </xsl:attribute>
        </Data>
        <xsl:choose>
	<xsl:when test="/OMA/@cli = 'true'">
        <xsl:if test="$UsrRights=7 and $UsrElevate!=1">
        <Data ignoreonweb="true">
          <xsl:choose>
            <xsl:when test="lrcBitmapSettings/ExecApp = 'true'">
              <xsl:attribute name="value"><xsl:value-of select="lrcEpfName"/></xsl:attribute>
              <xsl:attribute name="display"><xsl:value-of select="lrcEpfName"/></xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="value"><xsl:value-of select="$strNotSelected"/></xsl:attribute>
              <xsl:attribute name="display"><xsl:value-of select="$strNotSelected1"/></xsl:attribute>
            </xsl:otherwise>
          </xsl:choose>
        </Data>
        </xsl:if>
        </xsl:when>
        <xsl:otherwise>
        <Data ignoreonweb="true">
	   <xsl:choose>
	     <xsl:when test="lrcBitmapSettings/ExecApp = 'true'">
	         <xsl:attribute name="value"><xsl:value-of select="lrcEpfName"/></xsl:attribute>
	         <xsl:attribute name="display"><xsl:value-of select="lrcEpfName"/></xsl:attribute>
	     </xsl:when>
	     <xsl:otherwise>
	         <xsl:attribute name="value"><xsl:value-of select="$strNotSelected"/></xsl:attribute>
	         <xsl:attribute name="display"><xsl:value-of select="$strNotSelected1"/></xsl:attribute>
	     </xsl:otherwise>
	   </xsl:choose>
        </Data>
        </xsl:otherwise>
       </xsl:choose>
      </Row>
    </xsl:if>
  </xsl:template>

  <xsl:template name="StorageGetName">
    <xsl:param name="type"/>
    <xsl:choose>
      <xsl:when test="$type='2050'"><xsl:value-of select="$strStorageSysWarning"/></xsl:when>
      <xsl:when test="$type='2051'"><xsl:value-of select="$strStorageSysFailure"/></xsl:when>
      <xsl:when test="$type='2060'"><xsl:value-of select="$strStorageCtrlWarning"/></xsl:when>
      <xsl:when test="$type='2061'"><xsl:value-of select="$strStorageCtrlFailure"/></xsl:when>
      <xsl:when test="$type='2070'"><xsl:value-of select="$strPhysicalDiskWarning"/></xsl:when>
      <xsl:when test="$type='2071'"><xsl:value-of select="$strPhysicalDiskFailure"/></xsl:when>
      <xsl:when test="$type='2080'"><xsl:value-of select="$strVirtualDiskWarning"/></xsl:when>
      <xsl:when test="$type='2081'"><xsl:value-of select="$strVirtualDiskFailure"/></xsl:when>
      <xsl:when test="$type='2090'"><xsl:value-of select="$strEnclosureWarning"/></xsl:when>
      <xsl:when test="$type='2091'"><xsl:value-of select="$strEnclosureFailure"/></xsl:when>
      <xsl:when test="$type='2100'"><xsl:value-of select="$strStorageCtrlBatteryWarning"/></xsl:when>
      <xsl:when test="$type='2101'"><xsl:value-of select="$strStorageCtrlBatteryFailure"/></xsl:when>
    </xsl:choose>
  </xsl:template>
  
</xsl:stylesheet>
