<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="OMA">
		<xsl:choose>
			<xsl:when test="SMStatus != '0'">
				<DataArea printable="false">
					<PageTitle/>
					<xsl:attribute name="display"><xsl:value-of select="$strFanProbes"/></xsl:attribute>
					<TableData>
						<Header>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strError"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strError1"/></xsl:attribute>
							</Data>
						</Header>
						<Row>
                            <Data>
                                <xsl:attribute name="display"><xsl:value-of select="$str"/></xsl:attribute>
                                <xsl:attribute name="value"><xsl:call-template name="smstatus"><xsl:with-param name="status"><xsl:value-of select="SMStatus"/></xsl:with-param></xsl:call-template></xsl:attribute>
							</Data>
						</Row>
					</TableData>
				</DataArea>
			</xsl:when>
			<xsl:otherwise>
				<DataArea>
					<PageTitle>
						<xsl:attribute name="display"><xsl:value-of select="$strFanProbes1"/></xsl:attribute>
						<xsl:choose>
                            <xsl:when test="/OMA/@cli = 'true'"/>
							<xsl:otherwise>
							     <xsl:attribute name="status"><xsl:value-of select="/OMA/ObjStatus"/></xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</PageTitle>
					<CustomButton>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
							<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.FanProbesWebPlugin&amp;poid=<xsl:value-of select="/OMA/FanProbeList/@poid"/>&amp;help=Fans</xsl:attribute>
						</Data>
					</CustomButton>
					<xsl:choose>
						<xsl:when test="/OMA/@cli = 'true'">
							<xsl:for-each select="Chassis">
								<xsl:call-template name="ChassisFans"/>
							</xsl:for-each>
						</xsl:when>
                        <xsl:otherwise>
                            <xsl:call-template name="ChassisFans"/>
                        </xsl:otherwise>
                    	</xsl:choose>
				</DataArea>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="ChassisFans">
		<xsl:choose>
			<xsl:when test="Redundancy !=''">
                <xsl:variable name="redundata">
                    <xsl:value-of select="Redundancy"/>
                </xsl:variable>
				<xsl:choose>
					<xsl:when test="$redundata != '' ">
						<TableData name="reduntable">
							<xsl:attribute name="display"><xsl:value-of select="$strFanRedundancy"/></xsl:attribute>
						    <xsl:if test="/OMA/@cli = 'true'">
                                <SubHeader banner="true">
                                    <xsl:attribute name="display"><xsl:value-of select="@display"/><xsl:value-of select="$strFans"/></xsl:attribute>
                                    <xsl:attribute name="status"><xsl:value-of select="ObjStatus"/></xsl:attribute>
							     </SubHeader>
							</xsl:if>
							<SubHeader>
								<xsl:attribute name="display"><xsl:value-of select="$strFanRedundancy"/></xsl:attribute>
								<xsl:attribute name="status"><xsl:value-of select="Redundancy/@status"/></xsl:attribute>
							</SubHeader>
							<xsl:apply-templates select="Redundancy"/>
						</TableData>
						<TableData columnspacing="true" name="probestable">
							<xsl:attribute name="display"><xsl:value-of select="$strProbeList"/></xsl:attribute>
							<xsl:if test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
								<xsl:choose>
                                    <xsl:when test="/OMA/@cli = 'true'"/>
									<xsl:otherwise>
                                        <PromptText>
                                            <xsl:value-of select="$strClickTheProbe"/>
                                        </PromptText>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:if>
                            <SubHeader>
                                <xsl:attribute name="display"><xsl:value-of select="$strProbeList"/></xsl:attribute>
                            </SubHeader>
							<xsl:apply-templates select="FanProbeList"/>
						</TableData>
					</xsl:when>
					<xsl:otherwise>
						<TableData columnspacing="true" name="probestable">
							<xsl:attribute name="display"><xsl:value-of select="$strProbeList1"/></xsl:attribute>
							<xsl:if test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
								<xsl:choose>
                                    <xsl:when test="/OMA/@cli = 'true'"/>
									<xsl:otherwise>
                                        <PromptText>
                                            <xsl:value-of select="$strClickTheProbe1"/>
                                        </PromptText>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:if>
                            <xsl:if test="/OMA/@cli = 'true'">
                                <SubHeader banner="true">
                                    <xsl:choose>
                                        <xsl:when test="(count(FanProbeList/FanProbe)) > 1">
                                            <xsl:attribute name="display"><xsl:value-of select="@display"/><xsl:value-of select="$strFans"/></xsl:attribute>
											<xsl:attribute name="status"><xsl:value-of select="ObjStatus"/></xsl:attribute>
										</xsl:when>
										<xsl:otherwise>
									          <xsl:attribute name="display"><xsl:value-of select="@display"/></xsl:attribute>
										</xsl:otherwise>
			                  			</xsl:choose>
							     </SubHeader>
							</xsl:if>
							<xsl:apply-templates select="FanProbeList"/>
						</TableData>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
					<xsl:choose>
                        <xsl:when test="/OMA/@cli = 'true'"/>
						<xsl:otherwise>
                            <PromptText>
                                <xsl:value-of select="$strClickTheProbe2"/>
                            </PromptText>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:if>
                <TableData columnspacing="true" name="probestable">
                    <xsl:attribute name="display"><xsl:value-of select="@display"/><xsl:value-of select="$strFans"/></xsl:attribute>
                    <xsl:attribute name="status"><xsl:value-of select="ObjStatus"/></xsl:attribute>
                    <xsl:if test="/OMA/@cli = 'true'">
                        <SubHeader banner="true">
							<xsl:choose>
	                     			<xsl:when test="count(FanProbeList/FanProbe) > 1">
                                    <xsl:attribute name="display"><xsl:value-of select="@display"/><xsl:value-of select="$strFans"/></xsl:attribute>
									<xsl:attribute name="status"><xsl:value-of select="ObjStatus"/></xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
							          <xsl:attribute name="display"><xsl:value-of select="@display"/></xsl:attribute>
								</xsl:otherwise>
	                  			</xsl:choose>
	                          </SubHeader>
	                      </xsl:if>
					<xsl:apply-templates select="FanProbeList"/>
				</TableData>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
<xsl:template match="FanProbeList">
		<xsl:choose>
			<xsl:when test="/OMA/@cli = 'true'">
				<Header>
					<Data ignoreonweb="true">
						<xsl:attribute name="display"><xsl:value-of select="$strIndex"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strIndex1"/></xsl:attribute>
					</Data>
					<Data align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strStatus1"/></xsl:attribute>
					</Data>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strProbeName"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strProbeName1"/></xsl:attribute>
					</Data>
					<Data align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strReading"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strReading1"/></xsl:attribute>
					</Data>
					<Data align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strMinimumWarningThreshold"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strMinimumWarningThreshold1"/></xsl:attribute>
					</Data>
					<Data align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strMaximumWarningThreshold"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strMaximumWarningThreshold1"/></xsl:attribute>
					</Data>
					<Data align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strMinimumFailureThreshold"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strMinimumFailureThreshold1"/></xsl:attribute>
					</Data>
					<Data align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strMaximumFailureThreshold"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strMaximumFailureThreshold1"/></xsl:attribute>
					</Data>
				</Header>
			</xsl:when>
			<xsl:otherwise>
				<Header>
					<!--Data name="" display="" value="" ignoreonweb="true"/-->
                    <Data name="" ignoreonweb="true">
                        <xsl:attribute name="value"><xsl:value-of select="$str1"/></xsl:attribute>
                        <xsl:attribute name="display"><xsl:value-of select="$str2"/></xsl:attribute>
                    </Data>
                    <Data name="">
                        <xsl:attribute name="value"><xsl:value-of select="$str3"/></xsl:attribute>
                        <xsl:attribute name="display"><xsl:value-of select="$str4"/></xsl:attribute>
                    </Data>
                    <Data name="">
                        <xsl:attribute name="value"><xsl:value-of select="$str5"/></xsl:attribute>
                        <xsl:attribute name="display"><xsl:value-of select="$str6"/></xsl:attribute>
                    </Data>
                    <Data name="">
                        <xsl:attribute name="value"><xsl:value-of select="$str7"/></xsl:attribute>
                        <xsl:attribute name="display"><xsl:value-of select="$str8"/></xsl:attribute>
                    </Data>
					<Data colspan="3" italic="true" align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strWarningThreshold"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strWarningThreshold1"/></xsl:attribute>
					</Data>
					<Data colspan="3" italic="true" align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strFailureThreshold"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strFailureThreshold1"/></xsl:attribute>
					</Data>
				</Header>
				<Header>
					<Data ignoreonweb="true">
						<xsl:attribute name="display"><xsl:value-of select="$strIndex2"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strIndex3"/></xsl:attribute>
					</Data>
					<Data align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strStatus2"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strStatus3"/></xsl:attribute>
					</Data>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strProbeName2"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strProbeName3"/></xsl:attribute>
					</Data>
					<Data align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strReading2"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strReading3"/></xsl:attribute>
					</Data>
					<Data align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strMinimum"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strMinimum1"/></xsl:attribute>
						<xsl:attribute name="append"><xsl:value-of select="$strWarningThreshold2"/></xsl:attribute>
					</Data>
					<Data align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strMaximum"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strMaximum1"/></xsl:attribute>
						<xsl:attribute name="append"><xsl:value-of select="$strWarningThreshold3"/></xsl:attribute>
					</Data>
					<Data align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strMinimum2"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strMinimum3"/></xsl:attribute>
						<xsl:attribute name="append"><xsl:value-of select="$strFailureThreshold2"/></xsl:attribute>
					</Data>
					<Data align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strMaximum2"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strMaximum3"/></xsl:attribute>
						<xsl:attribute name="append"><xsl:value-of select="$strFailureThreshold3"/></xsl:attribute>
					</Data>
				</Header>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="/OMA/@cli = 'true'">
				<xsl:apply-templates select="FanProbe">
					<xsl:sort data-type="number" select="@index" order="ascending"/>
				</xsl:apply-templates>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="FanProbe">
					<xsl:sort data-type="text" select="ProbeLocation" order="ascending"/>
				</xsl:apply-templates>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="Redundancy">
		<Header>
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strAttribute"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strAttribute1"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strValue"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strValue1"/></xsl:attribute>
			</Data>
		</Header>
		<Row>
			<Data>
				<xsl:attribute name="value"><xsl:value-of select="$strRedundancyStatus"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:call-template name="RedStatus">
					<xsl:with-param name="status">
						<xsl:value-of select="RedunStatus"/>
					</xsl:with-param>
				</xsl:call-template>
			</Data>
		</Row>
		<xsl:if test="(RedunCount > '0')">
			<Row>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="$strNumberOfDevices"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="RedunCount"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
	</xsl:template>
	<xsl:template match="FanProbe">
		<xsl:choose>
			<xsl:when test="(SubType != '1') and (SubType != '3')">
				<Row>
					<xsl:element name="Data">
						<xsl:attribute name="value"><xsl:value-of select="@status"/></xsl:attribute>
						<xsl:attribute name="type">status</xsl:attribute>
						<xsl:attribute name="align">center</xsl:attribute>
					</xsl:element>
					<xsl:element name="Data">
						<xsl:attribute name="value"><xsl:value-of select="ProbeLocation"/></xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="ProbeLocation"/></xsl:attribute>
						<xsl:attribute name="align">left</xsl:attribute>
					</xsl:element>
					<xsl:element name="Data">
						<xsl:variable name="reading">
							<xsl:choose>
                                <xsl:when test="SubType='21'">
                                    <xsl:choose>
                                        <xsl:when test="ProbeReading = '1'">
                                            <xsl:value-of select="$strGood"/>
                                        </xsl:when>
                                         <xsl:when test="ProbeReading = '2'">
                                            <xsl:value-of select="$strBad"/>
                                        </xsl:when>
                                    </xsl:choose>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:choose>
								<xsl:when test="ProbeReading = 'true'">
									<xsl:value-of select="$strOn"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="$strOff"/>
								</xsl:otherwise>
							</xsl:choose>
                                </xsl:otherwise>
                            </xsl:choose>
						</xsl:variable>
						<xsl:attribute name="value"><xsl:value-of select="$reading"/></xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="$reading"/></xsl:attribute>
                        <xsl:attribute name="align">center</xsl:attribute>
					</xsl:element>
					<xsl:element name="Data">
						<xsl:attribute name="align">center</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="$strNA"/></xsl:attribute>
					</xsl:element>
					<xsl:element name="Data">
						<xsl:attribute name="align">center</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="$strNA"/></xsl:attribute>
					</xsl:element>
					<xsl:element name="Data">
						<xsl:attribute name="align">center</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="$strNA"/></xsl:attribute>
					</xsl:element>
					<xsl:element name="Data">
						<xsl:attribute name="align">center</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="$strNA"/></xsl:attribute>
					</xsl:element>
				</Row>
			</xsl:when>
			<xsl:otherwise>
				<Row>
					<xsl:element name="Data">
						<xsl:attribute name="ignoreonweb">true</xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="@index"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="@index"/></xsl:attribute>
					</xsl:element>
					<xsl:element name="Data">
						<xsl:attribute name="value"><xsl:value-of select="@status"/></xsl:attribute>
						<xsl:attribute name="type">status</xsl:attribute>
						<xsl:attribute name="align">center</xsl:attribute>
					</xsl:element>
					<xsl:element name="Data">
						<xsl:attribute name="value"><xsl:value-of select="ProbeLocation"/></xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="ProbeLocation"/></xsl:attribute>
						<xsl:if test="((/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')) and (ProbeThresholds/LNCThreshold &gt; 0) and ( ProbeThresholds/UNCThreshold &gt; 0)">
							<xsl:attribute name="link">true</xsl:attribute>
							<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.EditFanProbeWebPlugin&amp;oid=<xsl:value-of select="@oid"/>&amp;poid=<xsl:value-of select="@poid"/>&amp;help=EditFanProbe</xsl:attribute>
						</xsl:if>
						<xsl:attribute name="align">left</xsl:attribute>
					</xsl:element>
					<xsl:element name="Data">
						<xsl:attribute name="align">center</xsl:attribute>
						<xsl:choose>
							<xsl:when test="ProbeReading &gt;= 0">
								<xsl:attribute name="value"><xsl:value-of select="ProbeReading"/><xsl:value-of select="$strRPM"/></xsl:attribute>
								<xsl:attribute name="display"><xsl:value-of select="ProbeReading"/><xsl:value-of select="$strRPM1"/></xsl:attribute>
							</xsl:when>
							<xsl:when test="ProbeReading &lt; 0">
								<xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute>
								<xsl:attribute name="display"><xsl:value-of select="$strNA"/></xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute>
								<xsl:attribute name="display"><xsl:value-of select="$strNA"/></xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:element>
					<xsl:element name="Data">
						<xsl:attribute name="align">center</xsl:attribute>
						<xsl:choose>
							<xsl:when test="ProbeThresholds/LNCThreshold &gt; 0">
								<xsl:attribute name="value"><xsl:value-of select="ProbeThresholds/LNCThreshold"/><xsl:value-of select="$strRPM2"/></xsl:attribute>
								<xsl:attribute name="display"><xsl:value-of select="ProbeThresholds/LNCThreshold"/><xsl:value-of select="$strRPM3"/></xsl:attribute>
							</xsl:when>
							<xsl:when test="ProbeThresholds/LNCThreshold &lt;= 0">
								<xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute>
								<xsl:attribute name="display"><xsl:value-of select="$strNA"/></xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute>
								<xsl:attribute name="display"><xsl:value-of select="$strNA"/></xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:element>
					<xsl:element name="Data">
						<xsl:attribute name="align">center</xsl:attribute>
						<xsl:choose>
							<xsl:when test="ProbeThresholds/UNCThreshold &gt; 0">
								<xsl:attribute name="value"><xsl:value-of select="ProbeThresholds/UNCThreshold"/><xsl:value-of select="$strRPM4"/></xsl:attribute>
								<xsl:attribute name="display"><xsl:value-of select="ProbeThresholds/UNCThreshold"/><xsl:value-of select="$strRPM5"/></xsl:attribute>
							</xsl:when>
							<xsl:when test="ProbeThresholds/UNCThreshold &lt;= 0">
								<xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute>
								<xsl:attribute name="display"><xsl:value-of select="$strNA"/></xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute>
								<xsl:attribute name="display"><xsl:value-of select="$strNA"/></xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:element>
					<xsl:element name="Data">
						<xsl:attribute name="align">center</xsl:attribute>
						<xsl:choose>
							<xsl:when test="ProbeThresholds/LCThreshold &gt; 0">
								<xsl:attribute name="value"><xsl:value-of select="ProbeThresholds/LCThreshold"/><xsl:value-of select="$strRPM6"/></xsl:attribute>
								<xsl:attribute name="display"><xsl:value-of select="ProbeThresholds/LCThreshold"/><xsl:value-of select="$strRPM7"/></xsl:attribute>
							</xsl:when>
							<xsl:when test="ProbeThresholds/LCThreshold &lt;= 0">
								<xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute>
								<xsl:attribute name="display"><xsl:value-of select="$strNA"/></xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute>
								<xsl:attribute name="display"><xsl:value-of select="$strNA"/></xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:element>
					<xsl:element name="Data">
						<xsl:attribute name="align">center</xsl:attribute>
						<xsl:choose>
							<xsl:when test="ProbeThresholds/UCThreshold &gt; 0">
								<xsl:attribute name="value"><xsl:value-of select="ProbeThresholds/UCThreshold"/><xsl:value-of select="$strRPM8"/></xsl:attribute>
								<xsl:attribute name="display"><xsl:value-of select="ProbeThresholds/UCThreshold"/><xsl:value-of select="$strRPM9"/></xsl:attribute>
							</xsl:when>
							<xsl:when test="ProbeThresholds/UCThreshold &lt;= 0">
								<xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute>
								<xsl:attribute name="display"><xsl:value-of select="$strNA"/></xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute>
								<xsl:attribute name="display"><xsl:value-of select="$strNA"/></xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:element>
				</Row>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="RedStatus">
		<xsl:param name="status"/>
		<xsl:choose>
			<xsl:when test="$status = 1">
				<xsl:attribute name="value"><xsl:value-of select="$strUnknown10"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$status = 2">
				<xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$status = 3">
				<xsl:attribute name="value"><xsl:value-of select="$strOffline"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$status = 4">
				<xsl:attribute name="value"><xsl:value-of select="$strFull"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$status = 5">
				<xsl:attribute name="value"><xsl:value-of select="$strDegraded"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$status = 6">
				<xsl:attribute name="value"><xsl:value-of select="$strLost"/></xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="value"><xsl:value-of select="$strOther"/></xsl:attribute>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="smstatus">
		<xsl:param name="status"/>
		<xsl:param name="mssg"/>
		<xsl:choose>
            <xsl:when test="$status = '-1'">
                <xsl:value-of select="$strCommandUnsuccessful"/>
            </xsl:when>
            <xsl:when test="$status = '0'">
                <xsl:value-of select="$strCommandSuccessful"/>
            </xsl:when>
            <xsl:when test="$status = '1'">
                <xsl:value-of select="$strCommandNotImplemented"/>
            </xsl:when>
            <xsl:when test="$status = '2'">
                <xsl:value-of select="$strBadCommand"/>
            </xsl:when>
            <xsl:when test="$status = '3'">
                <xsl:value-of select="$strCommandTimeout"/>
            </xsl:when>
            <xsl:when test="$status = '4'">
                <xsl:value-of select="$strCommandCancelled"/>
            </xsl:when>
            <xsl:when test="$status = '5'">
                <xsl:value-of select="$strCommandAborted"/>
            </xsl:when>
            <xsl:when test="$status = '6'">
                <xsl:value-of select="$strCommandPending"/>
            </xsl:when>
            <xsl:when test="$status = '7'">
                <xsl:value-of select="$strNoSuchDevice"/>
            </xsl:when>
            <xsl:when test="$status = '8'">
                <xsl:value-of select="$strDeviceBusy"/>
            </xsl:when>
            <xsl:when test="$status = '9'">
                <xsl:value-of select="$strBadDevice"/>
            </xsl:when>
            <xsl:when test="$status = '10'">
                <xsl:value-of select="$strSpuriousInterrupt"/>
            </xsl:when>
            <xsl:when test="$status = '11'">
                <xsl:value-of select="$strResourceLocked"/>
            </xsl:when>
            <xsl:when test="$status = '12'">
                <xsl:value-of select="$strInvalidIndex"/>
            </xsl:when>
            <xsl:when test="$status = '13'">
                <xsl:value-of select="$strSMBError"/>
            </xsl:when>
            <xsl:when test="$status = '14'">
                <xsl:value-of select="$strDataRequestedIs"/>
            </xsl:when>
            <xsl:when test="$status = '15'">
                <xsl:value-of select="$strDataRequestedIs1"/>
            </xsl:when>
            <xsl:when test="$status = '16'">
                <xsl:value-of select="$strDataRequestedIs2"/>
            </xsl:when>
            <xsl:when test="$status = '17'">
                <xsl:value-of select="$strDeviceNotYet"/>
            </xsl:when>
            <xsl:when test="$status = '18'">
                <xsl:value-of select="$strDeviceDoesNot"/>
            </xsl:when>
            <xsl:when test="$status = '19'">
                <xsl:value-of select="$strDeviceOutOf"/>
            </xsl:when>
            <xsl:when test="$status = '20'">
                <xsl:value-of select="$strDeviceAlreadyExists"/>
            </xsl:when>
            <xsl:when test="$status = '256'">
                <xsl:value-of select="$strNoFanProbe"/>
            </xsl:when>
            <xsl:when test="$status = '257'">
                <xsl:value-of select="$strFanObjectMalformed"/>
            </xsl:when>
            <xsl:when test="$status = '258'">
                <xsl:value-of select="$strFanObjectAlready"/>
            </xsl:when>
            <xsl:when test="$status = '260'">
                <xsl:value-of select="$strINIFileNot"/>
            </xsl:when>
            <xsl:when test="$status = '261'">
                <xsl:value-of select="$strINIMalformedCorrupt"/>
            </xsl:when>
            <xsl:when test="$status = '262'">
                <xsl:value-of select="$strINISectionDoes"/>
            </xsl:when>
            <xsl:when test="$status = '263'">
                <xsl:value-of select="$strINIKeyDoes"/>
            </xsl:when>
            <xsl:when test="$status = '264'">
                <xsl:value-of select="$strINIValueMalformed"/>
            </xsl:when>
            <xsl:when test="$status = '270'">
                <xsl:value-of select="$strInsufficientAccessRights"/>
            </xsl:when>
            <xsl:when test="$status = '271'">
                <xsl:value-of select="$strInvalidParameterName"/>
                <xsl:value-of select="$mssg"/>
            </xsl:when>
            <xsl:when test="$status = '272'">
                <xsl:value-of select="$strOutOfMemory"/>
            </xsl:when>
            <xsl:when test="$status = '280'">
                <xsl:value-of select="$strXMLFileNot"/>
            </xsl:when>
            <xsl:when test="$status = '281'">
                <xsl:value-of select="$strXMLMalformedCorrupt"/>
            </xsl:when>
            <xsl:when test="$status = '282'">
                <xsl:value-of select="$strXMLNodeDoes"/>
            </xsl:when>
            <xsl:when test="$status = '283'">
                <xsl:value-of select="$strXMLValueMalformed"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$strSMStatus"/>
                <xsl:value-of select="$status"/>
            </xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="*"/>
</xsl:stylesheet>
