<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="/OMA">
		<DataArea validate="true">
      <xsl:if test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
				<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.hip.webplugins.SetChassisWebPlugin&amp;oid=<xsl:value-of select="Chassis/@oid"/>&amp;ChassisProps1Oid=<xsl:value-of select="ChassisInfo/ChassisProps1/@oid"/>&amp;ChassisProps2Oid=<xsl:value-of select="ChassisInfo/ChassisProps2/@oid"/>&amp;SystemInfoOid=<xsl:value-of select="ChassisInfo/SystemInfo/@oid"/></xsl:attribute>
			</xsl:if>
			<PageTitle>
				<xsl:attribute name="display">
					<xsl:value-of select="$strInformationTitle_Part1"/>
					<xsl:choose>
						<xsl:when test="ChassisInfo/ChassisProps1/ChassName='Main System Chassis'">
              <xsl:choose>
                <xsl:when test="/OMA/ChassisInfo/ChassisProps1/ChassType=25">
                  <xsl:value-of select="$strMainSystem"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="$strInformationTitle_Part2"/>
                </xsl:otherwise>
              </xsl:choose>
						</xsl:when>
						<xsl:otherwise><xsl:value-of select="ChassisInfo/ChassisProps1/ChassName"/></xsl:otherwise>
					</xsl:choose>
					<xsl:text> </xsl:text><xsl:value-of select="$strInformationTitle_Part3"/>
				</xsl:attribute>
			</PageTitle>
			<Header>Header</Header>
			<CustomButton>
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.ChassisWebPlugin&amp;oid=<xsl:value-of select="Chassis/@oid"/>&amp;help=MainChassisInfo</xsl:attribute>
				</Data>
			</CustomButton>
			<ListData type="custom">
				<xsl:apply-templates select="ChassisInfo"/>
			</ListData>
			
				<!--For Yellowstone-->	
			
			<xsl:if test="ChassisInfo/ChassisProps1/ChassType = '25' ">
				<xsl:if test="/OMA/ChassisInfo/BaseBoardList/@count > 0">
					<ListData>
						<Data type="hidden" name="dsmcount">
							<xsl:attribute name="returnvalue"><xsl:value-of select=" count( /OMA/ChassisInfo/BaseBoardList/BaseBoard[BaseBoardType='2'] ) "/></xsl:attribute>
						</Data>
						<xsl:for-each select="/OMA/ChassisInfo/BaseBoardList/BaseBoard">
						    <Data type ="hidden">
								<xsl:attribute name="name">
									<xsl:choose>
										<xsl:when test="BaseBoardType = '11'">pmmoid</xsl:when>
										<xsl:when test="BaseBoardType = '12'">iomoid</xsl:when>
									</xsl:choose>
								</xsl:attribute> 
								<xsl:attribute name="returnvalue"><xsl:value-of select=" @oid"/></xsl:attribute>
						    </Data>
						</xsl:for-each>
						<xsl:for-each select="/OMA/ChassisInfo/BaseBoardList/BaseBoard[BaseBoardType='2']">
						    <Data type ="hidden">
								<xsl:attribute name="name">dsmoid<xsl:value-of select="position()"/></xsl:attribute>
								<xsl:attribute name="returnvalue"><xsl:value-of select=" @oid"/></xsl:attribute>
						    </Data>
						</xsl:for-each>
					</ListData>
				</xsl:if>
			</xsl:if>
			
			<!-- Determine Chassis type and store the info in a hidden data to be used later by the plugin -->
			<!-- Now if ChassType is 25 and BaseBoard tye is 3, it is shredder,  otherwise it is yellowstone, this may not be true in the future with new platforms-->

			<HiddenTable>
				<Data name="chassistype">
					<xsl:choose>
						<xsl:when test=" ChassisInfo/ChassisProps1/ChassType = '25' ">
							<xsl:choose>
								<xsl:when test="(count(/OMA/ChassisList/Chassis/ChassisInfo/BaseBoardList/BaseBoard[BaseBoardType='3'] ) ) = 0">
									<xsl:attribute name="returnvalue">yellowstone</xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="returnvalue">shredder</xsl:attribute>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="returnvalue">other</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</Data>
			</HiddenTable>
			
			<ListData>
			   	<Data name="identifySupport"  type = "hidden">
				  	<xsl:attribute name="returnvalue"><xsl:value-of select="ChassisInfo/ChassisProps2/IdentifySupport"/></xsl:attribute>
				</Data>
				<!-- CHNG 104436 Added the hidden variables to check if values have been changed by user -->
				<Data name="oldAssetTag" type="hidden">
					<xsl:attribute name="returnvalue"><xsl:value-of select="ChassisInfo/ChassisProps2/AssetTag"/></xsl:attribute>
				</Data>
				<Data name="oldIndentify" type="hidden">
					<xsl:attribute name="returnvalue"><xsl:value-of select="ChassisInfo/ChassisProps2/ChassIdentifyState"/></xsl:attribute>
				</Data>
				<Data name="oldTimeout" type="hidden">
					<xsl:attribute name="returnvalue"><xsl:value-of select="ChassisInfo/ChassisProps2/ChassIdentifyTimeout"/></xsl:attribute>
				</Data> 
				<Data name="oldChassisName" type="hidden">
					<xsl:attribute name="returnvalue"><xsl:value-of select="ChassisInfo/ChassisProps1/ChassName"/></xsl:attribute>
				</Data>
				<Data name="oldHDFault" type="hidden">
					<xsl:attribute name="returnvalue"><xsl:value-of select="ChassisInfo/ChassisProps2/HdLedSupport"/></xsl:attribute>
				</Data>
				<Data name="oldLEDFault" type="hidden">
					<xsl:attribute name="returnvalue"><xsl:value-of select="ChassisInfo/ChassisProps2/FaultLEDControl "/></xsl:attribute>
				</Data>
			</ListData>
			
			<script language="javascript">
				function validate()
				{
				 
			 <xsl:choose>				
				 <xsl:when test="ChassisInfo/ChassisProps1/ChassType = '25' ">
				      <xsl:if test="/OMA/ChassisInfo/BaseBoardList/@count > 0">
			 		 <xsl:for-each select="/OMA/ChassisInfo/BaseBoardList/BaseBoard">
					<xsl:choose>
						  <xsl:when test="(BaseBoardType = '11') or (BaseBoardType = '12')">
						    var assettag<xsl:value-of select="position()"/> = '<xsl:choose><xsl:when test="BaseBoardType = '11'">pmm</xsl:when><xsl:when test="BaseBoardType = '12'">iom</xsl:when></xsl:choose>' + "assettag";
				<!--	alert(document.getElementById (assettag<xsl:value-of select="position()"/>).value); -->
  						    if(!isAlphaNumeric(document.getElementById (assettag<xsl:value-of select="position()"/>).value))
							{
							document.getElementById (assettag<xsl:value-of select="position()"/>).focus();
							document.getElementById (assettag<xsl:value-of select="position()"/>).select();
							return false;
							}
						    if(document.getElementById (assettag<xsl:value-of select="position()"/>).value.length > 10)
							{
							var tagname<xsl:value-of select="position()"/> = '<xsl:choose><xsl:when test="BaseBoardType = '11'"><xsl:value-of select="$strPMMAssetTag"/></xsl:when><xsl:when test="BaseBoardType = '12'"><xsl:value-of select="$strIOMAssetTag"/></xsl:when></xsl:choose>';
							alert(tagname<xsl:value-of select="position()"/> + " can't be more than 10 characters");
							document.getElementById (assettag<xsl:value-of select="position()"/>).focus();
							document.getElementById (assettag<xsl:value-of select="position()"/>).select();
							return false;
							}
						  </xsl:when >
						  <xsl:otherwise>
						<xsl:if test="BaseBoardType != '2'">
						
							while(document.dataarea.AssetTag.value.charAt(document.dataarea.AssetTag.value.length-1)==' ')
					{
						document.dataarea.AssetTag.value= document.dataarea.AssetTag.value.substring(0,document.dataarea.AssetTag.value.length-1);
					}
							
  						    if(!isAlphaNumeric(document.getElementById ("AssetTag").value))
							{
							document.getElementById ("AssetTag").focus();
							document.getElementById ("AssetTag").select();
							return false;
							}
						    if(document.getElementById ("AssetTag").value.length > 10)
							{
							alert(tagname + " can't be more than 10 characters");
							document.getElementById ("AssetTag").focus();
							document.getElementById ("AssetTag").select();
							return false;
							}
						</xsl:if>
						  </xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
				      </xsl:if>
							<xsl:for-each select="/OMA/ChassisInfo/BaseBoardList/BaseBoard[BaseBoardType='2']">
								var dsmAT = "dsmassettag" + '<xsl:value-of select="position()"/>';
													
								if(!isAlphaNumeric(document.getElementById (dsmAT).value))
								{
									document.getElementById (dsmAT).focus();
									document.getElementById (dsmAT).select();
									return false;
								}
								if(document.getElementById (dsmAT).value.length > 10)
								{
									var dsmTN = '<xsl:value-of select="$strDSMAssetTag"/>' + '<xsl:value-of select="position()"/>';
									alert(dsmTN + " can't be more than 10 characters");
									document.getElementById (dsmAT).focus();
									document.getElementById (dsmAT).select();
									return false;
								}
							</xsl:for-each>
					</xsl:when>


					 <xsl:otherwise>
						<!--xsl:if test="(BaseBoardType!='11') and (BaseBoardType!='2') and (BaseBoardType!='12')"-->
					
						//Eliminate the spaces at the end
						while(document.dataarea.AssetTag.value.charAt(document.dataarea.AssetTag.value.length-1)==' ')
						{
				document.dataarea.AssetTag.value= document.dataarea.AssetTag.value.substring(0,document.dataarea.AssetTag.value.length-1);
						}

						if(!isValidTagName(document.dataarea.AssetTag.value))
						{
						 document.dataarea.AssetTag.focus();
						 document.dataarea.AssetTag.select();
						 return false;
						}
						if(document.dataarea.AssetTag.value.length > 10)
						{
						alert("<xsl:value-of select="$strAssetTagCant"/>");
						document.dataarea.AssetTag.focus();
						document.dataarea.AssetTag.select();
						return false;
						}
						<!--/xsl:if-->
					</xsl:otherwise>
			</xsl:choose>
					
					
					//Check to see if the chassis led is there
					
					<xsl:if test="//ChassisProps2/IdentifySupport='true'">
						<xsl:if test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
							var pretimeout = <xsl:value-of select="//ChassisProps2/ChassIdentifyTimeout"/>;	
							var timeout 	= document.getElementById("timeout").value;
							var timeoutUpperLimit = 3600;
							if(isNaN(timeout) == true)
							{
								alert(<xsl:value-of select="$strErrorWholeNumber"/>);
								document.getElementById("timeout").value = pretimeout ;
								return false;
							}
							if(timeout &lt; 1) {
								alert(<xsl:value-of select="$strErrorChassisIdentify"/>);
								document.getElementById("timeout").value = pretimeout ;								
								return false;
							}
							else
							{
								if(timeout.indexOf(".") != "-1")
								{
									alert(<xsl:value-of select="$strErrorWholeNumber1"/>);
									document.getElementById("timeout").value = pretimeout ;						
									return false;
								}
								
								if(timeout &gt; timeoutUpperLimit) {
								     alert(<xsl:value-of select="$strErrorExceedsUpperLimit"/>);
									document.getElementById("timeout").value = pretimeout;
									return false;
								}
							}
						</xsl:if>
						
					</xsl:if>
					<xsl:if test="/OMA/Chassis/@oid != '2'">
						<xsl:if test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
							if( ! isAlphaNumeric( document.dataarea.ChassisName.value ) )
							{
								document.dataarea.ChassisName.focus();
								document.dataarea.ChassisName.select();
								return false;
							}
						</xsl:if>
					</xsl:if>
					return true;
				}
				
				function isAlphaNumeric(text)
			     {
				     // defect 84445 - add space to validValue and rewrite
					var validValue = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_'*$,.!%():[]=/?+~ ";
					var ok = true;

					//Eliminate the spaces at the end
					while( text.charAt( text.length -1 ) == ' ' )
					{
						text = text.substring( 0, text.length - 1 );
					}
					// Check for allowed characters
					for ( var i=0; i&lt;text.length; i++)
					{
						if ( validValue.indexOf( text.charAt( i ) ) == "-1" )
						{
							ok = false;
						        alert(<xsl:value-of select="$strErrorAlphanumericOr"/>);
							break;
						}
					}
					return ok;
				}

				function isValidTagName(text)
			        {
				     // defect 84445 - add space to validValue and rewrite
					var validValue = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_'*$,.!%():[]=/?+~ ";
					var ok = true;
                                        var invalidCh;

					//Eliminate the spaces at the end
					while( text.charAt( text.length -1 ) == ' ' )
					{
						text = text.substring( 0, text.length - 1 );
					}
					// Check for allowed characters
					for ( var i=0; i&lt;text.length; i++)
					{
						if ( validValue.indexOf( text.charAt( i ) ) == "-1" )
						{
                                                        invalidCh = text.charAt( i );
							ok = false;
						        alert(<xsl:value-of select="$strInvalidSymbol"/>);
							break;
						}
					}
					return ok;
				}
			</script>
		</DataArea>
	</xsl:template>
	
	<xsl:template match="ChassisInfo">
		<xsl:if test="/OMA/Chassis/@oid = '2'">
			<Data name="HostName">
				<xsl:attribute name="display"><xsl:value-of select="$strHostName"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="SystemInfo/SystemName"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:apply-templates select="FirmwareList"/>
      <Data name="SystemModel" width="300">
        <xsl:choose>
          <xsl:when test="ChassisProps1/ChassType != '25' ">
            <xsl:attribute name="display"><xsl:value-of select="$strChassisModel"/></xsl:attribute>
          </xsl:when>
          <xsl:otherwise>
            <xsl:attribute name="display">
              <xsl:value-of select="$strServerModel"/>
            </xsl:attribute>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:attribute name="value">
          <xsl:value-of select="ChassisProps1/ChassModel"/>
        </xsl:attribute>
      </Data>
<!--SystemRevision starts from '1' and 255 represents systemrevision is not applicable to that server-->

       <xsl:if test="ChassisProps1/SystemRevision !='0' and ChassisProps1/SystemRevision !='255' ">
	<xsl:if test="ChassisProps1/SystemRevisionName">
	 <Data name="SystemRevision">
		 <xsl:attribute name="display">
			 <xsl:value-of select="$strSystemRevisionName"/>
		 </xsl:attribute>
		 <xsl:attribute name="value">
			 <xsl:value-of select="ChassisProps1/SystemRevisionName"/>         
	        </xsl:attribute>
      </Data>
    </xsl:if>
    </xsl:if>

    <xsl:if test="ChassisProps1/ChassType != '25' ">
      <Data name="ChassLock">
        <xsl:attribute name="display">
          <xsl:value-of select="$strChassisLock"/>
        </xsl:attribute>
        <xsl:attribute name="value">
          <xsl:choose>
            <xsl:when test="ChassisProps1/ChassLockPresent='true'">
              <xsl:value-of select="$strPresent"/>
            </xsl:when>
            <xsl:when test="ChassisProps1/ChassLockPresent='false'">
              <xsl:value-of select="$strAbsent"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="$strNoValue"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:attribute>
      </Data>
    </xsl:if>
    <Data name="ServiceTag">
      <xsl:choose>
        <xsl:when test="ChassisProps1/ChassType = '25'">
          <xsl:attribute name="display">
            <xsl:value-of select="$strServerServiceTag"/>
          </xsl:attribute>
        </xsl:when>
        <xsl:otherwise>
      <xsl:attribute name="display">       
        <xsl:value-of select="$strChassisServiceTag"/>
      </xsl:attribute>
        </xsl:otherwise>
        </xsl:choose>
      <xsl:call-template name="DispChasSrvcTag"/>
    </Data>
    <xsl:call-template name="DispChasAssetTag"/>
			<!--Yellowstone-->
		
		<xsl:if test="ChassisProps1/ChassType = '25' ">
			<xsl:if test="/OMA/ChassisInfo/BaseBoardList/@count > 0">
				<xsl:call-template name="yellowStone"/>
			</xsl:if>
		</xsl:if>		

		
		
		<!-- ChassType 25 is a Shredder  or yellowstone-->
		<xsl:if test="ChassisProps1/ChassType = '25' ">
			<xsl:apply-templates select="/OMA/ChassisInfo/BaseBoardList"/>
		</xsl:if>

    <xsl:if test="ChassisProps1/ChassType != '25' ">
      <xsl:if test="/OMA/Chassis/@oid != '2'">
        <Data name="ChassisName">
          <xsl:attribute name="display">
            <xsl:value-of select="$strChassisName"/>
          </xsl:attribute>
          <xsl:attribute name="value">
            <xsl:value-of select="ChassisProps1/ChassName"/>
          </xsl:attribute>
          <xsl:if test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
            <xsl:attribute name="type">editbox</xsl:attribute>
            <xsl:attribute name="size">12</xsl:attribute>
            <xsl:attribute name="maxlength">31</xsl:attribute>
          </xsl:if>
        </Data>
      </xsl:if>
    </xsl:if>
      <xsl:if test="ChassisProps2/IdentifySupport='true'">
        <Data name="indentify" returnvalue="1" type="checkbox">
          <xsl:attribute name="display">
            <xsl:choose>
              <xsl:when test="ChassisProps1/ChassType = '25'">
                <xsl:value-of select="$strIdentifyChassisBlade"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="$strIdentifyChassis"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
          <xsl:attribute name="value"></xsl:attribute>
          <xsl:choose>
            <xsl:when test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
              <xsl:if test="ChassisProps2/ChassIdentifyState = '1'">
                <xsl:attribute name="state">1</xsl:attribute>
              </xsl:if>
            </xsl:when>
            <xsl:otherwise>
              <xsl:choose>
                <xsl:when test="ChassisProps2/ChassIdentifyState = '1'">
                  <xsl:attribute name="state">3</xsl:attribute>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:attribute name="state">2</xsl:attribute>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:otherwise>
          </xsl:choose>
        </Data>
        <Data name="timeout">
          <xsl:attribute name="display">
            <xsl:choose>
              <xsl:when test="ChassisProps1/ChassType = '25'">
                <xsl:value-of select="$strChassisIdentifyTimeoutBlade"/>
              </xsl:when>
              <xsl:otherwise>
                  <xsl:value-of select="$strChassisIdentifyTimeout"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
          <xsl:attribute name="value">
            <xsl:value-of select="ChassisProps2/ChassIdentifyTimeout"/>
          </xsl:attribute>
          <xsl:attribute name="unit">
            <xsl:value-of select="$strSeconds"/>
          </xsl:attribute>
          <xsl:if test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
            <xsl:attribute name="type">editbox</xsl:attribute>
          </xsl:if>
        </Data>
      </xsl:if>
    <xsl:choose>
			<xsl:when test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
				<xsl:if test="ChassisProps2/HdLedSupport = 'true'">
					<Data name="hdfault" type="checkbox">
						<xsl:attribute name="display"><xsl:value-of select="$strClearHardDrive"/></xsl:attribute>
						<xsl:attribute name="returnvalue">true</xsl:attribute>
					</Data>
				</xsl:if>
				<xsl:if test="ChassisProps2/FaultLEDControl != '0'">
					<Data name="ledfault" type="select">
						<xsl:attribute name="display"><xsl:value-of select="$strFaultLEDFlash"/></xsl:attribute>
						<Choice>
							<xsl:attribute name="value"><xsl:value-of select="$strCritical"/></xsl:attribute>
							<xsl:attribute name="returnvalue">16</xsl:attribute>
							<xsl:if test="ChassisProps2/FaultLEDControl=16">
								<xsl:attribute name="default">true</xsl:attribute>
							</xsl:if>
						</Choice>
						<Choice>
							<xsl:attribute name="value"><xsl:value-of select="$strWarning"/></xsl:attribute>
							<xsl:attribute name="returnvalue">8</xsl:attribute>
							<xsl:if test="ChassisProps2/FaultLEDControl=8">
								<xsl:attribute name="default">true</xsl:attribute>
							</xsl:if>
						</Choice>
					</Data>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="ChassisProps2/FaultLEDControl != '0'">
					<Data name="ledfault">
						<xsl:attribute name="display"><xsl:value-of select="$strFlashFaultLED"/></xsl:attribute>
						<xsl:attribute name="value">
							<xsl:choose>
								<xsl:when test="ChassisProps2/FaultLEDControl=8"><xsl:value-of select="$strWarning1"/></xsl:when>
								<xsl:otherwise><xsl:value-of select="$strCritical1"/></xsl:otherwise>
							</xsl:choose>
						</xsl:attribute>
					</Data>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="DispChasSrvcTag">
    <xsl:attribute name="value">
      <xsl:value-of select="/OMA/ChassisInfo/ChassisProps2/ServiceTag"/>
    </xsl:attribute>
	</xsl:template>
	
	<xsl:template name="DispChasAssetTag">
		<!--check for shredder-->
				<Data name="AssetTag">
          <xsl:choose>
            <xsl:when test="/OMA/ChassisInfo/ChassisProps1/ChassType='25'">
              <xsl:attribute name="display"><xsl:value-of select="$strServerAssetTag"/></xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
            <xsl:attribute name="display"><xsl:value-of select="$strChassisAssetTag"/></xsl:attribute>
            </xsl:otherwise>
          </xsl:choose>
					<xsl:attribute name="value"><xsl:value-of select="/OMA/ChassisInfo/ChassisProps2/AssetTag"/></xsl:attribute>
					<xsl:if test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
						<xsl:attribute name="type">editbox</xsl:attribute>
						<xsl:attribute name="size">12</xsl:attribute>
						<xsl:attribute name="maxlength">10</xsl:attribute>
					</xsl:if>
				</Data>	
	</xsl:template>
	
	<!--check for yellowstone-->
	
	<xsl:template name="yellowStone">
		<xsl:for-each select="/OMA/ChassisInfo/BaseBoardList/BaseBoard">
			<!-- All other than DSM Objects go here -->
			<xsl:choose>
				<xsl:when test="BaseBoardType = '11'">
					<Data name="pmmassettag">
						<xsl:attribute name="display"><xsl:value-of select="$strPMMAssetTag"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="AssetTag"/></xsl:attribute>
						<xsl:if test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
							<xsl:attribute name="type">editbox</xsl:attribute>
							<xsl:attribute name="size">12</xsl:attribute>
							<xsl:attribute name="maxlength">10</xsl:attribute>
						</xsl:if>
          </Data>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strPMMserviceTag"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="ServiceTag"/></xsl:attribute>
					</Data>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strPMMLocation"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="BoardLocation"/></xsl:attribute>
					</Data>
				</xsl:when>
				<xsl:when test="BaseBoardType = '12'">
					<Data name="iomassettag">
						<xsl:attribute name="display"><xsl:value-of select="$strIOMAssetTag"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="AssetTag"/></xsl:attribute>
						<xsl:if test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
							<xsl:attribute name="type">editbox</xsl:attribute>
							<xsl:attribute name="size">12</xsl:attribute>
							<xsl:attribute name="maxlength">10</xsl:attribute>
						</xsl:if>
					</Data>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strIOMserviceTag"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="ServiceTag"/></xsl:attribute>
					</Data>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strIOMLocation"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="BoardLocation"/></xsl:attribute>
					</Data>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>
		<!-- All DSM Objects go here -->
		<xsl:for-each select="/OMA/ChassisInfo/BaseBoardList/BaseBoard[BaseBoardType='2']">
			<Data>
				<xsl:attribute name="name">dsmassettag<xsl:value-of select="position()"/></xsl:attribute>
				<xsl:attribute name="display"><xsl:value-of select="$strDSMAssetTag"/><xsl:value-of select="position()"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="AssetTag"/></xsl:attribute>
				<xsl:if test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
					<xsl:attribute name="type">editbox</xsl:attribute>
					<xsl:attribute name="size">12</xsl:attribute>
					<xsl:attribute name="maxlength">10</xsl:attribute>
				</xsl:if>
			</Data>
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strDSMserviceTag"/><xsl:value-of select="position()"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="ServiceTag"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strDSMLocation"/><xsl:value-of select="position()"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="BoardLocation"/></xsl:attribute>
			</Data>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="FirmwareList">
		<xsl:apply-templates select="Firmware"/>
	</xsl:template>
	
	<xsl:template match="Firmware">
		<Data name="fwtype">
			<xsl:attribute name="display">
				<xsl:call-template name="getFWType">
					<xsl:with-param name="type">
						<xsl:value-of select="FWType"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="FWVersion"/></xsl:attribute>			
		</Data>
	</xsl:template>
	
	<xsl:template name="status2txt">
		<xsl:param name="Status"/>
		<xsl:choose>
			<xsl:when test="$Status=1"><xsl:value-of select="$strChassisIsOpen"/></xsl:when>
			<xsl:when test="$Status=2"><xsl:value-of select="$strChassisIsClosed"/></xsl:when>
			<xsl:when test="$Status=3"><xsl:value-of select="$strChassisIsPreviously"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$strUnknown1"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="getFWType">
		<xsl:param name="type"/>
		<xsl:choose>
			<xsl:when test="$type='2'"><xsl:value-of select="FWText"/></xsl:when>
			<xsl:when test="$type='3'"><xsl:value-of select="$strBIOSVersion"/></xsl:when>
			<xsl:when test="$type='4'"><xsl:value-of select="$strESMFirmwareVersion"/></xsl:when>
			<xsl:when test="$type='5'"><xsl:value-of select="$strPowerSupplyParalleling"/></xsl:when>
			<xsl:when test="$type='6'"><xsl:value-of select="$strBackplaneFirmwareVersion"/></xsl:when>
			<xsl:when test="$type='7'"><xsl:value-of select="$strKernelVersion"/></xsl:when>
			<xsl:when test="$type='8'"><xsl:value-of select="$strApplicationVersion"/></xsl:when>
			<xsl:when test="$type='9'"><xsl:value-of select="$strFrontPanelController"/></xsl:when>
			<xsl:when test="$type='10'"><xsl:value-of select="$strBaseboardManagementController"/></xsl:when>
			<xsl:when test="$type='11'"><xsl:value-of select="$strHotPlugPCI"/></xsl:when>
			<xsl:when test="$type='12'"><xsl:value-of select="$strSensorDataRecords"/></xsl:when>
			<xsl:when test="$type='13'"><xsl:value-of select="$strPeripheralBayBackplane"/></xsl:when>
			<xsl:when test="$type='14'"><xsl:value-of select="$strPowerEdge2450Secondary"/></xsl:when>
			<xsl:when test="$type='15'"><xsl:value-of select="$strSecondaryBackPlane"/></xsl:when>
			<xsl:when test="$type='16'"><xsl:value-of select="$strRemoteAccessController"/></xsl:when>			
			<xsl:when test="$type='17'"><xsl:value-of select="$striDRAC"/></xsl:when>			
			<xsl:otherwise><xsl:value-of select="$strUnknownFirmwareVersion"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
