<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="OMA/OMAUserRights"/>	

	<xsl:template match="OMA">	
	<xsl:variable name="IsLocalRacadmDisabled">
		<xsl:choose>
		      <xsl:when test="/OMA/EMPObj/localCommandDisableStatus= '1' or /OMA/EMPObj/localCommandDisableStatus= '3'">true</xsl:when>
		      <xsl:otherwise>false</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	
	<xsl:variable name="usrights"><xsl:value-of select="OMAUserRights"/></xsl:variable>
		<xsl:variable name="charSendThresholdUp"><xsl:value-of select="EMPSOLConfigObj/SOLCharSendThresholdUp"/></xsl:variable>
		<DataArea  validate="true" onLoad="true">
			<xsl:if test="(($usrights='7')and ($IsLocalRacadmDisabled!='true'))">
				<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.hip.webplugins.SetBmcSolAdvWebPlugin</xsl:attribute>
			</xsl:if>
			<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strSerialOverLAN"/></xsl:attribute>
			<xsl:attribute name="backpagetarget">/servlet/DataArea?plugin=com.dell.hip.webplugins.BMCSOLWebPlugin&amp;help=RemoteAccessSol</xsl:attribute>


			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strSerialOverLANAdv"/></xsl:attribute>
			</PageTitle>

			<xsl:if test="$IsLocalRacadmDisabled = 'true'">
				<PromptText><xsl:value-of select="$strInbandMessage"/></PromptText>
			</xsl:if>

			<xsl:if test="EMPObj/defaultRestoreStatus = '0'">
				<xsl:if test="EMPObj/defaultRestoreSupport = '1'">
				<PromptText><xsl:value-of select="$HIPLSTR_strResetToDefault"/></PromptText>
				</xsl:if>
			</xsl:if>

			<CustomButton>
				<Data name=""><xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.BMCSOLAdvWebPlugin&amp;help=RemoteAccessSolAd</xsl:attribute>
				</Data>
			</CustomButton>

	<TableData  columnspacing="true" name="tabSOLConfiguration"><xsl:attribute name="display"><xsl:value-of select="$strSerialOverLAN"/></xsl:attribute>
		<SubHeader value="User Rights">
			<xsl:attribute name="display"><xsl:value-of select="$strSerialOverLAN"/></xsl:attribute>
		</SubHeader>
		<Header>
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strAttribute"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strAttribute"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strValue"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strValue"/></xsl:attribute>
			</Data>
		</Header>

		<Row>
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$strCharacterAccumulateInterval"/></xsl:attribute>
			</Data>
			<Data name="Interval" type="editbox" editable="true">
					<xsl:attribute name="display"><xsl:value-of select="EMPSOLConfigObj/SOLCharAccumInterval"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="EMPSOLConfigObj/SOLCharAccumInterval"/></xsl:attribute>
			</Data>
		</Row>


		<Row>
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$strCharacterSendThreshold"/></xsl:attribute>
			</Data>
			<Data name="Threshold" type="editbox" editable="true">
					<xsl:attribute name="display"><xsl:value-of select="EMPSOLConfigObj/SOLCharSendThreshold"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="EMPSOLConfigObj/SOLCharSendThreshold"/></xsl:attribute>
			</Data>
		</Row>

		<script language="javascript">
			<xsl:if test="(/OMA/threshold != '') and (/OMA/threshold != EMPSOLConfigObj/SOLCharSendThreshold) and (/OMA/threshold &lt;=$charSendThresholdUp)" >
				alert ("<xsl:value-of select="$strErrorInvalid1"/>" + "<xsl:value-of select="/OMA/threshold"/>" + "<xsl:value-of select="$strErrorInvalid2"/>");
			</xsl:if>
		</script>

	</TableData>	

				<script language="javascript">
			var usrights = '<xsl:value-of select="/OMA/OMAUserRights"/>'

				function initializationRoutine()
				{
				var LocalRacadm = '<xsl:value-of select="$IsLocalRacadmDisabled"/>';
				EnableSettingsAccordingtoUserRights();
				if (LocalRacadm == "true")
        				DisableControls();
					
				}

				function DisableControls()
				{		
					document.getElementById("Interval").disabled  =true;
					document.getElementById("Threshold").disabled  =true; 

				}

				
				function EnableSettingsAccordingtoUserRights()
				{		
					if (usrights != 7 ) 
					{
						document.getElementById("Interval").disabled  =true;
						document.getElementById("Threshold").disabled  =true; 
					}
				}
				
				function tonum(obj){
     					 return parseInt(obj, 10);
   			        }
				
			function validate()
				{
					var Interval = document.getElementById("Interval").value;
					var lastvalInterval = <xsl:value-of select="/OMA/EMPSOLConfigObj/SOLCharAccumInterval"/>;
					var minvalInterval = 1;
					var maxvalInterval = 255;
					
					var Threshold = document.getElementById("Threshold").value;
					var lastvalThreshold= <xsl:value-of select="/OMA/EMPSOLConfigObj/SOLCharSendThreshold"/>;
					var minvalThreshold = 1;
					var maxvalThreshold = 255;
					
					<xsl:if test="$charSendThresholdUp">
						maxvalThreshold = <xsl:value-of select="$charSendThresholdUp"/>;
					</xsl:if>

					if(Interval.indexOf(".") != -1)
					{
							alert("<xsl:value-of select="$strErrorInterval"/>");
							document.getElementById("Interval").value = lastvalInterval;
							document.getElementById("Interval").focus();
							return false;
					}
					if (document.getElementById("Interval").value== "" ){
							alert("<xsl:value-of select="$strPleaseSpecifyInterval"/>");
							document.getElementById("Interval").value = lastvalInterval ;
							document.getElementById("Interval").focus();
							return false;
					}
					else{
							if(isNaN(Interval) == true){
									alert("<xsl:value-of select="$strIntervalNumber"/>");
									document.getElementById("Interval").value = lastvalInterval;
									document.getElementById("Interval").focus();
									return false;
							}
							else if(!((tonum(Interval) &gt;= minvalInterval)&amp;&amp;(tonum(Interval) &lt;= maxvalInterval))){
									alert(<xsl:value-of select="$strIntervalRange"/>);
									document.getElementById("Interval").value = lastvalInterval;
									document.getElementById("Interval").focus();
									return false;
							}
						}				
					if(Threshold.indexOf(".") != -1)
					{
							alert("<xsl:value-of select="$strErrorThreshold"/>");
							document.getElementById("Threshold").value = lastvalThreshold;
							document.getElementById("Threshold").focus();
							return false;
					}
					if (document.getElementById("Threshold").value== "" ){
							alert("<xsl:value-of select="$strPleaseSpecifyThreshold"/>");
							document.getElementById("Threshold").value = lastvalThreshold;
							document.getElementById("Threshold").focus();
							return false;
					}
					else{
							if(isNaN(Threshold) == true){
									alert("<xsl:value-of select="$strThresholdNumber"/>");
									document.getElementById("Threshold").value = lastvalThreshold;
									document.getElementById("Threshold").focus();
									return false;
							}
							else 
							{
							    	if(!((tonum(Threshold) &gt;= minvalThreshold)&amp;&amp;(tonum(Threshold) &lt;= maxvalThreshold)))
							    	{
									alert(<xsl:value-of select="$strThresholdRange"/>);
									document.getElementById("Threshold").value = lastvalThreshold;
									document.getElementById("Threshold").focus();
									return false;
							  	}
							}
						}

					// MM : convert strings to numbers
					Interval=tonum(Interval);
					document.getElementById("Interval").value=Interval;
					Threshold=tonum(Threshold);
					document.getElementById("Threshold").value=Threshold;
						
					return true;
					}

				</script>
		</DataArea>
	</xsl:template>
</xsl:stylesheet>