<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:strip-space elements="*"/>
	<xsl:output method="xml" indent="no"/>
	 <xsl:variable name="IsIMCPresent">
	    <xsl:choose>
	      <xsl:when test="/OMA/EMPObj/type &gt; '7'">true</xsl:when>
	      <xsl:otherwise>false</xsl:otherwise>
	    </xsl:choose>
	  </xsl:variable>

	<xsl:template match="OMA">
	<xsl:variable name="usrights"><xsl:value-of select="OMAUserRights"/></xsl:variable>
		<DataArea>

 			<PageTitle><xsl:attribute name="display"><xsl:value-of select="$strRemoteAccessInformation"/></xsl:attribute></PageTitle>
			<xsl:if test="EMPObj/defaultRestoreStatus = '0'">
				<xsl:if test="EMPObj/defaultRestoreSupport = '1'">
				<PromptText><xsl:value-of select="$HIPLSTR_strResetToDefault"/></PromptText>
				</xsl:if>
			</xsl:if>

			<!--xsl:choose>
			<xsl:when test="EMPObj/defaultRestoreStatus = '0'"-->
			<!--TableData columnspacing="true">
				<Row>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$HIPLSTR_strResetToDefault"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$HIPLSTR_strResetToDefault"/></xsl:attribute>
					</Data>
				</Row>
			</TableData-->
			<!--/xsl:when>
			<xsl:otherwise-->
					<CustomButton>
						<Data name="ref"><xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
							<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.BMCViewWebPlugin&amp;help=RemoteAccess</xsl:attribute>
						</Data>
					</CustomButton>
					<xsl:if test="EMPObj/defaultRestoreSupport = '1'">
			          <xsl:if test="EMPObj/localCommandDisableStatus != '1' and EMPObj/localCommandDisableStatus != '3'">
					<xsl:if test="$usrights='7'">
					<CustomButton align="left">
						<!--Data name="adv"><xsl:attribute name="display"><xsl:value-of select="$strReset"/></xsl:attribute>
							<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.BMCViewWebPlugin&amp;action=reset</xsl:attribute>
						</Data-->
						<Data name="reset" id="resetid">
							<xsl:attribute name="display"><xsl:value-of select="$strReset"/></xsl:attribute>
							<xsl:attribute name="href">javascript:reset()</xsl:attribute>
							<xsl:attribute name="formSubmit">true</xsl:attribute>
						</Data>

					</CustomButton>
					<script language="javascript">
					function reset()
					{
						if (confirm("<xsl:value-of select="$strResetToDefault"/>"))
						{
		 				    // disable the link after the first click.
						    var originallink = document.getElementById("resetid").href;
						    document.getElementById("resetid").href = "#" + originallink;
			  			    if (originallink.charAt(0) != '#')
						    {
						  	 document.getElementById("dataarea").action=top.gnv.appendVID('/servlet/DataArea?plugin=com.dell.hip.webplugins.BMCViewWebPlugin&amp;action=reset');
				   		        document.getElementById("dataarea").submit();
				   		    }
						}
					}
					</script>
					</xsl:if>
          </xsl:if>
					</xsl:if>
					<TableData columnspacing="true" name="BMC">
						<xsl:attribute name="display"><xsl:value-of select="$strBMC"/></xsl:attribute>

						<SubHeader value="BMC Sub">
						<xsl:choose>
                 <xsl:when test="$IsIMCPresent='true'">
                   <xsl:attribute name="display"><xsl:value-of select="$strIMC"/></xsl:attribute>
                 </xsl:when>
                 <xsl:otherwise>
                   <xsl:attribute name="display"><xsl:value-of select="$strBMC"/></xsl:attribute>
                 </xsl:otherwise>
            </xsl:choose>
           </SubHeader>
						<Header>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strAttribute"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strAttribute"/></xsl:attribute>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strValue"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strValue"/></xsl:attribute>
							</Data>
						</Header>
						<xsl:apply-templates select="EMPObj"/>
					<xsl:apply-templates select="EMPLANConfigObj"/>
				</TableData>

				<xsl:if test="DRSCSummaryObj">
					<TableData columnspacing="true" name="RAC">
						<xsl:attribute name="display"><xsl:value-of select="$strDRAC"/></xsl:attribute>
						<SubHeader value="DRAC">
							<xsl:attribute name="display"><xsl:value-of select="$strDRAC"/></xsl:attribute>
						</SubHeader>

						<Header>
							<Data editable="false" type="usting">
								<xsl:attribute name="display"><xsl:value-of select="$Attribute"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$Attribute1"/></xsl:attribute>
							</Data>
							<Data editable="false" type="usting">
								<xsl:attribute name="display"><xsl:value-of select="$Value"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$Value1"/></xsl:attribute>
							</Data>
						</Header>
						<xsl:apply-templates select="DRSCSummaryObj"/>
						<xsl:apply-templates select="RemoteHostObj"/>
					</TableData>
					<script language="javascript">
						function loadOOB(drac_version)
						{
     						var drsHttpsPort = '<xsl:value-of select="DRSCSummaryObj/Drac3Obj/drsHttpsPort"/>';
							var drsIpAddr = '<xsl:value-of 	select="DRSCSummaryObj/CurrentLanNetworkingObj/NicCurrentIpAddress"/>';

							if (drac_version == 6)
							{
								//DRAC5
								window.open('https://' + drsIpAddr + ':' + drsHttpsPort);
							}
							else
							{
							//DRAC4 and previous DRAC versions
							window.open('https://' + drsIpAddr + ':' + drsHttpsPort + '/cgi/authentication');
							}
						}
				</script>
                    </xsl:if>


			<!--/xsl:otherwise>
			</xsl:choose-->
			<script language="javascript">
			        function loadIMC(url)
			        {
			        //alert(url);
			        window.open(url);
			        }
			      </script>

		</DataArea>
</xsl:template>
<xsl:template match="EMPObj">
			<Row>
				<Data>
					  <xsl:choose>
						<xsl:when test="$IsIMCPresent='true'">
						  <xsl:attribute name="display"><xsl:value-of select="$strIMCName"/></xsl:attribute>
						  <xsl:attribute name="value"><xsl:value-of select="$strIMCName"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
						  <xsl:attribute name="display"><xsl:value-of select="$strBMCName"/></xsl:attribute>
						  <xsl:attribute name="value"><xsl:value-of select="$strBMCName"/></xsl:attribute>
						</xsl:otherwise>
					  </xsl:choose>
				</Data>
        <Data>
          <xsl:choose>
            <xsl:when test="$IsIMCPresent='true'">
					    <xsl:attribute name="display"><xsl:value-of select="$strIMCDisplayName"/></xsl:attribute>
					    <xsl:attribute name="value"><xsl:value-of select="$strIMCDisplayName"/></xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="display"><xsl:value-of select="DisplayName"/></xsl:attribute>
					    <xsl:attribute name="value"><xsl:value-of select="DisplayName"/></xsl:attribute>
            </xsl:otherwise>
          </xsl:choose>
				</Data>

			</Row>
			<Row>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strBMCFirmwareVersion"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strBMCFirmwareVersion"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="Version"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="Version"/></xsl:attribute>
				</Data>

			</Row>

			<Row>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strSystemGUID"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strSystemGUID"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="GUID"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="GUID"/></xsl:attribute>
				</Data>

			</Row>

			<xsl:if test="numPossibleActiveSessions != '255'">
				<Row>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strNumberofPossible"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strNumberofPossible"/></xsl:attribute>
					</Data>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="numPossibleActiveSessions"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="numPossibleActiveSessions"/></xsl:attribute>
					</Data>
				</Row>
			</xsl:if>

			<xsl:if test="numCurrentlyActiveSessions != '255'">
				<Row>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strNumberofCurrent"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strNumberofCurrent"/></xsl:attribute>
					</Data>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="numCurrentlyActiveSessions"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="numCurrentlyActiveSessions"/></xsl:attribute>
					</Data>
				</Row>
			</xsl:if>
</xsl:template>
<xsl:template match="EMPLANConfigObj">

			<Row>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strLANEnabled"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strLANEnabled"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:choose>
					<xsl:when test="IPMIMessagingAccessMode = '2'">
						<xsl:attribute name="display"><xsl:value-of select="$strYes"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strYes"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="display"><xsl:value-of select="$strNo"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strNo"/></xsl:attribute>
					</xsl:otherwise>
					</xsl:choose>
				</Data>

			</Row>
			<Row>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strSOLEnabled"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strSOLEnabled"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:choose>
					<xsl:when test="/OMA/EMPSOLConfigObj/SOLEnable = '1'">
						<xsl:attribute name="display"><xsl:value-of select="$strYes"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strYes"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="display"><xsl:value-of select="$strNo"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strNo"/></xsl:attribute>
					</xsl:otherwise>
					</xsl:choose>
				</Data>

			</Row>

			<Row>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strIPAddressSource"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strIPAddressSource"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:if test="IPAddrSource = '1'">
						<xsl:attribute name="display"><xsl:value-of select="$strStaticAddress"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strStaticAddress"/></xsl:attribute>
					</xsl:if>
					<xsl:if test="IPAddrSource = '2'">
						<xsl:attribute name="display"><xsl:value-of select="$strAddressObtainedby"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strAddressObtainedby"/></xsl:attribute>
					</xsl:if>
					<xsl:if test="IPAddrSource = '3'">
						<xsl:attribute name="display"><xsl:value-of select="$strBIOS"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strBIOS"/></xsl:attribute>
					</xsl:if>
				</Data>

			</Row>

			<Row>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strCurrentIPAddress"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strCurrentIPAddress"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="IPAddress"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="IPAddress"/></xsl:attribute>
				</Data>

			</Row>
			<Row>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strCurrentIPSubnet"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strCurrentIPSubnet"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="SubnetMask"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="SubnetMask"/></xsl:attribute>
				</Data>

			</Row>
			<Row>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strCurrentIPGateway"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strCurrentIPGateway"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="DefaultGateway"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="DefaultGateway"/></xsl:attribute>
				</Data>

			</Row>
			<Row>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strMACAddress"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strMACAddress"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="MACAddress"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="MACAddress"/></xsl:attribute>
				</Data>

			 </Row>
			      <xsl:if test="$IsIMCPresent='true'">
			        <Row ignoreoncli="true">
			          <Data ignoreoncli="true">
			            <xsl:attribute name="display">
			              <xsl:value-of select="$RemoteConnect"/>
			            </xsl:attribute>
			            <xsl:attribute name="value">
			              <xsl:value-of select="$RemoteConnect"/>
			            </xsl:attribute>
			          </Data>
			          <xsl:choose>
			            <xsl:when test="/OMA/EMPObj/uiStatus='0'">
			              <Data link="false" ignoreoncli="true">
			                <xsl:attribute name="value">
			                  <xsl:value-of select="$LogintoRemoteiDRAC"/>
			                </xsl:attribute>
			                <xsl:attribute name="href">javascript:loadIMC('<xsl:value-of select="/OMA/EMPObj/Url"/>')</xsl:attribute>
			              </Data>
			            </xsl:when>
			            <xsl:otherwise>
			              <Data link="true" ignoreoncli="true">
			                <xsl:attribute name="value">
			                  <xsl:value-of select="$LogintoRemoteiDRAC"/>
			                </xsl:attribute>
			                <xsl:attribute name="href">javascript:loadIMC('<xsl:value-of select="/OMA/EMPObj/Url"/>')</xsl:attribute>
			              </Data>
			            </xsl:otherwise>
			          </xsl:choose>
			        </Row>
			      </xsl:if>

</xsl:template>

<xsl:template match="DRSCSummaryObj">
			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$Product"/></xsl:attribute>
				</Data>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value">
						 <xsl:value-of select="DRSIdentificationObj/ProductInfo"/>
					</xsl:attribute>
				</Data>
			</Row>
			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$Description"/></xsl:attribute>
				</Data>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value">
						 <xsl:value-of select="DRSIdentificationObj/DescriptionInfo"/>
					</xsl:attribute>
				</Data>
			</Row>
			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$Version"/></xsl:attribute>
				</Data>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value">
						 <xsl:value-of select="DRSIdentificationObj/VersionInfo"/>
					</xsl:attribute>
				</Data>
			</Row>
			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$CurrentIPAddress"/></xsl:attribute>
				</Data>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value">
						 <xsl:value-of select="CurrentLanNetworkingObj/NicCurrentIpAddress"/>
					</xsl:attribute>
				</Data>
			</Row>
			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$CurrentIPSubnet"/></xsl:attribute>
				</Data>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value">
						 <xsl:value-of select="CurrentLanNetworkingObj/NicCurrentNetMask"/>
					</xsl:attribute>
				</Data>
			</Row>
			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$CurrentIPGateway"/></xsl:attribute>
				</Data>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value">
						 <xsl:value-of select="CurrentLanNetworkingObj/NicCurrentNetGateway"/>
					</xsl:attribute>
				</Data>
			</Row>
			<Row>
				<Data type="ustring" editable="false" ignoreoncli="true">
					<xsl:attribute name="value"><xsl:value-of select="$RemoteConnect"/></xsl:attribute>
				</Data>
				<Data link="true" ignoreoncli="true">
					<xsl:attribute name="value"><xsl:value-of select="$LogintoRemoteDRAC"/></xsl:attribute>
					<xsl:attribute name="href">javascript:loadOOB("<xsl:value-of select="DRSIdentificationObj/DrsType"/>")</xsl:attribute>
				</Data>
			</Row>
</xsl:template>
</xsl:stylesheet>
