<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="OMA">
		<xsl:choose>
			<xsl:when test="BIOSView1/SMStatus = 0">
				<DataArea>
					<PageTitle>
						<xsl:attribute name="display"><xsl:value-of select="$strBIOSInformation"/></xsl:attribute>
					</PageTitle>
					<ListData type="custom">
						<xsl:call-template name="SystemBIOS"/>
						<!--xsl:call-template name="LastBIOSUpdate"/-->
					</ListData>
					<CustomButton>
						<Data name="Refresh" href="/servlet/DataArea?plugin=com.dell.hip.webplugins.BIOSViewWebPlugin&amp;help=Bios">
							<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
						</Data>
					</CustomButton>
				</DataArea>
			</xsl:when>
			<xsl:otherwise>
				<DataArea>
					<PageTitle>
						<xsl:attribute name="display"><xsl:value-of select="$strBIOSInformation1"/></xsl:attribute>
					</PageTitle>
					<PromptText status="3">
						<xsl:value-of select="$strUnableToGet"/>
					</PromptText>
				</DataArea>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="SystemBIOS">
		<Data name="Name">
			<xsl:attribute name="display"><xsl:value-of select="$strManufacturer"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="BIOSView1/SystemBIOS/Manufacturer"/></xsl:attribute>
		</Data>
		<Data name="Version">
			<xsl:attribute name="display"><xsl:value-of select="$strVersion"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="BIOSView1/SystemBIOS/Version"/></xsl:attribute>
		</Data>
		<Data name="ReleaseDate">
			<xsl:attribute name="display"><xsl:value-of select="$strReleaseDate"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="BIOSView1/SystemBIOS/ReleaseDate"/></xsl:attribute>
		</Data>
	</xsl:template>
	<xsl:template name="LastBIOSUpdate">
		<Data>
			<xsl:attribute name="display"><xsl:value-of select="$strServerAdministratorBIOS"/></xsl:attribute>
			<xsl:if test="LUUpdateable = '1'">
				<xsl:if test="UserAdmin = '1'">
					<xsl:if test="BIOSView2/LastBIOSUpdate/Support = 1">
						<xsl:attribute name="value"><xsl:value-of select="$strYes"/></xsl:attribute>
					</xsl:if>
					<xsl:if test="BIOSView2/LastBIOSUpdate/Support != 1">
						<xsl:attribute name="value"><xsl:value-of select="$strNo"/></xsl:attribute>
					</xsl:if>
				</xsl:if>
				<xsl:if test="count(UserAdmin ) = '0'">
					<xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute>
				</xsl:if>
			</xsl:if>
			<xsl:if test="count(LUUpdateable ) = '0'">
				<xsl:attribute name="value"><xsl:value-of select="$strNA1"/></xsl:attribute>
			</xsl:if>
		</Data>
	</xsl:template>
	<xsl:template match="OMAUserRights"/>
</xsl:stylesheet>
