<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml" />
	<xsl:strip-space elements="*"/>
	<xsl:template match="/OMA">
		<xsl:choose>
			<xsl:when test="SMStatus != '0'">
				<DataArea>
					<PageTitle>
						<xsl:attribute name="display"><!--XLATESTART-->Fehler! <!--XLATESTOP--><xsl:call-template name="smstatus"><xsl:with-param name="status"><xsl:value-of select="SMStatus"/></xsl:with-param></xsl:call-template></xsl:attribute>
					</PageTitle>
				</DataArea>
			</xsl:when>
			<xsl:otherwise>
				<DataArea>
					<PageTitle>
						<xsl:attribute name="display"><!--XLATESTART-->Geh&#228;use-Informationen<!--XLATESTOP--></xsl:attribute>
					</PageTitle>
					<ListData>
						<Data>
							<xsl:attribute name="display"><!--XLATESTART-->Index<!--XLATESTOP--></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="Chassis/@index"/></xsl:attribute>
						</Data>
						<Data>
							<xsl:attribute name="display"><!--XLATESTART-->Geh&#228;use-Name<!--XLATESTOP--></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="Chassis/@display"/></xsl:attribute>
						</Data>
						<xsl:apply-templates select="ChassisInfo"/>
					</ListData>
				</DataArea>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="ChassisInfo">
		<xsl:if test="SystemInfo/SystemName">
			<Data>
				<xsl:attribute name="display"><!--XLATESTART-->Host-Name<!--XLATESTOP--></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="SystemInfo/SystemName"/></xsl:attribute>
			</Data>			
		</xsl:if>
		<xsl:if test="FirmwareList">
			<xsl:for-each select="FirmwareList/Firmware">
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="FWText"/><!--XLATESTART--> Version<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="FWVersion"/></xsl:attribute>
				</Data>
			</xsl:for-each>			
		</xsl:if>
		<xsl:if test="ChassisProps1/ChassModel">
			<Data>
				<xsl:attribute name="display"><!--XLATESTART-->Geh&#228;use-Modell<!--XLATESTOP--></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="ChassisProps1/ChassModel"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="ChassisProps1/ChassLockPresent">
			<Data>
				<xsl:attribute name="display"><!--XLATESTART-->Geh&#228;useschloss<!--XLATESTOP--></xsl:attribute>
				<xsl:choose>
					<xsl:when test="ChassisProps1/ChassLockPresent = 'true'">
						<xsl:attribute name="value"><!--XLATESTART-->Vorhanden<!--XLATESTOP--></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="value"><!--XLATESTART-->Nicht vorhanden<!--XLATESTOP--></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</Data>
		</xsl:if>
		<xsl:if test="ChassisProps2/ServiceTag">
			<Data>
				<xsl:attribute name="display"><!--XLATESTART-->Service-Tag-Nummer<!--XLATESTOP--></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="ChassisProps2/ServiceTag"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="ChassisProps2/AssetTag">
			<Data>
				<xsl:attribute name="display"><!--XLATESTART-->Systemkennnummer<!--XLATESTOP--></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="ChassisProps2/AssetTag"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="ChassisProps2/FaultLEDControl != '0'">
			<Data>
				<xsl:attribute name="display"><!--XLATESTART-->Blinken der Fehler-LED bei Schweregrad<!--XLATESTOP--></xsl:attribute>
				<xsl:choose>
					<xsl:when test="ChassisProps2/FaultLEDControl = '8'">
						<xsl:attribute name="value"><!--XLATESTART-->Warnung<!--XLATESTOP--></xsl:attribute>
					</xsl:when>
					<xsl:when test="ChassisProps2/FaultLEDControl = '16'">
						<xsl:attribute name="value"><!--XLATESTART-->Kritisch<!--XLATESTOP--></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="value"><!--XLATESTART-->Nicht definiert<!--XLATESTOP--></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</Data>
		</xsl:if>
		<xsl:if test="BaseBoardList/@count > '0'">
			<xsl:call-template name="BaseBoard"/>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="BaseBoard">
		<xsl:for-each select="/OMA/BaseBoardList/BaseBoard">
			<xsl:if test="FeatureFlags/HostingBoard='true'">
				<Data name="BladeServiceTag" type="ustring">
					<xsl:attribute name="display"><!--XLATESTART-->Blatt-Service-Tag-Nummer<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="ServiceTag"/></xsl:attribute>
				</Data>
				<Data name="BladeServiceTag" type="ustring">
					<xsl:attribute name="display"><!--XLATESTART-->Blatt-Systemkennnummer<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="AssetTag"/></xsl:attribute>
				</Data>
				<Data name="BladeLocation" type="ustring">
					<xsl:attribute name="display"><!--XLATESTART-->Blatt-Standort<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="BoardLocation"/></xsl:attribute>
				</Data>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="smstatus">
		<xsl:param name="status"/>
		<xsl:param name="mssg"/>
		<xsl:choose>
			<xsl:when test="$status = '-1'"><!--XLATESTART-->Befehl nicht erfolgreich<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '0'"><!--XLATESTART-->Befehl erfolgreich<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '1'"><!--XLATESTART-->Befehl nicht implementiert<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '2'"><!--XLATESTART-->Inkorrekter Befehl<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '3'"><!--XLATESTART-->Befehl-Zeit&#252;berschreitung<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '4'"><!--XLATESTART-->Befehl storniert<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '5'"><!--XLATESTART-->Befehl abgebrochen<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '6'"><!--XLATESTART-->Befehl anstehend<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '7'"><!--XLATESTART-->Kein derartiges Ger&#228;t vorhanden<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '8'"><!--XLATESTART-->Ger&#228;t besetzt<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '9'"><!--XLATESTART-->Fehlerhaftes Ger&#228;t<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '10'"><!--XLATESTART-->Unechter Interrupt<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '11'"><!--XLATESTART-->Ressource gesperrt<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '12'"><!--XLATESTART-->Ung&#252;ltiger Index<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '13'"><!--XLATESTART-->SMB-Fehler<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '14'"><!--XLATESTART-->Angeforderte Daten sind nicht verf&#252;gbar<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '15'"><!--XLATESTART-->Angeforderte Daten &#252;bersteigen die verf&#252;gbaren Daten<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '16'"><!--XLATESTART-->Angeforderte Daten sind weniger als die verf&#252;gbaren Daten<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '17'"><!--XLATESTART-->Ger&#228;t noch nicht zum Befehlsempfang bereit. Sp&#228;ter versuchen<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '18'"><!--XLATESTART-->Ger&#228;t hat keine Daten<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '19'"><!--XLATESTART-->Ger&#228;t hat nicht gen&#252;gend Speicher<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '20'"><!--XLATESTART-->Ger&#228;t existiert bereits<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '256'"><!--XLATESTART-->Objekt nicht gefunden<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '257'"><!--XLATESTART-->Objekt verformt, besch&#228;digt oder fehlerhaft<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '258'"><!--XLATESTART-->Objekt existiert bereits<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '260'"><!--XLATESTART-->INI-Datei nicht gefunden<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '261'"><!--XLATESTART-->INI verformt, besch&#228;digt oder fehlerhaft<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '262'"><!--XLATESTART-->INI-Abschnitt existiert nicht<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '263'"><!--XLATESTART-->INI-Schl&#252;ssel existiert nicht<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '264'"><!--XLATESTART-->INI-Wert verformt, besch&#228;digt oder fehlerhaft<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '270'"><!--XLATESTART-->Ungen&#252;gende Zugriffsrechte<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '271'"><!--XLATESTART-->Ung&#252;ltiger Parametername oder -wert <!--XLATESTOP--><xsl:value-of select="$mssg"/></xsl:when>
			<xsl:when test="$status = '272'"><!--XLATESTART-->Nicht gen&#252;gend Speicher vorhanden<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '280'"><!--XLATESTART-->XML-Datei nicht gefunden<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '281'"><!--XLATESTART-->XML verformt, besch&#228;digt oder fehlerhaft<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '282'"><!--XLATESTART-->XML-Knoten existiert nicht<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '283'"><!--XLATESTART-->XML-Wert verformt, besch&#228;digt oder fehlerhaft<!--XLATESTOP--></xsl:when>
		<xsl:otherwise>SMStatus: <xsl:value-of select="$status"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>