<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">	
	<xsl:output method="xml" omit-xml-declaration="yes"/>
  <xsl:variable name="IsCLICmdNew">
    <xsl:choose>
      <xsl:when test="/ChassisHealth/OMACMDNEW='0'">false</xsl:when>
      <xsl:otherwise>true</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
	<xsl:template match="ChassisHealth">
		<Health>
			<xsl:apply-templates />
		</Health>
	</xsl:template>
	<xsl:template match="ChassisList">
		<xsl:for-each select="Chassis">
			<Data>
				<xsl:call-template name="Image">
					<xsl:with-param name="status"><xsl:value-of select="@status"/></xsl:with-param>
				</xsl:call-template>
        <xsl:choose>
          <xsl:when test="$IsCLICmdNew='true'">
            <xsl:attribute name="value">Main System</xsl:attribute>
          </xsl:when>
          <xsl:otherwise>
            <xsl:attribute name="value"><xsl:value-of select="@display"/></xsl:attribute>    
          </xsl:otherwise>
        </xsl:choose>
				
			</Data>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="Image">
		<xsl:param name="status"/>
			<xsl:choose>
				<xsl:when test="$status=1">
					<xsl:attribute name="display"><!--XLATESTART-->Unknown<!--XLATESTOP--></xsl:attribute>
				</xsl:when>
				<xsl:when test="$status=2">
					<xsl:attribute name="display"><!--XLATESTART-->Ok<!--XLATESTOP--></xsl:attribute>
				</xsl:when>
				<xsl:when test="$status=3">
					<xsl:attribute name="display"><!--XLATESTART-->Non-Critical<!--XLATESTOP--></xsl:attribute>
				</xsl:when>
				<xsl:when test="$status=4">
					<xsl:attribute name="display"><!--XLATESTART-->Critical<!--XLATESTOP--></xsl:attribute>
				</xsl:when>
				<xsl:when test="$status=5">
					<xsl:attribute name="display"><!--XLATESTART-->Critical<!--XLATESTOP--></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="display"><!--XLATESTART-->Unknown<!--XLATESTOP--></xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
	</xsl:template>
	<xsl:template match="*"/>
</xsl:stylesheet>
