<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="OMA">
		<xsl:apply-templates select="LRAProtObj"/>
	</xsl:template>
	<xsl:template match="LRAProtObj">
		<DataArea>
			<PageTitle>
				<xsl:attribute name="display"><!--XLATESTART-->Thermal Shutdown<!--XLATESTOP--></xsl:attribute>
			</PageTitle>
			<ListData>
				<Data name="LRAProtect">
					<xsl:attribute name="display">Thermal protect shutdown severity</xsl:attribute>
					<xsl:call-template name="cond2txt">
						<xsl:with-param name="condition"><xsl:value-of select="Condition"/></xsl:with-param>
					</xsl:call-template>
				</Data>
			</ListData>
		</DataArea>
	</xsl:template>
	<xsl:template name="cond2txt">
		<xsl:param name="condition"/>
		<xsl:choose>
			<xsl:when test="$condition='0'"><xsl:attribute name="value">Disabled</xsl:attribute></xsl:when>
			<xsl:when test="$condition='1'"><xsl:attribute name="value">Warning</xsl:attribute></xsl:when>
			<xsl:when test="$condition='2'"><xsl:attribute name="value">Failure</xsl:attribute></xsl:when>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
