<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="EventLog">
		<DataArea>
			<script language="javascript">
							function clearLog()
							{
								document.dataarea.action='/servlet/SubmitForm?plugin=com.dell.hip.webplugins.ClearAlertLogWebPlugin';
								document.dataarea.submit();
							}
						</script>
			<Header>Page Header</Header>
			<PageTitle display="Alert Log"/>
			<PromptText><!--XLATESTART-->Alert Log contains...<!--XLATESTOP--></PromptText>
			<CustomButton>
				<Data display="Clear Alert Log" name="Clear" href="javascript:clearLog()"/>
				<Data display="Refresh" name="Refresh" href="/servlet/DataArea?plugin=com.dell.hip.webplugins.AlertLogWebPlugin"/>
			</CustomButton>
			<TableData>
				<Header>
					<Data value="Severity" display="Severity" name="Severity"/>
					<Data value="ID" display="ID" name="ID"/>
					<Data value="Date and Time" display="Date and Time" name="DateTime"/>
					<Data value="Category" display="Category" name="Category"/>
					<Data value="Description" display="Description" name="Description"/>
				</Header>
				<xsl:apply-templates select="LogEntry">
					<xsl:sort select="TimeStamp" data-type="number" order="descending"/>
				</xsl:apply-templates>
			</TableData>
		</DataArea>
	</xsl:template>
	<xsl:template match="LogEntry">
		<Row>
			<Data type="status" name="severity">
				<xsl:attribute name="value"><xsl:call-template name="alert-status2omsa"><xsl:with-param name="Status"><xsl:value-of select="Type"/></xsl:with-param></xsl:call-template></xsl:attribute>
			</Data>
			<Data name="ID">
				<xsl:attribute name="display"><xsl:value-of select="ID"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="ID"/></xsl:attribute>
			</Data>
			<Data name="DateTime">
				<xsl:attribute name="display"><xsl:value-of select="DateTime"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="DateTime"/></xsl:attribute>
			</Data>
			<Data name="Category">
				<xsl:attribute name="display"><xsl:value-of select="Category"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="Category"/></xsl:attribute>
			</Data>			
			<Data name="Description">
				<xsl:attribute name="display"><xsl:value-of select="Description"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="Description"/></xsl:attribute>
			</Data>
		</Row>
	</xsl:template>
	<xsl:template name="alert-status2omsa">
		<xsl:param name="Status" />
		<xsl:choose>
			<xsl:when test="$Status=0">0</xsl:when>
			<xsl:when test="$Status=1">4</xsl:when>
			<xsl:when test="$Status=2">3</xsl:when>
			<xsl:when test="$Status=4">2</xsl:when>
			<xsl:when test="$Status=8">2</xsl:when>
			<xsl:when test="$Status=16">4</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
