<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">

	<xsl:output method="xml"/>
	<xsl:strip-space elements="*"/>
<xsl:template match="/OMA">
	<xsl:apply-templates/>
</xsl:template>
<xsl:template match="DRSC">
	<xsl:apply-templates/>
</xsl:template>
<xsl:template match="Engine">
<ComponentTree>
	<Component name="System" help="">
		<xsl:attribute name="display"><xsl:value-of select="$System"/></xsl:attribute>
		<Component name="MainChassis" help="">
			<xsl:attribute name="display"><xsl:value-of select="$MainSystemChassis"/></xsl:attribute>
			<Component name="RAC" help="">
				<xsl:attribute name="display"><xsl:value-of select="$RemoteAccessController"/></xsl:attribute>
				<SNBMenuItem name="Properties" default="true">
					<xsl:attribute name="display"><xsl:value-of select="$Properties"/></xsl:attribute>
					<LSNBMenuItem help="view" app="drsc" name="View" href="/servlet/DataArea?plugin=com.dell.drsc.webplugins.DRSCView"><xsl:attribute name="display"><xsl:value-of select="$Information"/></xsl:attribute></LSNBMenuItem>
				</SNBMenuItem>
				<SNBMenuItem name="Configuration" default="false">
					<xsl:attribute name="display"><xsl:value-of select="$Configuration"/></xsl:attribute>

					<xsl:choose><xsl:when test="/OMA/LanNetworkingObj/NicCapabilities != 0">
						<LSNBMenuItem app="drsc" help="networkwin" name="NetworkConfiguration" href="/servlet/DataArea?plugin=com.dell.drsc.webplugins.DRSCNetwrk"><xsl:attribute name="display"><xsl:value-of select="$Network"/></xsl:attribute></LSNBMenuItem>
    				</xsl:when></xsl:choose>

					<LSNBMenuItem app="drsc" help="snmp" name="ConfiguredTraps" href="/servlet/DataArea?plugin=com.dell.drsc.webplugins.DRSCConfigureSNMPTraps"><xsl:attribute name="display"><xsl:value-of select="$SNMP"/></xsl:attribute></LSNBMenuItem>
				
					<xsl:choose><xsl:when test="/OMA/DialUpNetworkingObj/DialupCapabilities != 0">
						<LSNBMenuItem app="drsc" help="dialout" name="DemandDialOut" href="/servlet/DataArea?plugin=com.dell.drsc.webplugins.DRSCDemandDialOutUsers"><xsl:attribute name="display"><xsl:value-of select="$DemandDialOut"/></xsl:attribute></LSNBMenuItem>
						<LSNBMenuItem app="drsc" help="cfgdial" name="DialInUsers" href="/servlet/DataArea?plugin=com.dell.drsc.webplugins.DRSCDialInUsers"><xsl:attribute name="display"><xsl:value-of select="$DialInUsers"/></xsl:attribute></LSNBMenuItem>
    				</xsl:when></xsl:choose>

					<LSNBMenuItem app="drsc" help="cfgrprop" name="RemoteFeatures" href="/servlet/DataArea?plugin=com.dell.drsc.webplugins.DRSCRemoteFeatures"><xsl:attribute name="display"><xsl:value-of select="$RemoteFeatures"/></xsl:attribute></LSNBMenuItem>

					<xsl:choose><xsl:when test="/OMA/DialUpNetworkingObj/DialupCapabilities != 0">
						<LSNBMenuItem app="drsc" help="cfgmprop" name="Modem" href="/servlet/DataArea?plugin=com.dell.drsc.webplugins.DRSCModem"><xsl:attribute name="display"><xsl:value-of select="$Modem"/></xsl:attribute></LSNBMenuItem>
    				</xsl:when></xsl:choose>
					
				</SNBMenuItem>
				<SNBMenuItem name="Users" default="false">
					<xsl:attribute name="display"><xsl:value-of select="$Users"/></xsl:attribute>
					<LSNBMenuItem app="drsc" help="cfgracu" name="Users" href="/servlet/DataArea?plugin=com.dell.drsc.webplugins.DRSCUsers"><xsl:attribute name="display"><xsl:value-of select="$RACUsers"/></xsl:attribute></LSNBMenuItem>
				</SNBMenuItem>
				<SNBMenuItem name="RemoteConnect" default="false">
					<xsl:attribute name="display"><xsl:value-of select="$RemoteConnect"/></xsl:attribute>
					<LSNBMenuItem app="drsc" help="racrci" name="OOB" href="/servlet/DataArea?plugin=com.dell.drsc.webplugins.DRSCOutOfBand"><xsl:attribute name="display"><xsl:value-of select="$RemoteConnect1"/></xsl:attribute></LSNBMenuItem>
				</SNBMenuItem>
				
				<xsl:choose>
					<xsl:when test="(/OMA/DRSCSummaryObj/DRSIdentificationObj/DrsCapabilities mod 33554432) - (/OMA/DRSCSummaryObj/DRSIdentificationObj/DrsCapabilities mod 16777216)">
						<SNBMenuItem name="Security" default="false"><xsl:attribute name="display"><xsl:value-of select="$Security"/></xsl:attribute>
							<LSNBMenuItem app="drsc" help="certmgmt" name="CSR" href="/servlet/DataArea?plugin=com.dell.drsc.webplugins.RACCSR"><xsl:attribute name="display"><xsl:value-of select="$CertificateManagement"/></xsl:attribute></LSNBMenuItem>
							<LSNBMenuItem app="drsc" help="authoptions" name="Auth" href="/servlet/DataArea?plugin=com.dell.drsc.webplugins.RACGetAuthConfig"><xsl:attribute name="display"><xsl:value-of select="$AuthenticationOptions"/></xsl:attribute></LSNBMenuItem>
						</SNBMenuItem>
					</xsl:when>
				</xsl:choose>

			</Component>
		</Component>
	</Component>
</ComponentTree>
</xsl:template>

<xsl:template match="*"/>

</xsl:stylesheet>