<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:strip-space elements="*"/>
	<xsl:output method="xml" indent="no"/>
	<xsl:template match="OMA">

		<DataArea>	
			
 			<PageTitle><xsl:attribute name="display"><xsl:value-of select="$RemoteAccessController"/></xsl:attribute></PageTitle>	
			<CustomButton>
				<Data name=""><xsl:attribute name="display"><xsl:value-of select="$Refresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.drsc.webplugins.DRSCView</xsl:attribute>
				</Data>
			</CustomButton>
			<TableData columnspacing="true">				
				<Header>
					<Data editable="false" type="usting">
						<xsl:attribute name="display"><xsl:value-of select="$Attribute"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$Attribute1"/></xsl:attribute>
					</Data>
					<Data editable="false" type="usting">
						<xsl:attribute name="display"><xsl:value-of select="$Value"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$Value1"/></xsl:attribute>
					</Data>
				</Header>
				<xsl:apply-templates select="DRSCSummaryObj"/>
				<xsl:apply-templates select="RemoteHostObj"/>
			</TableData>
		</DataArea>
</xsl:template>
<xsl:template match="DRSCSummaryObj">	
			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$Product"/></xsl:attribute>
				</Data>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value">
						 <xsl:value-of select="DRSIdentificationObj/ProductInfo"/>
					</xsl:attribute>
				</Data>
			</Row>
			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$Description"/></xsl:attribute>
				</Data>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value">
						 <xsl:value-of select="$DescString01"/>
					</xsl:attribute>
				</Data>
			</Row>
			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$Version"/></xsl:attribute>
				</Data>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value">
						 <xsl:value-of select="DRSIdentificationObj/VersionInfo"/>
					</xsl:attribute>
				</Data>
			</Row>
			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$NICEnabled"/></xsl:attribute>
				</Data>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value">
						 <xsl:choose>
							<xsl:when test="LanNetworkingObj/NicEnable='true'"><xsl:value-of select="$Yes"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$No"/></xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
				</Data>
			</Row>
			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$DHCPEnabled"/></xsl:attribute>
				</Data>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value">
						 <xsl:choose>
							<xsl:when test="CurrentLanNetworkingObj/NicDHCPWasUsed='true'"><xsl:value-of select="$Yes1"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$No1"/></xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
				</Data>
			</Row>
			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$CurrentIPAddress"/></xsl:attribute>
				</Data>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value">
						 <xsl:value-of select="CurrentLanNetworkingObj/NicCurrentIpAddress"/>
					</xsl:attribute>
				</Data>
			</Row>
			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$CurrentIPSubnet"/></xsl:attribute>
				</Data>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value">
						 <xsl:value-of select="CurrentLanNetworkingObj/NicCurrentNetMask"/>
					</xsl:attribute>
				</Data>
			</Row>
			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$CurrentIPGateway"/></xsl:attribute>
				</Data>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value">
						 <xsl:value-of select="CurrentLanNetworkingObj/NicCurrentNetGateway"/>
					</xsl:attribute>
				</Data>
			</Row>
			<xsl:choose>
				<xsl:when test="(DRSIdentificationObj/DrsCapabilities mod 128) - (DRSIdentificationObj/DrsCapabilities mod 64)">
					<Row>
						<Data type="ustring" editable="false">
							<xsl:attribute name="value"><xsl:value-of select="$PCMCIACardInformation"/></xsl:attribute>
						</Data>
						<Data type="ustring" editable="false">
							<xsl:attribute name="value">
								 <xsl:choose>
									<xsl:when test="DRSIdentificationObj/PcmciaInfo=''"><xsl:value-of select="$NA"/></xsl:when>
									<xsl:otherwise><xsl:value-of select="DRSIdentificationObj/PcmciaInfo"/></xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
						</Data>
					</Row>
				</xsl:when>
			</xsl:choose>
</xsl:template>
<xsl:template match="RemoteHostObj">
			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$SMTPEnabled"/></xsl:attribute>
				</Data>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="RhostsSmtpEmailEnable='true'"><xsl:value-of select="$Yes2"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$No2"/></xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
				</Data>
			</Row>
			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$SMTPServerIP"/></xsl:attribute>
				</Data>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value">
						 <xsl:value-of select="RhostsSmtpSvrIpAddr"/>
					</xsl:attribute>
				</Data>
			</Row>
			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$RemoteFloppyBoot"/></xsl:attribute>
				</Data>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="RhostsFloppyTftpEnable='true'"><xsl:value-of select="$Yes3"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$No3"/></xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
				</Data>
			</Row>
			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$RemoteFloppyTFTP"/></xsl:attribute>
				</Data>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value">
						<xsl:value-of select="RhostsFloppyTftpIpAddr"/>
					</xsl:attribute>
				</Data>
			</Row>
			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$RemoteFloppyTFTP1"/></xsl:attribute>
				</Data>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value">
						 <xsl:value-of select="RhostsFloppyTftpPath"/>
					</xsl:attribute>
				</Data>
			</Row>
			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$FirmwareUpdateIP"/></xsl:attribute>
				</Data>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value">
						 <xsl:value-of select="RhostsFwUpdateIpAddr"/>
					</xsl:attribute>
				</Data>
			</Row>
			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$FirmwareUpdatePath"/></xsl:attribute>
				</Data>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value">
						 <xsl:value-of select="RhostsFwUpdatePath"/>
					</xsl:attribute>
				</Data>
			</Row>	
</xsl:template>
</xsl:stylesheet>