<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="OMA/OMAUserRights"/>	
	<xsl:template match="OMA">	
	
		<DataArea exportdata="false">
			<xsl:choose>
				<xsl:when test="SMStatus = '258'">
					<xsl:attribute name="submitdisplay"><xsl:value-of select="$BackToUserConfiguration"/></xsl:attribute>
					<xsl:attribute name="submit">/servlet/DataArea?plugin=com.dell.drsc.webplugins.DRSCUsers</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="validate">true</xsl:attribute>
					<xsl:attribute name="onLoad">true</xsl:attribute>
					<xsl:attribute name="backpagedisplay"><xsl:value-of select="$UserConfiguration"/></xsl:attribute>
					<xsl:attribute name="backpagetarget">/servlet/DataArea?plugin=com.dell.drsc.webplugins.DRSCUsers&amp;help=cfgracu</xsl:attribute>
					<xsl:choose>
						<xsl:when test="DRSCUserEntry/UserName= ''">
							<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.drsc.webplugins.SetDRSCUserEntry&amp;oid=<xsl:value-of select="DRSCUserEntry/@oid"></xsl:value-of>&amp;drsFilter=<xsl:value-of select="DRSCUserEntry/UserAlertFilterDrsEvents"/>&amp;AlertFilterSysEvents=<xsl:value-of select="DRSCUserEntry/UserAlertFilterSysEvents"/>&amp;UpdUserMode=ModeAdd&amp;c=<xsl:value-of select="/OMA/NumValidEntries" />
							</xsl:attribute>
						</xsl:when>
				
						<xsl:otherwise>
							<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.drsc.webplugins.SetDRSCUserEntry&amp;oid=<xsl:value-of select="DRSCUserEntry/@oid"></xsl:value-of>&amp;drsFilter=<xsl:value-of select="DRSCUserEntry/UserAlertFilterDrsEvents"/>&amp;AlertFilterSysEvents=<xsl:value-of select="DRSCUserEntry/UserAlertFilterSysEvents"/>&amp;UpdUserMode=ModeUpdate&amp;c=<xsl:value-of select="/OMA/NumValidEntries" />
							</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise> 
			</xsl:choose>

			<HTMLData><iframe id="pagetest" name="pagetest" style="visibility: hidden; height: 1px; width: 1px; top: 0px; left: 0px; position: absolute;" src="/oma/blank.html"></iframe></HTMLData>
			<HTMLData><input type="hidden" value="false" name="passwordChange"/></HTMLData>
			<PageTitle>
				<xsl:choose>
					<xsl:when test="DRSCUserEntry/UserName= ''">
						<xsl:attribute name="display"><xsl:value-of select="$AddRemoteAccess"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="display"><xsl:value-of select="$AddRemoteAccess"/></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</PageTitle>
			
			<xsl:choose>
				<xsl:when test="SMStatus = '258'">
					<PromptText><xsl:value-of select="$ErrorRemoteAccessMsg"/></PromptText>
				</xsl:when>
				<xsl:otherwise>
					<CustomButton>
						<xsl:choose>
							<xsl:when test="DRSCUserEntry/UserName= ''">
							</xsl:when>
							<xsl:otherwise>
								<Data name="Remove" formSubmit="true"><xsl:attribute name="display"><xsl:value-of select="$Remove"/></xsl:attribute>
									<xsl:attribute name="href">javascript:RemoveDRSCUser()</xsl:attribute>
								</Data>
							</xsl:otherwise>
						</xsl:choose>
					</CustomButton>
					<xsl:apply-templates select="DRSCUserEntry"/>
				</xsl:otherwise>
			</xsl:choose>
			
			<script type="text/javascript" src="/drsc/js/utility.js"/>
			<script language="javascript">
				var	resetMsg = "<xsl:value-of select="$Thisoperationcaused"/>";
				
				function RemoveDRSCUser()
				{
					var a = <xsl:value-of select="/OMA/NumValidEntries" />;
					if (a &lt;= 1)
					{
						alert("<xsl:value-of select="$CannotRemoveUser"/>");
					}
					else
					{
						var resetMsg = <xsl:value-of select="$Thisoperationcaused1"/>;
						alert(resetMsg);
						document.dataarea.action= top.gnv.appendVID('/servlet/SubmitForm?plugin=com.dell.drsc.webplugins.SetDRSCUserEntry&amp;oid=<xsl:value-of select="DRSCUserEntry/@oid"/>&amp;drsFilter=<xsl:value-of select="DRSCUserEntry/UserAlertFilterDrsEvents"/>&amp;AlertFilterSysEvents=<xsl:value-of select="DRSCUserEntry/UserAlertFilterSysEvents"/>&amp;UpdUserMode=ModeRemove');
						document.dataarea.submit();
					}
				}
				
				function initializationRoutine()
				{
					enableChangePassword();
					<xsl:choose><xsl:when test="(DRSCUserEntry/UserCapabilities mod 2048) - (DRSCUserEntry/UserCapabilities mod 1024)">enableNumericPaging2();</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="(DRSCUserEntry/UserCapabilities mod 8388608) - (DRSCUserEntry/UserCapabilities mod 4194304)">enableEmailPaging2();</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="(DRSCUserEntry/UserCapabilities mod 32768) - (DRSCUserEntry/UserCapabilities mod 16384)">enableAlphaPaging2();</xsl:when></xsl:choose>
				}
				
				function enableChangePassword()
				{
					if (document.dataarea.enableChangePass != null)
					{
						if (document.dataarea.enableChangePass.checked == true)
						{
							document.dataarea.Password.disabled = false;
							document.dataarea.ConfirmPassword.disabled = false;
						}
						else
						{
							document.dataarea.Password.disabled = true;
							document.dataarea.ConfirmPassword.disabled = true;
						}
					}
				}
				
				function enableNumericPaging()
				{
					enableNumericPaging2();
					changeNumericPaging();
				}
				
				function enableNumericPaging2()
				{
					var checked = document.dataarea.enableNumPage.checked;
					if (checked) checked = false;
					else checked = true;
					document.dataarea.PagerNumber.disabled = checked;
					document.dataarea.NumericMessage.disabled = checked;
				}

				function enableEmailPaging()
				{
					enableEmailPaging2();
					changeEmailPaging();
				}
				
				function enableEmailPaging2()
				{
					var checked = document.dataarea.enableEmailPage.checked;
					if (checked) checked = false;
					else checked = true;
					document.dataarea.EmailAddr.disabled = checked;
					document.dataarea.emailMsg.disabled =checked;
				}
				
				function enableAlphaPaging()
				{
					enableAlphaPaging2();
					changeAlphaPaging();
				}
				
				function enableAlphaPaging2()
				{
					var checked = document.dataarea.enableAlphaPage.checked;
					if (checked) checked = false;
					else checked = true;
					document.dataarea.AlphaPagerNum.disabled = checked;
					document.dataarea.alphaPrtcl.disabled =checked;
					document.dataarea.AlphaBaudrate.disabled =checked;
					document.dataarea.CustomMsg.disabled =checked;
					document.dataarea.PagerID.disabled =checked;
					document.dataarea.PagerPassword.disabled =checked;
				}
				
				function selectAllInfoA()
				{
					var value = document.dataarea.selectAllInfo.checked;
					<xsl:choose><xsl:when test="DRSCUserEntry/DRSCTempSensor1/Capable='true'">if (document.dataarea.EnableDRSCTemp1.disabled == false) document.dataarea.EnableDRSCTemp1.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="DRSCUserEntry/DRSCVoltSensor1/Capable='true'">if (document.dataarea.EnableDRSCVolt1.disabled == false) document.dataarea.EnableDRSCVolt1.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="DRSCUserEntry/DRSCBatterSensor1/Capable='true'">if (document.dataarea.EnableDRSCBattery1.disabled == false) document.dataarea.EnableDRSCBattery1.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="DRSCUserEntry/DRSCPCIVoltSensor1/Capable='true'">if (document.dataarea.EnableDRSCPCIVolt1.disabled == false) document.dataarea.EnableDRSCPCIVolt1.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="DRSCUserEntry/DRSCPCIAUXVoltSensor1/Capable='true'">if (document.dataarea.EnableDRSCPCIAUXVolt1.disabled == false) document.dataarea.EnableDRSCPCIAUXVolt1.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="DRSCUserEntry/SystemTempSensor1/Capable='true'">if (document.dataarea.EnableSystemTemp1.disabled == false) document.dataarea.EnableSystemTemp1.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="DRSCUserEntry/SystemVoltSensor1/Capable='true'">if (document.dataarea.EnableSystemVolt1.disabled == false) document.dataarea.EnableSystemVolt1.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="DRSCUserEntry/SystemFanSensor1/Capable='true'">if (document.dataarea.EnableSystemFan1.disabled == false) document.dataarea.EnableSystemFan1.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="DRSCUserEntry/SystemMiscSensor1/Capable='true'">if (document.dataarea.EnableSystemMisc1.disabled == false) document.dataarea.EnableSystemMisc1.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="DRSCUserEntry/DRSCCommEMCLostSensor/Capable='true'">if (document.dataarea.EnableDRSCCommEMCLost.disabled == false) document.dataarea.EnableDRSCCommEMCLost.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="DRSCUserEntry/DRSCCommEMCRestoredSensor/Capable='true'">if (document.dataarea.EnableDRSCCommEMCRestored.disabled == false) document.dataarea.EnableDRSCCommEMCRestored.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="DRSCUserEntry/DRSCAuthenticationFailSensor/Capable='true'">if (document.dataarea.EnableDRSCAuthenticationFail.disabled == false) document.dataarea.EnableSystemDetectedHang.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="DRSCUserEntry/DRSCBatteryChargeLowSensor/Capable='true'">if (document.dataarea.EnableDRSCBatteryChargeLow.disabled == false) document.dataarea.EnableDRSCBatteryChargeLow.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="DRSCUserEntry/SystemDetectedHang/Capable='true'">if (document.dataarea.EnableSystemDetectedHang.disabled == false) document.dataarea.EnableSystemDetectedHang.checked = value;</xsl:when></xsl:choose>
				}
	
				function selectAllWarningA()
				{
					var value = document.dataarea.selectAllWarning.checked;
					<xsl:choose><xsl:when test="DRSCUserEntry/DRSCTempSensor1/Capable='true'">if (document.dataarea.EnableDRSCTemp2.disabled == false) document.dataarea.EnableDRSCTemp2.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="DRSCUserEntry/DRSCVoltSensor1/Capable='true'">if (document.dataarea.EnableDRSCVolt2.disabled == false) document.dataarea.EnableDRSCVolt2.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="DRSCUserEntry/DRSCBatterSensor1/Capable='true'">if (document.dataarea.EnableDRSCBattery2.disabled == false) document.dataarea.EnableDRSCBattery2.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="DRSCUserEntry/DRSCPCIVoltSensor1/Capable='true'">if (document.dataarea.EnableDRSCPCIVolt2.disabled == false) document.dataarea.EnableDRSCPCIVolt2.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="DRSCUserEntry/DRSCPCIAUXVoltSensor1/Capable='true'">if (document.dataarea.EnableDRSCPCIAUXVolt2.disabled == false) document.dataarea.EnableDRSCPCIAUXVolt2.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="DRSCUserEntry/SystemTempSensor1/Capable='true'">if (document.dataarea.EnableSystemTemp2.disabled == false) document.dataarea.EnableSystemTemp2.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="DRSCUserEntry/SystemVoltSensor1/Capable='true'">if (document.dataarea.EnableSystemVolt2.disabled == false) document.dataarea.EnableSystemVolt2.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="DRSCUserEntry/SystemFanSensor1/Capable='true'">if (document.dataarea.EnableSystemFan2.disabled == false) document.dataarea.EnableSystemFan2.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="DRSCUserEntry/SystemMiscSensor1/Capable='true'">if (document.dataarea.EnableSystemMisc2.disabled == false) document.dataarea.EnableSystemMisc2.checked = value;</xsl:when></xsl:choose>
				}
				
				function selectAllSevereA()
				{
					var value = document.dataarea.selectAllSevere.checked;
					<xsl:choose><xsl:when test="DRSCUserEntry/DRSCTempSensor1/Capable='true'">if (document.dataarea.EnableDRSCTemp3.disabled == false) document.dataarea.EnableDRSCTemp3.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="DRSCUserEntry/DRSCVoltSensor1/Capable='true'">if (document.dataarea.EnableDRSCVolt3.disabled == false) document.dataarea.EnableDRSCVolt3.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="DRSCUserEntry/DRSCBatterSensor1/Capable='true'">if (document.dataarea.EnableDRSCBattery3.disabled == false) document.dataarea.EnableDRSCBattery3.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="DRSCUserEntry/DRSCPCIVoltSensor1/Capable='true'">if (document.dataarea.EnableDRSCPCIVolt3.disabled == false) document.dataarea.EnableDRSCPCIVolt3.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="DRSCUserEntry/DRSCPCIAUXVoltSensor1/Capable='true'">if (document.dataarea.EnableDRSCPCIAUXVolt3.disabled == false) document.dataarea.EnableDRSCPCIAUXVolt3.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="DRSCUserEntry/SystemTempSensor1/Capable='true'">if (document.dataarea.EnableSystemTemp3.disabled == false) document.dataarea.EnableSystemTemp3.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="DRSCUserEntry/SystemVoltSensor1/Capable='true'">if (document.dataarea.EnableSystemVolt3.disabled == false) document.dataarea.EnableSystemVolt3.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="DRSCUserEntry/SystemFanSensor1/Capable='true'">if (document.dataarea.EnableSystemFan3.disabled == false) document.dataarea.EnableSystemFan3.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="DRSCUserEntry/SystemMiscSensor1/Capable='true'">if (document.dataarea.EnableSystemMisc3.disabled == false) document.dataarea.EnableSystemMisc3.checked = value;</xsl:when></xsl:choose>
				}
				
				function validate()
				{
					var errorMsg = "";
					var errorFound = false;
					var test = '<xsl:value-of select="DRSCUserEntry/UserName"/>'
					
					if (test == "")
					{
						if (trim(document.dataarea.usrName.value) == "")
						{
							if (errorMsg != "") errorMsg += "\n";
							errorMsg += "<xsl:value-of select="$Usernamecannot"/>";
							errorFound = true;
						}

						else if (!testUnicode(document.dataarea.usrName.value))
						{
							if (errorMsg != "") errorMsg += "\n";
							errorMsg += "<xsl:value-of select="$Usernamecontains"/>";
							errorFound = true;
						}
					}

					if (document.dataarea.Password.disabled == false &amp;&amp; document.dataarea.ConfirmPassword.disabled == false)
					{
						document.dataarea.passwordChange.value = "true";
						if (document.dataarea.Password.value == "")
						{
							if (errorMsg != "") errorMsg += "\n";
							errorMsg += "<xsl:value-of select="$Passwordfieldname"/>";
						 	errorFound = true;
						}
						else if (!testUnicode(document.dataarea.Password.value))
						{
							if (errorMsg != "") errorMsg += "\n";
							errorMsg += "<xsl:value-of select="$Passwordcontainsinvalid"/>";
							errorFound = true;
						}
						
						if (document.dataarea.ConfirmPassword.value == "")
						{
							if (errorMsg != "") errorMsg += "\n";
							errorMsg += "<xsl:value-of select="$Confirmpasswordfield"/>";
						 	errorFound = true;
						}
						else if (!testUnicode(document.dataarea.ConfirmPassword.value))
						{
							if (errorMsg != "") errorMsg += "\n";
							errorMsg += "<xsl:value-of select="$Confirmpasswordcontains"/>";
							errorFound = true;
						}

						if (document.dataarea.ConfirmPassword.value != document.dataarea.Password.value)
						{
							if (errorMsg != "") errorMsg += "\n";
							errorMsg += "<xsl:value-of select="$Passwordsdonot"/>";
						 	errorFound = true;
						}					
					}
					else document.dataarea.passwordChange.value = "false";
					
					function ltrim ( s ) 
					{ 
						return s.replace( /^\s*/, "" ) 
					} 
			
					function rtrim ( s ) 
					{ 
						return s.replace( /\s*$/, "" ); 
					} 
			
					//Combine the rtrim() and ltrim() functions to make the trim() function, which just wraps both calls together: 
			
					function trim ( s ) 
					{ 
						return rtrim(ltrim(s)); 
					}
					
					<xsl:choose><xsl:when test="(DRSCUserEntry/UserCapabilities mod 2048) - (DRSCUserEntry/UserCapabilities mod 1024)">
					if (document.dataarea.enableNumPage.checked == true)
					{
						if (document.dataarea.PagerNumber.value == "")
						{
							if (errorMsg != "") errorMsg += "\n";
							errorMsg += "<xsl:value-of select="$Numericpagernumber"/>";
						 	errorFound = true;
						}
						else if (!testUnicode(document.dataarea.PagerNumber.value))
						{
							if (errorMsg != "") errorMsg += "\n";
							errorMsg += "<xsl:value-of select="$Numericpagernumber1"/>";
							errorFound = true;
						}
						
						if (document.dataarea.NumericMessage.value == "")
						{
							if (errorMsg != "") errorMsg += "\n";
							errorMsg += "<xsl:value-of select="$Numericmessagefield"/>";
						 	errorFound = true;
						}
						else if (!testUnicode(document.dataarea.NumericMessage.value))
						{
							if (errorMsg != "") errorMsg += "\n";
							errorMsg += "<xsl:value-of select="$Numericmessagecontains"/>";
							errorFound = true;
						}
					}
					</xsl:when></xsl:choose>
	
					<xsl:choose><xsl:when test="(DRSCUserEntry/UserCapabilities mod 8388608) - (DRSCUserEntry/UserCapabilities mod 4194304)">
					if (document.dataarea.enableEmailPage.checked == true)
					{
						if (document.dataarea.EmailAddr.value == "")
						{
							if (errorMsg != "") errorMsg += "\n";
							errorMsg += "<xsl:value-of select="$Emailaddressfield"/>";
						 	errorFound = true;
						}
						else if (!testUnicode(document.dataarea.EmailAddr.value))
						{
							if (errorMsg != "") errorMsg += "\n";
							errorMsg += "<xsl:value-of select="$Emailaddresscontains"/>";
							errorFound = true;
						}
						else if(document.dataarea.EmailAddr.value.indexOf("@")==-1)
						{
							if (errorMsg != "") errorMsg += "\n";
							errorMsg += "<xsl:value-of select="$Emailaddressis"/>";
							errorFound = true;
						}
						else if(trim(document.dataarea.EmailAddr.value).indexOf(" ")!=-1)
						{
							if (errorMsg != "") errorMsg += "\n";
							errorMsg += "<xsl:value-of select="$Emailaddressis1"/>";
							errorFound = true;
						}
						if (trim(document.dataarea.emailMsg.value) == "")
						{
							if (errorMsg != "") errorMsg += "\n";
							errorMsg += "<xsl:value-of select="$Emailpagingmessage"/>";
						 	errorFound = true;
						}
						else if (!testUnicode(document.dataarea.emailMsg.value))
						{
							if (errorMsg != "") errorMsg += "\n";
							errorMsg += "<xsl:value-of select="$Emailpagingmessage1"/>";
							errorFound = true;
						}
					}
					</xsl:when></xsl:choose>
	
					<xsl:choose><xsl:when test="(DRSCUserEntry/UserCapabilities mod 32768) - (DRSCUserEntry/UserCapabilities mod 16384)">
					if (document.dataarea.enableAlphaPage.checked == true)
					{
						if (document.dataarea.AlphaPagerNum.value == "")
						{
							if (errorMsg != "") errorMsg += "\n";
							errorMsg += "<xsl:value-of select="$AlphaNumericpagernumber"/>";
						 	errorFound = true;
						}
						else if (!testUnicode(document.dataarea.AlphaPagerNum.value))
						{
							if (errorMsg != "") errorMsg += "\n";
							errorMsg += "<xsl:value-of select="$AlphaNumericpagernumber1"/>";
							errorFound = true;
						}
						
						if (document.dataarea.CustomMsg.value == "")
						{
							if (errorMsg != "") errorMsg += "\n";
							errorMsg += "<xsl:value-of select="$AlphaNumericpagingmessage"/>";
						 	errorFound = true;
						}
						else if (!testUnicode(document.dataarea.CustomMsg.value))
						{
							if (errorMsg != "") errorMsg += "\n";
							errorMsg += "<xsl:value-of select="$AlphaNumericpagingmessage1"/>";
							errorFound = true;
						}
						
						if (document.dataarea.PagerID.value == "")
						{
							if (errorMsg != "") errorMsg += "\n";
							errorMsg += "<xsl:value-of select="$AlphaNumericpagerID"/>";
						 	errorFound = true;
						}
						else if (!testUnicode(document.dataarea.PagerID.value))
						{
							if (errorMsg != "") errorMsg += "\n";
							errorMsg += "<xsl:value-of select="$AlphaNumericpagerID1"/>";
							errorFound = true;
						}
					}
					</xsl:when></xsl:choose>
					
					if (errorFound == true)
					{
						alert(errorMsg)
						return false;
					}
					else
					{
						var	resetMsg = <xsl:value-of select="$Thisoperationcaused1"/>
						alert(resetMsg);
						return true;
					}

					
					return true;
				}
				
				var isNumericPagingChanged = false;
				var isAlphaPagingChanged = false;
				var isEmailPagingChanged = false;
				
				function changeNumericPaging()
				{
					isNumericPagingChanged = true;
				}
				
				function changeAlphaPaging()
				{
					isAlphaPagingChanged = true;
				}

				function changeEmailPaging()
				{
					isEmailPagingChanged = true;
				}

				function pageTest(type, oid)
				{
					if (type == 0) // Email Paging
					{
						if (document.dataarea.enableEmailPage.checked == true)
						{
							var testSMTP = '<xsl:value-of select="RemoteHostObj/RhostsSmtpEmailEnable"/>';
							if (isEmailPagingChanged == true)
							{
								alert(<xsl:value-of select="$Emailpagingoptions"/>);
							 	return;
							}
							else if (testSMTP == "false")
							{
								alert("<xsl:value-of select="$Cannottestemail"/>");
							 	return;
							}
						}
						else
						{
							alert(<xsl:value-of select="$Emailpagingis"/>);
						 	return;
						}					
					}
					else if (type == 1) // Alpha-Numeric Paging
					{
						if (document.dataarea.enableAlphaPage.checked == true)
						{
							if (isAlphaPagingChanged == true)
							{
								alert(<xsl:value-of select="$AlphaNumericpagingoptions"/>);
							 	return;
							}
						}
						else
						{
							alert(<xsl:value-of select="$AlphaNumericpagingis"/>);
						 	return;
						}
					}
					else if (type == 2) // Numeric Paging
					{
						if (document.dataarea.enableNumPage.checked == true)
						{
							if (isNumericPagingChanged == true)
							{
								alert(<xsl:value-of select="$Numericpagingoptions"/>);
							 	return;
							}
						}
						else
						{
							alert(<xsl:value-of select="$Numericpagingis"/>);
						 	return;
						}
					}
					
					if (oid == null || oid == "") return;
					document.getElementById("pagetest").src = "/servlet/DataArea?plugin=com.dell.drsc.webplugins.TestDRSCPageTrap&amp;oid=" + oid + "&amp;id=" + type;
				}
				
				</script>
		</DataArea>
		
	</xsl:template>
		<xsl:template match="DRSCUserEntry">	
		
		<TableData name="TableGeneralConf"><xsl:attribute name="display"><xsl:value-of select="$General"/></xsl:attribute>
			<SubHeader value="General"><xsl:attribute name="display"><xsl:value-of select="$General1"/></xsl:attribute></SubHeader>
			<Header>
				<Data name="Property" value="Property" editable="false" ignoreonweb="true" type="usting"><xsl:attribute name="display"><xsl:value-of select="$Property"/></xsl:attribute></Data>
				<Data name="Value" value="Value" editable="false" ignoreonweb="true" type="usting"><xsl:attribute name="display"><xsl:value-of select="$Value"/></xsl:attribute></Data>
			</Header>
			<Row>
				<Data value="Index" type="ustring" editable="false" ignoreonweb="true"/>
				<Data name="Index" type="editbox" editable="true" ignoreonweb="true">
					<xsl:attribute name="value"><xsl:value-of select="number(UserIndex) - 1"/></xsl:attribute>
				</Data>
			</Row>
			<xsl:choose>
			<xsl:when test="UserName=''">
				<Row>
					<Data type="ustring" editable="false" width="190">
						<xsl:attribute name="value"><xsl:value-of select="$UserName"/></xsl:attribute>
					</Data>
					<Data name="usrName" type="editbox" editable="false">
						<xsl:attribute name="value"><xsl:value-of select="UserName"/></xsl:attribute>
					</Data>
					<Data ignoreoncli="true"/>
				</Row>
			</xsl:when>
			<xsl:otherwise>
				<Row>
					<Data type="ustring" editable="false" width="190">
						<xsl:attribute name="value"><xsl:value-of select="$UserName1"/></xsl:attribute>
					</Data>
					<Data name="usrName" type="ustring" editable="false">
						<xsl:attribute name="value"><xsl:value-of select="UserName"/></xsl:attribute>
					</Data>
					<Data ignoreoncli="true" name="usrName" type="hidden" editable="false">
						<xsl:attribute name="returnvalue"><xsl:value-of select="UserName"/></xsl:attribute>
					</Data>
				</Row>
				<Row>
					<Data type="ustring" editable="false" width="190">
						<xsl:attribute name="value"><xsl:value-of select="$ChangePassword"/></xsl:attribute>
					</Data>
					<Data name="enableChangePass" type="checkbox" event="onClick" handler="javascript:enableChangePassword()" editable="true" align="left"/>
					<Data ignoreoncli="true"/>
				</Row>
			</xsl:otherwise>
			</xsl:choose>
			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$Password"/></xsl:attribute>
				</Data>
				<Data name="Password" type="password" editable="true" size="63" value=""/>
				<Data ignoreoncli="true"/>
			</Row>		
			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$ConfirmPassword"/></xsl:attribute>
				</Data>
				<Data name="ConfirmPassword" type="password" editable="true" size="63" value=""/>
				<Data ignoreoncli="true"/>
			</Row>	
		</TableData>	
		
		<xsl:choose><xsl:when test="(UserCapabilities mod 2048) - (UserCapabilities mod 1024)">
		<TableData columnspacing="true" name="TableNumericPaging"><xsl:attribute name="display"><xsl:value-of select="$NumericPaging"/></xsl:attribute>
			<SubHeader value="Numeric Paging"><xsl:attribute name="display"><xsl:value-of select="$NumericPaging1"/></xsl:attribute></SubHeader>
			<Header>
				<Data name="Property" value="Property" editable="false" ignoreonweb="true" type="usting"><xsl:attribute name="display"><xsl:value-of select="$Property1"/></xsl:attribute></Data>
				<Data name="Value" value="Value" editable="false" ignoreonweb="true" type="usting"><xsl:attribute name="display"><xsl:value-of select="$Value1"/></xsl:attribute></Data>
			</Header>

			<Row>
				<Data type="ustring" editable="false" width="190">
					<xsl:attribute name="value"><xsl:value-of select="$EnableNumericPaging"/></xsl:attribute>
				</Data>
				<Data name="enableNumPage" type="checkbox" event="onClick" handler="javascript:enableNumericPaging()" editable="true" align="left">
					<xsl:if test="EnableNumericPaging='true'">
						<xsl:attribute name="state">1</xsl:attribute>
					</xsl:if>
				</Data>
				<xsl:choose>
					<xsl:when test="UserName=''">
						<Data ignoreoncli="true"/>
					</xsl:when>
					<xsl:otherwise>
						<Data ignoreoncli="true" align="right" link="true">
							<xsl:attribute name="href">javascript:pageTest(2, "<xsl:value-of select="@oid"/>")</xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$TestNumericPaging"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</Row> 
			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$PagerNumber"/></xsl:attribute>
				</Data>
				<Data name="PagerNumber" type="editbox" editable="true" event="onChange" handler="javascript:changeNumericPaging()">
					<xsl:attribute name="value"><xsl:value-of select="PageNumber"/></xsl:attribute>
				</Data>
				<Data ignoreoncli="true"/>
			</Row>
			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$NumericMessage"/></xsl:attribute>
				</Data>
				<Data name="NumericMessage" type="editbox" editable="true" event="onChange" handler="javascript:changeNumericPaging()">
					<xsl:attribute name="value"><xsl:value-of select="NumericMessage"/></xsl:attribute>
				</Data>
				<Data ignoreoncli="true"/>
			</Row>
		</TableData>
		</xsl:when></xsl:choose>
		
		<xsl:choose><xsl:when test="(UserCapabilities mod 8388608) - (UserCapabilities mod 4194304)">
		<TableData columnspacing="true" name="TableEmailPaging"><xsl:attribute name="display"><xsl:value-of select="$EmailPaging"/></xsl:attribute>
			<SubHeader value="Email Paging"><xsl:attribute name="display"><xsl:value-of select="$EmailPaging1"/></xsl:attribute></SubHeader>
			<Header>
				<Data name="Property" value="Property" editable="false" ignoreonweb="true" type="usting"><xsl:attribute name="display"><xsl:value-of select="$Property2"/></xsl:attribute></Data>
				<Data name="Value" value="Value" editable="false" ignoreonweb="true" type="usting"><xsl:attribute name="display"><xsl:value-of select="$Value2"/></xsl:attribute></Data>
			</Header>
			<Row>
				<Data type="ustring" editable="false" width="190">
					<xsl:attribute name="value"><xsl:value-of select="$EnableEmailPaging"/></xsl:attribute>
				</Data>
				<Data name="enableEmailPage" type="checkbox" event="onClick" handler="javascript:enableEmailPaging()" editable="true" align="left">
					<xsl:if test="EnableEmailPaging='true'">
						<xsl:attribute name="state">1</xsl:attribute>
					</xsl:if>
				</Data>
				<xsl:choose>
					<xsl:when test="UserName=''">
						<Data ignoreoncli="true"/>
					</xsl:when>
					<xsl:otherwise>
						<Data ignoreoncli="true" align="right" link="true">
							<xsl:attribute name="href">javascript:pageTest(0, "<xsl:value-of select="@oid"/>")</xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$TestEmailPaging"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</Row> 
			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$EmailAddress"/></xsl:attribute>
				</Data>
				<Data name="EmailAddr" type="editbox" editable="true" event="onChange" handler="javascript:changeEmailPaging()" maxlength="63">
					<xsl:attribute name="value"><xsl:value-of select="EmailAddress"/></xsl:attribute>
				</Data>
				<Data ignoreoncli="true"/>
			</Row>
			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$Message"/></xsl:attribute>
				</Data>
				<Data name="emailMsg" type="editbox" editable="true" event="onChange" handler="javascript:changeEmailPaging()" maxlength="30">
					<xsl:attribute name="value"><xsl:value-of select="EmailMessage"/></xsl:attribute>
				</Data>
				<Data ignoreoncli="true"/>
			</Row>
		</TableData>
		</xsl:when></xsl:choose>
	
		<xsl:choose><xsl:when test="(UserCapabilities mod 32768) - (UserCapabilities mod 16384)">
		<TableData columnspacing="true" name="TableAlphaPaging"><xsl:attribute name="display"><xsl:value-of select="$AlphaPaging"/></xsl:attribute>
			<SubHeader value="Alpha  Paging"><xsl:attribute name="display"><xsl:value-of select="$AlphaNumericPaging"/></xsl:attribute></SubHeader>
			<Header>
				<Data name="Property" value="Property" editable="false" ignoreonweb="true" type="usting"><xsl:attribute name="display"><xsl:value-of select="$Property3"/></xsl:attribute></Data>
				<Data name="Value" value="Value" editable="false" ignoreonweb="true" type="usting"><xsl:attribute name="display"><xsl:value-of select="$Value3"/></xsl:attribute></Data>
			</Header>
			<Row>
				<Data type="ustring" editable="false" width="190">
					<xsl:attribute name="value"><xsl:value-of select="$EnableAlphaNumericPaging"/></xsl:attribute>
				</Data>
				<Data name="enableAlphaPage" type="checkbox" event="onClick" handler="javascript:enableAlphaPaging()" editable="true" align="left">
					<xsl:if test="EnableAlphaPaging='true'">
						<xsl:attribute name="state">1</xsl:attribute>
					</xsl:if>
				</Data>
				<xsl:choose>
					<xsl:when test="UserName=''">
						<Data ignoreoncli="true"/>
					</xsl:when>
					<xsl:otherwise>
						<Data ignoreoncli="true" align="right" link="true">
							<xsl:attribute name="href">javascript:pageTest(1, "<xsl:value-of select="@oid"/>")</xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$TestAlphaPaging"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</Row> 
			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$PagerNumber1"/></xsl:attribute>
				</Data>
				<Data name="AlphaPagerNum" type="editbox" editable="true" event="onChange" handler="javascript:changeAlphaPaging()">
					<xsl:attribute name="value"><xsl:value-of select="AplhaPageNumber"/></xsl:attribute>
				</Data>
				<Data ignoreoncli="true"/>
			</Row>
			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$AlphaNumericProtocol"/></xsl:attribute>
				</Data>
				<Data type="select" name="alphaPrtcl" editable="true" event="onChange" handler="javascript:changeAlphaPaging()"><xsl:attribute name="display"><xsl:value-of select="$AlphaProtocol"/></xsl:attribute>
						<Choice value="8N1" returnvalue="8N1">
							<xsl:if test="AlphaProtocol='8N1'">
								<xsl:attribute name="default">true</xsl:attribute>
							</xsl:if>
						</Choice>
						<Choice value="7E0" returnvalue="7E0">
							<xsl:if test="AlphaProtocol='7E0'">
								<xsl:attribute name="default">true</xsl:attribute>
							</xsl:if>
						</Choice>
				</Data>
				<Data ignoreoncli="true"/>
			</Row>
			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$BaudRate"/></xsl:attribute>
				</Data>
				<Data type="select" name="AlphaBaudrate" editable="true" event="onChange" handler="javascript:changeAlphaPaging()"><xsl:attribute name="display"><xsl:value-of select="$DialInAuthentication"/></xsl:attribute>
					<Choice value="300" returnvalue="300">
						<xsl:if test="BaudRate='300'">
							<xsl:attribute name="default">true</xsl:attribute>
						</xsl:if>				
					</Choice>
					<Choice value="1200" returnvalue="1200">
						<xsl:if test="BaudRate='1200'">
							<xsl:attribute name="default">true</xsl:attribute>
						</xsl:if>				
					</Choice>
				</Data>
				<Data ignoreoncli="true"/>
			</Row>
			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$CustomMessage"/></xsl:attribute>
				</Data>
				<Data name="CustomMsg" type="editbox" maxlength="31" editable="true" event="onChange" handler="javascript:changeAlphaPaging()">
					<xsl:attribute name="value"><xsl:value-of select="CustomMessage"/></xsl:attribute>
				</Data>
				<Data ignoreoncli="true"/>
			</Row>
			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$PagerID"/></xsl:attribute>
				</Data>
				<Data name="PagerID" type="editbox" editable="true" event="onChange" handler="javascript:changeAlphaPaging()">
					<xsl:attribute name="value"><xsl:value-of select="PagerID"/></xsl:attribute>
				</Data>
				<Data ignoreoncli="true"/>
			</Row>
			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$PagerPassword"/></xsl:attribute>
				</Data>
				<Data name="PagerPassword" type="editbox" editable="true" event="onChange" handler="javascript:changeAlphaPaging()">
					<xsl:attribute name="value"><xsl:value-of select="PagerPassword"/></xsl:attribute>
				</Data>
				<Data ignoreoncli="true"/>
			</Row>
		</TableData>
		</xsl:when></xsl:choose>
		
		<TableData name="TableTrapConf" columnspacing="true"><xsl:attribute name="display"><xsl:value-of select="$SeverityConfiguration"/></xsl:attribute>
			<SubHeader value="SeverityConfiguration"><xsl:attribute name="display"><xsl:value-of select="$SeverityConfiguration1"/></xsl:attribute></SubHeader>
			<Header>
				<Data editable="false" type="usting"><xsl:attribute name="display"><xsl:value-of select="$Informational"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$Informational1"/></xsl:attribute>
				</Data>
				<Data editable="false" type="usting"><xsl:attribute name="display"><xsl:value-of select="$Warning"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$Warning1"/></xsl:attribute>
				</Data>
				<Data editable="false" type="usting"><xsl:attribute name="display"><xsl:value-of select="$Severe"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$Severe1"/></xsl:attribute>
				</Data>
				<Data editable="false" type="usting"><xsl:attribute name="display"><xsl:value-of select="$TrapDescription"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$TrapDescription1"/></xsl:attribute>
				</Data>
			</Header>

			<Row>			
				<Data name="selectAllInfo" type="checkbox" editable="true" align="left" event="onClick" handler="javascript:selectAllInfoA()"/>
				<Data name="selectAllWarning" type="checkbox" editable="true" align="left" event="onClick" handler="javascript:selectAllWarningA()"/>
				<Data name="selectAllSevere" type="checkbox" editable="true" align="left" event="onClick" handler="javascript:selectAllSevereA()"/>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$SelectAll"/></xsl:attribute>
				</Data>
			</Row> 

		<xsl:choose><xsl:when test="DRSCTempSensor1/Capable='true'">
		<Row>			
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCTempSensor1/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCTempSensor1/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCTemp1</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllInfo</xsl:with-param>
			</xsl:call-template>
	
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCTempSensor2/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCTempSensor2/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCTemp2</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllWarning</xsl:with-param>
			</xsl:call-template>
				
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCTempSensor3/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCTempSensor3/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCTemp3</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllSevere</xsl:with-param>
			</xsl:call-template>
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$RemoteAccessController"/></xsl:attribute>
			</Data>
		</Row>
		</xsl:when></xsl:choose>
			
		<xsl:choose><xsl:when test="DRSCVoltSensor1/Capable='true'">
		<Row>
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCVoltSensor1/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCVoltSensor1/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCVolt1</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllInfo</xsl:with-param>
			</xsl:call-template>

			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCVoltSensor2/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCVoltSensor2/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCVolt2</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllWarning</xsl:with-param>
			</xsl:call-template>
			
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCVoltSensor3/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCVoltSensor3/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCVolt3</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllSevere</xsl:with-param>
			</xsl:call-template>
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$RemoteAccessController1"/></xsl:attribute>
			</Data>
		</Row>
		</xsl:when></xsl:choose> 	
		
		<xsl:choose><xsl:when test="DRSCBatterSensor1/Capable='true'">
		<Row>
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCBatterSensor1/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCBatterSensor1/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCBattery1</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllInfo</xsl:with-param>
			</xsl:call-template>

			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCBatterSensor2/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCBatterSensor2/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCBattery2</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllWarning</xsl:with-param>
			</xsl:call-template>
			
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCBatterSensor3/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCBatterSensor3/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCBattery3</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllSevere</xsl:with-param>
			</xsl:call-template>	
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$RemoteAccessController2"/></xsl:attribute>
			</Data>
		</Row> 	
		</xsl:when></xsl:choose>
		
		<xsl:choose><xsl:when test="DRSCPCIVoltSensor1/Capable='true'">
		<Row>
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCPCIVoltSensor1/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCPCIVoltSensor1/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCPCIVolt1</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllInfo</xsl:with-param>
			</xsl:call-template>

			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCPCIVoltSensor2/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCPCIVoltSensor2/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCPCIVolt2</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllWarning</xsl:with-param>
			</xsl:call-template>
			
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCPCIVoltSensor3/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCPCIVoltSensor3/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCPCIVolt3</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllSevere</xsl:with-param>
			</xsl:call-template>	
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$RemoteAccessController3"/></xsl:attribute>
			</Data>
		</Row> 	
		</xsl:when></xsl:choose>
		
		<xsl:choose><xsl:when test="DRSCPCIAUXVoltSensor1/Capable='true'">
		<Row>
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCPCIAUXVoltSensor1/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCPCIAUXVoltSensor1/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCPCIAUXVolt1</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllInfo</xsl:with-param>
			</xsl:call-template>

			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCPCIAUXVoltSensor2/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCPCIAUXVoltSensor2/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCPCIAUXVolt2</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllWarning</xsl:with-param>
			</xsl:call-template>
			
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCPCIAUXVoltSensor3/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCPCIAUXVoltSensor3/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCPCIAUXVolt3</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllSevere</xsl:with-param>
			</xsl:call-template>	
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$RemoteAccessController4"/></xsl:attribute>
			</Data>
		</Row>
		</xsl:when></xsl:choose>
		
		<xsl:choose><xsl:when test="SystemTempSensor1/Capable='true'">
		<Row>
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="SystemTempSensor1/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="SystemTempSensor1/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableSystemTemp1</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllInfo</xsl:with-param>
			</xsl:call-template>

			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="SystemTempSensor2/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="SystemTempSensor2/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableSystemTemp2</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllWarning</xsl:with-param>
			</xsl:call-template>
			
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="SystemTempSensor3/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="SystemTempSensor3/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableSystemTemp3</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllSevere</xsl:with-param>
			</xsl:call-template>	
			<Data editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$SystemTemperatureSensors"/></xsl:attribute>
			</Data>
		</Row>
		</xsl:when></xsl:choose>
		
		<xsl:choose><xsl:when test="SystemVoltSensor1/Capable='true'">
		<Row>
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="SystemVoltSensor1/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="SystemVoltSensor1/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableSystemVolt1</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllInfo</xsl:with-param>
			</xsl:call-template>

			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="SystemVoltSensor2/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="SystemVoltSensor2/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableSystemVolt2</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllWarning</xsl:with-param>
			</xsl:call-template>
			
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="SystemVoltSensor3/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="SystemVoltSensor3/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableSystemVolt3</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllSevere</xsl:with-param>
			</xsl:call-template>
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$SystemVoltageSensors"/></xsl:attribute>
			</Data>
		</Row>
		</xsl:when></xsl:choose>
		
		<xsl:choose><xsl:when test="SystemFanSensor1/Capable='true'">
		<Row>
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="SystemFanSensor1/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="SystemFanSensor1/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableSystemFan1</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllInfo</xsl:with-param>
			</xsl:call-template>

			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="SystemFanSensor2/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="SystemFanSensor2/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableSystemFan2</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllWarning</xsl:with-param>
			</xsl:call-template>
			
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="SystemFanSensor3/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="SystemFanSensor3/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableSystemFan3</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllSevere</xsl:with-param>
			</xsl:call-template>
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$SystemFanSensors"/></xsl:attribute>
			</Data>
		</Row>
		</xsl:when></xsl:choose>
		
		<xsl:choose><xsl:when test="SystemMiscSensor1/Capable='true'">
		<Row>
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="SystemMiscSensor1/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="SystemMiscSensor1/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableSystemMisc1</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllInfo</xsl:with-param>
			</xsl:call-template>

			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="SystemMiscSensor2/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="SystemMiscSensor2/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableSystemMisc2</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllWarning</xsl:with-param>
			</xsl:call-template>
			
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="SystemMiscSensor3/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="SystemMiscSensor3/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableSystemMisc3</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllSevere</xsl:with-param>
			</xsl:call-template>
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$SystemMiscellaneousSensors"/></xsl:attribute>
			</Data>
		</Row>
		</xsl:when></xsl:choose>
		
		<xsl:choose><xsl:when test="DRSCCommEMCLostSensor/Capable='true'">
		<Row>
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCCommEMCLostSensor/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCCommEMCLostSensor/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCCommEMCLost</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllInfo</xsl:with-param>
			</xsl:call-template>

			<Data value="" type="ustring" editable="false"/>
			<Data value="" type="ustring" editable="false"/>
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$RemoteAccessController5"/></xsl:attribute>
			</Data>
		</Row>
		</xsl:when></xsl:choose>
		
		<xsl:choose><xsl:when test="DRSCCommEMCRestoredSensor/Capable='true'">
		<Row>
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCCommEMCRestoredSensor/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCCommEMCRestoredSensor/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCCommEMCRestored</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllInfo</xsl:with-param>
			</xsl:call-template>

			<Data value="" type="ustring" editable="false"/>
			<Data value="" type="ustring" editable="false"/>
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$RemoteAccessController6"/></xsl:attribute>
			</Data>
		</Row>	
		</xsl:when></xsl:choose>
		
		<xsl:choose><xsl:when test="DRSCAuthenticationFailSensor/Capable='true'">
		<Row>
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCAuthenticationFailSensor/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCAuthenticationFailSensor/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCAuthenticationFail</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllInfo</xsl:with-param>
			</xsl:call-template>

			<Data value="" type="ustring" editable="false"/>
			<Data value="" type="ustring" editable="false"/>
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$RemoteAccessController7"/></xsl:attribute>
			</Data>
		</Row>
		</xsl:when></xsl:choose>
		
		<xsl:choose><xsl:when test="DRSCBatteryChargeLowSensor/Capable='true'">
		<Row>
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCBatteryChargeLowSensor/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCBatteryChargeLowSensor/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCBatteryChargeLow</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllInfo</xsl:with-param>
			</xsl:call-template>
			
			<Data value="" type="ustring" editable="false"/>
			<Data value="" type="ustring" editable="false"/>
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$RemoteAccessController8"/></xsl:attribute>
			</Data>
		</Row>
		</xsl:when></xsl:choose>
		
		<xsl:choose><xsl:when test="SystemDetectedHang/Capable='true'">
		<Row>
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="SystemDetectedHang/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="SystemDetectedHang/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableSystemDetectedHang</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllInfo</xsl:with-param>
			</xsl:call-template>
			<Data value="" type="ustring" editable="false"/>
			<Data value="" type="ustring" editable="false"/>				
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$SystemDetectedHang"/></xsl:attribute>
			</Data>
		</Row>
		</xsl:when></xsl:choose>
		</TableData>

		</xsl:template>

		<xsl:template name="ShowCheckBox">
			<xsl:param name="bCapable"/>
			<xsl:param name="bChecked"/>
			<xsl:param name="ChkCtrlName"/>
			<xsl:param name="bGroupName"/>
				<Data type="checkbox" align="left">
					<xsl:attribute name="event">onClick</xsl:attribute>
					<xsl:attribute name="handler">javascript:document.dataarea.<xsl:value-of select="$bGroupName"/>.checked=false;</xsl:attribute>
					<xsl:attribute name="name"><xsl:value-of select="$ChkCtrlName"/></xsl:attribute>
					<xsl:attribute name="editable">true</xsl:attribute>
					<xsl:choose>
						<xsl:when test="$bCapable='true'">
							<xsl:choose>
							<xsl:when test="$bChecked='true'">
									<xsl:attribute name="state">1</xsl:attribute>
							</xsl:when>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="$bChecked='true'">
									<xsl:attribute name="state">3</xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="state">2</xsl:attribute>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
				</Data>
		</xsl:template>
	</xsl:stylesheet>