<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="OMA/OMAUserRights"/>	
	<xsl:template match="OMA">	
	
		<DataArea ipbox="true" validate="true" backpagetarget="/servlet/DataArea?plugin=com.dell.drsc.webplugins.DRSCConfigureSNMPTraps&amp;help=snmp" onLoad="true">
			<xsl:attribute name="backpagedisplay"><xsl:value-of select="$SNMPTraps"/></xsl:attribute>
			<xsl:choose>
				<xsl:when test="SNMPTrap/TrapsDestIpAddr= ''">
					<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.drsc.webplugins.SetDRSCSNMPTrap&amp;oid=<xsl:value-of select="SNMPTrap/@oid">			</xsl:value-of>&amp;drsFilter=<xsl:value-of select="SNMPTrap/TrapsFilterDrsEvents"/>&amp;AlertFilterSysEvents=<xsl:value-of select="SNMPTrap/TrapsFilterSysEvents"/>&amp;ModeUpdSNMPTrap=ModeAdd
					</xsl:attribute>

				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.drsc.webplugins.SetDRSCSNMPTrap&amp;oid=<xsl:value-of select="SNMPTrap/@oid">			</xsl:value-of>&amp;drsFilter=<xsl:value-of select="SNMPTrap/TrapsFilterDrsEvents"/>&amp;AlertFilterSysEvents=<xsl:value-of select="SNMPTrap/TrapsFilterSysEvents"/>&amp;ModeUpdSNMPTrap=ModeUpdate
					</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<PageTitle>
				<xsl:choose>
					<xsl:when test="SNMPTrap/TrapsDestIpAddr= ''">
						<xsl:attribute name="display"><xsl:value-of select="$AddSNMPTrap"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="display"><xsl:value-of select="$ConfigureSNMPTrap"/></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</PageTitle>
			<CustomButton> 
				<xsl:choose>
					<xsl:when test="SNMPTrap/TrapsDestIpAddr= ''">
					</xsl:when>
					<xsl:otherwise>
						<Data name="Remove" formSubmit="true"><xsl:attribute name="display"><xsl:value-of select="$Remove"/></xsl:attribute>
							<xsl:attribute name="href">javascript:RemoveSNMPTrap()</xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>

			</CustomButton>

			<xsl:apply-templates select="SNMPTrap"/>
			
			<script type="text/javascript" src="/drsc/js/utility.js"/>
			<script language="javascript">
				
				var	resetMsg = <xsl:value-of select="$Thisoperationcaused"/>
				
				function RemoveSNMPTrap()
				{
					alert(resetMsg);
					document.dataarea.action=top.gnv.appendVID('/servlet/SubmitForm?plugin=com.dell.drsc.webplugins.SetDRSCSNMPTrap&amp;oid=<xsl:value-of select="SNMPTrap/@oid">			</xsl:value-of>&amp;drsFilter=<xsl:value-of select="SNMPTrap/TrapsFilterDrsEvents"/>&amp;AlertFilterSysEvents=<xsl:value-of select="SNMPTrap/TrapsFilterSysEvents"/>&amp;ModeUpdSNMPTrap=ModeRemove');
					document.dataarea.submit();
				}


				function chkForEmptyField(strValue)
				{
					if (!strValue)
							return false;
					return true;
				}
				function chkForStrMaxLen (strValue, MaxLen)
				{
					var tempString = new String(strValue);
					if (tempString.length  &gt; MaxLen)
						return -1;
					else
						return 0;
				}

				function initializationRoutine()
				{
			
				}
				
				function selectAllInfoA()
				{
					var value = document.dataarea.selectAllInfo.checked;
					<xsl:choose><xsl:when test="SNMPTrap/DRSCTempSensor1/Capable='true'">if (document.dataarea.EnableDRSCTemp1.disabled == false) document.dataarea.EnableDRSCTemp1.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="SNMPTrap/DRSCVoltSensor1/Capable='true'">if (document.dataarea.EnableDRSCVolt1.disabled == false) document.dataarea.EnableDRSCVolt1.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="SNMPTrap/DRSCBatterSensor1/Capable='true'">if (document.dataarea.EnableDRSCBattery1.disabled == false) document.dataarea.EnableDRSCBattery1.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="SNMPTrap/DRSCPCIVoltSensor1/Capable='true'">if (document.dataarea.EnableDRSCPCIVolt1.disabled == false) document.dataarea.EnableDRSCPCIVolt1.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="SNMPTrap/DRSCPCIAUXVoltSensor1/Capable='true'">if (document.dataarea.EnableDRSCPCIAUXVolt1.disabled == false) document.dataarea.EnableDRSCPCIAUXVolt1.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="SNMPTrap/SystemTempSensor1/Capable='true'">if (document.dataarea.EnableSystemTemp1.disabled == false) document.dataarea.EnableSystemTemp1.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="SNMPTrap/SystemVoltSensor1/Capable='true'">if (document.dataarea.EnableSystemVolt1.disabled == false) document.dataarea.EnableSystemVolt1.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="SNMPTrap/SystemFanSensor1/Capable='true'">if (document.dataarea.EnableSystemFan1.disabled == false) document.dataarea.EnableSystemFan1.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="SNMPTrap/SystemMiscSensor1/Capable='true'">if (document.dataarea.EnableSystemMisc1.disabled == false) document.dataarea.EnableSystemMisc1.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="SNMPTrap/DRSCCommEMCLostSensor/Capable='true'">if (document.dataarea.EnableDRSCCommEMCLost.disabled == false) document.dataarea.EnableDRSCCommEMCLost.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="SNMPTrap/DRSCCommEMCRestoredSensor/Capable='true'">if (document.dataarea.EnableDRSCCommEMCRestored.disabled == false) document.dataarea.EnableDRSCCommEMCRestored.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="SNMPTrap/DRSCAuthenticationFailSensor/Capable='true'">if (document.dataarea.EnableDRSCAuthenticationFail.disabled == false) document.dataarea.EnableSystemDetectedHang.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="SNMPTrap/DRSCBatteryChargeLowSensor/Capable='true'">if (document.dataarea.EnableDRSCBatteryChargeLow.disabled == false) document.dataarea.EnableDRSCBatteryChargeLow.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="SNMPTrap/SystemDetectedHang/Capable='true'">if (document.dataarea.EnableSystemDetectedHang.disabled == false) document.dataarea.EnableSystemDetectedHang.checked = value;</xsl:when></xsl:choose>
				}
	
				function selectAllWarningA()
				{
					var value = document.dataarea.selectAllWarning.checked;
					<xsl:choose><xsl:when test="SNMPTrap/DRSCTempSensor1/Capable='true'">if (document.dataarea.EnableDRSCTemp2.disabled == false) document.dataarea.EnableDRSCTemp2.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="SNMPTrap/DRSCVoltSensor1/Capable='true'">if (document.dataarea.EnableDRSCVolt2.disabled == false) document.dataarea.EnableDRSCVolt2.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="SNMPTrap/DRSCBatterSensor1/Capable='true'">if (document.dataarea.EnableDRSCBattery2.disabled == false) document.dataarea.EnableDRSCBattery2.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="SNMPTrap/DRSCPCIVoltSensor1/Capable='true'">if (document.dataarea.EnableDRSCPCIVolt2.disabled == false) document.dataarea.EnableDRSCPCIVolt2.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="SNMPTrap/DRSCPCIAUXVoltSensor1/Capable='true'">if (document.dataarea.EnableDRSCPCIAUXVolt2.disabled == false) document.dataarea.EnableDRSCPCIAUXVolt2.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="SNMPTrap/SystemTempSensor1/Capable='true'">if (document.dataarea.EnableSystemTemp2.disabled == false) document.dataarea.EnableSystemTemp2.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="SNMPTrap/SystemVoltSensor1/Capable='true'">if (document.dataarea.EnableSystemVolt2.disabled == false) document.dataarea.EnableSystemVolt2.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="SNMPTrap/SystemFanSensor1/Capable='true'">if (document.dataarea.EnableSystemFan2.disabled == false) document.dataarea.EnableSystemFan2.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="SNMPTrap/SystemMiscSensor1/Capable='true'">if (document.dataarea.EnableSystemMisc2.disabled == false) document.dataarea.EnableSystemMisc2.checked = value;</xsl:when></xsl:choose>
				}
				
				function selectAllSevereA()
				{
					var value = document.dataarea.selectAllSevere.checked;
					<xsl:choose><xsl:when test="SNMPTrap/DRSCTempSensor1/Capable='true'">if (document.dataarea.EnableDRSCTemp3.disabled == false) document.dataarea.EnableDRSCTemp3.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="SNMPTrap/DRSCVoltSensor1/Capable='true'">if (document.dataarea.EnableDRSCVolt3.disabled == false) document.dataarea.EnableDRSCVolt3.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="SNMPTrap/DRSCBatterSensor1/Capable='true'">if (document.dataarea.EnableDRSCBattery3.disabled == false) document.dataarea.EnableDRSCBattery3.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="SNMPTrap/DRSCPCIVoltSensor1/Capable='true'">if (document.dataarea.EnableDRSCPCIVolt3.disabled == false) document.dataarea.EnableDRSCPCIVolt3.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="SNMPTrap/DRSCPCIAUXVoltSensor1/Capable='true'">if (document.dataarea.EnableDRSCPCIAUXVolt3.disabled == false) document.dataarea.EnableDRSCPCIAUXVolt3.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="SNMPTrap/SystemTempSensor1/Capable='true'">if (document.dataarea.EnableSystemTemp3.disabled == false) document.dataarea.EnableSystemTemp3.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="SNMPTrap/SystemVoltSensor1/Capable='true'">if (document.dataarea.EnableSystemVolt3.disabled == false) document.dataarea.EnableSystemVolt3.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="SNMPTrap/SystemFanSensor1/Capable='true'">if (document.dataarea.EnableSystemFan3.disabled == false) document.dataarea.EnableSystemFan3.checked = value;</xsl:when></xsl:choose>
					<xsl:choose><xsl:when test="SNMPTrap/SystemMiscSensor1/Capable='true'">if (document.dataarea.EnableSystemMisc3.disabled == false) document.dataarea.EnableSystemMisc3.checked = value;</xsl:when></xsl:choose>
				}
				
				function chkIPAddress(objName, Octet1MaxVal,Octet4MinVal,Octet4MaxVal)
				{
					var octet1 = eval("document.dataarea." + objName + "1");
					var octet2 = eval("document.dataarea." + objName + "2");
					var octet3 = eval("document.dataarea." + objName + "3");
					var octet4 = eval("document.dataarea." + objName + "4");
					
					if (octet1.disabled == true) return true
					else
					{
						if (octet1.value == null || octet1.value == "" || octet1.value.indexOf(".") &gt;= 0) return false;
						else if (isNaN(octet1.value)) return false;
						else octet1 = parseInt(octet1.value);

						if (octet2.value == null || octet2.value == "" || octet2.value.indexOf(".") &gt;= 0) return false;
						else if (isNaN(octet2.value)) return false;
						else octet2 = parseInt(octet2.value);

						if (octet3.value == null || octet3.value == "" || octet3.value.indexOf(".") &gt;= 0) return false;
						else if (isNaN(octet3.value)) return false;
						else octet3 = parseInt(octet3.value);

						if (octet4.value == null || octet4.value == "" || octet4.value.indexOf(".") &gt;= 0) return false;
						else if (isNaN(octet4.value)) return false;
						else octet4 = parseInt(octet4.value);

						if (octet1 &lt; 1  || octet1 &gt; Octet1MaxVal) return false;
						else if (octet2 &lt; 0  || octet2 &gt; 255) return false;
						else if (octet3 &lt; 0  || octet3 &gt; 255) return false;
						else if (octet4 &lt; Octet4MinVal   || octet4 &gt; Octet4MaxVal) return false;
						else return true;
					}
				}

				function validate()
				{

					var invalidIP = false;
					var errorMsg = "";

					if ((document.dataarea.TrapsCommunity.value == null) || (trim(document.dataarea.TrapsCommunity.value) == ""))
					{
						errorMsg += "<xsl:value-of select="$Communitynamecant"/>";
					 	invalidIP = true;
					}
					if (chkForStrMaxLen(document.dataarea.TrapsCommunity.value , 31) == -1)
					{
						errorMsg += "<xsl:value-of select="$Communitynamecant1"/>";
					 	invalidIP = true;
					}
					if (!testUnicode(document.dataarea.TrapsCommunity.value))
					{
						if (errorMsg != "") errorMsg += "\n";
						errorMsg += "<xsl:value-of select="$Communitynamecontains"/>";
						invalidIP = true;
					}
					
									
					
					if (chkIPAddress("TrapsIPAddressBox", 254, 1, 254) == false)
					{
					 	if (errorMsg != "") errorMsg += "\n";
						errorMsg += <xsl:value-of select="$InvalidIPAddress"/>
					 	invalidIP = true;
					}

					if (invalidIP == true)
					{
						alert(errorMsg)
						return false;
					}
					else
					{
						alert(resetMsg);
						trimIPAddress("TrapsIPAddressBox" , 4);
						return true;
					}
					return false;
				}
				
				function trimIPAddress(ipboxname , length){
					for (i =1 ; i &lt;= length ; i++) {
						var ipbox = ipboxname + i;
						try
						{
							var ipboxval = document.getElementById(ipbox).value;
							document.getElementById(ipbox).value = trim(ipboxval);
						}
						catch(e){};
					}
				}
				
				function ltrim ( s ) 
				{ 
					return s.replace( /^\s*/, "" )
				} 
		
				function rtrim ( s ) 
				{ 
					return s.replace( /\s*$/, "" ); 
				} 
		
				//Combine the rtrim() and ltrim() functions to make the trim() function, which just wraps both calls together: 
		
				function trim ( s ) 
				{ 
					return rtrim(ltrim(s)); 
				}

		</script>		
	</DataArea>
		</xsl:template>
		<xsl:template match="SNMPTrap">	
		<TableData columnspacing="true" name="TableGeneralConfig"><xsl:attribute name="display"><xsl:value-of select="$General"/></xsl:attribute>
			<SubHeader value="General"><xsl:attribute name="display"><xsl:value-of select="$General1"/></xsl:attribute></SubHeader>
			<Header>
					<Data name="Property" value="Property" editable="false" ignoreonweb="true" type="usting"><xsl:attribute name="display"><xsl:value-of select="$Property"/></xsl:attribute></Data>
					<Data name="Value" value="Value" editable="false" ignoreonweb="true" type="usting"><xsl:attribute name="display"><xsl:value-of select="$Value"/></xsl:attribute></Data>
				</Header>
				<Row>
				<Data value="Index" type="ustring" editable="false" ignoreonweb="true"/>
				<Data name="Index" type="editbox" editable="true" ignoreonweb="true">
				<xsl:attribute name="value"><xsl:value-of select="number(TrapsIndex) - 1"/></xsl:attribute>
				</Data>
			</Row>
			<xsl:choose>
			<xsl:when test="TrapsDestIpAddr=''">
				<Row>
					<Data type="ustring" editable="false" width="150">
						<xsl:attribute name="value"><xsl:value-of select="$EnableSNMPTrap"/></xsl:attribute>
					</Data>
					<Data name="enableSNMPTraps" type="checkbox" editable="true" align="left">
						<xsl:if test="TrapsEnable='true'">
							<xsl:attribute name="state">1</xsl:attribute>
						</xsl:if>
					</Data>
				</Row> 
				<Row>
					<Data type="ustring" editable="false" width="150">
						<xsl:attribute name="value"><xsl:value-of select="$Community"/></xsl:attribute>
					</Data>
					<Data name="TrapsCommunity" type="editbox" editable="true">
						<xsl:attribute name="value"><xsl:value-of select="TrapsSnmpCommunity"/></xsl:attribute>
					</Data>
				</Row>
				<Row>
					<xsl:call-template name="ShowIPAddrBox">
						<xsl:with-param name="Address"><xsl:value-of select="TrapsDestIpAddr"/></xsl:with-param>
						<xsl:with-param name="DisplayStr"><xsl:value-of select="$IPAddress"/></xsl:with-param>
						<xsl:with-param name="IPCtrlName">TrapsIPAddressBox</xsl:with-param>
					</xsl:call-template>
				</Row>
			</xsl:when>
			<xsl:otherwise>
				<Row>
					<Data type="ustring" editable="false" width="150">
						<xsl:attribute name="value"><xsl:value-of select="$IPAddress1"/></xsl:attribute>
					</Data>
					<Data type="ustring" editable="false">
						<xsl:attribute name="value"><xsl:value-of select="TrapsDestIpAddr"/></xsl:attribute>
					</Data>
					<xsl:call-template name="HiddenIPAddrress">
						<xsl:with-param name="Address"><xsl:value-of select="TrapsDestIpAddr"/></xsl:with-param>
					</xsl:call-template>
				</Row>
				<Row>
					<Data type="ustring" editable="false" width="150">
						<xsl:attribute name="value"><xsl:value-of select="$EnableSNMPTrap1"/></xsl:attribute>
					</Data>
					<Data name="enableSNMPTraps" type="checkbox" editable="true" align="left">
						<xsl:if test="TrapsEnable='true'">
							<xsl:attribute name="state">1</xsl:attribute>
						</xsl:if>
					</Data>
					<Data ignoreoncli="true"/><Data ignoreoncli="true"/><Data ignoreoncli="true"/><Data ignoreoncli="true"/>
				</Row> 
				<Row>
					<Data type="ustring" editable="false" width="150">
						<xsl:attribute name="value"><xsl:value-of select="$Community1"/></xsl:attribute>
					</Data>
					<Data name="TrapsCommunity" type="editbox" editable="true">
						<xsl:attribute name="value"><xsl:value-of select="TrapsSnmpCommunity"/></xsl:attribute>
					</Data>
					<Data ignoreoncli="true"/><Data ignoreoncli="true"/><Data ignoreoncli="true"/><Data ignoreoncli="true"/>
				</Row>
			</xsl:otherwise>
			</xsl:choose>
		</TableData>

		<TableData columnspacing="true" name="TableTrapConf"><xsl:attribute name="display"><xsl:value-of select="$SeverityConfiguration"/></xsl:attribute>
			<SubHeader value="SeverityConfiguration"><xsl:attribute name="display"><xsl:value-of select="$SeverityConfiguration1"/></xsl:attribute></SubHeader>
			<Header>
				<Data editable="false" type="usting"><xsl:attribute name="display"><xsl:value-of select="$Informational"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$Informational1"/></xsl:attribute>
				</Data>
				<Data editable="false" type="usting"><xsl:attribute name="display"><xsl:value-of select="$Warning"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$Warning1"/></xsl:attribute>
				</Data>
				<Data editable="false" type="usting"><xsl:attribute name="display"><xsl:value-of select="$Severe"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$Severe1"/></xsl:attribute>
				</Data>
				<Data editable="false" type="usting"><xsl:attribute name="display"><xsl:value-of select="$TrapDescription"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$TrapDescription1"/></xsl:attribute>
				</Data>
			</Header>

			<Row>			
				<Data name="selectAllInfo" type="checkbox" editable="true" align="left" event="onClick" handler="javascript:selectAllInfoA()"/>
				<Data name="selectAllWarning" type="checkbox" editable="true" align="left" event="onClick" handler="javascript:selectAllWarningA()"/>
				<Data name="selectAllSevere" type="checkbox" editable="true" align="left" event="onClick" handler="javascript:selectAllSevereA()"/>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$SelectAll"/></xsl:attribute>
				</Data>
			</Row> 

		<xsl:choose><xsl:when test="DRSCTempSensor1/Capable='true'">
		<Row>			
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCTempSensor1/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCTempSensor1/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCTemp1</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllInfo</xsl:with-param>
			</xsl:call-template>
	
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCTempSensor2/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCTempSensor2/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCTemp2</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllWarning</xsl:with-param>
			</xsl:call-template>
				
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCTempSensor3/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCTempSensor3/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCTemp3</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllSevere</xsl:with-param>
			</xsl:call-template>
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$RemoteAccessController"/></xsl:attribute>
			</Data>
		</Row>
		</xsl:when></xsl:choose>
			
		<xsl:choose><xsl:when test="DRSCVoltSensor1/Capable='true'">
		<Row>
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCVoltSensor1/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCVoltSensor1/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCVolt1</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllInfo</xsl:with-param>
			</xsl:call-template>

			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCVoltSensor2/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCVoltSensor2/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCVolt2</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllWarning</xsl:with-param>
			</xsl:call-template>
			
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCVoltSensor3/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCVoltSensor3/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCVolt3</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllSevere</xsl:with-param>
			</xsl:call-template>
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$RemoteAccessController1"/></xsl:attribute>
			</Data>
		</Row>
		</xsl:when></xsl:choose> 	
		
		<xsl:choose><xsl:when test="DRSCBatterSensor1/Capable='true'">
		<Row>
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCBatterSensor1/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCBatterSensor1/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCBattery1</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllInfo</xsl:with-param>
			</xsl:call-template>

			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCBatterSensor2/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCBatterSensor2/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCBattery2</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllWarning</xsl:with-param>
			</xsl:call-template>
			
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCBatterSensor3/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCBatterSensor3/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCBattery3</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllSevere</xsl:with-param>
			</xsl:call-template>	
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$RemoteAccessController2"/></xsl:attribute>
			</Data>
		</Row> 	
		</xsl:when></xsl:choose>
		
		<xsl:choose><xsl:when test="DRSCPCIVoltSensor1/Capable='true'">
		<Row>
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCPCIVoltSensor1/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCPCIVoltSensor1/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCPCIVolt1</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllInfo</xsl:with-param>
			</xsl:call-template>

			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCPCIVoltSensor2/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCPCIVoltSensor2/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCPCIVolt2</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllWarning</xsl:with-param>
			</xsl:call-template>
			
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCPCIVoltSensor3/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCPCIVoltSensor3/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCPCIVolt3</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllSevere</xsl:with-param>
			</xsl:call-template>	
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$RemoteAccessController3"/></xsl:attribute>
			</Data>
		</Row> 	
		</xsl:when></xsl:choose>
		
		<xsl:choose><xsl:when test="DRSCPCIAUXVoltSensor1/Capable='true'">
		<Row>
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCPCIAUXVoltSensor1/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCPCIAUXVoltSensor1/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCPCIAUXVolt1</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllInfo</xsl:with-param>
			</xsl:call-template>

			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCPCIAUXVoltSensor2/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCPCIAUXVoltSensor2/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCPCIAUXVolt2</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllWarning</xsl:with-param>
			</xsl:call-template>
			
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCPCIAUXVoltSensor3/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCPCIAUXVoltSensor3/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCPCIAUXVolt3</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllSevere</xsl:with-param>
			</xsl:call-template>	
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$RemoteAccessController4"/></xsl:attribute>
			</Data>
		</Row>
		</xsl:when></xsl:choose>
		
		<xsl:choose><xsl:when test="SystemTempSensor1/Capable='true'">
		<Row>
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="SystemTempSensor1/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="SystemTempSensor1/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableSystemTemp1</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllInfo</xsl:with-param>
			</xsl:call-template>

			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="SystemTempSensor2/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="SystemTempSensor2/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableSystemTemp2</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllWarning</xsl:with-param>
			</xsl:call-template>
			
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="SystemTempSensor3/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="SystemTempSensor3/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableSystemTemp3</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllSevere</xsl:with-param>
			</xsl:call-template>	
			<Data editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$SystemTemperatureSensors"/></xsl:attribute>
			</Data>
		</Row>
		</xsl:when></xsl:choose>
		
		<xsl:choose><xsl:when test="SystemVoltSensor1/Capable='true'">
		<Row>
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="SystemVoltSensor1/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="SystemVoltSensor1/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableSystemVolt1</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllInfo</xsl:with-param>
			</xsl:call-template>

			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="SystemVoltSensor2/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="SystemVoltSensor2/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableSystemVolt2</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllWarning</xsl:with-param>
			</xsl:call-template>
			
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="SystemVoltSensor3/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="SystemVoltSensor3/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableSystemVolt3</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllSevere</xsl:with-param>
			</xsl:call-template>
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$SystemVoltageSensors"/></xsl:attribute>
			</Data>
		</Row>
		</xsl:when></xsl:choose>
		
		<xsl:choose><xsl:when test="SystemFanSensor1/Capable='true'">
		<Row>
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="SystemFanSensor1/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="SystemFanSensor1/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableSystemFan1</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllInfo</xsl:with-param>
			</xsl:call-template>

			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="SystemFanSensor2/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="SystemFanSensor2/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableSystemFan2</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllWarning</xsl:with-param>
			</xsl:call-template>
			
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="SystemFanSensor3/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="SystemFanSensor3/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableSystemFan3</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllSevere</xsl:with-param>
			</xsl:call-template>
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$SystemFanSensors"/></xsl:attribute>
			</Data>
		</Row>
		</xsl:when></xsl:choose>
		
		<xsl:choose><xsl:when test="SystemMiscSensor1/Capable='true'">
		<Row>
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="SystemMiscSensor1/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="SystemMiscSensor1/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableSystemMisc1</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllInfo</xsl:with-param>
			</xsl:call-template>

			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="SystemMiscSensor2/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="SystemMiscSensor2/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableSystemMisc2</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllWarning</xsl:with-param>
			</xsl:call-template>
			
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="SystemMiscSensor3/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="SystemMiscSensor3/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableSystemMisc3</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllSevere</xsl:with-param>
			</xsl:call-template>
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$SystemMiscellaneousSensors"/></xsl:attribute>
			</Data>
		</Row>
		</xsl:when></xsl:choose>
		
		<xsl:choose><xsl:when test="DRSCCommEMCLostSensor/Capable='true'">
		<Row>
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCCommEMCLostSensor/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCCommEMCLostSensor/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCCommEMCLost</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllInfo</xsl:with-param>
			</xsl:call-template>

			<Data value="" type="ustring" editable="false"/>
			<Data value="" type="ustring" editable="false"/>
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$RemoteAccessController5"/></xsl:attribute>
			</Data>
		</Row>
		</xsl:when></xsl:choose>
		
		<xsl:choose><xsl:when test="DRSCCommEMCRestoredSensor/Capable='true'">
		<Row>
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCCommEMCRestoredSensor/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCCommEMCRestoredSensor/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCCommEMCRestored</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllInfo</xsl:with-param>
			</xsl:call-template>

			<Data value="" type="ustring" editable="false"/>
			<Data value="" type="ustring" editable="false"/>
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$RemoteAccessController6"/></xsl:attribute>
			</Data>
		</Row>	
		</xsl:when></xsl:choose>
		
		<xsl:choose><xsl:when test="DRSCAuthenticationFailSensor/Capable='true'">
		<Row>
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCAuthenticationFailSensor/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCAuthenticationFailSensor/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCAuthenticationFail</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllInfo</xsl:with-param>
			</xsl:call-template>

			<Data value="" type="ustring" editable="false"/>
			<Data value="" type="ustring" editable="false"/>
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$RemoteAccessController7"/></xsl:attribute>
			</Data>
		</Row>
		</xsl:when></xsl:choose>
		
		<xsl:choose><xsl:when test="DRSCBatteryChargeLowSensor/Capable='true'">
		<Row>
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="DRSCBatteryChargeLowSensor/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="DRSCBatteryChargeLowSensor/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableDRSCBatteryChargeLow</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllInfo</xsl:with-param>
			</xsl:call-template>
			
			<Data value="" type="ustring" editable="false"/>
			<Data value="" type="ustring" editable="false"/>
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$RemoteAccessController8"/></xsl:attribute>
			</Data>
		</Row>
		</xsl:when></xsl:choose>
		
		<xsl:choose><xsl:when test="SystemDetectedHang/Capable='true'">
		<Row>
			<xsl:call-template name="ShowCheckBox">
				<xsl:with-param name="bCapable"><xsl:value-of select="SystemDetectedHang/Capable"/></xsl:with-param>
				<xsl:with-param name="bChecked"><xsl:value-of select="SystemDetectedHang/Checked"/></xsl:with-param>
				<xsl:with-param name="ChkCtrlName">EnableSystemDetectedHang</xsl:with-param>
				<xsl:with-param name="bGroupName">selectAllInfo</xsl:with-param>
			</xsl:call-template>
			<Data value="" type="ustring" editable="false"/>
			<Data value="" type="ustring" editable="false"/>				
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$SystemDetectedHang"/></xsl:attribute>
			</Data>
		</Row>
		</xsl:when></xsl:choose>
		</TableData>
		</xsl:template>

		<xsl:template name="ShowCheckBox">
			<xsl:param name="bCapable"/>
			<xsl:param name="bChecked"/>
			<xsl:param name="ChkCtrlName"/>
			<xsl:param name="bGroupName"/>
				<Data type="checkbox" align="left">
					<xsl:attribute name="event">onClick</xsl:attribute>
					<xsl:attribute name="handler">javascript:document.dataarea.<xsl:value-of select="$bGroupName"/>.checked=false;</xsl:attribute>
					<xsl:attribute name="name"><xsl:value-of select="$ChkCtrlName"/></xsl:attribute>
					<xsl:attribute name="editable">true</xsl:attribute>
					<xsl:choose>
						<xsl:when test="$bCapable='true'">
							<xsl:choose>
							<xsl:when test="$bChecked='true'">
									<xsl:attribute name="state">1</xsl:attribute>
							</xsl:when>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="$bChecked='true'">
									<xsl:attribute name="state">3</xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="state">2</xsl:attribute>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
				</Data>
		</xsl:template>
	
	<xsl:template name="ShowIPAddrBox">
		<xsl:param name="Address"/>
		<xsl:param name="DisplayStr"/>
		<xsl:param name="IPCtrlName"/>

		<Data type="ustring" editable="false">
			<xsl:attribute name="value"><xsl:value-of select="$DisplayStr"/></xsl:attribute>
		</Data>
		<Data type="ipaddrbox" autocursoroff="false">
			<xsl:attribute name="name"><xsl:value-of select="$IPCtrlName"/></xsl:attribute>
			<xsl:attribute name="sep">.</xsl:attribute>
			
			<xsl:variable name="var1"><xsl:value-of select="substring-before($Address,'.')"/></xsl:variable>
			<xsl:variable name="holdString1"><xsl:value-of select="substring-after($Address,'.')"/></xsl:variable>
			<xsl:variable name="var2"><xsl:value-of select="substring-before($holdString1,'.')"/></xsl:variable>
			<xsl:variable name="holdString2"><xsl:value-of select="substring-after($holdString1,'.')"/></xsl:variable>
			<xsl:variable name="var3"><xsl:value-of select="substring-before($holdString2,'.')"/></xsl:variable>
			<xsl:variable name="holdString3"><xsl:value-of select="substring-after($holdString2,'.')"/></xsl:variable>
			<xsl:variable name="var4"><xsl:value-of select="$holdString3"/></xsl:variable>
			
			<xsl:attribute name="value1"><xsl:value-of select="$var1"/></xsl:attribute>
			<xsl:attribute name="value2"><xsl:value-of select="$var2"/></xsl:attribute>
			<xsl:attribute name="value3"><xsl:value-of select="$var3"/></xsl:attribute>
			<xsl:attribute name="value4"><xsl:value-of select="$var4"/></xsl:attribute>
		</Data>
	</xsl:template>
	
	<xsl:template name="HiddenIPAddrress">
		<xsl:param name="Address"/>
			
		<xsl:variable name="var1"><xsl:value-of select="substring-before($Address,'.')"/></xsl:variable>
		<xsl:variable name="holdString1"><xsl:value-of select="substring-after($Address,'.')"/></xsl:variable>
		<xsl:variable name="var2"><xsl:value-of select="substring-before($holdString1,'.')"/></xsl:variable>
		<xsl:variable name="holdString2"><xsl:value-of select="substring-after($holdString1,'.')"/></xsl:variable>
		<xsl:variable name="var3"><xsl:value-of select="substring-before($holdString2,'.')"/></xsl:variable>
		<xsl:variable name="holdString3"><xsl:value-of select="substring-after($holdString2,'.')"/></xsl:variable>
		<xsl:variable name="var4"><xsl:value-of select="$holdString3"/></xsl:variable>

		<Data ignoreoncli="true" name="TrapsIPAddressBox1" type="hidden" editable="false">
			<xsl:attribute name="returnvalue"><xsl:value-of select="$var1"/></xsl:attribute>
		</Data>
		<Data ignoreoncli="true" name="TrapsIPAddressBox2" type="hidden" editable="false">
			<xsl:attribute name="returnvalue"><xsl:value-of select="$var2"/></xsl:attribute>
		</Data>
		<Data ignoreoncli="true" name="TrapsIPAddressBox3" type="hidden" editable="false">
			<xsl:attribute name="returnvalue"><xsl:value-of select="$var3"/></xsl:attribute>
		</Data>
		<Data ignoreoncli="true" name="TrapsIPAddressBox4" type="hidden" editable="false">
			<xsl:attribute name="returnvalue"><xsl:value-of select="$var4"/></xsl:attribute>
		</Data>
	</xsl:template>

	</xsl:stylesheet>