<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="OMA/OMAUserRights"/>	
	
	<xsl:template match="OMA">	
	<xsl:variable name="usrights"><xsl:value-of select="OMAUserRights"/></xsl:variable>
		<DataArea onLoad="true">
			<PageTitle><xsl:attribute name="display"><xsl:value-of select="$ConfigureSNMPTraps"/></xsl:attribute></PageTitle>
			<HTMLData><iframe id="traptest" name="traptest" style="visibility: hidden; height: 1px; width: 1px; top: 0px; left: 0px; position: absolute; z-index: -1" src="/oma/blank.html"/></HTMLData>
				<xsl:if test="$usrights='7'">
					<PromptText><xsl:value-of select="$ClickonIP"/></PromptText>
				</xsl:if>
			<CustomButton>
				<xsl:choose>
					<xsl:when test="SNMPTrapList/NumValidEntries='16'">
					</xsl:when>
					<xsl:otherwise>
					<xsl:if test="$usrights='7'">
						<Data name="Add"><xsl:attribute name="display"><xsl:value-of select="$Add"/></xsl:attribute>
							<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.drsc.webplugins.DRSCGetSNMPTrap&amp;oid=<xsl:value-of select="SNMPTrapList/NextAvailableSNMPTrap/@oid"/>&amp;help=adcntrap&amp;app=drsc</xsl:attribute>
						</Data>
						</xsl:if>
					
					</xsl:otherwise>
				</xsl:choose>
				<Data name=""><xsl:attribute name="display"><xsl:value-of select="$Refresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.drsc.webplugins.DRSCConfigureSNMPTraps</xsl:attribute>
				</Data>
	
			</CustomButton>
			<script language="javascript">
				var usrights = '<xsl:value-of select="/OMA/OMAUserRights"/>'
				function initializationRoutine()
				{
				}
				function UpdateSNMPEnableState(oidValue, CtrlName)
				{
					var temp = document.getElementById(CtrlName);
					if (temp.checked)
					{
						document.dataarea.action='/servlet/SubmitForm?plugin=com.dell.drsc.webplugins.SetDRSCSNMPTrapEnable&amp;oid=' + oidValue + '&amp;EnableTrap=true';
					}
					else
					{
						document.dataarea.action='/servlet/SubmitForm?plugin=com.dell.drsc.webplugins.SetDRSCSNMPTrapEnable&amp;oid=' + oidValue + '&amp;EnableTrap=false';

					}
					document.dataarea.submit();
				}
				function testTrap(oidValue)
				{
					document.getElementById("traptest").src = "/servlet/DataArea?plugin=com.dell.drsc.webplugins.TestDRSCSMNPTrap&amp;oid=" + oidValue;
				}

			</script> 
			<xsl:apply-templates select="SNMPTrapList"/>
		</DataArea>
	</xsl:template>
	
	<xsl:template match="SNMPTrapList">
		<TableData columnspacing="true" name="tableConfiguredTraps"><xsl:attribute name="display"><xsl:value-of select="$Traps"/></xsl:attribute>
			<SubHeader><xsl:attribute name="display"><xsl:value-of select="$ListofConfigured"/></xsl:attribute></SubHeader>
			<Header>
				<Data ignoreonweb="true">
					<xsl:attribute name="display"><xsl:value-of select="$Index"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$Index1"/></xsl:attribute>
				</Data>
				<Data ignoreoncli="true" name="Enabled" editable="false" type="usting"><xsl:attribute name="display"><xsl:value-of select="$Enabled"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$Enabled1"/></xsl:attribute>
				</Data>
				<Data name="DestinationIPAddress" editable="false" type="usting"><xsl:attribute name="display"><xsl:value-of select="$DestinationIPAddress"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$DestinationIPAddress1"/></xsl:attribute>
				</Data>
				<Data ignoreoncli="true" name="CommunityName" editable="false" type="usting"><xsl:attribute name="display"><xsl:value-of select="$Community"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$Community1"/></xsl:attribute>
				</Data>
				<Data ignoreoncli="true" align="center" name="Test" editable="false" type="usting"><xsl:attribute name="display"><xsl:value-of select="$Test"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$Test1"/></xsl:attribute>
				</Data>
			</Header>
			<xsl:apply-templates select="SNMPTrap">
			</xsl:apply-templates>
		</TableData>
	</xsl:template>
	
	<xsl:template match="SNMPTrap">
	<xsl:variable name="usrights"><xsl:value-of select="/OMA/OMAUserRights"/></xsl:variable>
			<Row>
				<xsl:element name="Data">
					<xsl:attribute name="ignoreonweb">true</xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="@index"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="@index"/></xsl:attribute>
				</xsl:element>
				<Data ignoreoncli="true">
					<xsl:choose>
						<xsl:when test="TrapsEnable='true'">
							<xsl:attribute name="value"><xsl:value-of select="$Yes"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="value"><xsl:value-of select="$No"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</Data>				
				<Data>
					<xsl:choose>
						<xsl:when test="$usrights='7'">
							<xsl:attribute name="link">true</xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="link">false</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>

					<xsl:attribute name="value"><xsl:value-of select="TrapsDestIpAddr"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.drsc.webplugins.DRSCGetSNMPTrap&amp;oid=<xsl:value-of select="@oid"/>&amp;help=adcntrap&amp;app=drsc</xsl:attribute>
				</Data>
				<Data ignoreoncli="true">
					<xsl:attribute name="value"><xsl:value-of select="TrapsSnmpCommunity"/></xsl:attribute>
				</Data>
				<Data ignoreoncli="true" link="true" type="icon" value="/oma/images/unknown.gif" align="center">
					<xsl:attribute name="href">javascript:testTrap('<xsl:value-of select="@oid"/>');</xsl:attribute>
					<xsl:attribute name="alt"><xsl:value-of select="$Test2"/><xsl:text> </xsl:text><xsl:value-of select="TrapsDestIpAddr"/></xsl:attribute>
					<xsl:attribute name="name">img_<xsl:value-of select="@oid"/></xsl:attribute>
				</Data>
			</Row>
	</xsl:template>

</xsl:stylesheet>