<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="OMA/OMAUserRights"/>
	<xsl:template match="OMA">
	<xsl:variable name="usrights"><xsl:value-of select="OMAUserRights"/></xsl:variable>
		<DataArea validate="true" onLoad="true" ipbox="true">
			<xsl:if test="$usrights='7'">
					<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.drsc.webplugins.SetDRSCNetwork</xsl:attribute>
			</xsl:if>
			<PageTitle><xsl:attribute name="display"><xsl:value-of select="$ConfigureNetworkProperties"/></xsl:attribute></PageTitle>
			<CustomButton>
				<Data name=""><xsl:attribute name="display"><xsl:value-of select="$Refresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.drsc.webplugins.DRSCNetwrk</xsl:attribute>
				</Data>
			</CustomButton>
			<TableData columnspacing="true" name="tabNICConfiguration"><xsl:attribute name="display"><xsl:value-of select="$NIC"/></xsl:attribute>
				<SubHeader value="NIC">
					<xsl:attribute name="display"><xsl:value-of select="$NIC1"/></xsl:attribute>
				</SubHeader>
				<Header>
					<Data name="Property" value="Property" editable="false" ignoreonweb="true" type="usting"><xsl:attribute name="display"><xsl:value-of select="$Property"/></xsl:attribute></Data>
					<Data name="Value" value="Value" editable="false" ignoreonweb="true" type="usting"><xsl:attribute name="display"><xsl:value-of select="$Value"/></xsl:attribute></Data>
				</Header>
				<xsl:apply-templates select="LanNetworkingObj"/>
	            <xsl:apply-templates select="CurrentLanNetworkingObj"/>
			</TableData>
			
			<xsl:choose><xsl:when test="DialUpNetworkingObj/DialupCapabilities != 0">
			<TableData columnspacing="true" name="tabDialInConfiguration"><xsl:attribute name="display"><xsl:value-of select="$ConfigurationOptions"/></xsl:attribute>
				<SubHeader value="Dial-In Users"><xsl:attribute name="display"><xsl:value-of select="$DialInConfigurationOptions"/></xsl:attribute></SubHeader>
				<Header>
					<Data name="Property" value="Property" editable="false" ignoreonweb="true" type="usting"><xsl:attribute name="display"><xsl:value-of select="$Property1"/></xsl:attribute></Data>
					<Data name="Value" value="Value" editable="false" ignoreonweb="true" type="usting"><xsl:attribute name="display"><xsl:value-of select="$Value1"/></xsl:attribute></Data>
				</Header>
				<xsl:apply-templates select="DialUpNetworkingObj"/>
			</TableData>
			</xsl:when></xsl:choose>
			
			<TableData columnspacing="true" name="tabSMTPConfiguration"><xsl:attribute name="display"><xsl:value-of select="$SMTP"/></xsl:attribute>
				<SubHeader value="SMTP"><xsl:attribute name="display"><xsl:value-of select="$SMTP1"/></xsl:attribute></SubHeader>
				<Header>
					<Data name="Property" value="Property" editable="false" ignoreonweb="true" type="usting"><xsl:attribute name="display"><xsl:value-of select="$Property2"/></xsl:attribute></Data>
					<Data name="Value" value="Value" editable="false" ignoreonweb="true" type="usting"><xsl:attribute name="display"><xsl:value-of select="$Value2"/></xsl:attribute></Data>
				</Header>
				<xsl:apply-templates select="RemoteHostObj"/>
			</TableData>
			<script language="javascript">
			var usrights = '<xsl:value-of select="/OMA/OMAUserRights"/>'

				function initializationRoutine()
				{
					EnableNicSettings();
					<xsl:choose><xsl:when test="DialUpNetworkingObj/DialupCapabilities != 0">EnableDialInSettings();</xsl:when></xsl:choose>
					EnableSMTPSettings();
					EnableSettingsAccordingtoUserRights();
				}
				
				function EnableSettingsAccordingtoUserRights()
				{
					if (usrights != 7 )
					{
						document.dataarea.EnableNIC.disabled =true;
						document.dataarea.EnableDHCPNIC.disabled =true;						
						document.dataarea.IPAddressBox.disabled =true; 
						<!--document.dataarea.IPAddressBox2.disabled =true; 
						document.dataarea.IPAddressBox3.disabled =true; 
						document.dataarea.IPAddressBox4.disabled =true;-->
						document.dataarea.SubnetAddrBox.disabled =true;
						<!--document.dataarea.SubnetAddrBox2.disabled =true; 
						document.dataarea.SubnetAddrBox3.disabled =true; 
						document.dataarea.SubnetAddrBox4.disabled =true;-->
						document.dataarea.GatewayAddrBox.disabled =true; 
						<!--document.dataarea.GatewayAddrBox2.disabled =true; 
						document.dataarea.GatewayAddrBox3.disabled =true; 
						document.dataarea.GatewayAddrBox4.disabled =true;-->

						<xsl:choose><xsl:when test="DialUpNetworkingObj/DialupCapabilities != 0">
							document.dataarea.EnableDialIn.disabled=true;							
							document.dataarea.EnableDHCPDialIn.disabled=true;
							document.dataarea.BaseIPAddrBox.disabled =true; 
							<!--document.dataarea.BaseIPAddrBox2.disabled =true; 
							document.dataarea.BaseIPAddrBox3.disabled =true; 
							document.dataarea.BaseIPAddrBox4.disabled =true;-->
							document.dataarea.DialInAuthentication.disabled=true;
						</xsl:when></xsl:choose>
						
						document.dataarea.EnableSMTP.disabled=true; 
						document.dataarea.SMTPAddrBox.disabled =true; 
						<!--document.dataarea.SMTPAddrBox2.disabled =true; 
						document.dataarea.SMTPAddrBox3.disabled =true; 
						document.dataarea.SMTPAddrBox4.disabled =true;-->
					}
				}

				function validate()
				{
					var invalidIP = false;
					var errorFound = false;
					var errorMsg = "";
				
					var tmpIPAddressBox = document.getElementById("IPAddressBox").value;
					//alert(document.getElementById("IPAddressBox").value);
					document.getElementById("IPAddressBox").value = trim(tmpIPAddressBox);
					var IPAddressBox = document.getElementById("IPAddressBox").value;
					
					var tmpSubnetAddrBox = document.getElementById("SubnetAddrBox").value;
					//alert(document.getElementById("SubnetAddrBox").value);
					document.getElementById("SubnetAddrBox").value = trim(tmpSubnetAddrBox);
					var SubnetAddrBox = document.getElementById("SubnetAddrBox").value;
					//alert(document.getElementById("SubnetAddrBox").value);

					var tmpGatewayAddrBox = document.getElementById("GatewayAddrBox").value;
					//alert(document.getElementById("GatewayAddrBox").value);
					document.getElementById("GatewayAddrBox").value = trim(tmpGatewayAddrBox);
					var GatewayAddrBox = document.getElementById("GatewayAddrBox").value;
					
					if(!document.dataarea.IPAddressBox.disabled)
					{
						if(Valid_IPV4("IPAddressBox",0,223) != true)
						{
							errorMsg += <xsl:value-of select="$InvalidStaticIP"/>
							invalidIP = true;
						}
					}		
					
					if(!document.dataarea.SubnetAddrBox.disabled)
					{
						if(Valid_IPV4_Subnet("SubnetAddrBox",0,255) != true)
						{
							errorMsg += <xsl:value-of select="$InvalidStaticSubnet"/>
							invalidIP = true;
						}
					}
						
					if(!document.dataarea.GatewayAddrBox.disabled)
					{
						if(Valid_IPV4("GatewayAddrBox",0,223) != true)
						{
							errorMsg += <xsl:value-of select="$InvalidStaticGateway"/>
							invalidIP = true;
						}
					}
	
					<xsl:choose><xsl:when test="DialUpNetworkingObj/DialupCapabilities != 0">
					if(!document.dataarea.BaseIPAddrBox.disabled)
					{
						if(Valid_IPV4("BaseIPAddrBox",0,223) != true)
						{
							errorMsg += <xsl:value-of select="$InvalidBaseIP"/>
							invalidIP = true;
						}
					}
					</xsl:when></xsl:choose>
					
					if(!document.dataarea.SMTPAddrBox.disabled)
					{
						if(Valid_IPV4_SMTP("SMTPAddrBox",0,223) != true)
						{
							errorMsg += <xsl:value-of select="$InvalidSMTPIP"/>
							invalidIP = true;
						}
					}

					if (invalidIP == true)
					{
						alert(errorMsg);
						return false;
					}
					else
					{
						var	resetMsg = <xsl:value-of select="$Thisoperationcaused"/>
						alert(resetMsg);
						return true;
					}
				}
				
				function Compare_Strings(str1, str2)
				{
				    ret_val = true;
				    if(str1.length != str2.length)
				    return false;

				    for (var i = 0; i &lt;= str1.length; i++)
				    {
				        curChar1 = str1.charCodeAt(i);
				        curChar2 = str2.charCodeAt(i);
				        if ( curChar1 == curChar2)
				        {
				            continue;
				        }
					  else
				        {
				            ret_val = false;
				            break;
				        }
				    }

				    return ret_val;
				}	

				function Valid_Number(value, exact, min, max)
				{
				    var nASCII_0 = 48;
				    var nASCII_9 = 57;

				    if (exact != -1 &amp;&amp; value != exact)
				    	  return false;  
				    else if (exact != -1 &amp;&amp; value == exact)
					  return true;

				    if (value == null || value == "") 
				        return false;
				    var str = new String(value);
				    for (var i = 0; i &lt; str.length; i++)
				    {
				        if (str.charCodeAt(i) &lt; nASCII_0 || str.charCodeAt(i) &gt; nASCII_9)
			            return false;
				    }

				    if (Math.floor(str) &lt; Math.floor(min) || Math.floor(str) &gt; Math.floor(max)) 
				       return false;
				    else 
				        return true;
				}

				function Valid_IPV4(objstr,min,max)
				{
				    var nASCII_0 = 48;
				    var nASCII_9 = 57;
				    var nASCII_dot = 46;
				    var curNumber = "";
				    var iCount = 0;
				    var jCount = 0;
				    var limitedMask = 255;
                                    var str = document.getElementById(objstr).value;
                                    //var tempstr = eval("document.dataarea." + objstr);
                                    //if (tempstr.disabled == true)
                                      //  return true;
				    if(str.length == 0 || str == "")
				        return false;

				    if (Compare_Strings(str, '0.0.0.0'))
				        return false;

				    if (Compare_Strings(str, '255.255.255.255'))
				       return false;

				    for (var i = 0; i &lt; str.length; i++)
				    {
				        curChar = str.charCodeAt(i);
				        curNum = str.charAt(i);
				        if (curChar == nASCII_dot)
				        {
            
				            iCount++;
				            jCount = 0;

				            if (iCount == 1)
						{
						    if (curNumber &lt; 1 || curNumber == 127)
						        return false;
				                ret_code = Valid_Number(curNumber,-1,min,max);
						}
				            else
					           ret_code = Valid_Number(curNumber,-1,min,limitedMask);

					       if (ret_code != 1)
					           return false;

					       curNumber = "";
					       continue;
					   }
					   else if (curChar &gt;= nASCII_0 &amp;&amp; curChar &lt;= nASCII_9 &amp;&amp; jCount &lt;= 3)
				        {
				            jCount++;
				            curNumber += curNum;
				        }
				        else
				        {
				            return false;
				        }
    				    }

				    ret_code = Valid_Number(curNumber,-1,min,limitedMask);
				    if (ret_code != 1)
				        return false;

				    if (iCount != 3)
				        return false;

				    return true;
				}
				

				function Valid_IPV4_SMTP(objstr,min,max)
				{
				    var nASCII_0 = 48;
				    var nASCII_9 = 57;
				    var nASCII_dot = 46;
				    var curNumber = "";
				    var iCount = 0;
				    var jCount = 0;
				    var limitedMask = 255;
                                    var str = document.getElementById(objstr).value;
                                    //var tempstr = eval("document.dataarea." + objstr);
                                    //if (tempstr.disabled == true)
                                      //  return true;
				    if(str.length == 0 || str == "")
				        return false;

				    if (Compare_Strings(str, '0.0.0.0'))
				        return false;

				    if (Compare_Strings(str, '255.255.255.255'))
				       return false;

				    for (var i = 0; i &lt; str.length; i++)
				    {
				        curChar = str.charCodeAt(i);
				        curNum = str.charAt(i);
				        if (curChar == nASCII_dot)
				        {
            
				            iCount++;
				            jCount = 0;

				            if (iCount == 1)
						{
						    if (curNumber &lt; 1)
						        return false;
				                ret_code = Valid_Number(curNumber,-1,min,max);
						}
				            else
					           ret_code = Valid_Number(curNumber,-1,min,limitedMask);

					       if (ret_code != 1)
					           return false;

					       curNumber = "";
					       continue;
					   }
					   else if (curChar &gt;= nASCII_0 &amp;&amp; curChar &lt;= nASCII_9 &amp;&amp; jCount &lt;= 3)
				        {
				            jCount++;
				            curNumber += curNum;
				        }
				        else
				        {
				            return false;
				        }
    				    }

				    ret_code = Valid_Number(curNumber,-1,min,limitedMask);
				    if (ret_code != 1)
				        return false;

				    if (iCount != 3)
				        return false;

				    return true;
				}
				
				function Valid_SubnetOctet(value)
				{
				    if ((value == 0) || (value == 128) || (value == 192)
				       || (value == 224) || (value == 240) || (value ==252)
				       || (value == 254))
			        	  return true;
				    else 
				        return false;
				}


				function Valid_IPV4_Subnet(objstr,min,max)
				{
				    var nASCII_0 = 48;
				    var nASCII_9 = 57;
				    var nASCII_dot = 46;
				    var curNumber = "";
				    var iCount = 0;
				    var jCount = 0;
				    var limitedMask = 255;
				    var octet0 = 0;
				    var octet1 = 0;
				    var octet2 = 0;
				    var octet3 = 0;
                                    var str = document.getElementById(objstr).value;
			
                                    var tempstr = eval("document.dataarea." + objstr);
                                    if (tempstr.disabled == true)
                                        return true;

				    if(str.length == 0 || str == "")
				        return false;

				    if (Compare_Strings(str, '0.0.0.0'))
				        return false;

				    if (Compare_Strings(str, '255.255.255.255'))
				       return false;

				    for (var i = 0; i &lt; str.length; i++)
				    {
				        curChar = str.charCodeAt(i);
				        curNum = str.charAt(i);
				        if (curChar == nASCII_dot)
				        {
		            
				            iCount++;
				            jCount = 0;

				            ret_code = Valid_Number(curNumber,-1,min,limitedMask);
				            if (ret_code != 1)
				                return false;

				            if (iCount == 1)
				                octet0 = curNumber;
				            else if (iCount == 2)		
				                octet1 = curNumber;
				            else if (iCount == 3)		
				                octet2 = curNumber;
				            else
						return false;
	
				            curNumber = "";
				            continue;
        				}
				      else if (curChar &gt;= nASCII_0 &amp;&amp;  curChar &lt;= nASCII_9 &amp;&amp; jCount &lt;=3)
				      {
				            jCount++;
				            curNumber += curNum;
				      }
				      else
				      {
				            return false;
				      }

    			        }
				  octet3 = curNumber;
				  ret_code = Valid_Number(curNumber,-1,min,limitedMask);
				  if (ret_code != 1)
				        return false;

				  if (iCount != 3)
				        return false;

			        if( octet0 == 255 &amp;&amp; octet1 == 255 &amp;&amp; octet2 == 255 )
        			  {
			            if(Valid_SubnetOctet(octet3) == true)
            			{
						return true;
            			}

        			  }
				  else if( octet0 == 255 &amp;&amp; 
				            octet1 == 255 )
        			  {
			            if( Valid_SubnetOctet(octet2 ) &amp;&amp;  octet3 == 0 )
            		  	{
						return true;
            			}
        			  }
			        else if( octet0 == 255 )
        			  {
			            if( Valid_SubnetOctet(octet1 ) &amp;&amp;  octet2 == 0 &amp;&amp;  octet3 == 0) 
            			{
						return true;
            			}

        			  }
			        else if( Valid_SubnetOctet(octet0 ) &amp;&amp;  octet1 == 0 &amp;&amp;   octet2 == 0 &amp;&amp;
            				octet3 == 0 )
        			  {
					return true;
       			  }

				  return false;
			}

				
				
				function trimIPAddress(ipboxname , length)
				{
					for (i =1 ; i &lt;= length ; i++) {
						var ipbox = ipboxname + i;
						try
						{
							var ipboxval = document.getElementById(ipbox).value;
							document.getElementById(ipbox).value = trim(ipboxval);
						}
						catch(e){};
					}
				}
				
				function ltrim ( s ) 
				{ 
					return s.replace( /^\s*/, "" ) 
				} 
		
				function rtrim ( s ) 
				{ 
					return s.replace( /\s*$/, "" ); 
				} 
		
				//Combine the rtrim() and ltrim() functions to make the trim() function, which just wraps both calls together: 
		
				function trim ( s ) 
				{ 
					return rtrim(ltrim(s)); 
				}
				
				function EnableNicSettings()
				{
					document.dataarea.EnableDHCPNIC.disabled =(!(document.dataarea.EnableNIC.checked)); 
					EnableNicDHCPSettings();
				}
				function EnableNicDHCPSettings()
				{
					document.dataarea.IPAddressBox.disabled =(!(document.dataarea.EnableNIC.checked)||(document.dataarea.EnableDHCPNIC.checked)); 
					<!--document.dataarea.IPAddressBox2.disabled =(!(document.dataarea.EnableNIC.checked)||(document.dataarea.EnableDHCPNIC.checked)); 
					document.dataarea.IPAddressBox3.disabled =(!(document.dataarea.EnableNIC.checked)||(document.dataarea.EnableDHCPNIC.checked)); 
					document.dataarea.IPAddressBox4.disabled =(!(document.dataarea.EnableNIC.checked)||(document.dataarea.EnableDHCPNIC.checked));-->
 			
					document.dataarea.SubnetAddrBox.disabled =(!(document.dataarea.EnableNIC.checked)||(document.dataarea.EnableDHCPNIC.checked)); 
					<!--document.dataarea.SubnetAddrBox2.disabled =(!(document.dataarea.EnableNIC.checked)||(document.dataarea.EnableDHCPNIC.checked)); 
					document.dataarea.SubnetAddrBox3.disabled =(!(document.dataarea.EnableNIC.checked)||(document.dataarea.EnableDHCPNIC.checked)); 
					document.dataarea.SubnetAddrBox4.disabled =(!(document.dataarea.EnableNIC.checked)||(document.dataarea.EnableDHCPNIC.checked)); -->

					document.dataarea.GatewayAddrBox.disabled =(!(document.dataarea.EnableNIC.checked)||(document.dataarea.EnableDHCPNIC.checked)); 
					<!--document.dataarea.GatewayAddrBox2.disabled =(!(document.dataarea.EnableNIC.checked)||(document.dataarea.EnableDHCPNIC.checked)); 
					document.dataarea.GatewayAddrBox3.disabled =(!(document.dataarea.EnableNIC.checked)||(document.dataarea.EnableDHCPNIC.checked)); 
					document.dataarea.GatewayAddrBox4.disabled =(!(document.dataarea.EnableNIC.checked)||(document.dataarea.EnableDHCPNIC.checked)); -->
		
				}
				function EnableDialInSettings()
				{
					document.dataarea.EnableDHCPDialIn.disabled =(!(document.dataarea.EnableDialIn.checked)); 
					EnableDialInDHCPSettings();
					document.dataarea.DialInAuthentication.disabled =(!(document.dataarea.EnableDialIn.checked)); 
				}

				function EnableDialInDHCPSettings()
				{
					document.dataarea.BaseIPAddrBox.disabled =(!(document.dataarea.EnableDialIn.checked)||(document.dataarea.EnableDHCPDialIn.checked)); 
					<!--document.dataarea.BaseIPAddrBox2.disabled =(!(document.dataarea.EnableDialIn.checked)||(document.dataarea.EnableDHCPDialIn.checked)); 
					document.dataarea.BaseIPAddrBox3.disabled =(!(document.dataarea.EnableDialIn.checked)||(document.dataarea.EnableDHCPDialIn.checked)); 
					document.dataarea.BaseIPAddrBox4.disabled =(!(document.dataarea.EnableDialIn.checked)||(document.dataarea.EnableDHCPDialIn.checked)); -->
				}
				function EnableSMTPSettings()
				{
					document.dataarea.SMTPAddrBox.disabled =(!(document.dataarea.EnableSMTP.checked)); 
					<!--document.dataarea.SMTPAddrBox2.disabled =(!(document.dataarea.EnableSMTP.checked)); 
					document.dataarea.SMTPAddrBox3.disabled =(!(document.dataarea.EnableSMTP.checked)); 
					document.dataarea.SMTPAddrBox4.disabled =(!(document.dataarea.EnableSMTP.checked)); -->
				}
				
				function resetBaseIp(value)
				{
					var dfltIp = '<xsl:value-of select="DialUpNetworkingObj/DialupDialInDfltIpAddr"/>';
					document.dataarea.BaseIPAddrBox.value = dfltIp;
					<!--document.dataarea.BaseIPAddrBox2.value = dfltIp[1];
					document.dataarea.BaseIPAddrBox3.value = dfltIp[2];
					document.dataarea.BaseIPAddrBox4.value = dfltIp[3];-->
				}
		</script>
		</DataArea>
	</xsl:template>
	<xsl:template match="LanNetworkingObj">
		<Row>
			<Data type="ustring" editable="false" width="250">
				<xsl:attribute name="value"><xsl:value-of select="$EnableNIC"/></xsl:attribute>
			</Data>
			<Data name="EnableNIC" type="checkbox" editable="true" align="left" event="onClick" handler="javascript:EnableNicSettings()">
				<xsl:if test="NicEnable='true'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>
		</Row>
		<Row>
			<Data type="ustring" editable="false" width="250">
				<xsl:attribute name="value"><xsl:value-of select="$UseDHCPFor"/></xsl:attribute>
			</Data>
			<Data name="EnableDHCPNIC" type="checkbox" editable="true" align="left" event="onClick" handler="javascript:EnableNicDHCPSettings()">
				<xsl:if test="NicUseDHCP='true'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>
		</Row>
		<Row>
			<xsl:call-template name="ShowIPAddrBox">
				<xsl:with-param name="Address">
					<xsl:value-of select="IPAddress"/>
				</xsl:with-param>
				<xsl:with-param name="IPCtrlName">IPAddressBox</xsl:with-param>
				<xsl:with-param name="DisplayStr"><xsl:value-of select="$StaticIPAddress"/></xsl:with-param>
			</xsl:call-template>
		</Row>
		<Row>
			<xsl:call-template name="ShowIPAddrBox">
				<xsl:with-param name="Address">
					<xsl:value-of select="SubnetMask"/>
				</xsl:with-param>
				<xsl:with-param name="IPCtrlName">SubnetAddrBox</xsl:with-param>
				<xsl:with-param name="DisplayStr"><xsl:value-of select="$StaticSubnetMask"/></xsl:with-param>
			</xsl:call-template>
		</Row>
		<Row>
			<xsl:call-template name="ShowIPAddrBox">
				<xsl:with-param name="Address">
					<xsl:value-of select="Gateway"/>
				</xsl:with-param>
				<xsl:with-param name="IPCtrlName">GatewayAddrBox</xsl:with-param>
				<xsl:with-param name="DisplayStr"><xsl:value-of select="$StaticGatewayAddress"/></xsl:with-param>
			</xsl:call-template>
		</Row>
	</xsl:template>

	<xsl:template match="CurrentLanNetworkingObj">
			<Row>
				<Data ignoreonweb="true" type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$CurrentIPAddress"/></xsl:attribute>
				</Data>
				<Data ignoreonweb="true" type="ustring" editable="false">
					<xsl:attribute name="value">
						 <xsl:value-of select="NicCurrentIpAddress"/>
					</xsl:attribute>
				</Data>
			</Row>
	</xsl:template>
	
	<xsl:template match="DialUpNetworkingObj">
		<Row>
			<Data type="ustring" editable="false" width="250">
				<xsl:attribute name="value"><xsl:value-of select="$EnableDialIn"/></xsl:attribute>
			</Data>
			<Data name="EnableDialIn" type="checkbox" editable="true" align="left" event="onClick" handler="javascript:EnableDialInSettings()">
				<xsl:if test="DialupDialInEnable='true'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>
		</Row>
		<Row>
			<Data type="ustring" editable="false" width="250">
				<xsl:attribute name="value"><xsl:value-of select="$UseDHCPFor1"/></xsl:attribute>
			</Data>
			<Data name="EnableDHCPDialIn" type="checkbox" editable="true" align="left" event="onClick" handler="javascript:EnableDialInDHCPSettings()">
				<xsl:if test="DialupDialInDhcpEnable='true'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>
		</Row>
		<Row>
			<xsl:choose>
				<xsl:when test="DialupDialInBaseIpAddr='0.0.0.0'">
					<xsl:call-template name="ShowIPAddrBox">
						<xsl:with-param name="Address">
							<xsl:value-of select="DialupDialInDfltIpAddr"/>
						</xsl:with-param>
						<xsl:with-param name="IPCtrlName">BaseIPAddrBox</xsl:with-param>
						<xsl:with-param name="DisplayStr"><xsl:value-of select="$BaseIPAddress"/></xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="ShowIPAddrBox">
						<xsl:with-param name="Address">
							<xsl:value-of select="DialupDialInBaseIpAddr"/>
						</xsl:with-param>
						<xsl:with-param name="IPCtrlName">BaseIPAddrBox</xsl:with-param>
						<xsl:with-param name="DisplayStr"><xsl:value-of select="$BaseIPAddress"/></xsl:with-param>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</Row>
		<Row>
			<Data ignoreoncli="true" value="" type="ustring" editable="false" width="250"/>
			<Data ignoreoncli="true" align="left" link="true">
				<xsl:attribute name="href">javascript:resetBaseIp(true)</xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$ResetDefaultIP"/></xsl:attribute>
			</Data>
		</Row>
		<Row>
			<Data type="ustring" editable="false" width="250">
				<xsl:attribute name="value"><xsl:value-of select="$DialInAuthentication"/></xsl:attribute>
			</Data>
			<Data type="select" name="DialInAuthentication" editable="true"><xsl:attribute name="display"><xsl:value-of select="$DialInAuthentication1"/></xsl:attribute>
				<Choice returnvalue="0">
					<xsl:attribute name="value"><xsl:value-of select="$Any"/></xsl:attribute>
					<xsl:if test="DialInAuthType='0'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="1">
					<xsl:attribute name="value"><xsl:value-of select="$Encrypted"/></xsl:attribute>
					<xsl:if test="DialInAuthType='1'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
			</Data>
		</Row>
	</xsl:template>
	
	<xsl:template match="RemoteHostObj">
		<Row>
			<Data type="ustring" editable="false" width="250">
				<xsl:attribute name="value"><xsl:value-of select="$EnableSMTP"/></xsl:attribute>
			</Data>
			<Data name="EnableSMTP" type="checkbox" editable="true" align="left" event="onClick" handler="javascript:EnableSMTPSettings()">
				<xsl:if test="RhostsSmtpEmailEnable='true'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>
		</Row>
		<Row>
			<xsl:call-template name="ShowIPAddrBox">
				<xsl:with-param name="Address">
					<xsl:value-of select="RhostsSmtpSvrIpAddr"/>
				</xsl:with-param>
				<xsl:with-param name="IPCtrlName">SMTPAddrBox</xsl:with-param>
				<xsl:with-param name="DisplayStr"><xsl:value-of select="$SMTPEmailServer"/></xsl:with-param>
			</xsl:call-template>
		</Row>
	</xsl:template>
	<xsl:template name="ShowIPAddrBox">
		<xsl:param name="Address"/>
		<xsl:param name="IPCtrlName"/>
		<xsl:param name="DisplayStr"/>
		<Data type="ustring" editable="false">
			<xsl:attribute name="value"><xsl:value-of select="$DisplayStr"/></xsl:attribute>
		</Data>
		
	<Data type="editbox" editable="true" >
			<xsl:attribute name="name"><xsl:value-of select="$IPCtrlName"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$Address"/></xsl:attribute>

	</Data>
		
		<!--Data type="ipaddrbox" autocursoroff="false">
			<xsl:attribute name="name"><xsl:value-of select="$IPCtrlName"/></xsl:attribute>
			<xsl:attribute name="sep">.</xsl:attribute>
			<xsl:variable name="var1">
				<xsl:value-of select="substring-before($Address,'.')"/>
			</xsl:variable>
			<xsl:variable name="holdString1">
				<xsl:value-of select="substring-after($Address,'.')"/>
			</xsl:variable>
			<xsl:variable name="var2">
				<xsl:value-of select="substring-before($holdString1,'.')"/>
			</xsl:variable>
			<xsl:variable name="holdString2">
				<xsl:value-of select="substring-after($holdString1,'.')"/>
			</xsl:variable>
			<xsl:variable name="var3">
				<xsl:value-of select="substring-before($holdString2,'.')"/>
			</xsl:variable>
			<xsl:variable name="holdString3">
				<xsl:value-of select="substring-after($holdString2,'.')"/>
			</xsl:variable>
			<xsl:variable name="var4">
				<xsl:value-of select="$holdString3"/>
			</xsl:variable>
			<xsl:attribute name="value1"><xsl:value-of select="$var1"/></xsl:attribute>
			<xsl:attribute name="value2"><xsl:value-of select="$var2"/></xsl:attribute>
			<xsl:attribute name="value3"><xsl:value-of select="$var3"/></xsl:attribute>
			<xsl:attribute name="value4"><xsl:value-of select="$var4"/></xsl:attribute>
		</Data-->
	</xsl:template>
	<xsl:template name="chkIPValue">
		<xsl:param name="IPAddress1"/>
		<xsl:value-of select="$IPAddress1"/>
	</xsl:template>
</xsl:stylesheet>