<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="OMA/OMAUserRights"/>	
	<xsl:template match="OMA">	
	
		<DataArea ipbox="true" validate="true" backpagetarget="/servlet/DataArea?plugin=com.dell.drsc.webplugins.DRSCDemandDialOutUsers&amp;help=dialout">
			<xsl:attribute name="backpagedisplay"><xsl:value-of select="$DemandDialOutEntries"/></xsl:attribute>
			<xsl:choose>
				<xsl:when test="DemandDialObj /DemandDialIpAddr= ''">
					<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.drsc.webplugins.SetDemandDialOutEntry&amp;oid=<xsl:value-of select="DemandDialObj/@oid"/>&amp;ModeUpdDialOutUsr=ModeAdd
					</xsl:attribute>

				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.drsc.webplugins.SetDemandDialOutEntry&amp;oid=<xsl:value-of select="DemandDialObj/@oid"/>&amp;ModeUpdDialOutUsr=ModeUpdate
					</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			
			<PageTitle>
				<xsl:choose>
					<xsl:when test="DemandDialObj/DemandDialIpAddr= ''">
							<xsl:attribute name="display"><xsl:value-of select="$AddDemandDialOut"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="display"><xsl:value-of select="$ConfigureDemandDialOut"/></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</PageTitle>
			<CustomButton>
				<xsl:choose>
					<xsl:when test="DemandDialObj/DemandDialIpAddr= ''">
					</xsl:when>
					<xsl:otherwise>
						<Data name="Remove" formSubmit="true"><xsl:attribute name="display"><xsl:value-of select="$Remove"/></xsl:attribute>
							<xsl:attribute name="href">javascript:RemoveDialOutUser()</xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>

			</CustomButton>
			
			<TableData columnspacing="true">	
			<Header>
					<Data name="Property" value="Property" editable="false" ignoreonweb="true" type="usting"><xsl:attribute name="display"><xsl:value-of select="$Property"/></xsl:attribute></Data>
					<Data name="Value" value="Value" editable="false" ignoreonweb="true" type="usting"><xsl:attribute name="display"><xsl:value-of select="$Value"/></xsl:attribute></Data>
				</Header>
				<xsl:apply-templates select="DemandDialObj"/>
			</TableData>
			<script type="text/javascript" src="/drsc/js/utility.js"/>
			<script language="javascript">
				var	resetMsg = "<xsl:value-of select="$Thisoperationcaused"/>";

				function RemoveDialOutUser()
				{
					alert(resetMsg);
					document.dataarea.action=top.gnv.appendVID('/servlet/SubmitForm?plugin=com.dell.drsc.webplugins.SetDemandDialOutEntry&amp;oid=<xsl:value-of select="DemandDialObj/@oid"/>&amp;ModeUpdDialOutUsr=ModeRemove');
					document.dataarea.submit();
				}

				function chkIPAddress(objName, Octet1MaxVal,Octet4MinVal,Octet4MaxVal)
				{
					var octet1 = eval("document.dataarea." + objName + "1");
					var octet2 = eval("document.dataarea." + objName + "2");
					var octet3 = eval("document.dataarea." + objName + "3");
					var octet4 = eval("document.dataarea." + objName + "4");
					
					if (octet1.disabled == true) return true
					else
					{
						if (octet1.value == null || octet1.value == "" || octet1.value.indexOf(".") &gt;= 0) return false;
						else if (isNaN(octet1.value)) return false;
						else octet1 = parseInt(octet1.value);

						if (octet2.value == null || octet2.value == "" || octet2.value.indexOf(".") &gt;= 0) return false;
						else if (isNaN(octet2.value)) return false;
						else octet2 = parseInt(octet2.value);

						if (octet3.value == null || octet3.value == "" || octet3.value.indexOf(".") &gt;= 0) return false;
						else if (isNaN(octet3.value)) return false;
						else octet3 = parseInt(octet3.value);

						if (octet4.value == null || octet4.value == "" || octet4.value.indexOf(".") &gt;= 0) return false;
						else if (isNaN(octet4.value)) return false;
						else octet4 = parseInt(octet4.value);

						if (octet1 &lt; 1  || octet1 &gt; Octet1MaxVal) return false;
						else if (octet2 &lt; 0  || octet2 &gt; 255) return false;
						else if (octet3 &lt; 0  || octet3 &gt; 255) return false;
						else if (octet4 &lt; Octet4MinVal   || octet4 &gt; Octet4MaxVal) return false;
						else return true;
					}
				}
				
				function validate()
				{
					var invalidIP = false;
					var errorMsg = "";
					
					
					if (chkIPAddress("IPAddressBox", 254, 1, 254) == false) 
					{
						errorMsg += "<xsl:value-of select="$InvalidIPAddress"/>";
						invalidIP = true;
					}
					
					if (document.dataarea.PhoneNumber.value == "")
					{
						if (errorMsg != "") errorMsg += "\n";
						errorMsg += "<xsl:value-of select="$Phonenumbercannot"/>";
						invalidIP = true;
					}
					else if (!testUnicode(document.dataarea.PhoneNumber.value))
					{
						if (errorMsg != "") errorMsg += "\n";
						errorMsg += "<xsl:value-of select="$Phonenumbercontains"/>";
						invalidIP = true;
					}
					
					if (trim(document.dataarea.UserName.value) == "")
					{
						if (errorMsg != "") errorMsg += "\n";
						errorMsg += "<xsl:value-of select="$Usernamecannot"/>";
						invalidIP = true;
					}
					else if (!testUnicode(document.dataarea.UserName.value))
					{
						if (errorMsg != "") errorMsg += "\n";
						errorMsg += "<xsl:value-of select="$Usernamecontains"/>";
						invalidIP = true;
					}
					
					if (document.dataarea.Password.value == "")
					{
						if (errorMsg != "") errorMsg += "\n";
						errorMsg += "<xsl:value-of select="$Userpasswordcannot"/>";
						invalidIP = true;
					}
					else if (!testUnicode(document.dataarea.Password.value))
					{
						if (errorMsg != "") errorMsg += "\n";
						errorMsg += "<xsl:value-of select="$Passwordcontainsinvalid"/>";
						invalidIP = true;
					}					
					
					if (invalidIP == true)
					{
						alert(errorMsg)
						return false;
					}
					else
					{
						alert(resetMsg);
						trimIPAddress("IPAddressBox" , 4);
						return true;
					}
				}
				
				function trimIPAddress(ipboxname , length){
					for (i =1 ; i &lt;= length ; i++) {
						var ipbox = ipboxname + i;
						try
						{
							var ipboxval = document.getElementById(ipbox).value;
							document.getElementById(ipbox).value = trim(ipboxval);
						}
						catch(e){};
					}
				}

				function ltrim ( s ) 
				{ 
					return s.replace( /^\s*/, "" ) 
				} 
		
				function rtrim ( s ) 
				{ 
					return s.replace( /\s*$/, "" ); 
				} 
		
				//Combine the rtrim() and ltrim() functions to make the trim() function, which just wraps both calls together: 
		
				function trim ( s ) 
				{ 
					return rtrim(ltrim(s)); 
				}

				</script>
		</DataArea>
		
	</xsl:template>
	<xsl:template match="DemandDialObj">	
		<Row>
			<Data type="ustring" editable="false" ignoreonweb="true" width="120">
				<xsl:attribute name="value"><xsl:value-of select="$Index"/></xsl:attribute>
			</Data>
			<Data name="Index" type="editbox" editable="true" ignoreonweb="true">
				<xsl:attribute name="value"><xsl:value-of select="number(DemandDialIndex) - 1"/></xsl:attribute>
			</Data>
		</Row>
			
		<xsl:choose>
		<xsl:when test="DemandDialIpAddr=''">
			<Row>
				<xsl:call-template name="ShowIPAddrBox">
					<xsl:with-param name="Address"><xsl:value-of select="DemandDialIpAddr"/></xsl:with-param>
					<xsl:with-param name="IPCtrlName">IPAddressBox</xsl:with-param>
				</xsl:call-template>
			</Row>
			<Row>
				<Data type="ustring" editable="false" width="120">
					<xsl:attribute name="value"><xsl:value-of select="$PhoneNumber"/></xsl:attribute>
				</Data>
				<Data name="PhoneNumber" type="editbox" editable="true" maxlength="95">
					<xsl:attribute name="value"><xsl:value-of select="DemandDialPhoneNumber"/></xsl:attribute>
				</Data>

			</Row>
			<Row>
				<Data type="ustring" editable="true" width="120">
					<xsl:attribute name="value"><xsl:value-of select="$UserName"/></xsl:attribute>
				</Data>
				<Data name="UserName" type="editbox" editable="true" maxlength="31">
					<xsl:attribute name="value"><xsl:value-of select="DemandDialPppUserName"/></xsl:attribute>
				</Data>
			</Row>
			<Row>
				<Data type="ustring" editable="false" width="120">
					<xsl:attribute name="value"><xsl:value-of select="$Password"/></xsl:attribute>
				</Data>
				<Data name="Password" type="password" editable="true" size="31" ignoreoncli="true">
					<xsl:attribute name="value"><xsl:value-of select="DemandDialPppPassword"/></xsl:attribute>
				</Data>
				<Data name="Password" type="password" editable="true" size="7" ignoreonweb="true">
					<xsl:attribute name="value"><xsl:value-of select="DemandDialPppPassword"/></xsl:attribute>
				</Data>
			</Row>
			<Row>
				<Data type="ustring" editable="false" width="120">
					<xsl:attribute name="value"><xsl:value-of select="$Authentication"/></xsl:attribute>
				</Data>
				<Data type="select" name="DemandAuthentication" editable="true"><xsl:attribute name="display"><xsl:value-of select="$Authentication1"/></xsl:attribute>
				<xsl:choose>
					<xsl:when test="DemandDialAuthType='0'">
							<Choice returnvalue="0" default="true">
								<xsl:attribute name="value"><xsl:value-of select="$Any"/></xsl:attribute>
							</Choice>
							<Choice returnvalue="1">
								<xsl:attribute name="value"><xsl:value-of select="$Encrypted"/></xsl:attribute>
							</Choice>
					</xsl:when>
					<xsl:otherwise>
						<Choice returnvalue="1" default="true">
							<xsl:attribute name="value"><xsl:value-of select="$Encrypted1"/></xsl:attribute>
						</Choice>
						<Choice returnvalue="0">
							<xsl:attribute name="value"><xsl:value-of select="$Any1"/></xsl:attribute>
						</Choice>
					</xsl:otherwise>
				</xsl:choose>
				</Data>
			</Row>
		</xsl:when>
		<xsl:otherwise>
			<Row>
				<Data type="ustring" editable="false" width="150">
					<xsl:attribute name="value"><xsl:value-of select="$IPAddress"/></xsl:attribute>
				</Data>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="DemandDialIpAddr"/></xsl:attribute>
				</Data>
				<xsl:call-template name="HiddenIPAddrress">
					<xsl:with-param name="Address"><xsl:value-of select="DemandDialIpAddr"/></xsl:with-param>
				</xsl:call-template>
			</Row>
			<Row>
				<Data type="ustring" editable="false" width="120">
					<xsl:attribute name="value"><xsl:value-of select="$PhoneNumber1"/></xsl:attribute>
				</Data>
				<Data name="PhoneNumber" type="editbox" editable="true" maxlength="95">
					<xsl:attribute name="value"><xsl:value-of select="DemandDialPhoneNumber"/></xsl:attribute>
				</Data>
				<Data ignoreoncli="true"/><Data ignoreoncli="true"/><Data ignoreoncli="true"/><Data ignoreoncli="true"/>
			</Row>
			<Row>
				<Data type="ustring" editable="true" width="120">
					<xsl:attribute name="value"><xsl:value-of select="$UserName1"/></xsl:attribute>
				</Data>
				<Data name="UserName" type="editbox" editable="true" maxlength="31">
					<xsl:attribute name="value"><xsl:value-of select="DemandDialPppUserName"/></xsl:attribute>
				</Data>
				<Data ignoreoncli="true"/><Data ignoreoncli="true"/><Data ignoreoncli="true"/><Data ignoreoncli="true"/>
			</Row>
			<Row>
				<Data type="ustring" editable="false" width="120">
					<xsl:attribute name="value"><xsl:value-of select="$Password1"/></xsl:attribute>
				</Data>
				<Data name="Password" type="password" editable="true" size="31" ignoreoncli="true">
					<xsl:attribute name="value"><xsl:value-of select="DemandDialPppPassword"/></xsl:attribute>
				</Data>
				<Data name="Password" type="password" editable="true" size="7" ignoreonweb="true">
					<xsl:attribute name="value"><xsl:value-of select="DemandDialPppPassword"/></xsl:attribute>
				</Data>
				<Data ignoreoncli="true"/><Data ignoreoncli="true"/><Data ignoreoncli="true"/><Data ignoreoncli="true"/>
			</Row>
			<Row>
				<Data type="ustring" editable="false" width="120">
					<xsl:attribute name="value"><xsl:value-of select="$Authentication2"/></xsl:attribute>
				</Data>
				<Data type="select" name="DemandAuthentication" editable="true"><xsl:attribute name="display"><xsl:value-of select="$Authentication3"/></xsl:attribute>
				<xsl:choose>
					<xsl:when test="DemandDialAuthType='1'">
						<Choice returnvalue="1" default="true">
							<xsl:attribute name="value"><xsl:value-of select="$Encrypted2"/></xsl:attribute>
						</Choice>
						<Choice returnvalue="0">
							<xsl:attribute name="value"><xsl:value-of select="$Any2"/></xsl:attribute>
						</Choice>
					</xsl:when>
					<xsl:otherwise>
						<Choice returnvalue="0" default="true">
							<xsl:attribute name="value"><xsl:value-of select="$Any3"/></xsl:attribute>
						</Choice>
						<Choice returnvalue="1">
							<xsl:attribute name="value"><xsl:value-of select="$Encrypted3"/></xsl:attribute>
						</Choice>
					</xsl:otherwise>
				</xsl:choose>
				</Data>
				<Data ignoreoncli="true"/><Data ignoreoncli="true"/><Data ignoreoncli="true"/><Data ignoreoncli="true"/>
			</Row>
		</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="ShowIPAddrBox">
		<xsl:param name="Address"/>
		<xsl:param name="IPCtrlName"/>

		<Data type="ustring" editable="false">
			<xsl:attribute name="value"><xsl:value-of select="$IPAddress1"/></xsl:attribute>
		</Data>
		<Data type="ipaddrbox" autocursoroff="false">
			<xsl:attribute name="name"><xsl:value-of select="$IPCtrlName"/></xsl:attribute>
			<xsl:attribute name="sep">.</xsl:attribute>
			
			<xsl:variable name="var1"><xsl:value-of select="substring-before($Address,'.')"/></xsl:variable>
			<xsl:variable name="holdString1"><xsl:value-of select="substring-after($Address,'.')"/></xsl:variable>
			<xsl:variable name="var2"><xsl:value-of select="substring-before($holdString1,'.')"/></xsl:variable>
			<xsl:variable name="holdString2"><xsl:value-of select="substring-after($holdString1,'.')"/></xsl:variable>
			<xsl:variable name="var3"><xsl:value-of select="substring-before($holdString2,'.')"/></xsl:variable>
			<xsl:variable name="holdString3"><xsl:value-of select="substring-after($holdString2,'.')"/></xsl:variable>
			<xsl:variable name="var4"><xsl:value-of select="$holdString3"/></xsl:variable>
					
			<xsl:attribute name="value1"><xsl:value-of select="$var1"/></xsl:attribute>
			<xsl:attribute name="value2"><xsl:value-of select="$var2"/></xsl:attribute>
			<xsl:attribute name="value3"><xsl:value-of select="$var3"/></xsl:attribute>
			<xsl:attribute name="value4"><xsl:value-of select="$var4"/></xsl:attribute>
		</Data>
	</xsl:template>
	
	<xsl:template name="HiddenIPAddrress">
		<xsl:param name="Address"/>
		<xsl:variable name="var1"><xsl:value-of select="substring-before($Address,'.')"/></xsl:variable>
		<xsl:variable name="holdString1"><xsl:value-of select="substring-after($Address,'.')"/></xsl:variable>
		<xsl:variable name="var2"><xsl:value-of select="substring-before($holdString1,'.')"/></xsl:variable>
		<xsl:variable name="holdString2"><xsl:value-of select="substring-after($holdString1,'.')"/></xsl:variable>
		<xsl:variable name="var3"><xsl:value-of select="substring-before($holdString2,'.')"/></xsl:variable>
		<xsl:variable name="holdString3"><xsl:value-of select="substring-after($holdString2,'.')"/></xsl:variable>
		<xsl:variable name="var4"><xsl:value-of select="$holdString3"/></xsl:variable>

		<Data ignoreoncli="true" name="IPAddressBox1" type="hidden" editable="false">
			<xsl:attribute name="returnvalue"><xsl:value-of select="$var1"/></xsl:attribute>
		</Data>
		<Data ignoreoncli="true" name="IPAddressBox2" type="hidden" editable="false">
			<xsl:attribute name="returnvalue"><xsl:value-of select="$var2"/></xsl:attribute>
		</Data>
		<Data ignoreoncli="true" name="IPAddressBox3" type="hidden" editable="false">
			<xsl:attribute name="returnvalue"><xsl:value-of select="$var3"/></xsl:attribute>
		</Data>
		<Data ignoreoncli="true" name="IPAddressBox4" type="hidden" editable="false">
			<xsl:attribute name="returnvalue"><xsl:value-of select="$var4"/></xsl:attribute>
		</Data>
	</xsl:template>

</xsl:stylesheet>