<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="OMA/OMAUserRights"/>	
	<xsl:template match="OMA">	
	
		<DataArea onLoad="true" validate="true" backpagetarget="/servlet/DataArea?plugin=com.dell.drsc.webplugins.DRSCDialInUsers&amp;help=cfgdial">
			<xsl:attribute name="backpagedisplay"><xsl:value-of select="$DialInUserConfiguration"/></xsl:attribute>
			<xsl:choose>
				<xsl:when test="DialInUsersObj/DialinUsrPppUserName= ''">
						<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.drsc.webplugins.SetDialInUserEntry&amp;oid=<xsl:value-of select="DialInUsersObj/@oid"/>&amp;ModeUpdDialInUsr=ModeAdd</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
						<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.drsc.webplugins.SetDialInUserEntry&amp;oid=<xsl:value-of select="DialInUsersObj/@oid"/>&amp;ModeUpdDialInUsr=ModeUpdate</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>

			<PageTitle>
				<xsl:choose>
					<xsl:when test="DialInUsersObj/DialinUsrPppUserName= ''">
							<xsl:attribute name="display"><xsl:value-of select="$AddDialInUser"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="display"><xsl:value-of select="$ConfigureDialInUser"/></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</PageTitle>

			<CustomButton>
				<xsl:choose>
					<xsl:when test="DialInUsersObj/DialinUsrPppUserName= ''">
					</xsl:when>
					<xsl:otherwise>
						<Data name="Remove" formSubmit="true"><xsl:attribute name="display"><xsl:value-of select="$Remove"/></xsl:attribute>
							<xsl:attribute name="href">javascript:RemoveDialInUser()</xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>

			</CustomButton>
		
			<TableData columnspacing="true">
			<Header>
					<Data name="Property" value="Property" editable="false" ignoreonweb="true" type="usting"><xsl:attribute name="display"><xsl:value-of select="$Property"/></xsl:attribute></Data>
					<Data name="Value" value="Value" editable="false" ignoreonweb="true" type="usting"><xsl:attribute name="display"><xsl:value-of select="$Value"/></xsl:attribute></Data>
				</Header>

				<xsl:apply-templates select="DialInUsersObj"/>
			</TableData>
			<script type="text/javascript" src="/drsc/js/utility.js"/>
			<script language="javascript">
				var	resetMsg = "<xsl:value-of select="$Thisoperationcaused"/>";

				function RemoveDialInUser()
				{
					alert(resetMsg);
					document.dataarea.action=top.gnv.appendVID('/servlet/SubmitForm?plugin=com.dell.drsc.webplugins.SetDialInUserEntry&amp;oid=<xsl:value-of select="DialInUsersObj /@oid"/>&amp;ModeUpdDialInUsr=ModeRemove');
					document.dataarea.submit();
				}

				function validate()
				{
					var invalidIP = false;
					var errorMsg = "";
					
							
					if (document.dataarea.PhoneNumber.disabled == false &amp;&amp; document.dataarea.PhoneNumber.value == "")
					{
						errorMsg += "<xsl:value-of select="$Callbacknumbercannot"/>";
						invalidIP = true;
					}
					else if (document.dataarea.PhoneNumber.disabled == false &amp;&amp; !testUnicode(document.dataarea.PhoneNumber.value))
					{
						if (errorMsg != "") errorMsg += "\n";
						errorMsg += "<xsl:value-of select="$Callbacknumbercontains"/>";
						invalidIP = true;
					}
					
					if (trim(document.dataarea.UserName.value) == "")
					{
						if (errorMsg != "") errorMsg += "\n";
						errorMsg += "<xsl:value-of select="$Usernamecannot"/>";
						invalidIP = true;
					}
					else if (!testUnicode(document.dataarea.UserName.value))
					{
						if (errorMsg != "") errorMsg += "\n";
						errorMsg += "<xsl:value-of select="$Usernamecontains"/>";
						invalidIP = true;
					}
										
					if (document.dataarea.Password.value == "")
					{
						if (errorMsg != "") errorMsg += "\n";
						errorMsg += "<xsl:value-of select="$Userpasswordcannot"/>";
						invalidIP = true;
					}					
					else if (!testUnicode(document.dataarea.Password.value))
					{
						if (errorMsg != "") errorMsg += "\n";
						errorMsg += "<xsl:value-of select="$Userpasswordcontains"/>";
						invalidIP = true;
					}
										
					if (invalidIP == true)
					{
						alert(errorMsg)
						return false;
					}
					else
					{
						if (document.dataarea.PhoneNumber.disabled == true) 
						{
							document.dataarea.PhoneNumber.value = "";
							document.dataarea.PhoneNumber.disabled = false;
						}
						alert(resetMsg);
						return true;
					}
				}
				
				function initializationRoutine()
				{
					var dType = '<xsl:value-of select="DialInUsersObj/DialinUsrCallbackType"/>';
					if (dType == 1) document.dataarea.PhoneNumber.disabled = false;
					else document.dataarea.PhoneNumber.disabled = true;
				}
				
				function enableCallbackNum()
				{
					if (document.dataarea.CallbackType.options[document.dataarea.CallbackType.selectedIndex].value == 1) document.dataarea.PhoneNumber.disabled = false;
					else document.dataarea.PhoneNumber.disabled = true;
				}
				
								
				function ltrim ( s ) 
				{ 
					return s.replace( /^\s*/, "" ) 
				} 
		
				function rtrim ( s ) 
				{ 
					return s.replace( /\s*$/, "" ); 
				} 
		
				//Combine the rtrim() and ltrim() functions to make the trim() function, which just wraps both calls together: 
		
				function trim ( s ) 
				{ 
					return rtrim(ltrim(s)); 
				}

				</script>
		</DataArea>
		
	</xsl:template>
		<xsl:template match="DialInUsersObj">	
			<Row>
				<Data type="ustring" editable="false" ignoreonweb="true">
					<xsl:attribute name="value"><xsl:value-of select="$Index"/></xsl:attribute>
				</Data>
				<Data name="Index" type="editbox" editable="true" ignoreonweb="true">
				<xsl:attribute name="value"><xsl:value-of select="number(DialinUsrIndex) - 1"/></xsl:attribute>
				</Data>
			</Row>
			<xsl:choose>
			<xsl:when test="DialinUsrPppUserName=''">
				<Row>
					<Data type="ustring" editable="false" width="120">
						<xsl:attribute name="value"><xsl:value-of select="$UserName"/></xsl:attribute>
					</Data>
					<Data name="UserName" type="editbox" editable="true" maxlength="15">
						<xsl:attribute name="value"><xsl:value-of select="DialinUsrPppUserName"/></xsl:attribute>
					</Data>
				</Row>
				<Row>
					<Data type="ustring" editable="false">
						<xsl:attribute name="value"><xsl:value-of select="$Password"/></xsl:attribute>
					</Data>
					<Data name="Password" type="password" size="15" ignoreoncli="true" editable="true">
						<xsl:attribute name="value"><xsl:value-of select="DialinUsrPppUserPassword"/></xsl:attribute>
					</Data>
					<Data name="Password" type="password" size="8" ignoreonweb="true" editable="true">
						<xsl:attribute name="value"><xsl:value-of select="DialinUsrPppUserPassword"/></xsl:attribute>
					</Data>
				</Row>
				<Row>
					<Data type="ustring" editable="false">
						<xsl:attribute name="value"><xsl:value-of select="$CallbackNumber"/></xsl:attribute>
					</Data>
					<Data name="PhoneNumber" type="editbox" editable="true" maxlength="95">
						<xsl:attribute name="value"><xsl:value-of select="DialinUsrCallbackNumber"/></xsl:attribute>
					</Data>
				</Row>
				<Row>
					<Data type="ustring" editable="false">
						<xsl:attribute name="value"><xsl:value-of select="$CallbackType"/></xsl:attribute>
					</Data>
					<Data type="select" name="CallbackType" editable="true" event="onChange" handler="javascript:enableCallbackNum()"><xsl:attribute name="display"><xsl:value-of select="$CallbackType1"/></xsl:attribute>
						<Choice returnvalue="0">
							<xsl:attribute name="value"><xsl:value-of select="$None"/></xsl:attribute>
							<xsl:if test="DialinUsrCallbackType='0'">
								<xsl:attribute name="default">true</xsl:attribute>
							</xsl:if>
						</Choice>
						<Choice returnvalue="1">
							<xsl:attribute name="value"><xsl:value-of select="$Preset"/></xsl:attribute>
							<xsl:if test="DialinUsrCallbackType='1'">
								<xsl:attribute name="default">true</xsl:attribute>
							</xsl:if>
						</Choice>
						<Choice returnvalue="2">
							<xsl:attribute name="value"><xsl:value-of select="$UserSpecified"/></xsl:attribute>
							<xsl:if test="DialinUsrCallbackType='2'">
								<xsl:attribute name="default">true</xsl:attribute>
							</xsl:if>
						</Choice>
					</Data>
				</Row>
			</xsl:when>
			<xsl:otherwise>
				<Row>
					<Data type="ustring" editable="false" width="120">
						<xsl:attribute name="value"><xsl:value-of select="$UserName1"/></xsl:attribute>
					</Data>
					<Data type="ustring" editable="false">
						<xsl:attribute name="value"><xsl:value-of select="DialinUsrPppUserName"/></xsl:attribute>
					</Data>
					<Data ignoreoncli="true" name="UserName" type="hidden" editable="false">
						<xsl:attribute name="returnvalue"><xsl:value-of select="DialinUsrPppUserName"/></xsl:attribute>
					</Data>
				</Row>
				<Row>
					<Data type="ustring" editable="false">
						<xsl:attribute name="value"><xsl:value-of select="$Password1"/></xsl:attribute>
					</Data>
					<Data name="Password" type="password" size="15" ignoreoncli="true" editable="true">
						<xsl:attribute name="value"><xsl:value-of select="DialinUsrPppUserPassword"/></xsl:attribute>
					</Data>
					<Data name="Password" type="password" size="8" ignoreonweb="true" editable="true">
						<xsl:attribute name="value"><xsl:value-of select="DialinUsrPppUserPassword"/></xsl:attribute>
					</Data>
					<Data ignoreoncli="true"/>
				</Row>
				<Row>
					<Data type="ustring" editable="false">
						<xsl:attribute name="value"><xsl:value-of select="$CallbackNumber1"/></xsl:attribute>
					</Data>
					<Data name="PhoneNumber" type="editbox" editable="true" maxlength="95">
						<xsl:attribute name="value"><xsl:value-of select="DialinUsrCallbackNumber"/></xsl:attribute>
					</Data>
					<Data ignoreoncli="true"/>
				</Row>
				<Row>
					<Data type="ustring" editable="false">
						<xsl:attribute name="value"><xsl:value-of select="$CallbackType2"/></xsl:attribute>
					</Data>
					<Data type="select" name="CallbackType" editable="true" event="onChange" handler="javascript:enableCallbackNum()"><xsl:attribute name="display"><xsl:value-of select="$CallbackType3"/></xsl:attribute>
						<Choice returnvalue="1">
							<xsl:attribute name="value"><xsl:value-of select="$Preset1"/></xsl:attribute>
							<xsl:if test="DialinUsrCallbackType='1'">
								<xsl:attribute name="default">true</xsl:attribute>
							</xsl:if>
						</Choice>
						<Choice returnvalue="0">
							<xsl:attribute name="value"><xsl:value-of select="$None1"/></xsl:attribute>
							<xsl:if test="DialinUsrCallbackType='0'">
								<xsl:attribute name="default">true</xsl:attribute>
							</xsl:if>
						</Choice>
						<Choice returnvalue="2">
							<xsl:attribute name="value"><xsl:value-of select="$UserSpecified1"/></xsl:attribute>
							<xsl:if test="DialinUsrCallbackType='2'">
								<xsl:attribute name="default">true</xsl:attribute>
							</xsl:if>
						</Choice>
					</Data>
					<Data ignoreoncli="true"/>
				</Row>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>