<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:strip-space elements="*"/>
	<xsl:output method="xml" indent="no" />
	<xsl:template match="OMA">
		<DataArea backpagetarget="/servlet/DataArea?plugin=com.dell.drsc.webplugins.RACCSR&amp;help=certmgmt">	
 			<xsl:attribute name="backpagedisplay"><xsl:value-of select="$CSRManagement"/></xsl:attribute>
 			<xsl:choose>
 				<xsl:when test="normalize-space(certEntry/type)='1'">
 					<PageTitle><xsl:attribute name="display"><xsl:value-of select="$CSRTitleServerCert"/></xsl:attribute></PageTitle>
 				</xsl:when>
				<xsl:otherwise>
					<PageTitle><xsl:attribute name="display"><xsl:value-of select="$CSRTitleCACert"/></xsl:attribute></PageTitle>
				</xsl:otherwise>
 			</xsl:choose>
			<CustomButton>
				<Data name="">
					<xsl:attribute name="display"><xsl:value-of select="$CSRRefresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.drsc.webplugins.RACCSRView&amp;certType=<xsl:value-of select="certEntry/type"/>&amp;help=viewcert</xsl:attribute>
				</Data>
			</CustomButton>
			<xsl:choose>
				<xsl:when test="SMStatus='0'">
					<TableData columnspacing="true">				
						<Header>
							<Data editable="false" type="usting">
								<xsl:attribute name="display"><xsl:value-of select="$CSRAttribute"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$CSRAttribute"/></xsl:attribute>
							</Data>
							<Data editable="false" type="usting">
								<xsl:attribute name="display"><xsl:value-of select="$CSRValue"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$CSRValue"/></xsl:attribute>
							</Data>
						</Header>
						<xsl:apply-templates select="certEntry"/>
					</TableData>
				</xsl:when>
				<xsl:otherwise>
					<PromptText><xsl:value-of select="$CSRViewError"/></PromptText>
				</xsl:otherwise>
			</xsl:choose>
		</DataArea>
	</xsl:template>
	
	<xsl:template match="certEntry">	
		<Row>
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$CSRType"/></xsl:attribute>
			</Data>
			<Data type="ustring" editable="false">
				<xsl:attribute name="value">
					 <xsl:choose>
						<xsl:when test="normalize-space(type)='1'"><xsl:value-of select="$CSRServerCert"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="$CSRCACert"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
		</Row>
		<Row>
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$CSRSerial"/></xsl:attribute>
			</Data>
			<Data type="ustring" editable="false">
				<xsl:attribute name="value">
					 <xsl:value-of select="serial"/>
				</xsl:attribute>
			</Data>
		</Row>
		<Row>
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$CSRKeySize"/></xsl:attribute>
			</Data>
			<Data type="ustring" editable="false">
				<xsl:attribute name="value">
					 <xsl:value-of select="keySize"/>
				</xsl:attribute>
			</Data>
		</Row>
		<Row>
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$CSRValidFrom"/></xsl:attribute>
			</Data>
			<Data type="ustring" editable="false">
				<xsl:attribute name="value">
					 <xsl:value-of select="validFrom"/>
				</xsl:attribute>
			</Data>
		</Row>
		<Row>
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$CSRValidTo"/></xsl:attribute>
			</Data>
			<Data type="ustring" editable="false">
				<xsl:attribute name="value">
					 <xsl:value-of select="validTo"/>
				</xsl:attribute>
			</Data>
		</Row>
		<Row>
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$CSRSubject"/></xsl:attribute>
			</Data>
			<Data type="ustring" editable="false">
				<xsl:attribute name="value">
					 <xsl:value-of select="subject"/>
				</xsl:attribute>
			</Data>
		</Row>
		<Row>
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$CSRIssuer"/></xsl:attribute>
			</Data>
			<Data type="ustring" editable="false">
				<xsl:attribute name="value">
					 <xsl:value-of select="issuer"/>
				</xsl:attribute>
			</Data>
		</Row>
	</xsl:template>

</xsl:stylesheet>