<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="OMA/OMAUserRights"/>	
	<xsl:template match="/OMA">
		<xsl:variable name="usrights"><xsl:value-of select="OMAUserRights"/></xsl:variable>
		<DataArea backpagetarget="/servlet/DataArea?plugin=com.dell.drsc.webplugins.RACCSR&amp;help=certmgmt" validate="true" enctype="true">
			<xsl:attribute name="backpagedisplay"><xsl:value-of select="$CSRManagement"/></xsl:attribute>
			<xsl:if test="$usrights='7'">
				<xsl:attribute name="submitdisplay"><xsl:value-of select="$CSRUpload"/></xsl:attribute>
				<xsl:attribute name="submit">/servlet/UploadServlet</xsl:attribute>
			</xsl:if>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$CSRUploadCert"/></xsl:attribute>
			</PageTitle>
			
			<PromptText><xsl:value-of select="$CSRUploadPrompt"/></PromptText>
			
			<ListData type="custom">
				<Data name="certType"  value="" editable="true" type="select" align="left">
					<xsl:attribute name="display"><xsl:value-of select="$CSRUploadType"/></xsl:attribute>
					<Choice returnvalue="1">
						<xsl:attribute name="value"><xsl:value-of select="$CSRUploadServerCert"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="2">
						<xsl:attribute name="value"><xsl:value-of select="$CSRUploadCACert"/></xsl:attribute>
					</Choice>
				</Data>
				<Data size="45" name="file"  value="" editable="true" type="file" align="left">
					<xsl:attribute name="display"><xsl:value-of select="$CSRUploadFilename"/></xsl:attribute>
				</Data>
			</ListData>

			<script type="text/javascript" src="/drsc/js/utility.js"></script>
			<script language="javascript">
				
				var sFRequired	= "<xsl:value-of select="$CSRUploadFilenameRequired"/>";
				var sFInvalid	= "<xsl:value-of select="$CSRUploadFilenameInvalid"/>";

				function validate()
				{
					var errStr = "";
					
					if (document.dataarea.file.value == "") errStr = addToErrorMsg(errStr, sFRequired);
					else if(!checkString(document.dataarea.file.value, DELIM_FILE_NAME)) errStr = addToErrorMsg(errStr, sFInvalid);
					
					if (errStr != "")
					{
						alert(errStr);
						return false;
					}
					
					document.dataarea.redirectURL.value = "/servlet/DataArea?plugin=com.dell.drsc.webplugins.RACCSRUploadPost&amp;&amp;certType=" + document.dataarea.certType.options[document.dataarea.certType.selectedIndex].value;
					document.dataarea.action =  top.gnv.appendVID("/servlet/UploadServlet");
					return true;				
				}			
			</script>
			<HTMLData>
				<input type="hidden" name="dir" value="RAC"/>
				<input type="hidden" name="redirectURL" value=""/>
			</HTMLData>
		</DataArea>
	</xsl:template>
	<xsl:template match="*"/>	
</xsl:stylesheet>