<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="OMA/OMAUserRights"/>	
	<xsl:template match="/OMA">
		<xsl:variable name="usrights"><xsl:value-of select="OMAUserRights"/></xsl:variable>
		<DataArea backpagetarget="/servlet/DataArea?plugin=com.dell.drsc.webplugins.RACCSR&amp;help=certmgmt">			
			<xsl:attribute name="backpagedisplay"><xsl:value-of select="$CSRManagement"/></xsl:attribute>

			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$CSRGenerate"/></xsl:attribute>
			</PageTitle>
			
			<!--
				ERROR CODES:
				0	- CSR generated successfully.
				271 - Invalid Input, Bad CSR, or CSR doesn't exist.
			-->

			<xsl:choose>
				<xsl:when test="SMStatus='0'">
					<PromptText><xsl:value-of select="$CSRGenerateSuccess"/></PromptText>
				</xsl:when>
				<xsl:when test="SMStatus='271'">
					<PromptText><xsl:value-of select="$CSRGenerateError_271"/></PromptText>
				</xsl:when>
				<xsl:otherwise>
					<PromptText><xsl:value-of select="$CSRGenerateError"/></PromptText>
				</xsl:otherwise>
			</xsl:choose>
		</DataArea>
	</xsl:template>
	<xsl:template match="*"/>	
</xsl:stylesheet>