<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="OMA/OMAUserRights"/>	
	<xsl:template match="/OMA">
		<xsl:variable name="usrights"><xsl:value-of select="OMAUserRights"/></xsl:variable>
		<DataArea backpagetarget="/servlet/DataArea?plugin=com.dell.drsc.webplugins.RACCSR&amp;help=certmgmt" validate="true">			
			<xsl:attribute name="backpagedisplay"><xsl:value-of select="$CSRManagement"/></xsl:attribute>
			<xsl:if test="$usrights='7'">
				<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.drsc.webplugins.RACCSRGeneratePost</xsl:attribute>
				<xsl:attribute name="submitdisplay"><xsl:value-of select="$CSRGenerate"/></xsl:attribute>
			</xsl:if>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$CSRTitle"/></xsl:attribute>
			</PageTitle>
			
			<PromptText><xsl:value-of select="$CSRPrompt"/></PromptText>
			
			<ListData type="custom">
				<Data size="45" name="CN"  value="" editable="true" type="editbox" align="left" maxlength="64">
					<xsl:attribute name="display"><xsl:value-of select="$CSRCN"/></xsl:attribute>
				</Data>
				<Data size="45" name="OU"  value="" editable="true" type="editbox" align="left" maxlength="64">
					<xsl:attribute name="display"><xsl:value-of select="$CSROU"/></xsl:attribute>
				</Data>
				<Data size="45" name="O"  value="" editable="true" type="editbox" align="left" maxlength="64">
					<xsl:attribute name="display"><xsl:value-of select="$CSRO"/></xsl:attribute>
				</Data>
				<Data name="C" value="" editable="true" type="select" align="left">
					<xsl:attribute name="display"><xsl:value-of select="$CSRC"/></xsl:attribute>
					<Choice returnvalue="AD">
						<xsl:attribute name="value"><xsl:value-of select="$AD"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="AE">
						<xsl:attribute name="value"><xsl:value-of select="$AE"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="AF">
						<xsl:attribute name="value"><xsl:value-of select="$AF"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="AG">
						<xsl:attribute name="value"><xsl:value-of select="$AG"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="AI">
						<xsl:attribute name="value"><xsl:value-of select="$AI"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="AL">
						<xsl:attribute name="value"><xsl:value-of select="$AL"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="AM">
						<xsl:attribute name="value"><xsl:value-of select="$AM"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="AN">
						<xsl:attribute name="value"><xsl:value-of select="$AN"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="AO">
						<xsl:attribute name="value"><xsl:value-of select="$AO"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="AQ">
						<xsl:attribute name="value"><xsl:value-of select="$AQ"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="AR">
						<xsl:attribute name="value"><xsl:value-of select="$AR"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="AS">
						<xsl:attribute name="value"><xsl:value-of select="$AS"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="AT">
						<xsl:attribute name="value"><xsl:value-of select="$AT"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="AU">
						<xsl:attribute name="value"><xsl:value-of select="$AU"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="AW">
						<xsl:attribute name="value"><xsl:value-of select="$AW"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="AZ">
						<xsl:attribute name="value"><xsl:value-of select="$AZ"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="BA">
						<xsl:attribute name="value"><xsl:value-of select="$BA"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="BB">
						<xsl:attribute name="value"><xsl:value-of select="$BB"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="BD">
						<xsl:attribute name="value"><xsl:value-of select="$BD"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="BE">
						<xsl:attribute name="value"><xsl:value-of select="$BE"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="BF">
						<xsl:attribute name="value"><xsl:value-of select="$BF"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="BG">
						<xsl:attribute name="value"><xsl:value-of select="$BG"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="BH">
						<xsl:attribute name="value"><xsl:value-of select="$BH"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="BI">
						<xsl:attribute name="value"><xsl:value-of select="$BI"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="BJ">
						<xsl:attribute name="value"><xsl:value-of select="$BJ"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="BM">
						<xsl:attribute name="value"><xsl:value-of select="$BM"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="BN">
						<xsl:attribute name="value"><xsl:value-of select="$BN"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="BO">
						<xsl:attribute name="value"><xsl:value-of select="$BO"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="BR">
						<xsl:attribute name="value"><xsl:value-of select="$BR"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="BS">
						<xsl:attribute name="value"><xsl:value-of select="$BS"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="BT">
						<xsl:attribute name="value"><xsl:value-of select="$BT"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="BV">
						<xsl:attribute name="value"><xsl:value-of select="$BV"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="BW">
						<xsl:attribute name="value"><xsl:value-of select="$BW"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="BY">
						<xsl:attribute name="value"><xsl:value-of select="$BY"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="BZ">
						<xsl:attribute name="value"><xsl:value-of select="$BZ"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="CA">
						<xsl:attribute name="value"><xsl:value-of select="$CA"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="CC">
						<xsl:attribute name="value"><xsl:value-of select="$CC"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="CF">
						<xsl:attribute name="value"><xsl:value-of select="$CF"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="CG">
						<xsl:attribute name="value"><xsl:value-of select="$CG"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="CH">
						<xsl:attribute name="value"><xsl:value-of select="$CH"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="CI">
						<xsl:attribute name="value"><xsl:value-of select="$CI"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="CK">
						<xsl:attribute name="value"><xsl:value-of select="$CK"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="CL">
						<xsl:attribute name="value"><xsl:value-of select="$CL"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="CM">
						<xsl:attribute name="value"><xsl:value-of select="$CM"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="CN">
						<xsl:attribute name="value"><xsl:value-of select="$CN"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="CO">
						<xsl:attribute name="value"><xsl:value-of select="$CO"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="CR">
						<xsl:attribute name="value"><xsl:value-of select="$CR"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="CS">
						<xsl:attribute name="value"><xsl:value-of select="$CS"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="CU">
						<xsl:attribute name="value"><xsl:value-of select="$CU"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="CV">
						<xsl:attribute name="value"><xsl:value-of select="$CV"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="CX">
						<xsl:attribute name="value"><xsl:value-of select="$CX"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="CY">
						<xsl:attribute name="value"><xsl:value-of select="$CY"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="CZ">
						<xsl:attribute name="value"><xsl:value-of select="$CZ"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="DE">
						<xsl:attribute name="value"><xsl:value-of select="$DE"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="DJ">
						<xsl:attribute name="value"><xsl:value-of select="$DJ"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="DK">
						<xsl:attribute name="value"><xsl:value-of select="$DK"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="DM">
						<xsl:attribute name="value"><xsl:value-of select="$DM"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="DO">
						<xsl:attribute name="value"><xsl:value-of select="$DO"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="DZ">
						<xsl:attribute name="value"><xsl:value-of select="$DZ"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="EC">
						<xsl:attribute name="value"><xsl:value-of select="$EC"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="EE">
						<xsl:attribute name="value"><xsl:value-of select="$EE"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="EG">
						<xsl:attribute name="value"><xsl:value-of select="$EG"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="EH">
						<xsl:attribute name="value"><xsl:value-of select="$EH"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="ER">
						<xsl:attribute name="value"><xsl:value-of select="$ER"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="ES">
						<xsl:attribute name="value"><xsl:value-of select="$ES"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="ET">
						<xsl:attribute name="value"><xsl:value-of select="$ET"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="FI">
						<xsl:attribute name="value"><xsl:value-of select="$FI"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="FJ">
						<xsl:attribute name="value"><xsl:value-of select="$FJ"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="FK">
						<xsl:attribute name="value"><xsl:value-of select="$FK"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="FM">
						<xsl:attribute name="value"><xsl:value-of select="$FM"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="FO">
						<xsl:attribute name="value"><xsl:value-of select="$FO"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="FR">
						<xsl:attribute name="value"><xsl:value-of select="$FR"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="FX">
						<xsl:attribute name="value"><xsl:value-of select="$FX"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="GA">
						<xsl:attribute name="value"><xsl:value-of select="$GA"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="GB">
						<xsl:attribute name="value"><xsl:value-of select="$GB"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="GD">
						<xsl:attribute name="value"><xsl:value-of select="$GD"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="GE">
						<xsl:attribute name="value"><xsl:value-of select="$GE"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="GF">
						<xsl:attribute name="value"><xsl:value-of select="$GF"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="GH">
						<xsl:attribute name="value"><xsl:value-of select="$GH"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="GI">
						<xsl:attribute name="value"><xsl:value-of select="$GI"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="GL">
						<xsl:attribute name="value"><xsl:value-of select="$GL"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="GM">
						<xsl:attribute name="value"><xsl:value-of select="$GM"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="GN">
						<xsl:attribute name="value"><xsl:value-of select="$GN"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="GP">
						<xsl:attribute name="value"><xsl:value-of select="$GP"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="GQ">
						<xsl:attribute name="value"><xsl:value-of select="$GQ"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="GR">
						<xsl:attribute name="value"><xsl:value-of select="$GR"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="GS">
						<xsl:attribute name="value"><xsl:value-of select="$GS"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="GT">
						<xsl:attribute name="value"><xsl:value-of select="$GT"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="GU">
						<xsl:attribute name="value"><xsl:value-of select="$GU"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="GW">
						<xsl:attribute name="value"><xsl:value-of select="$GW"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="GY">
						<xsl:attribute name="value"><xsl:value-of select="$GY"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="HK">
						<xsl:attribute name="value"><xsl:value-of select="$HK"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="HM">
						<xsl:attribute name="value"><xsl:value-of select="$HM"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="HN">
						<xsl:attribute name="value"><xsl:value-of select="$HN"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="HR">
						<xsl:attribute name="value"><xsl:value-of select="$HR"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="HT">
						<xsl:attribute name="value"><xsl:value-of select="$HT"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="HU">
						<xsl:attribute name="value"><xsl:value-of select="$HU"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="ID">
						<xsl:attribute name="value"><xsl:value-of select="$ID"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="IE">
						<xsl:attribute name="value"><xsl:value-of select="$IE"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="IL">
						<xsl:attribute name="value"><xsl:value-of select="$IL"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="IN">
						<xsl:attribute name="value"><xsl:value-of select="$IN"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="IO">
						<xsl:attribute name="value"><xsl:value-of select="$IO"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="IQ">
						<xsl:attribute name="value"><xsl:value-of select="$IQ"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="IR">
						<xsl:attribute name="value"><xsl:value-of select="$IR"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="IS">
						<xsl:attribute name="value"><xsl:value-of select="$IS"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="IT">
						<xsl:attribute name="value"><xsl:value-of select="$IT"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="JM">
						<xsl:attribute name="value"><xsl:value-of select="$JM"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="JO">
						<xsl:attribute name="value"><xsl:value-of select="$JO"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="JP">
						<xsl:attribute name="value"><xsl:value-of select="$JP"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="KE">
						<xsl:attribute name="value"><xsl:value-of select="$KE"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="KG">
						<xsl:attribute name="value"><xsl:value-of select="$KG"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="KH">
						<xsl:attribute name="value"><xsl:value-of select="$KH"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="KI">
						<xsl:attribute name="value"><xsl:value-of select="$KI"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="KM">
						<xsl:attribute name="value"><xsl:value-of select="$KM"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="KN">
						<xsl:attribute name="value"><xsl:value-of select="$KN"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="KP">
						<xsl:attribute name="value"><xsl:value-of select="$KP"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="KR">
						<xsl:attribute name="value"><xsl:value-of select="$KR"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="KW">
						<xsl:attribute name="value"><xsl:value-of select="$KW"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="KY">
						<xsl:attribute name="value"><xsl:value-of select="$KY"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="KZ">
						<xsl:attribute name="value"><xsl:value-of select="$KZ"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="LA">
						<xsl:attribute name="value"><xsl:value-of select="$LA"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="LB">
						<xsl:attribute name="value"><xsl:value-of select="$LB"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="LC">
						<xsl:attribute name="value"><xsl:value-of select="$LC"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="LI">
						<xsl:attribute name="value"><xsl:value-of select="$LI"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="LK">
						<xsl:attribute name="value"><xsl:value-of select="$LK"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="LR">
						<xsl:attribute name="value"><xsl:value-of select="$LR"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="LS">
						<xsl:attribute name="value"><xsl:value-of select="$LS"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="LT">
						<xsl:attribute name="value"><xsl:value-of select="$LT"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="LU">
						<xsl:attribute name="value"><xsl:value-of select="$LU"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="LV">
						<xsl:attribute name="value"><xsl:value-of select="$LV"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="LY">
						<xsl:attribute name="value"><xsl:value-of select="$LY"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="MA">
						<xsl:attribute name="value"><xsl:value-of select="$MA"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="MC">
						<xsl:attribute name="value"><xsl:value-of select="$MC"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="MD">
						<xsl:attribute name="value"><xsl:value-of select="$MD"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="MG">
						<xsl:attribute name="value"><xsl:value-of select="$MG"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="MH">
						<xsl:attribute name="value"><xsl:value-of select="$MH"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="MK">
						<xsl:attribute name="value"><xsl:value-of select="$MK"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="ML">
						<xsl:attribute name="value"><xsl:value-of select="$ML"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="MM">
						<xsl:attribute name="value"><xsl:value-of select="$MM"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="MN">
						<xsl:attribute name="value"><xsl:value-of select="$MN"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="MO">
						<xsl:attribute name="value"><xsl:value-of select="$MO"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="MP">
						<xsl:attribute name="value"><xsl:value-of select="$MP"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="MQ">
						<xsl:attribute name="value"><xsl:value-of select="$MQ"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="MR">
						<xsl:attribute name="value"><xsl:value-of select="$MR"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="MS">
						<xsl:attribute name="value"><xsl:value-of select="$MS"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="MT">
						<xsl:attribute name="value"><xsl:value-of select="$MT"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="MU">
						<xsl:attribute name="value"><xsl:value-of select="$MU"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="MV">
						<xsl:attribute name="value"><xsl:value-of select="$MV"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="MW">
						<xsl:attribute name="value"><xsl:value-of select="$MW"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="MX">
						<xsl:attribute name="value"><xsl:value-of select="$MX"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="MY">
						<xsl:attribute name="value"><xsl:value-of select="$MY"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="MZ">
						<xsl:attribute name="value"><xsl:value-of select="$MZ"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="NA">
						<xsl:attribute name="value"><xsl:value-of select="$NA"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="NC">
						<xsl:attribute name="value"><xsl:value-of select="$NC"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="NE">
						<xsl:attribute name="value"><xsl:value-of select="$NE"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="NF">
						<xsl:attribute name="value"><xsl:value-of select="$NF"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="NG">
						<xsl:attribute name="value"><xsl:value-of select="$NG"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="NI">
						<xsl:attribute name="value"><xsl:value-of select="$NI"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="NL">
						<xsl:attribute name="value"><xsl:value-of select="$NL"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="NO">
						<xsl:attribute name="value"><xsl:value-of select="$NO"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="NP">
						<xsl:attribute name="value"><xsl:value-of select="$NP"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="NR">
						<xsl:attribute name="value"><xsl:value-of select="$NR"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="NT">
						<xsl:attribute name="value"><xsl:value-of select="$NT"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="NU">
						<xsl:attribute name="value"><xsl:value-of select="$NU"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="NZ">
						<xsl:attribute name="value"><xsl:value-of select="$NZ"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="OM">
						<xsl:attribute name="value"><xsl:value-of select="$OM"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="PA">
						<xsl:attribute name="value"><xsl:value-of select="$PA"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="PE">
						<xsl:attribute name="value"><xsl:value-of select="$PE"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="PF">
						<xsl:attribute name="value"><xsl:value-of select="$PF"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="PG">
						<xsl:attribute name="value"><xsl:value-of select="$PG"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="PH">
						<xsl:attribute name="value"><xsl:value-of select="$PH"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="PK">
						<xsl:attribute name="value"><xsl:value-of select="$PK"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="PL">
						<xsl:attribute name="value"><xsl:value-of select="$PL"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="PM">
						<xsl:attribute name="value"><xsl:value-of select="$PM"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="PN">
						<xsl:attribute name="value"><xsl:value-of select="$PN"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="PR">
						<xsl:attribute name="value"><xsl:value-of select="$PR"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="PT">
						<xsl:attribute name="value"><xsl:value-of select="$PT"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="PW">
						<xsl:attribute name="value"><xsl:value-of select="$PW"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="PY">
						<xsl:attribute name="value"><xsl:value-of select="$PY"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="QA">
						<xsl:attribute name="value"><xsl:value-of select="$QA"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="RE">
						<xsl:attribute name="value"><xsl:value-of select="$RE"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="RO">
						<xsl:attribute name="value"><xsl:value-of select="$RO"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="RU">
						<xsl:attribute name="value"><xsl:value-of select="$RU"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="RW">
						<xsl:attribute name="value"><xsl:value-of select="$RW"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="SA">
						<xsl:attribute name="value"><xsl:value-of select="$SA"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="Sb">
						<xsl:attribute name="value"><xsl:value-of select="$Sb"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="SC">
						<xsl:attribute name="value"><xsl:value-of select="$SC"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="SD">
						<xsl:attribute name="value"><xsl:value-of select="$SD"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="SE">
						<xsl:attribute name="value"><xsl:value-of select="$SE"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="SG">
						<xsl:attribute name="value"><xsl:value-of select="$SG"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="SH">
						<xsl:attribute name="value"><xsl:value-of select="$SH"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="SI">
						<xsl:attribute name="value"><xsl:value-of select="$SI"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="SJ">
						<xsl:attribute name="value"><xsl:value-of select="$SJ"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="SK">
						<xsl:attribute name="value"><xsl:value-of select="$SK"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="SL">
						<xsl:attribute name="value"><xsl:value-of select="$SL"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="SM">
						<xsl:attribute name="value"><xsl:value-of select="$SM"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="SN">
						<xsl:attribute name="value"><xsl:value-of select="$SN"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="SO">
						<xsl:attribute name="value"><xsl:value-of select="$SO"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="SR">
						<xsl:attribute name="value"><xsl:value-of select="$SR"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="ST">
						<xsl:attribute name="value"><xsl:value-of select="$ST"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="SU">
						<xsl:attribute name="value"><xsl:value-of select="$SU"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="SV">
						<xsl:attribute name="value"><xsl:value-of select="$SV"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="SY">
						<xsl:attribute name="value"><xsl:value-of select="$SY"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="SZ">
						<xsl:attribute name="value"><xsl:value-of select="$SZ"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="TC">
						<xsl:attribute name="value"><xsl:value-of select="$TC"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="TD">
						<xsl:attribute name="value"><xsl:value-of select="$TD"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="TF">
						<xsl:attribute name="value"><xsl:value-of select="$TF"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="TG">
						<xsl:attribute name="value"><xsl:value-of select="$TG"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="TH">
						<xsl:attribute name="value"><xsl:value-of select="$TH"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="TJ">
						<xsl:attribute name="value"><xsl:value-of select="$TJ"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="TK">
						<xsl:attribute name="value"><xsl:value-of select="$TK"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="TM">
						<xsl:attribute name="value"><xsl:value-of select="$TM"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="TN">
						<xsl:attribute name="value"><xsl:value-of select="$TN"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="TO">
						<xsl:attribute name="value"><xsl:value-of select="$TO"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="TP">
						<xsl:attribute name="value"><xsl:value-of select="$TP"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="TR">
						<xsl:attribute name="value"><xsl:value-of select="$TR"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="TT">
						<xsl:attribute name="value"><xsl:value-of select="$TT"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="TV">
						<xsl:attribute name="value"><xsl:value-of select="$TV"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="TW">
						<xsl:attribute name="value"><xsl:value-of select="$TW"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="TZ">
						<xsl:attribute name="value"><xsl:value-of select="$TZ"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="UA">
						<xsl:attribute name="value"><xsl:value-of select="$UA"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="UG">
						<xsl:attribute name="value"><xsl:value-of select="$UG"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="UK">
						<xsl:attribute name="value"><xsl:value-of select="$UK"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="UM">
						<xsl:attribute name="value"><xsl:value-of select="$UM"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="US">
						<xsl:attribute name="value"><xsl:value-of select="$US"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="UY">
						<xsl:attribute name="value"><xsl:value-of select="$UY"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="UZ">
						<xsl:attribute name="value"><xsl:value-of select="$UZ"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="VA">
						<xsl:attribute name="value"><xsl:value-of select="$VA"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="VC">
						<xsl:attribute name="value"><xsl:value-of select="$VC"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="VE">
						<xsl:attribute name="value"><xsl:value-of select="$VE"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="VG">
						<xsl:attribute name="value"><xsl:value-of select="$VG"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="VI">
						<xsl:attribute name="value"><xsl:value-of select="$VI"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="VN">
						<xsl:attribute name="value"><xsl:value-of select="$VN"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="VU">
						<xsl:attribute name="value"><xsl:value-of select="$VU"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="WF">
						<xsl:attribute name="value"><xsl:value-of select="$WF"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="WS">
						<xsl:attribute name="value"><xsl:value-of select="$WS"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="YE">
						<xsl:attribute name="value"><xsl:value-of select="$YE"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="YT">
						<xsl:attribute name="value"><xsl:value-of select="$YT"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="YU">
						<xsl:attribute name="value"><xsl:value-of select="$YU"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="ZA">
						<xsl:attribute name="value"><xsl:value-of select="$ZA"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="ZM">
						<xsl:attribute name="value"><xsl:value-of select="$ZM"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="ZR">
						<xsl:attribute name="value"><xsl:value-of select="$ZR"/></xsl:attribute>
					</Choice>
					<Choice returnvalue="ZW">
						<xsl:attribute name="value"><xsl:value-of select="$ZW"/></xsl:attribute>
					</Choice>

				</Data>
				<Data name="L"  value="" editable="true" type="editbox" align="left" maxlength="128">
					<xsl:attribute name="display"><xsl:value-of select="$CSRL"/></xsl:attribute>
				</Data>
				<Data name="S"  value="" editable="true" type="editbox" align="left" maxlength="128">
					<xsl:attribute name="display"><xsl:value-of select="$CSRS"/></xsl:attribute>
				</Data>
				<Data size="45" name="E"  value="" editable="true" type="editbox" align="left">
					<xsl:attribute name="display"><xsl:value-of select="$CSRE"/></xsl:attribute>
				</Data>
				<Data size="45" name="F"  value="" editable="true" type="editbox" align="left">
					<xsl:attribute name="display"><xsl:value-of select="$CSRF"/></xsl:attribute>
				</Data>
			</ListData>

			<script type="text/javascript" src="/drsc/js/utility.js"></script>
			<script language="javascript">
				
				var sCNRequired	= "<xsl:value-of select="$CSRCNRequired"/>"
				var sOURequired	= "<xsl:value-of select="$CSROURequired"/>"
				var sORequired	= "<xsl:value-of select="$CSRORequired"/>"
				var sCRequired	= "<xsl:value-of select="$CSRCRequired"/>"
				var sFRequired	= "<xsl:value-of select="$CSRFRequired"/>"
				var sSRequired	= "<xsl:value-of select="$CSRSRequired"/>"
				var sLRequired	= "<xsl:value-of select="$CSRLRequired"/>"
				
				var sCNInvalid	= "<xsl:value-of select="$CSRCNInvalid"/>"
				var sOUInvalid	= "<xsl:value-of select="$CSROUInvalid"/>"
				var sOInvalid	= "<xsl:value-of select="$CSROInvalid"/>"
				var sCInvalid	= "<xsl:value-of select="$CSRCInvalid"/>"
				var sFInvalid	= "<xsl:value-of select="$CSRFInvalid"/>"
				var sLInvalid	= "<xsl:value-of select="$CSRLInvalid"/>"
				var sSInvalid	= "<xsl:value-of select="$CSRSInvalid"/>"
				var sEInvalid	= "<xsl:value-of select="$CSREInvalid"/>"

				function validate()
				{
					var errStr = "";
					
					if (document.dataarea.CN.value == "") errStr = addToErrorMsg(errStr, sCNRequired);
					else if(!checkString(document.dataarea.CN.value, DELIM_COMMON_NAME)) errStr = addToErrorMsg(errStr, sCNInvalid);
										
					if (document.dataarea.OU.value == "") errStr = addToErrorMsg(errStr, sOURequired);
					else if(!checkString(document.dataarea.OU.value, DELIM_ORGANIZATION)) errStr = addToErrorMsg(errStr, sOUInvalid);
										
					if (document.dataarea.O.value == "")  errStr = addToErrorMsg(errStr, sORequired);
					else if(!checkString(document.dataarea.O.value, DELIM_ORGANIZATION)) errStr = addToErrorMsg(errStr, sOInvalid);
					
					if (document.dataarea.L.value == "") errStr = addToErrorMsg(errStr, sLRequired);
					if(!checkString(document.dataarea.L.value, DELIM_LOCALE)) errStr = addToErrorMsg(errStr, sLInvalid);
					
					if (document.dataarea.S.value == "") errStr = addToErrorMsg(errStr, sSRequired);
					if(!checkString(document.dataarea.S.value, DELIM_LOCALE)) errStr = addToErrorMsg(errStr, sSInvalid);
					
					if (document.dataarea.F.value == "") errStr = addToErrorMsg(errStr, sFRequired);
					else if(!checkString(document.dataarea.F.value, DELIM_FILE_NAME)) errStr = addToErrorMsg(errStr, sFInvalid);
					
					if(!checkString(document.dataarea.E.value, DELIM_EMAIL)) errStr = addToErrorMsg(errStr, sEInvalid);
					
					if (errStr != "")
					{
						alert(errStr);
						return false;
					}
					
					// if (document.dataarea.OU.value.indexOf(" ") >= 0) document.dataarea.OU.value = "\"" + document.dataarea.OU.value + "\"";
					// if (document.dataarea.O.value.indexOf(" ") >= 0) document.dataarea.O.value = "\"" + document.dataarea.O.value + "\"";
					// if (document.dataarea.S.value.indexOf(" ") >= 0) document.dataarea.S.value = "\"" + document.dataarea.S.value + "\"";
					// if (document.dataarea.L.value.indexOf(" ") >= 0) document.dataarea.L.value = "\"" + document.dataarea.L.value + "\"";
					// if (document.dataarea.F.value.indexOf(" ") >= 0) document.dataarea.F.value = "\"" + document.dataarea.F.value + "\"";
					
					
					return true;				
				}			
			</script>
		</DataArea>
	</xsl:template>
	<xsl:template match="*"/>	
</xsl:stylesheet>