<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="/OMA">
		<DataArea backpagetarget="/servlet/DataArea?plugin=security.X509.webplugins.CertoptionWebPlugin&amp;help=Certificate&amp;app=oma" validate="true">
			<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strCertificateManagement"/></xsl:attribute>
			<xsl:attribute name="submit">/servlet/SubmitForm?plugin=security.X509.webplugins.ReqoptionWebPlugin</xsl:attribute>
			<xsl:attribute name="submitdisplay"><xsl:value-of select="$strNext"/></xsl:attribute>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strX509Certificates"/></xsl:attribute>
			</PageTitle>
			<PromptText><xsl:value-of select="$strSelectCertificateFrom"/></PromptText>
			
			<ListData type="custom">
				<xsl:choose>
					<xsl:when test="count(CertentryList/.) &gt; '1'">
						<Data name="option" editable="true" type="select" align="left">
							<xsl:attribute name="display"><xsl:value-of select="$strCertificates"/></xsl:attribute>
							<xsl:for-each select="CertentryList/Certentry">
								<xsl:sort select="." order="ascending"/>
								<Choice>
									<xsl:attribute name="returnvalue"><xsl:value-of select="."/></xsl:attribute>
									<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
									<xsl:attribute name="default"><xsl:if test="@select='true'">true</xsl:if></xsl:attribute>
								</Choice>
							</xsl:for-each>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strCertificates1"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="CertentryList/Certentry"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
				<Data name="subreq" editable="true"  type="select" align="left">
					<xsl:attribute name="display"><xsl:value-of select="$strSelectAppropriateAction"/></xsl:attribute>
					<xsl:for-each select="OptionList/Option">
						<xsl:sort select="." order="ascending"/>
						<Choice>
							<xsl:attribute name="returnvalue"><xsl:value-of select="@name"/></xsl:attribute>
							<xsl:attribute name="value">
								<xsl:choose>
									<xsl:when test=".='Display Contents'"><xsl:value-of select="$strDisplayContents"/></xsl:when>
									<xsl:when test=".='Delete'"><xsl:value-of select="$strDelete"/></xsl:when>
									<xsl:when test=".='Certificate Signing Request(CSR)'"><xsl:value-of select="$strCertificateSigningRequestCSR"/></xsl:when>
									<xsl:when test=".='Export Certificate in BASE64-encoded format'"><xsl:value-of select="$strExportCertificateIn"/></xsl:when>
									<xsl:when test=".='Make Active'"><xsl:value-of select="$strMakeActive"/></xsl:when>
								</xsl:choose>
							</xsl:attribute>
							<xsl:attribute name="default">
								<xsl:if test=".='Display Contents'">true</xsl:if>
							</xsl:attribute>
						</Choice>
					</xsl:for-each>
				</Data>
			</ListData>
			<ListData>
				<xsl:if test="count(CertentryList/.) =  '1'">
					<Data name="option" display=" "  type="hidden">
						<xsl:attribute name="returnvalue"><xsl:value-of select="CertentryList/Certentry"/></xsl:attribute>
					</Data>
				</xsl:if>
			</ListData>
			<script language="javascript">
				var optval ;
				var reqval;

				function validate(){
				
					optval = document.dataarea.option.value;
					reqval = document.dataarea.subreq.value;
					
					if (optval == "" ){
						alert("<xsl:value-of select="$strThereIsNo"/>");
					}
					else{
						if(reqval == "Delete"){
							if (confirm("<xsl:value-of select="$strAreYouSure"/>")){
								return true;
							}
							else{
								return false;
							}
						}
						return true;
					}
					return false;	
				}								
			</script>
		</DataArea>
	</xsl:template>
	<xsl:template match="*"/>	
</xsl:stylesheet>
