<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="/OMA">
		<DataArea exportdata="false" backpagetarget="/servlet/DataArea?plugin=security.X509.webplugins.CertoptionWebPlugin&amp;help=Certificate&amp;app=oma" validate="true">			
			<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strCertificateManagement"/></xsl:attribute>
			<xsl:attribute name="submit">/servlet/SubmitForm?plugin=security.X509.webplugins.GenerateWebPlugin&amp;generated=true</xsl:attribute>
			<xsl:attribute name="submitdisplay"><xsl:value-of select="$strGenerate"/></xsl:attribute>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strX509CertificateGeneration"/></xsl:attribute>
			</PageTitle>
			<xsl:choose>
				<xsl:when test="Generator/@status">
					<xsl:choose>
						<xsl:when test="Generator/@status='duplicate'">
							<PromptText status="3"><xsl:value-of select="$strAlias"/><xsl:value-of select="Generator/@aliasused"/><xsl:value-of select="$strAlreadyExistsFill"/></PromptText>
						</xsl:when>
						<xsl:otherwise>
							<PromptText status="4"><xsl:value-of select="$strFailedToGenerate"/><xsl:value-of select="Generator/@aliasused"/><xsl:value-of select="$strFillInAll"/></PromptText>
						</xsl:otherwise>
					</xsl:choose>
					<ListData type="custom">
						<Data name="alias" value="" editable="true" type="editbox" align="left" maxlength="10">
							<xsl:attribute name="display"><xsl:value-of select="$strAlias1"/></xsl:attribute>
						</Data>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strKeyGenerationAlgorithm"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="Generator/KeyAlg/Keypair"/></xsl:attribute>
						</Data>
						<Data name="keysize" editable="true" type="editbox" align="left" size="10">
							<xsl:attribute name="unit"><xsl:value-of select="$strBits"/></xsl:attribute>
							<xsl:attribute name="display"><xsl:value-of select="$strKeySize"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="Generator/@keysize"/></xsl:attribute>
						</Data>
						<Data name="validity" editable="true" type="editbox" align="left" size="10" >
							<xsl:attribute name="unit"><xsl:value-of select="$strDays"/></xsl:attribute>
							<xsl:attribute name="display"><xsl:value-of select="$strValidityPeriod"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="Generator/@validity"/></xsl:attribute>
						</Data>
						<Data name="comname" editable="true" type="editbox" align="left" size="45">
							<xsl:attribute name="display"><xsl:value-of select="$strCommonNameCN"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="Generator/@comname"/></xsl:attribute>
						</Data>
						<Data name="org" editable="true" type="editbox" align="left" size="45">
							<xsl:attribute name="display"><xsl:value-of select="$strOrganizationO"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="Generator/@org"/></xsl:attribute>
						</Data>
						<Data name="orgunit"  value="" editable="true" type="editbox" align="left" size="45">
							<xsl:attribute name="display"><xsl:value-of select="$strOrganizationUnitOU"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="Generator/@orgunit"/></xsl:attribute>
						</Data>
						<Data name="locality" editable="true" type="editbox" align="left" size="45">
							<xsl:attribute name="display"><xsl:value-of select="$strLocalityL"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="Generator/@locality"/></xsl:attribute>
						</Data>
						<Data name="state" editable="true" type="editbox" align="left" size="45">
							<xsl:attribute name="display"><xsl:value-of select="$strStateST"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="Generator/@state"/></xsl:attribute>
						</Data>
						<Data name="country" editable="true" type="select" align="left">
							<xsl:attribute name="display"><xsl:value-of select="$strCountryC"/></xsl:attribute>
							<xsl:for-each select="Generator/CountryGroup/Country">
								<xsl:sort select="." order="ascending"/>
								<Choice>
									<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
									<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
									<xsl:attribute name="default"><xsl:if test="@value = /OMA/Generator/@country">true</xsl:if></xsl:attribute>
								</Choice>
							</xsl:for-each>
						</Data>
					</ListData>
				</xsl:when>
				<xsl:otherwise>
					<PromptText><xsl:value-of select="$strFillInAll1"/></PromptText>
					<ListData type="custom">
						<Data name="alias"  value="" editable="true" type="editbox" align="left" maxlength="10">
							<xsl:attribute name="display"><xsl:value-of select="$strAlias2"/></xsl:attribute>
						</Data>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strKeyGenerationAlgorithm1"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="Generator/KeyAlg/Keypair"/></xsl:attribute>
						</Data>
						<Data name="keysize"   value="1024" editable="true" type="editbox" align="left" size="10">
							<xsl:attribute name="unit"><xsl:value-of select="$strBits"/></xsl:attribute>
							<xsl:attribute name="display"><xsl:value-of select="$strKeySize1"/></xsl:attribute>
						</Data>
						<Data name="validity"  value="" editable="true" type="editbox" align="left" size="10">
							<xsl:attribute name="unit"><xsl:value-of select="$strDays"/></xsl:attribute>
							<xsl:attribute name="display"><xsl:value-of select="$strValidityPeriod1"/></xsl:attribute>
						</Data>
						<Data name="comname"  value="" editable="true" type="editbox" align="left" size="45">
							<xsl:attribute name="display"><xsl:value-of select="$strCommonNameCN1"/></xsl:attribute>
						</Data>
						<Data name="org"  value="" editable="true" type="editbox" align="left" size="45">
							<xsl:attribute name="display"><xsl:value-of select="$strOrganizationO1"/></xsl:attribute>
						</Data>
						<Data name="orgunit"  value="" editable="true" type="editbox" align="left" size="45">
							<xsl:attribute name="display"><xsl:value-of select="$strOrganizationUnitOU1"/></xsl:attribute>
						</Data>
						<Data name="locality"  value="" editable="true" type="editbox" align="left" size="45">
							<xsl:attribute name="display"><xsl:value-of select="$strLocalityL1"/></xsl:attribute>
						</Data>
						<Data name="state"  value="" editable="true" type="editbox" align="left" size="45">
							<xsl:attribute name="display"><xsl:value-of select="$strStateST1"/></xsl:attribute>
						</Data>
						<Data name="country" editable="true" type="select" align="left">
							<xsl:attribute name="display"><xsl:value-of select="$strCountryC1"/></xsl:attribute>
							<xsl:for-each select="Generator/CountryGroup/Country">
								<xsl:sort select="." order="ascending"/>
								<Choice>
									<xsl:attribute name="returnvalue"><xsl:value-of select="@value"/></xsl:attribute>
									<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
									<xsl:attribute name="default"><xsl:if test=".='UNITED STATES'">true</xsl:if></xsl:attribute>
								</Choice>
							</xsl:for-each>
						</Data>
					</ListData>
				</xsl:otherwise>
			</xsl:choose>
			<script language="javascript">
				var keysize ; 
				var validity ;	
				
				function isAlphaNumeric(text, varname)
				{
					var validValue = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-.";
					var ok = "yes";
					var temp;
					
					//Eliminate the spaces at the end
					while(''+text.charAt(text.length-1)==' '){
						text = text.substring(0,text.length-1);
					}
					
					for (var i=0; i&lt;text.length; i++){
						temp = "" + text.substring(i, i+1);
						if (validValue.indexOf(temp) == "-1"){
							if(temp != " "){
								ok = "no";
							}
						}
					}
					if (ok == "no"){
						alert(<xsl:value-of select="$strInvalidValueFor"/>);
						return false;
					}
					return true;
				}
				
				function isAlphaNumericsp(text, varname)
				{
					var validValue = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_'*$,.!%():[]=/?+~@";
					var ok = "yes";
					var temp;
					
					//Eliminate the spaces at the end
					while(''+text.charAt(text.length-1)==' '){
						text = text.substring(0,text.length-1);
					}
					
					for (var i=0; i&lt;text.length; i++){
						temp = "" + text.substring(i, i+1);
						if (validValue.indexOf(temp) == "-1"){
							if(temp != " "){
								ok = "no";
							}
						}
					}
					if (ok == "no"){
						alert(<xsl:value-of select="$strInvalidValueFor1"/>);
						return false;
					}
					return true;
				}
				
				function is_valid(validity)
				{
					var isValid=true;
					var validValues="0123456789";
					var indx;
					for (indx=0; indx &lt; validity.length; indx++)
					{
						if (validValues.indexOf(validity.charAt(indx)) &lt; 0)
						{	
							isValid=false;
							break;
						}
					}
					return isValid;
				}
				
				function validate()
				{
					keysize = document.dataarea.keysize.value;
					validity = document.dataarea.validity.value;
					logresult = new Number(Math.log(parseInt(keysize))/Math.log(2));
					logresStr = logresult.toString();
					
					if (document.dataarea.alias.value== "" ){
						alert("<xsl:value-of select="$strAliasIsRequired"/>");
						document.dataarea.alias.focus();
					}
					else if(document.dataarea.keysize.value== "" ){
						alert("<xsl:value-of select="$strKeysizeIsRequired"/>");
						document.dataarea.keysize.focus();
					}
					else if(document.dataarea.validity.value== ""){
						alert("<xsl:value-of select="$strValidityPeriodIs"/>");
						document.dataarea.validity.focus();
					}
					else if(document.dataarea.comname.value== "" ){
						alert("<xsl:value-of select="$strCommonNameCNIs"/>");
						document.dataarea.comname.focus();
					}
					else if(document.dataarea.org.value== "" ){
						alert("<xsl:value-of select="$strOrganizationOIsRequired"/>");
						document.dataarea.org.focus();
					}
					else if(document.dataarea.orgunit.value== "" ){
						alert("<xsl:value-of select="$strOrganizationUnitOUIs"/>");
						document.dataarea.orgunit.focus();
					}
					else if(document.dataarea.locality.value== "" ){
						alert("<xsl:value-of select="$strLocalityLIsRequired"/>");
						document.dataarea.locality.focus();
					}
					else if(document.dataarea.state.value== "" ){
						alert("<xsl:value-of select="$strStateSTIsRequired"/>");
						document.dataarea.state.focus();
					}
					else{
						if(isNaN(keysize) == true){
							alert("<xsl:value-of select="$strKeysizeIsNot"/>");
							document.dataarea.keysize.value = "";
							document.dataarea.keysize.focus();
						}
						else if((parseInt(keysize) &lt; 512) || (parseInt(keysize) &gt; 2048)){
							alert("<xsl:value-of select="$strKeysizeShouldBe"/>");
							document.dataarea.keysize.value = "";
							document.dataarea.keysize.focus();
						}
						else if(logresStr.indexOf(".") != -1){
							alert("<xsl:value-of select="$strKeysizeShouldBe1"/>");
							document.dataarea.keysize.value = "";
							document.dataarea.keysize.focus();
						}
						else if(isNaN(validity) == true){
							alert("<xsl:value-of select="$strValidityPeriodIs1"/>");
							document.dataarea.validity.value = "";
							document.dataarea.validity.focus();
						}
						else if((parseInt(validity) &lt;= 0) || (parseInt(validity) &gt;= 3651)){
							alert("<xsl:value-of select="$strValidityPeriodFalls"/>");
							document.dataarea.validity.value = "";
							document.dataarea.validity.focus();
						}
						else if (keysize.indexOf('.')!= -1)
						{
						alert("<xsl:value-of select="$strKeysizeCanHave"/>");
						}
						else if(is_valid(validity) == false)
						{
						alert("<xsl:value-of select="$strValidityCanHave"/>");
        }
        else if( ! isAlphaNumeric(document.dataarea.comname.value, "<xsl:value-of select="$strCommonNameCN2"/>")){
							document.dataarea.comname.value = "";
							document.dataarea.comname.focus();
						}
						
						else {
								var newalias = document.getElementById("alias").value;
								var aliasname = newalias.toLowerCase();
								var curalias = "<xsl:value-of select="Generator/@currentalias"/>";

							if (aliasname == curalias){
								alert(<xsl:value-of select="$strAliasNewaliasAlready"/>);
								document.dataarea.alias.value ="";
								document.dataarea.alias.focus();
							}
							else {
													
								if (confirm("<xsl:value-of select="$strGeneratingANew"/>")){
									return true;
								}
								else{
									return false;
								}
							}
							return false;
						}
						return false;
					}
					return false;				
				}			
			</script>
		</DataArea>
	</xsl:template>
	<xsl:template match="*"/>	
</xsl:stylesheet>
