#!/bin/sh
###############################################################################
#
#          Dell Inc. PROPRIETARY INFORMATION
# This software is supplied under the terms of a license agreement or
# nondisclosure agreement with Dell Inc. and may not
# be copied or disclosed except in accordance with the terms of that
# agreement.
#
# Copyright (c) 2000-2006 Dell Inc. All Rights Reserved.
#
# Module Name:
#
#   services.sh
#
#
# Abstract/Purpose:
#
#   This Script will start/stop/restart/status all the services installed
#   by Systems Management.
#
# Environment:
#
#   Linux
#
###############################################################################

# ensure sbin utilities are available in path, so that su will also work
export PATH=/usr/kerberos/sbin:/usr/local/sbin:/sbin:/usr/sbin:$PATH

# Server Administrator package prefix
DELL_OPENMANAGE_PREFIX="srvadmin"
SRVADMIN_STR="Server Administrator"

# Executable and Service Name variable place holder
#
###############################################################################
#
#          Dell Inc. PROPRIETARY INFORMATION
# This software is supplied under the terms of a license agreement or
# nondisclosure agreement with Dell Inc. and may not
# be copied or disclosed except in accordance with the terms of that
# agreement.
#
# Copyright (c) 2000-2005 Dell Inc. All Rights Reserved.
#
# Module Name:
#
#   executable_names_sh.txt
#
# Abstract/Purpose:
#
#   Defines process and service names for shell script files.
#
# Environment:
#
#   Linux
#
###############################################################################
#
#
#

#
# Instrumentation Service and Process (Executable) Names
#
PROCESS_NAME_OMSA_DCEVT=dsm_sa_eventmgr32d
PROCESS_NAME_OMSA_DCSTOR=dsm_sa_datamgr32d
PROCESS_NAME_OMSA_DCSNMP=dsm_sa_snmp32d

SERVICE_NAME_OMSA_DCEVT="DSM SA Event Manager"
SERVICE_NAME_OMSA_DCSTOR="DSM SA Data Manager"
SERVICE_NAME_OMSA_DCSNMP="DSM SA SNMP Service"


#
# OMSA SERVICE AND PROCESS (EXECUTABLE) Names
#
PROCESS_NAME_OMSA_BADA=bada
PROCESS_NAME_OMSA_OMAWSD=dsm_om_connsvc32d
PROCESS_NAME_OMSA_OMSAD=dsm_om_shrsvc32d

SERVICE_NAME_OMSA_BADA="DSM SA Bundle Applicator"
SERVICE_NAME_OMSA_OMAWSD="DSM SA Connection Service"
SERVICE_NAME_OMSA_OMSAD="DSM SA Shared Services"


#
# OMSM SERVICE AND PROCESS (EXECUTABLE) Names
#
PROCESS_NAME_LSI_MR2KSERV=mr2kserv

SERVICE_NAME_LSI_MR2KSERV="DSM SM LSI Manager"

#
# ITA SERVICE AND PROCESS (EXECUTABLE) Names
#
PROCESS_NAME_ITA_DCNETMON=dcnetmon
PROCESS_NAME_ITA_OMAWSD=omaws32
PROCESS_NAME_ITA_OMSAD=omsad32

SERVICE_NAME_ITA_DCNETMON="DSM ITA Network Monitor"
SERVICE_NAME_ITA_OMAWSD="DSM ITA Connection Service"
SERVICE_NAME_ITA_OMSAD="DSM ITA Shared Services"


#
# BMC SERVICE AND PROCESS (EXECUTABLE) Names
#
PROCESS_NAME_BMU_SOLPROXY=solproxy

SERVICE_NAME_BMU_SOLPROXY="DSM BMU SOL Proxy"


#
# INIT SCRIPT PROCESS NAMES
PROCESS_NAME_OMSA_INIT_INSTSVCDRV=instsvcdrv
PROCESS_NAME_OMSA_INIT_DATAENG=dataeng
PROCESS_NAME_OMSA_INIT_OMAWSD=dsm_om_connsvc
PROCESS_NAME_OMSA_INIT_OMSAD=dsm_om_shrsvc
PROCESS_NAME_LSI_INIT_MPTCTL=mptctl
PROCESS_NAME_RAC3_INIT_RACSER=racser
PROCESS_NAME_RAC3_INIT_RACVNC=racvnc
PROCESS_NAME_RAC3_INIT_RACSRVC=racsrvc
PROCESS_NAME_RAC4_INIT_RACSVC=racsvc

SERVICE_NAME_OMSA_INIT_INSTSVCDRV="DSM SA Instrumentation Service"
SERVICE_NAME_OMSA_INIT_DATAENG="DSM SA Data Manager Service"
SERVICE_NAME_OMSA_INIT_OMAWSD="DSM SA Connection Service"
SERVICE_NAME_OMSA_INIT_OMSAD="DSM SA Shared Services"
SERVICE_NAME_LSI_INIT_MPTCTL="DSM SM LSI Manager"
SERVICE_NAME_RAC3_INIT_RACSER="DSM RA Controller Service Manager"
SERVICE_NAME_RAC3_INIT_RACVNC="DSM RA Controller Service Manager"
SERVICE_NAME_RAC3_INIT_RACSRVC="DSM RA Controller Service Manager"
SERVICE_NAME_RAC4_INIT_RACSVC="DSM RA Controller Service Manager"


# list of services start
arrayStart=(${PROCESS_NAME_LSI_INIT_MPTCTL} ${PROCESS_NAME_RAC4_INIT_RACSVC} ${PROCESS_NAME_OMSA_INIT_INSTSVCDRV} ${PROCESS_NAME_OMSA_INIT_DATAENG} ${PROCESS_NAME_OMSA_INIT_OMSAD} ${PROCESS_NAME_OMSA_INIT_OMAWSD} ${PROCESS_NAME_RAC3_INIT_RACSER} ${PROCESS_NAME_RAC3_INIT_RACVNC} ${PROCESS_NAME_RAC3_INIT_RACSRVC})

# list of services to stop
arrayStop=(${PROCESS_NAME_RAC4_INIT_RACSVC} ${PROCESS_NAME_OMSA_INIT_OMSAD} ${PROCESS_NAME_OMSA_INIT_OMAWSD} ${PROCESS_NAME_RAC3_INIT_RACSER} ${PROCESS_NAME_RAC3_INIT_RACVNC} ${PROCESS_NAME_RAC3_INIT_RACSRVC} ${PROCESS_NAME_OMSA_INIT_DATAENG} ${PROCESS_NAME_OMSA_INIT_INSTSVCDRV})

# list of services to find status
arrayStatus=(${PROCESS_NAME_RAC4_INIT_RACSVC} ${PROCESS_NAME_OMSA_INIT_INSTSVCDRV} ${PROCESS_NAME_OMSA_INIT_DATAENG} ${PROCESS_NAME_OMSA_INIT_OMSAD} ${PROCESS_NAME_OMSA_INIT_OMAWSD} ${PROCESS_NAME_RAC3_INIT_RACSER} ${PROCESS_NAME_RAC3_INIT_RACVNC} ${PROCESS_NAME_RAC3_INIT_RACSRVC})

OMI_LOCK_FILE=/var/lock/LCK..srvadmin-services.sh.0

#The following lines for trapping signals and
#creating a lock file have been added for DF 44900
#unexpected behavior when user opens another terminal and
#runs this script concurrently - BK

trap 'InterruptOMI' INT QUIT TERM
trap 'InterruptOMIHUP' HUP
trap 'InterruptOMIExit' exit

###############################################################################
# Function : InterruptOMI
#
#   Process and clean up from INT, QUIT or TERM signal
###############################################################################
function InterruptOMI
{
    echo " "
    echo "Interrupting Install of $0 due to signal"
    exit -1
}

###############################################################################
# Function : InterruptOMIHUP
#
#   Process and clean up from an application error, as "tee" command used
#   to write log, continues execution after the "tee" when any part of the
#   utility exits.
###############################################################################
function InterruptOMIHUP
{
    exit 1
}

###############################################################################
# Function : InterruptOMIExit
#
#   Process and clean up from utilty exit
###############################################################################
function InterruptOMIExit
{
    THEEXITVALUE=$?

    rm -f ${OMI_LOCK_FILE} > /dev/null 2>&1

    exit $THEEXITVALUE
}


###############################################################################
#   Function : EnterOMI
#
#   Uses "lockfile" to create a semaphore ( file ) that needs to be
#   deleted manually
###############################################################################
function EnterOMI {
    SCRIPT_NAME=`basename $1`
    LOCK_UTIL=$(which lockfile 2>/dev/null)

    if [ -z "${LOCK_UTIL}" ]; then
        LOCK_UTIL=$(which /usr/bin/lockfile 2>/dev/null)
        if [ -z "${LOCK_UTIL}" ]; then
          cat <<EOF
Warning: The lockfile utility is not found in PATH or /usr/bin.
         This utility prevents concurrent executions of ${SCRIPT_NAME}
         which can lead to unexpected or invalid installation results.
EOF
          return 0
        fi
    fi

    if ! eval ${LOCK_UTIL} -r0 ${OMI_LOCK_FILE} 2>/dev/null; then
        cat <<EOF
Error: ${SCRIPT_NAME} is already executing.
       Wait for ${SCRIPT_NAME} to complete and try again.
       Concurrent executions of ${SCRIPT_NAME} can lead to unexpected
       or invalid installation results.

       If you want to continue anyway, please delete '${OMI_LOCK_FILE}' and try again.
EOF
        exit -1
    fi
}

# Make sure standard bin directories are in path
PATH="${PATH}:/sbin:/usr/sbin:/bin:/usr/bin"

##
## StartServices
##
function StartServices {
    MSG=0
    for srvc in ${arrayStart[*]};
    do
        chkconfig --list | grep ^${srvc} >/dev/null 2>&1
        if [ $? == 0 ]; then
            /etc/init.d/${srvc} status >/dev/null 2>&1
            if [ $? != 0 ]; then
                MSG=1
                /etc/init.d/${srvc} start
            fi
        fi
    done

    [ ${MSG} == 0 ] && echo "${SRVADMIN_STR} services already started."
}

##
## StopServices
##
function StopServices {
    MSG=0
    for srvc in ${arrayStop[*]};
    do
        chkconfig --list | grep ^${srvc} >/dev/null 2>&1
        if [ $? == 0 ]; then
            /etc/init.d/${srvc} status >/dev/null 2>&1
            if [ $? == 0 ]; then
                MSG=1
                /etc/init.d/${srvc} stop
            fi
        fi
    done

    [ -z "${1}" -a ${MSG} == 0 ] && echo "${SRVADMIN_STR} services already stopped."
}

##
## ServicesStatus
##
function ServicesStatus {
    for srvc in ${arrayStatus[*]};
    do
        chkconfig --list | grep ^${srvc} >/dev/null 2>&1 && /etc/init.d/${srvc} status
    done
}

##
## Main
##
function Main {
    # check for the presence of Server Administrator packages
    rpm -qa | grep "${DELL_OPENMANAGE_PREFIX}" >/dev/null 2>&1
    if [ $? == 0 ]; then
        if [ ${1} == "start" ]; then
            StartServices
        elif [ ${1} == "stop" ]; then
            StopServices
        elif [ ${1} == "status" ]; then
            ServicesStatus
        elif [ ${1} == "restart" ]; then
            StopServices "NOMSG"
            StartServices
        else
            Usage
        fi
    else
        echo "No ${SRVADMIN_STR} RPM packages are installed."
    fi
}

##
## Usage
##
function Usage {
    cat <<EOF
Usage: srvadmin-services.sh {start|stop|status|restart|help}
  start  : starts ${SRVADMIN_STR} services
  stop   : stops ${SRVADMIN_STR} services
  status : display status of ${SRVADMIN_STR} services
  restart: restart ${SRVADMIN_STR} services
  help   : Displays this help text
EOF
    exit 1
}

# get out of the mounted cdrom directory so that the device can be unmounted later
cd /

# check for root privileges
if [ "${UID}" != "0" ]; then
    echo "This utility requires root privileges"
    exit 1
fi

if [ $# != 1 ]; then
    Usage
else
    if [ ${1} == "start" -o ${1} == "stop" -o ${1} == "status" -o ${1} == "restart" ]; then
        chkconfig >/dev//null 2>&1
        if [ $? == 127 ]; then
          echo "Unable to find 'chkconfig' utility in the PATH, cannot continue."
          exit 127
        else
          # lock omi
          EnterOMI "$0"
          Main ${1}
          #remove lock file ( fix for DF 44900 )
          rm -f $OMI_LOCK_FILE
          exit 0
        fi
    elif [ ${1} == "help" ]; then
        Usage
    else
        echo "Invalid option '${1}', please see the usage below"
        echo " "
        Usage
    fi
fi
exit 1
