/*
 * Decompiled with CFR 0.152.
 */
package com.webworks.wwhelp4;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;

public class WWHURLDataCache {
    private int mInitialSize;
    private int mBufferSize;
    private byte[] mBuffer;

    WWHURLDataCache() {
        this.mInitialSize = 32768;
        this.mBuffer = new byte[this.mInitialSize];
    }

    WWHURLDataCache(int n) {
        this.mInitialSize = n > 0 ? n : 32768;
        this.mBuffer = new byte[this.mInitialSize];
    }

    public boolean fLoadURLData(String string) {
        boolean bl = false;
        try {
            URL uRL = new URL(string);
            bl = this.fLoadURLData(uRL);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return bl;
    }

    public boolean fLoadURLData(URL uRL) {
        boolean bl = false;
        try {
            InputStream inputStream = uRL.openStream();
            byte[] byArray = new byte[this.mInitialSize];
            int n = 0;
            this.mBufferSize = 0;
            n = inputStream.read(byArray, 0, byArray.length);
            while (n != -1) {
                if (this.mBufferSize + n > this.mBuffer.length) {
                    int n2 = this.mBuffer.length;
                    while (n2 < this.mBufferSize + n) {
                        n2 += this.mBuffer.length;
                    }
                    byte[] byArray2 = new byte[n2];
                    System.arraycopy(this.mBuffer, 0, byArray2, 0, this.mBufferSize);
                    this.mBuffer = byArray2;
                }
                System.arraycopy(byArray, 0, this.mBuffer, this.mBufferSize, n);
                this.mBufferSize += n;
                n = inputStream.read(byArray, 0, byArray.length);
            }
            bl = true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return bl;
    }

    public InputStream fGetInputStream() {
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.mBufferSize > 0) {
            byteArrayInputStream = new ByteArrayInputStream(this.mBuffer, 0, this.mBufferSize);
        }
        return byteArrayInputStream;
    }
}

